/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.PrereqObject;
import pcgen.core.Race;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FollowerOption
extends PrereqObject
implements Comparable<FollowerOption> {
    private String theRaceKey;
    private Race theRace = null;
    private int theAdjustment = 0;
    private String theType = null;
    private static final String ANY_RACE = "ANY";
    private static final String RACETYPE = "RACETYPE";

    public FollowerOption(String string) {
        this.theRaceKey = string.toUpperCase();
        this.theRace = Globals.getRaceKeyed(this.theRaceKey);
    }

    public FollowerOption(Race race) {
        this.theRace = race;
        this.theRaceKey = race.getKeyName();
    }

    public Race getRace() {
        if (this.theRace == null) {
            if (this.theRaceKey.startsWith(RACETYPE) || this.theRaceKey.equals(ANY_RACE)) {
                return null;
            }
            this.theRace = Globals.getRaceKeyed(this.theRaceKey);
        }
        return this.theRace;
    }

    public Collection<FollowerOption> getExpandedOptions() {
        ArrayList<FollowerOption> arrayList = new ArrayList<FollowerOption>();
        if (this.theRace != null) {
            arrayList.add(this);
            return arrayList;
        }
        HashSet<Race> hashSet = null;
        if (this.theRaceKey.startsWith(RACETYPE)) {
            hashSet = new HashSet<Race>();
            String string = this.theRaceKey.substring(9);
            Collection<Race> object2 = Globals.getAllRaces();
            for (Race race : object2) {
                if (!string.equalsIgnoreCase(race.getRaceType())) continue;
                hashSet.add(race);
            }
        } else if (this.theRaceKey.equals(ANY_RACE)) {
            hashSet = new HashSet();
            hashSet.addAll(Globals.getAllRaces());
        }
        if (hashSet != null) {
            for (Race race : hashSet) {
                FollowerOption followerOption = new FollowerOption(race);
                followerOption.setAdjustment(this.getAdjustment());
                followerOption.addPrerequisites(this.getPreReqList());
                arrayList.add(followerOption);
            }
        }
        return arrayList;
    }

    public void setType(String string) {
        this.theType = string;
    }

    public String getType() {
        return this.theType;
    }

    public void setAdjustment(int n) {
        this.theAdjustment = n;
    }

    public int getAdjustment() {
        return this.theAdjustment;
    }

    @Override
    public boolean qualifies(PlayerCharacter playerCharacter) {
        int n;
        if (this.theAdjustment != 0 && (n = playerCharacter.getEffectiveCompanionLevel(this.theType)) + this.theAdjustment <= 0) {
            return false;
        }
        return super.qualifies(playerCharacter);
    }

    @Override
    public int compareTo(FollowerOption followerOption) {
        Collator collator = Collator.getInstance();
        String string = this.theRaceKey;
        String string2 = followerOption.theRaceKey;
        if (this.theRace != null) {
            string = this.theRace.getDisplayName();
        }
        if (followerOption.theRace != null) {
            string2 = followerOption.theRace.getDisplayName();
        }
        return collator.compare(string, string2);
    }
}

