/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JFrame;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityInfo;
import pcgen.core.BioSet;
import pcgen.core.Campaign;
import pcgen.core.Categorisable;
import pcgen.core.CategorisableStore;
import pcgen.core.Constants;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.GameMode;
import pcgen.core.Kit;
import pcgen.core.Language;
import pcgen.core.LevelInfo;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PObjectDataStore;
import pcgen.core.PaperInfo;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.RollInfo;
import pcgen.core.SettingsHandler;
import pcgen.core.SizeAdjustment;
import pcgen.core.Skill;
import pcgen.core.SourceEntry;
import pcgen.core.SpecialAbility;
import pcgen.core.SystemCollections;
import pcgen.core.UnitSet;
import pcgen.core.WeaponProf;
import pcgen.core.character.CompanionMod;
import pcgen.core.character.EquipSlot;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.persistence.PersistenceManager;
import pcgen.util.InputFactory;
import pcgen.util.InputInterface;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;
import pcgen.util.enumeration.Load;
import pcgen.util.enumeration.Tab;
import pcgen.util.enumeration.Visibility;
import pcgen.util.enumeration.VisionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Globals {
    private static PlayerCharacter currentPC;
    private static List<PlayerCharacter> pcList;
    public static Race s_EMPTYRACE;
    private static boolean d_sorted;
    public static final String javaVersion;
    public static final int javaVersionMajor;
    public static final int javaVersionMinor;
    private static final String defaultPath;
    private static final String defaultPcgPath;
    private static final String backupPcgPath = "";
    private static final int[] dieSizes;
    private static String language;
    private static String country;
    private static BioSet bioSet;
    private static final List<String> custColumnWidth;
    private static SourceEntry.SourceFormat sourceDisplay;
    private static int selectedPaper;
    private static CategorisableStore abilityStore;
    private static Map<URI, Campaign> campaignMap;
    private static Map<String, Domain> domainMap;
    private static SortedMap<String, Race> raceMap;
    private static Map<String, Object> spellMap;
    private static Map<String, String> eqSlotMap;
    private static Map<String, List<CompanionMod>> companionModMap;
    private static List<String> armorProfList;
    private static List<Campaign> campaignList;
    private static List<PCClass> classList;
    private static List<Deity> deityList;
    private static List<Domain> domainList;
    private static Map<String, Kit> kitMap;
    private static List<Language> languageList;
    private static List<String> pcClassTypeList;
    private static List<Skill> skillList;
    private static List<PCTemplate> templateList;
    private static SortedSet<SpecialAbility> saSet;
    private static Map<String, Map<String, String>> sponsors;
    private static List<Map<String, String>> sponsorList;
    private static final PObjectDataStore<WeaponProf> weaponProfs;
    private static final Random random;
    private static SortedSet<String> pantheonsSet;
    private static SortedSet<String> raceTypesSet;
    private static SortedSet<String> subschoolsSet;
    private static SortedSet<String> weaponTypes;
    private static SortedSet<String> castingTimesSet;
    private static SortedSet<String> componentSet;
    private static SortedSet<String> descriptorSet;
    private static SortedSet<String> durationSet;
    private static SortedSet<String> typeForSpellsSet;
    private static SortedSet<String> rangesSet;
    private static SortedSet<String> saveInfoSet;
    private static SortedSet<String> srSet;
    private static SortedSet<String> statSet;
    private static SortedSet<String> targetSet;
    private static JFrame rootFrame;
    private static JFrame currentFrame;
    private static final StringBuffer section15;
    private static final String spellPoints = "0";
    private static boolean useGUI;
    private static final Comparator<PObject> pObjectComp;
    private static final Comparator<PObject> pObjectNameComp;
    private static final Comparator<Object> pObjectStringComp;
    public static final Class[] EMPTY_CLASS_ARRAY;
    public static final Double[] EMPTY_DOUBLE_ARRAY;
    public static final Object[] EMPTY_OBJECT_ARRAY;
    public static final String[] EMPTY_STRING_ARRAY;
    public static final String INNATE_SPELL_BOOK_NAME = "Innate";

    public static Collection<WeaponProf> getAllWeaponProfsOfType(String string) {
        return weaponProfs.getAllOfType(string);
    }

    public static Set<String> getWeaponProfTypes() {
        return weaponProfs.getTypes();
    }

    public static Collection<WeaponProf> getAllWeaponProfs() {
        return Collections.unmodifiableCollection(weaponProfs.getAll());
    }

    public static List<String> getAllowedGameModes() {
        if (SettingsHandler.getGame() != null) {
            return SettingsHandler.getGame().getAllowedModes();
        }
        return new ArrayList<String>();
    }

    public static void setBioSet(BioSet bioSet) {
        Globals.bioSet = bioSet;
    }

    public static BioSet getBioSet() {
        return bioSet;
    }

    public static Map<String, String> getBonusSpellMap() {
        return SettingsHandler.getGame().getBonusSpellMap();
    }

    public static Campaign getCampaignByURI(URI uRI) {
        return Globals.getCampaignByURI(uRI, true);
    }

    public static Campaign getCampaignByURI(URI uRI, boolean bl) {
        Campaign campaign = campaignMap.get(uRI);
        if (campaign == null && bl) {
            Logging.errorPrint("Could not find campaign by filename: " + uRI);
        }
        return campaign;
    }

    public static List<Campaign> getCampaignList() {
        return campaignList;
    }

    public static Campaign getCampaignKeyed(String string) {
        for (Campaign campaign : Globals.getCampaignList()) {
            if (!campaign.getKeyName().equalsIgnoreCase(string)) continue;
            return campaign;
        }
        Logging.errorPrint("Could not find campaign: " + string);
        return null;
    }

    public static SortedSet<String> getCastingTimesSet() {
        return castingTimesSet;
    }

    public static PCClass getClassKeyed(String string) {
        return Globals.searchPObjectList(Globals.getClassList(), string);
    }

    public static List<PCClass> getClassList() {
        return classList;
    }

    private static <T extends PObject> List<T> getPObjectsOfType(List<T> list, String string) {
        ArrayList<PObject> arrayList = new ArrayList<PObject>(list.size());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList2.add(stringTokenizer.nextToken());
        }
        for (PObject pObject : list) {
            boolean bl = false;
            for (String string2 : arrayList2) {
                boolean bl2;
                boolean bl3 = bl2 = string2.charAt(0) != '!';
                if (pObject.isType(string2) == bl2) {
                    bl = true;
                    continue;
                }
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(pObject);
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public static List<PCClass> getClassesByType(String string) {
        return Globals.getPObjectsOfType(Globals.getClassList(), string);
    }

    public static void addCompanionMod(CompanionMod companionMod) {
        String string = companionMod.getType().toUpperCase();
        List<CompanionMod> list = companionModMap.get(string);
        if (list == null) {
            list = new ArrayList<CompanionMod>();
            companionModMap.put(string, list);
        }
        list.add(companionMod);
    }

    public static void removeCompanionMod(CompanionMod companionMod) {
        Collection<List<CompanionMod>> collection = companionModMap.values();
        Iterator<List<CompanionMod>> iterator = collection.iterator();
        while (iterator.hasNext()) {
            List<CompanionMod> list = iterator.next();
            boolean bl = list.remove(companionMod);
            if (!bl || list.size() != 0) continue;
            iterator.remove();
            return;
        }
    }

    public static Collection<String> getFollowerTypes() {
        return Collections.unmodifiableSet(companionModMap.keySet());
    }

    public static Collection<CompanionMod> getCompanionMods(String string) {
        String string2 = string.toUpperCase();
        List<CompanionMod> list = companionModMap.get(string2);
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(companionModMap.get(string2));
    }

    public static CompanionMod getCompanionMod(String string) {
        if (string.length() <= 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(9), "=", false);
        String string2 = stringTokenizer.nextToken();
        int n = Integer.parseInt(stringTokenizer.nextToken());
        for (CompanionMod companionMod : Globals.getAllCompanionMods()) {
            stringTokenizer = new StringTokenizer(string2, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (companionMod.getLevel(string3) != n) continue;
                return companionMod;
            }
        }
        return null;
    }

    public static Collection<CompanionMod> getAllCompanionMods() {
        ArrayList<CompanionMod> arrayList = new ArrayList<CompanionMod>();
        Collection<List<CompanionMod>> collection = companionModMap.values();
        for (List<CompanionMod> list : collection) {
            arrayList.addAll(list);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public static SortedSet<String> getComponentSet() {
        return componentSet;
    }

    public static void setCountry(String string) {
        country = string;
    }

    public static String getCountry() {
        return country;
    }

    public static String getCurrencyDisplay() {
        return SettingsHandler.getGame().getCurrencyDisplay();
    }

    public static void setCurrentPC(PlayerCharacter playerCharacter) {
        currentPC = playerCharacter;
    }

    public static void setCustColumnWidth(String string, int n, int n2) {
        boolean bl = false;
        String string2 = string.concat(Integer.toString(n));
        String string3 = string2.concat("|").concat(Integer.toString(n2));
        if (Globals.getCustColumnWidth().isEmpty()) {
            Globals.getCustColumnWidth().add(string3);
        }
        int n3 = Globals.getCustColumnWidth().size();
        for (int i = 0; i < n3; ++i) {
            StringTokenizer stringTokenizer;
            String string4;
            String string5 = Globals.getCustColumnWidth().get(i);
            if (string5 == null || string5.length() == 0 || !string2.equals(string4 = (stringTokenizer = new StringTokenizer(string5, "|", false)).nextToken())) continue;
            Globals.getCustColumnWidth().set(i, string3);
            bl = true;
        }
        if (!bl) {
            Globals.getCustColumnWidth().add(string3);
        }
    }

    public static int getCustColumnWidth(String string, int n) {
        int n2 = 0;
        String string2 = string.concat(Integer.toString(n));
        int n3 = Globals.getCustColumnWidth().size();
        for (int i = 0; i < n3; ++i) {
            String string3;
            StringTokenizer stringTokenizer = new StringTokenizer(Globals.getCustColumnWidth().get(i), "|", false);
            if (!stringTokenizer.hasMoreTokens() || !(string3 = stringTokenizer.nextToken()).equals(string2)) continue;
            n2 = Integer.parseInt(stringTokenizer.nextToken());
        }
        return n2;
    }

    public static String getDefaultPath() {
        return Globals.expandRelativePath(defaultPath);
    }

    public static String getBackupPcgPath() {
        return Globals.expandRelativePath(backupPcgPath);
    }

    public static String getDefaultSpellBook() {
        String string = null;
        if (SettingsHandler.getGame() != null) {
            string = SettingsHandler.getGame().getDefaultSpellBook();
        }
        return string;
    }

    public static Deity getDeityKeyed(String string) {
        return Globals.searchPObjectList(Globals.getDeityList(), string);
    }

    public static List<Deity> getDeityList() {
        return deityList;
    }

    public static Deity getDeityKeyed(String string, List<Deity> list) {
        for (Deity deity : list) {
            if (!deity.getKeyName().equalsIgnoreCase(string)) continue;
            return deity;
        }
        return null;
    }

    public static SortedSet<String> getDescriptorSet() {
        return descriptorSet;
    }

    public static Domain getDomainKeyed(String string) {
        return domainMap.get(string);
    }

    public static List<Domain> getDomainList() {
        return domainList;
    }

    public static Map<String, Domain> getDomainMap() {
        return domainMap;
    }

    public static SortedSet<String> getDurationSet() {
        return durationSet;
    }

    public static EquipSlot getEquipSlotByName(String string) {
        for (EquipSlot equipSlot : SystemCollections.getUnmodifiableEquipSlotList()) {
            if (!equipSlot.getSlotName().equals(string)) continue;
            return equipSlot;
        }
        return null;
    }

    public static Map<String, String> getEquipSlotMap() {
        return eqSlotMap;
    }

    public static void setEquipSlotTypeCount(String string, String string2) {
        Globals.getEquipSlotMap().put(string, string2);
    }

    public static int getEquipSlotTypeCount(String string) {
        String string2 = Globals.getEquipSlotMap().get(string);
        if (string2 != null) {
            return Integer.parseInt(string2);
        }
        return 0;
    }

    public static boolean addAbility(Ability ability) {
        return abilityStore.addCategorisable(ability);
    }

    public static boolean removeAbilityKeyed(AbilityCategory abilityCategory, String string) {
        return abilityStore.removeKeyed(abilityCategory.getKeyName(), string);
    }

    public static boolean removeAbilityKeyed(String string, String string2) {
        return abilityStore.removeKeyed(string, string2);
    }

    public static Ability getAbilityKeyed(AbilityCategory abilityCategory, String string) {
        return (Ability)abilityStore.getKeyed(abilityCategory.getAbilityCategory(), string);
    }

    public static Ability getAbilityKeyed(String string, String string2) {
        return (Ability)abilityStore.getKeyed(string, string2);
    }

    public static Iterator<Categorisable> getAbilityKeyIterator(String string) {
        return abilityStore.getKeyIterator(string);
    }

    public static Iterator<? extends Categorisable> getAbilityNameIterator(String string) {
        return abilityStore.getNameIterator(string);
    }

    public static List<Ability> getAbilityList(AbilityCategory abilityCategory) {
        List<Categorisable> list = abilityStore.getUnmodifiableList(abilityCategory.getAbilityCategory());
        ArrayList<Ability> arrayList = new ArrayList<Ability>(list.size());
        block0: for (Categorisable categorisable : list) {
            if (!(categorisable instanceof Ability)) continue;
            Ability ability = (Ability)categorisable;
            if (abilityCategory.getAbilityTypes().size() > 0) {
                for (String string : abilityCategory.getAbilityTypes()) {
                    if (!ability.isType(string)) continue;
                    arrayList.add(ability);
                    continue block0;
                }
                continue;
            }
            arrayList.add(ability);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static List<? extends Categorisable> getUnmodifiableAbilityList(String string) {
        return abilityStore.getUnmodifiableList(string);
    }

    public static List<Ability> getAbilitiesByType(String string, String string2) {
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        for (Categorisable categorisable : Globals.getUnmodifiableAbilityList(string)) {
            if (categorisable instanceof Ability) {
                arrayList.add((Ability)categorisable);
                continue;
            }
            if (!(categorisable instanceof AbilityInfo)) continue;
            arrayList.add(((AbilityInfo)categorisable).getAbility());
        }
        return Globals.getPObjectsOfType(arrayList, string2);
    }

    public static Collection<String> getAbilityTypes(AbilityCategory abilityCategory, boolean bl) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Categorisable categorisable : Globals.getUnmodifiableAbilityList(abilityCategory.getKeyName())) {
            Ability ability = null;
            if (categorisable instanceof Ability) {
                ability = (Ability)categorisable;
            } else if (categorisable instanceof AbilityInfo) {
                ability = ((AbilityInfo)categorisable).getAbility();
            }
            treeSet.addAll(ability.getTypeList(bl));
        }
        return Collections.unmodifiableSet(treeSet);
    }

    public static String getGameModeACAbbrev() {
        return SettingsHandler.getGame().getACAbbrev();
    }

    public static String getGameModeACText() {
        return SettingsHandler.getGame().getACText();
    }

    public static String getGameModeAlignmentText() {
        return SettingsHandler.getGame().getAlignmentText();
    }

    public static String getGameModeAltHPAbbrev() {
        return SettingsHandler.getGame().getAltHPAbbrev();
    }

    public static String getGameModeAltHPText() {
        return SettingsHandler.getGame().getAltHPText();
    }

    public static String getGameModeBaseSpellDC() {
        return SettingsHandler.getGame().getSpellBaseDC();
    }

    public static String getGameModeDamageResistanceText() {
        return SettingsHandler.getGame().getDamageResistanceText();
    }

    public static int getGameModeNonProfPenalty() {
        return SettingsHandler.getGame().getNonProfPenalty();
    }

    public static String getGameModePointPoolName() {
        return SettingsHandler.getGame().getPointPoolName();
    }

    public static boolean getGameModeHasPointPool() {
        return Globals.getGameModePointPoolName().length() != 0;
    }

    public static String getGameModeHPAbbrev() {
        return SettingsHandler.getGame().getHPAbbrev();
    }

    public static String getGameModeHPFormula() {
        return SettingsHandler.getGame().getHPFormula();
    }

    public static String getGameModeHitPointText() {
        return SettingsHandler.getGame().getHPText();
    }

    public static String getGameModeRankModFormula() {
        return SettingsHandler.getGame().getRankModFormula();
    }

    public static boolean getGameModeShowClassDefense() {
        return SettingsHandler.getGame().getShowClassDefense();
    }

    public static boolean getGameModeShowSpellTab() {
        return SettingsHandler.getGame().getTabShown(Tab.SPELLS);
    }

    public static int getGameModeSkillCost_Class() {
        return SettingsHandler.getGame().getSkillCost_Class();
    }

    public static int getGameModeSkillCost_CrossClass() {
        return SettingsHandler.getGame().getSkillCost_CrossClass();
    }

    public static int getGameModeSkillCost_Exclusive() {
        return SettingsHandler.getGame().getSkillCost_Exclusive();
    }

    public static String getGameModeSpellRangeFormula(String string) {
        return SettingsHandler.getGame().getSpellRangeFormula(string);
    }

    public static UnitSet getGameModeUnitSet() {
        return SettingsHandler.getGame().getUnitSet();
    }

    public static String getGameModeVariableDisplay2Name() {
        return SettingsHandler.getGame().getVariableDisplay2Name();
    }

    public static String getGameModeVariableDisplay2Text() {
        return SettingsHandler.getGame().getVariableDisplay2Text();
    }

    public static String getGameModeVariableDisplay3Name() {
        return SettingsHandler.getGame().getVariableDisplay3Name();
    }

    public static String getGameModeVariableDisplay3Text() {
        return SettingsHandler.getGame().getVariableDisplay3Text();
    }

    public static String getGameModeVariableDisplayName() {
        return SettingsHandler.getGame().getVariableDisplayName();
    }

    public static String getGameModeVariableDisplayText() {
        return SettingsHandler.getGame().getVariableDisplayText();
    }

    public static List<String> getGlobalDeityList() {
        if (SettingsHandler.getGame() != null) {
            return SettingsHandler.getGame().getDeityList();
        }
        return new ArrayList<String>();
    }

    public static double getGameModeSquareSize() {
        return SettingsHandler.getGame().getSquareSize();
    }

    public static boolean isInGameMode(String string) {
        return string.length() == 0 || SettingsHandler.getGame() != null && string.equalsIgnoreCase(SettingsHandler.getGame().getName());
    }

    public static Map<String, Kit> getKitInfo() {
        return kitMap;
    }

    public static Kit getKitKeyed(String string) {
        return kitMap.get(string);
    }

    public static void setLanguage(String string) {
        language = string;
    }

    public static String getLanguage() {
        return language;
    }

    public static List<Language> getLanguageList() {
        return languageList;
    }

    public static Language getLanguageKeyed(String string) {
        if (string.equalsIgnoreCase("ALL") || string.equalsIgnoreCase("ANY")) {
            return Language.getAllLanguage();
        }
        for (Language language : Globals.getLanguageList()) {
            if (!language.getKeyName().equalsIgnoreCase(string)) continue;
            return language;
        }
        return null;
    }

    public static Map<String, LevelInfo> getLevelInfo() {
        return SettingsHandler.getGame().getLevelInfo();
    }

    public static List<String> getLoadStrings() {
        if (SettingsHandler.getGame() != null) {
            return SettingsHandler.getGame().getLoadStrings();
        }
        return new ArrayList<String>();
    }

    public static String getLongCurrencyDisplay() {
        return SettingsHandler.getGame().getLongCurrencyDisplay();
    }

    public static List<String> getPCClassTypeList() {
        return pcClassTypeList;
    }

    public static void setPCList(List<PlayerCharacter> list) {
        pcList = list;
    }

    public static List<PlayerCharacter> getPCList() {
        return pcList;
    }

    public static SortedSet<String> getPantheons() {
        return Globals.getPantheonsSet();
    }

    public static int getPaperCount() {
        return SystemCollections.getUnmodifiablePaperInfo().size();
    }

    public static String getPaperInfo(int n) {
        return Globals.getPaperInfo(Globals.getSelectedPaper(), n);
    }

    public static String getPaperInfo(int n, int n2) {
        if (n < 0 || n >= SystemCollections.getUnmodifiablePaperInfo().size()) {
            return null;
        }
        PaperInfo paperInfo = SystemCollections.getUnmodifiablePaperInfo().get(n);
        return paperInfo.getPaperInfo(n2);
    }

    public static SortedSet<String> getRaceTypes() {
        return raceTypesSet;
    }

    public static int getRandomInt() {
        return Globals.getRandom().nextInt();
    }

    public static SortedSet<String> getRangesSet() {
        return rangesSet;
    }

    public static void setRootFrame(JFrame jFrame) {
        rootFrame = jFrame;
    }

    public static JFrame getRootFrame() {
        return rootFrame;
    }

    public static void setCurrentFrame(JFrame jFrame) {
        currentFrame = jFrame;
    }

    public static JFrame getCurrentFrame() {
        if (currentFrame == null) {
            return rootFrame;
        }
        return currentFrame;
    }

    public static SortedSet<SpecialAbility> getSASet() {
        return saSet;
    }

    public static SortedSet<String> getSaveInfoSet() {
        return saveInfoSet;
    }

    public static StringBuffer getSection15() {
        return section15;
    }

    public static int getSelectedPaper() {
        return selectedPaper;
    }

    public static Skill getSkillKeyed(String string) {
        return Globals.searchPObjectList(Globals.getSkillList(), string);
    }

    public static List<Skill> getSkillList() {
        return skillList;
    }

    public static List<Skill> getPartialSkillList(Visibility visibility) {
        ArrayList<Skill> arrayList = new ArrayList<Skill>();
        for (Skill skill : Globals.getSkillList()) {
            Visibility visibility2 = skill.getVisibility();
            if (visibility != Visibility.DEFAULT && visibility2 != Visibility.DEFAULT && visibility2 != visibility) continue;
            arrayList.add(skill);
        }
        return arrayList;
    }

    public static List<Skill> getSkillsByType(String string) {
        return Globals.getPObjectsOfType(Globals.getSkillList(), string);
    }

    public static boolean isEquipmentTypeHidden(String string) {
        return SettingsHandler.getGame().isEquipmentTypeHidden(string);
    }

    public static boolean isAbilityTypeHidden(String string) {
        return SettingsHandler.getGame().isAbilityTypeHidden(string);
    }

    public static boolean isSkillTypeHidden(String string) {
        return SettingsHandler.getGame().isSkillTypeHidden(string);
    }

    public static void setSorted(boolean bl) {
        Globals.setD_sorted(bl);
    }

    public static void setSourceDisplay(SourceEntry.SourceFormat sourceFormat) {
        sourceDisplay = sourceFormat;
    }

    public static SourceEntry.SourceFormat getSourceDisplay() {
        return sourceDisplay;
    }

    public static Spell getSpellKeyed(String string) {
        Object obj = Globals.getSpellMap().get(string);
        if (obj != null) {
            if (obj instanceof Spell) {
                return (Spell)obj;
            }
            if (obj instanceof ArrayList) {
                return (Spell)((ArrayList)obj).get(0);
            }
        }
        return null;
    }

    public static Map<String, ?> getSpellMap() {
        return Collections.unmodifiableMap(spellMap);
    }

    public static void addToSpellMap(String string, Object object) {
        spellMap.put(string, object);
    }

    public static Object removeFromSpellMap(String string) {
        return spellMap.remove(string);
    }

    public static String getSpellPoints() {
        return spellPoints;
    }

    public static List<Spell> getSpellsIn(int n, String string, String string2) {
        ArrayList<Spell> arrayList = new ArrayList<Spell>();
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = backupPcgPath;
        if (string.length() > 0) {
            Object object;
            if (string.indexOf(124) < 0) {
                object = Globals.getClassKeyed(string);
                stringBuffer.append("CLASS|").append(string);
            } else {
                object = Globals.getClassKeyed(string.substring(string.indexOf("|") + 1));
                stringBuffer.append(string);
            }
            if (object != null) {
                string3 = ((PCClass)object).getSpellType();
            }
        }
        if (string2.length() > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('|');
            }
            if (string2.indexOf(124) < 0) {
                stringBuffer.append("DOMAIN|").append(string2);
            } else {
                stringBuffer.append(string2);
            }
            string3 = "DIVINE";
        }
        for (String string4 : spellMap.keySet()) {
            Object object;
            Object object2 = spellMap.get(string4);
            if (object2 instanceof ArrayList) {
                object = ((ArrayList)object2).iterator();
                while (object.hasNext()) {
                    Spell spell = (Spell)object.next();
                    if (!spell.levelForKeyContains(stringBuffer.toString(), n, currentPC) || spell.getType().indexOf(string3.toUpperCase()) < 0) continue;
                    arrayList.add(spell);
                }
                continue;
            }
            if (!(object2 instanceof Spell) || !((Spell)(object = (Spell)object2)).levelForKeyContains(stringBuffer.toString(), n, currentPC)) continue;
            arrayList.add((Spell)object);
        }
        return arrayList;
    }

    public static SortedSet<String> getSrSet() {
        return srSet;
    }

    public static SortedSet<String> getStatSet() {
        return statSet;
    }

    public static SortedSet<String> getSubschools() {
        return Globals.getSubschoolsSet();
    }

    public static SortedSet<String> getTargetSet() {
        return targetSet;
    }

    public static PCTemplate getTemplateKeyed(String string) {
        return Globals.searchPObjectList(Globals.getTemplateList(), string);
    }

    public static List<PCTemplate> getTemplateList() {
        return templateList;
    }

    public static SortedSet<String> getTypeForSpells() {
        return typeForSpellsSet;
    }

    public static void addTypeForSpells(String string) {
        typeForSpellsSet.add(string);
    }

    public static void setUseGUI(boolean bl) {
        useGUI = bl;
    }

    public static boolean getUseGUI() {
        return Globals.isUseGUI();
    }

    public static List<WeaponProf> getWeaponProfArrayCopy() {
        return weaponProfs.getArrayCopy();
    }

    public static WeaponProf getWeaponProfKeyed(String string) {
        return weaponProfs.getKeyed(string);
    }

    public static String getWeaponProfNames(String string, boolean bl) {
        return weaponProfs.getNames(string, bl);
    }

    public static int getWeaponProfSize() {
        return weaponProfs.size();
    }

    public static SortedSet<String> getWeaponTypeList() {
        return weaponTypes;
    }

    public static String getWeaponReachForumla() {
        return SettingsHandler.getGame().getWeaponReachFormula();
    }

    public static void addCampaign(Campaign campaign) {
        campaignMap.put(campaign.getSourceURI(), campaign);
        campaignList.add(campaign);
    }

    public static void addDomain(Domain domain) {
        domainMap.put(domain.getKeyName(), domain);
        domainList.add(domain);
    }

    public static void addDurationSet(String string) {
        durationSet.add(string);
    }

    public static void addSpellCastingTimesSet(String string) {
        castingTimesSet.add(string);
    }

    public static void addSpellComponentSet(String string) {
        componentSet.add(string);
    }

    public static void addSpellDescriptorSet(String string) {
        descriptorSet.add(string);
    }

    public static void addSpellRangesSet(String string) {
        rangesSet.add(string);
    }

    public static void addSpellSaveInfoSet(String string) {
        saveInfoSet.add(string);
    }

    public static void addSpellSrSet(String string) {
        srSet.add(string);
    }

    public static void addSpellStatSet(String string) {
        statSet.add(string);
    }

    public static void addSpellTargetSet(String string) {
        targetSet.add(string);
    }

    public static void addToSASet(SpecialAbility specialAbility) {
        saSet.add(specialAbility);
    }

    public static void addUniqueWeaponProfsAsStringTo(List<String> list) {
        weaponProfs.addUniqueAsStringTo(list);
    }

    public static void addWeaponProf(WeaponProf weaponProf) {
        weaponProfs.add(weaponProf);
    }

    public static String adjustDamage(String string, int n, int n2) {
        Object object;
        String string2 = string;
        int n3 = 1;
        int n4 = 0;
        String string3 = backupPcgPath;
        if (n < n2) {
            string3 = Globals.getDamageUpKey(string);
            n4 = 1;
        } else if (n > n2) {
            string3 = Globals.getDamageDownKey(string);
            n4 = -1;
        }
        if (n4 != 0 && string3 != null) {
            object = new StringTokenizer(string3, "|");
            n3 = Integer.parseInt(((StringTokenizer)object).nextToken());
            string3 = ((StringTokenizer)object).nextToken();
            object = new StringTokenizer(string3, ",");
            while (n != n2 && ((StringTokenizer)object).hasMoreTokens()) {
                string2 = ((StringTokenizer)object).nextToken();
                n += n4;
            }
        }
        if (n3 > 1) {
            object = new RollInfo(string2);
            ((RollInfo)object).times *= n3;
            string2 = ((RollInfo)object).toString();
        }
        return string2;
    }

    public static boolean canResizeHaveEffect(PlayerCharacter playerCharacter, Equipment equipment, List<String> list) {
        if (list == null) {
            list = equipment.typeList();
        }
        for (int i = 0; i < SettingsHandler.getGame().getSizeAdjustmentListSize(); ++i) {
            SizeAdjustment sizeAdjustment = SettingsHandler.getGame().getSizeAdjustmentAtIndex(i);
            if (!(!CoreUtility.doublesEqual(sizeAdjustment.getBonusTo(playerCharacter, "ITEMCOST", list, 1.0), 1.0) || equipment.isArmor() || equipment.isShield() && !CoreUtility.doublesEqual(sizeAdjustment.getBonusTo(playerCharacter, "ACVALUE", list, 1.0), 1.0) || !CoreUtility.doublesEqual(equipment.getWeightAsDouble(playerCharacter), 0.0) && !CoreUtility.doublesEqual(sizeAdjustment.getBonusTo(playerCharacter, "ITEMWEIGHT", list, 1.0), 1.0)) && (!equipment.isContainer() || CoreUtility.doublesEqual(sizeAdjustment.getBonusTo(playerCharacter, "ITEMCAPACITY", list, 1.0), 1.0))) continue;
            return true;
        }
        return false;
    }

    public static boolean checkRule(String string) {
        boolean bl = false;
        GameMode gameMode = SettingsHandler.getGame();
        if (gameMode.hasRuleCheck(string)) {
            bl = gameMode.getRuleCheck(string);
            if (SettingsHandler.hasRuleCheck(string)) {
                bl = SettingsHandler.getRuleCheck(string);
            }
        }
        return bl;
    }

    public static void clearCampaignsForRefresh() {
        Globals.emptyLists();
        campaignMap.clear();
        campaignList.clear();
    }

    public static void clearSASet() {
        saSet.clear();
    }

    public static boolean displayListsHappy() {
        Logging.debugPrint("Number of objects loaded. The following should all be greater than 0:");
        Logging.debugPrint("Races=" + raceMap.size());
        Logging.debugPrint("Classes=" + Globals.getClassList().size());
        Logging.debugPrint("Skills=" + Globals.getSkillList().size());
        Logging.debugPrint("Feats=" + Globals.getUnmodifiableAbilityList("FEAT").size());
        Logging.debugPrint("Equipment=" + EquipmentList.size());
        Logging.debugPrint("WeaponProfs=" + Globals.getWeaponProfSize());
        Logging.debugPrint("Kits=" + kitMap.size());
        Logging.debugPrint("Templates=" + templateList.size());
        return raceMap.size() != 0 && Globals.getClassList().size() != 0 && Globals.getSkillList().size() != 0 && Globals.getUnmodifiableAbilityList("FEAT").size() != 0 && EquipmentList.size() != 0 && Globals.getWeaponProfSize() != 0;
    }

    public static void emptyLists() {
        abilityStore = new CategorisableStore();
        armorProfList = new ArrayList<String>();
        classList = new ArrayList<PCClass>();
        companionModMap = new TreeMap<String, List<CompanionMod>>();
        deityList = new ArrayList<Deity>();
        domainList = new ArrayList<Domain>();
        EquipmentList.clearEquipmentMap();
        kitMap = new HashMap<String, Kit>();
        languageList = new ArrayList<Language>();
        EquipmentList.clearModifierList();
        pcClassTypeList = new ArrayList<String>();
        skillList = new ArrayList<Skill>();
        templateList = new ArrayList<PCTemplate>();
        saSet = new TreeSet<SpecialAbility>();
        Globals.clearWeaponProfs();
        domainMap = new HashMap<String, Domain>();
        raceMap = new TreeMap<String, Race>();
        spellMap = new HashMap<String, Object>();
        VisionType.clearConstants();
        Globals.clearSpellSets();
        pantheonsSet = new TreeSet<String>();
        raceTypesSet = new TreeSet<String>();
        subschoolsSet = new TreeSet<String>();
        weaponTypes = new TreeSet<String>();
        Globals.createEmptyRace();
        Equipment.clearEquipmentTypes();
        PersistenceManager.getInstance().emptyLists();
    }

    public static void executePostExportCommandStandard(String string) {
        String string2 = SettingsHandler.getPostExportCommandStandard();
        Globals.executePostExportCommand(string, string2);
    }

    public static void executePostExportCommandPDF(String string) {
        String string2 = SettingsHandler.getPostExportCommandPDF();
        Globals.executePostExportCommand(string, string2);
    }

    public static void executePostExportCommand(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = (String)arrayList.get(i);
            if (string3.indexOf("%") > -1) {
                String string4 = string3.substring(0, string3.indexOf("%"));
                String string5 = string3.substring(string3.indexOf("%") + 1);
                stringArray[i] = string4 + string + string5;
                continue;
            }
            stringArray[i] = string3;
        }
        if (stringArray.length > 0) {
            try {
                Runtime.getRuntime().exec(stringArray);
            }
            catch (IOException iOException) {
                Logging.errorPrint("Could not execute " + string2 + " after exporting " + string, iOException);
            }
        }
    }

    public static boolean hasWeaponProfVariableNamed(Collection<WeaponProf> collection, String string) {
        return weaponProfs.hasVariableNamed(collection, string);
    }

    public static void loadAttributeNames() {
        Globals.createEmptyRace();
    }

    public static Load loadTypeForLoadScore(int n, Float f, PlayerCharacter playerCharacter) {
        double d = f.doubleValue() / Globals.maxLoadForLoadScore(n, playerCharacter).doubleValue();
        if (SystemCollections.getLoadInfo().getLoadMultiplier("LIGHT") != null && d <= SystemCollections.getLoadInfo().getLoadMultiplier("LIGHT").doubleValue()) {
            return Load.LIGHT;
        }
        if (SystemCollections.getLoadInfo().getLoadMultiplier("MEDIUM") != null && d <= SystemCollections.getLoadInfo().getLoadMultiplier("MEDIUM").doubleValue()) {
            return Load.MEDIUM;
        }
        if (SystemCollections.getLoadInfo().getLoadMultiplier("HEAVY") != null && d <= SystemCollections.getLoadInfo().getLoadMultiplier("HEAVY").doubleValue()) {
            return Load.HEAVY;
        }
        return Load.OVERLOAD;
    }

    public static Float maxLoadForLoadScore(int n, PlayerCharacter playerCharacter) {
        return Globals.maxLoadForLoadScore(n, playerCharacter, new Float(1.0));
    }

    public static Float maxLoadForLoadScore(int n, PlayerCharacter playerCharacter, Float f) {
        Float f2 = SystemCollections.getLoadInfo().getLoadScoreValue(n);
        String string = SystemCollections.getLoadInfo().getLoadModifierFormula();
        if (string.length() != 0) {
            string = CoreUtility.replaceAll(string, "$$SCORE$$", new Float(f2.doubleValue() * f.doubleValue() * Globals.getLoadMultForSize(playerCharacter)).toString());
            return new Float(playerCharacter.getVariableValue(string, backupPcgPath).intValue());
        }
        return new Float(f2.doubleValue() * f.doubleValue() * Globals.getLoadMultForSize(playerCharacter));
    }

    public static void removeWeaponProfKeyed(String string) {
        weaponProfs.removeNamed(string);
    }

    public static int rollHP(int n, int n2, String string, int n3) {
        int n4;
        switch (SettingsHandler.getHPRollMethod()) {
            case 4: {
                n4 = -1;
                break;
            }
            case 2: {
                n4 = n2 - n;
                if ((n3 & 1) == 0 && (n4 & 1) != 0) {
                    ++n4;
                }
                n4 = n + n4 / 2;
                break;
            }
            case 1: {
                n4 = n2;
                break;
            }
            case 3: {
                n4 = n - 1 + (int)((double)(SettingsHandler.getHPPct() * (n2 - n + 1)) / 100.0);
                break;
            }
            case 5: {
                n4 = (int)Math.ceil((double)(n + n2) / 2.0);
                break;
            }
            default: {
                n4 = Math.abs(Globals.getRandomInt(n2 - n + 1)) + n;
            }
        }
        if (SettingsHandler.getShowHPDialogAtLevelUp()) {
            Object[] objectArray = new Object[n2 - n + 2];
            objectArray[0] = "<none selected>";
            for (int i = n; i <= n2; ++i) {
                objectArray[i - n + 1] = i;
            }
            while (n <= n2) {
                InputInterface inputInterface = InputFactory.getInputInstance();
                Object object = inputInterface.showInputDialog(Globals.getRootFrame(), "Randomly generate a number between " + n + " and " + n2 + "." + Constants.s_LINE_SEP + "Select it from the box below.", Globals.getGameModeHitPointText() + " for " + CoreUtility.ordinal(n3) + " level of " + string, MessageType.INFORMATION, objectArray, n4);
                if (object == null || !(object instanceof Integer)) continue;
                n4 = (Integer)object;
                break;
            }
        }
        return n4;
    }

    public static boolean selectPaper(String string) {
        for (int i = 0; i < SystemCollections.getUnmodifiablePaperInfo().size(); ++i) {
            PaperInfo paperInfo = SystemCollections.getUnmodifiablePaperInfo().get(i);
            if (!paperInfo.getName().equals(string)) continue;
            Globals.setSelectedPaper(i);
            return true;
        }
        Globals.setSelectedPaper(-1);
        return false;
    }

    public static int sizeInt(String string) {
        return Globals.sizeInt(string, 0);
    }

    public static int sizeInt(String string, int n) {
        for (int i = 0; i <= SettingsHandler.getGame().getSizeAdjustmentListSize() - 1; ++i) {
            if (!string.startsWith(SettingsHandler.getGame().getSizeAdjustmentAtIndex(i).getAbbreviation())) continue;
            return i;
        }
        return n;
    }

    public static void sortCampaigns() {
        Globals.sortPObjectListByKey(Globals.getClassList());
        Globals.sortPObjectListByKey(Globals.getSkillList());
        Globals.sortPObjectListByKey(Globals.getDeityList());
        Globals.sortPObjectListByKey(Globals.getDomainList());
        Collections.sort(Globals.getArmorProfList());
        Globals.sortPObjectListByKey(Globals.getTemplateList());
        Globals.sortPObjectListByKey(Globals.getLanguageList());
        Globals.setD_sorted(true);
    }

    public static void sortChooserLists(List list, List list2) {
        boolean bl = list.size() > 0 ? list.get(0) instanceof String : (list2.size() > 0 ? list2.get(0) instanceof String : false);
        if (bl) {
            Collections.sort(list);
            if (list2.size() > 0 && list2.get(0) != null) {
                Collections.sort(list2);
            }
        } else {
            Globals.sortPObjectListByName(list);
            Globals.sortPObjectListByName(list2);
        }
    }

    public static List<? extends PObject> sortPObjectList(List<? extends PObject> list) {
        Collections.sort(list, pObjectComp);
        return list;
    }

    public static <T extends PObject> List<T> sortPObjectListByName(List<T> list) {
        Collections.sort(list, pObjectNameComp);
        return list;
    }

    public static <T extends PObject> List<T> sortPObjectListByKey(List<T> list) {
        Collections.sort(list, pObjectStringComp);
        return list;
    }

    protected static <T extends PObject> T searchPObjectList(List<T> list, String string) {
        if (string == null || string.length() <= 0) {
            return null;
        }
        if (list == null || list.size() == 0) {
            return null;
        }
        if (Globals.isD_sorted()) {
            return Globals.binarySearchPObject(list, string);
        }
        for (PObject pObject : list) {
            if (!string.equalsIgnoreCase(pObject.getKeyName())) continue;
            return (T)pObject;
        }
        return null;
    }

    static String getBonusFeatString() {
        return SettingsHandler.getGame().getBonusFeatLevels().get(0);
    }

    static int getBonusFeatsForLevel(int n) {
        int n2 = 0;
        for (String string : SettingsHandler.getGame().getBonusFeatLevels()) {
            n2 = Globals.bonusParsing(string, n, n2);
        }
        return n2;
    }

    static int getBonusStatsForLevel(int n) {
        int n2 = 0;
        for (String string : SettingsHandler.getGame().getBonusStatLevels()) {
            n2 = Globals.bonusParsing(string, n, n2);
        }
        return n2;
    }

    public static <T> List<T> getChoiceFromList(String string, List<T> list, List<T> list2, int n) {
        return Globals.getChoiceFromList(string, list, list2, n, false);
    }

    static <T> List<T> getChoiceFromList(String string, List<T> list, List<T> list2, int n, boolean bl) {
        ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
        chooserInterface.setPool(n);
        chooserInterface.setPoolFlag(bl);
        chooserInterface.setAllowsDups(false);
        chooserInterface.setTitle(string);
        chooserInterface.setAvailableList(list);
        if (list2 != null) {
            chooserInterface.setSelectedList(list2);
        }
        chooserInterface.setVisible(true);
        return chooserInterface.getSelectedList();
    }

    static List<String> getCustColumnWidth() {
        return custColumnWidth;
    }

    static String getDefaultPcgPath() {
        return Globals.expandRelativePath(defaultPcgPath);
    }

    static int[] getDieSizes() {
        return dieSizes;
    }

    static String getFilepathsPath() {
        String string = System.getProperty("pcgen.filepaths");
        if (string == null) {
            string = System.getProperty("user.dir") + File.separator + "filepaths.ini";
        } else {
            File file = new File(Globals.expandRelativePath(string));
            if (file.exists() && file.isDirectory()) {
                string = file.getAbsolutePath() + File.separator + "filepaths.ini";
                file = new File(string);
            }
            if (file.exists() && !file.canWrite()) {
                Logging.errorPrint("WARNING: The filepaths file you specified is not updatable. Filepath changes will not be saved. File is " + file.getAbsolutePath());
            }
        }
        return Globals.expandRelativePath(string);
    }

    static String getFilterPath() {
        String string = System.getProperty("pcgen.filter");
        if (string == null) {
            string = Globals.getFilePath("filter.ini");
        } else {
            File file = new File(Globals.expandRelativePath(string));
            if (file.exists() && file.isDirectory()) {
                string = file.getAbsolutePath() + File.separator + "filter.ini";
                file = new File(string);
            }
            if (file.exists() && !file.canWrite()) {
                Logging.errorPrint("WARNING: The filter file you specified is not updatable. Filter changes will not be saved. File is " + file.getAbsolutePath());
            }
        }
        return Globals.expandRelativePath(string);
    }

    static List<Language> getLanguagesFromListOfType(List<Language> list, String string) {
        ArrayList<Language> arrayList = new ArrayList<Language>();
        for (Language language : list) {
            if (language == null || !language.isType(string) && (string.length() <= 0 || string.charAt(0) != '!' || language.isType(string))) continue;
            arrayList.add(language);
        }
        return arrayList;
    }

    static String getOptionsPath() {
        String string = System.getProperty("pcgen.options");
        if (string == null) {
            string = Globals.getFilePath("options.ini");
        } else {
            File file = new File(Globals.expandRelativePath(string));
            if (file.exists() && file.isDirectory()) {
                string = file.getAbsolutePath() + File.separator + "options.ini";
                file = new File(string);
            }
            if (file.exists() && !file.canWrite()) {
                Logging.errorPrint("WARNING: The options file you specified is not updatable. Settings changes will not be saved. File is " + file.getAbsolutePath());
            }
        }
        return Globals.expandRelativePath(string);
    }

    public static int getRandomInt(int n) {
        if (n <= 0) {
            return 0;
        }
        int n2 = Globals.getRandom().nextInt(n);
        Logging.debugPrint("Generated random number between 0 and " + n + ": " + n2);
        return n2;
    }

    static int getSkillMultiplierForLevel(int n) {
        List<String> list = SettingsHandler.getGame().getSkillMultiplierLevels();
        if (n > list.size() || n <= 0) {
            return 1;
        }
        return Integer.parseInt(list.get(n - 1));
    }

    public static List<WeaponProf> getWeaponProfs(String string, PlayerCharacter playerCharacter) {
        ArrayList<WeaponProf> arrayList = new ArrayList<WeaponProf>();
        ArrayList<WeaponProf> arrayList2 = new ArrayList<WeaponProf>();
        for (String object : playerCharacter.getChangeProfList()) {
            StringTokenizer stringTokenizer = new StringTokenizer(object, "|");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            WeaponProf weaponProf = Globals.getWeaponProfKeyed(string2);
            if (weaponProf == null) continue;
            if (string3.equalsIgnoreCase(string)) {
                arrayList.add(weaponProf);
                continue;
            }
            arrayList2.add(weaponProf);
        }
        Collection<WeaponProf> collection = Globals.getAllWeaponProfsOfType(string);
        if (collection == null) {
            return arrayList;
        }
        for (WeaponProf weaponProf : collection) {
            if (arrayList2.contains(weaponProf)) continue;
            arrayList.add(weaponProf);
        }
        return arrayList;
    }

    public static void addWeaponType(String string) {
        weaponTypes.add(string.toUpperCase());
    }

    static String adjustDamage(String string, String string2, String string3) {
        if (string.length() == 0) {
            return string;
        }
        return Globals.adjustDamage(string, Globals.sizeInt(string2), Globals.sizeInt(string3));
    }

    static <T extends PObject> T binarySearchPObject(List<T> list, String string) {
        if (string == null || string.length() <= 0) {
            return null;
        }
        int n = Collections.binarySearch(list, string, pObjectStringComp);
        if (n >= 0) {
            return (T)((PObject)list.get(n));
        }
        return null;
    }

    static double calcEncumberedMove(Load load, double d, boolean bl) {
        return Globals.calcEncumberedMove(load, d, bl, null);
    }

    static double calcEncumberedMove(Load load, double d, boolean bl, PlayerCharacter playerCharacter) {
        double d2;
        if (bl) {
            if (playerCharacter != null && playerCharacter.ignoreEncumberedLoadMove(load)) {
                d2 = d;
            } else {
                String string;
                if (playerCharacter != null && (string = SystemCollections.getLoadInfo().getLoadMoveFormula(load.toString())).length() != 0) {
                    string = CoreUtility.replaceAll(string, "$$MOVE$$", new Float(Math.floor(d)).toString());
                    return playerCharacter.getVariableValue(string, backupPcgPath).doubleValue();
                }
                switch (load) {
                    case LIGHT: {
                        d2 = d;
                        break;
                    }
                    case MEDIUM: 
                    case HEAVY: {
                        if (CoreUtility.doublesEqual(d, 5.0)) {
                            d2 = 5.0;
                            break;
                        }
                        if (CoreUtility.doublesEqual(d, 10.0)) {
                            d2 = 5.0;
                            break;
                        }
                        d2 = Math.floor(d / 15.0) * 10.0 + (double)((int)d % 15);
                        break;
                    }
                    case OVERLOAD: {
                        d2 = 0.0;
                        break;
                    }
                    default: {
                        Logging.errorPrint("The load " + (Object)((Object)load) + " is not possible.");
                        d2 = 0.0;
                        break;
                    }
                }
            }
        } else {
            d2 = d;
        }
        return d2;
    }

    public static SortedSet<Language> getLanguagesFromString(String string) {
        TreeSet<Language> treeSet = new TreeSet<Language>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("ALL".equals(string2)) {
                treeSet.addAll(Globals.getLanguageList());
                return treeSet;
            }
            if (string2.startsWith("TYPE=") || string2.startsWith("TYPE.")) {
                treeSet.addAll(Globals.getLanguagesOfType(string2.substring(5)));
                continue;
            }
            Language language = Globals.getLanguageKeyed(string2);
            if (language == null) {
                Logging.debugPrint("Someone expected Language: " + string2 + " to exist: it doesn't");
                continue;
            }
            treeSet.add(language);
        }
        return treeSet;
    }

    static void initCustColumnWidth(List<String> list) {
        Globals.getCustColumnWidth().clear();
        Globals.getCustColumnWidth().addAll(list);
    }

    public static boolean weaponTypesContains(String string) {
        return weaponTypes.contains(string.toUpperCase());
    }

    private static List<String> getArmorProfList() {
        return armorProfList;
    }

    private static void setD_sorted(boolean bl) {
        d_sorted = bl;
    }

    private static boolean isD_sorted() {
        return d_sorted;
    }

    private static String getDamageDownKey(String string) {
        if (SettingsHandler.getGame().getDamageDownMap().containsKey(string)) {
            return "1|" + SettingsHandler.getGame().getDamageDownMap().get(string);
        }
        RollInfo rollInfo = new RollInfo(string);
        String string2 = "1d" + Integer.toString(rollInfo.sides);
        if (SettingsHandler.getGame().getDamageDownMap().containsKey(string2)) {
            return Integer.toString(rollInfo.times) + "|" + SettingsHandler.getGame().getDamageDownMap().get(string2);
        }
        return null;
    }

    private static String getDamageUpKey(String string) {
        if (SettingsHandler.getGame().getDamageUpMap().containsKey(string)) {
            return "1|" + SettingsHandler.getGame().getDamageUpMap().get(string);
        }
        RollInfo rollInfo = new RollInfo(string);
        String string2 = "1d" + Integer.toString(rollInfo.sides);
        if (SettingsHandler.getGame().getDamageUpMap().containsKey(string2)) {
            return Integer.toString(rollInfo.times) + "|" + SettingsHandler.getGame().getDamageUpMap().get(string2);
        }
        return null;
    }

    private static String getFilePath(String string) {
        String string2 = SettingsHandler.getFilePaths();
        if (string2 == null || string2.equals("pcgen")) {
            return System.getProperty("user.dir") + File.separator + string;
        }
        if (string2.equals("user")) {
            return System.getProperty("user.home") + File.separator + ".pcgen" + File.separator + string;
        }
        return string2 + File.separator + string;
    }

    public static List<Language> getLanguagesOfType(String string) {
        return Globals.getPObjectsOfType(Globals.getLanguageList(), string);
    }

    private static double getLoadMultForSize(PlayerCharacter playerCharacter) {
        SizeAdjustment sizeAdjustment;
        double d = 1.0;
        String string = playerCharacter.getSize();
        Float f = SystemCollections.getLoadInfo().getSizeAdjustment(string);
        if (f != null) {
            d = f.doubleValue();
        }
        if ((sizeAdjustment = SettingsHandler.getGame().getSizeAdjustmentAtIndex(Globals.sizeInt(string))) == null) {
            sizeAdjustment = SettingsHandler.getGame().getDefaultSizeAdjustment();
        }
        if (sizeAdjustment != null) {
            d += sizeAdjustment.bonusTo("LOADMULT", "TYPE=SIZE", playerCharacter, playerCharacter);
        }
        return d;
    }

    private static SortedSet<String> getPantheonsSet() {
        return pantheonsSet;
    }

    private static Random getRandom() {
        return random;
    }

    private static void setSelectedPaper(int n) {
        selectedPaper = n;
    }

    private static SortedSet<String> getSubschoolsSet() {
        return subschoolsSet;
    }

    private static boolean isUseGUI() {
        return useGUI;
    }

    private static int bonusParsing(String string, int n, int n2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        int n4 = Integer.parseInt(stringTokenizer.nextToken());
        if (n == n3 || n > n3 && n4 > 0 && (n - n3) % n4 == 0) {
            ++n2;
        }
        return n2;
    }

    private static void clearSpellSets() {
        castingTimesSet.clear();
        componentSet.clear();
        descriptorSet.clear();
        durationSet.clear();
        rangesSet.clear();
        saveInfoSet.clear();
        srSet.clear();
        statSet.clear();
        targetSet.clear();
    }

    private static void clearWeaponProfs() {
        weaponProfs.clear();
    }

    private static void createEmptyRace() {
        if (s_EMPTYRACE == null) {
            s_EMPTYRACE = new Race();
            s_EMPTYRACE.setName("<none selected>");
            s_EMPTYRACE.setTypeInfo("HUMANOID");
        }
        Globals.addRace(s_EMPTYRACE);
    }

    private static String expandRelativePath(String string) {
        if (string.startsWith("@")) {
            string = System.getProperty("user.dir") + File.separator + string.substring(1);
        }
        return string;
    }

    public static void addSponsor(Map<String, String> map) {
        sponsors.put(map.get("SPONSOR"), map);
        sponsorList.add(map);
    }

    public static List<Map<String, String>> getSponsors() {
        return sponsorList;
    }

    public static Map<String, String> getSponsor(String string) {
        return sponsors.get(string);
    }

    public static List<String> getAllGenders() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(PropertyFactory.getString("in_genderMale"));
        arrayList.add(PropertyFactory.getString("in_genderFemale"));
        arrayList.add(PropertyFactory.getString("in_genderNeuter"));
        arrayList.add(PropertyFactory.getString("in_comboNone"));
        arrayList.add(PropertyFactory.getString("in_comboOther"));
        return arrayList;
    }

    public static Race getRaceKeyed(String string) {
        return (Race)raceMap.get(string.toLowerCase());
    }

    public static void addRace(Race race) {
        raceMap.put(race.getKeyName().toLowerCase(), race);
    }

    public static Collection<Race> getAllRaces() {
        return Collections.unmodifiableCollection(raceMap.values());
    }

    public static boolean removeRaceKeyed(String string) {
        return raceMap.remove(string.toLowerCase()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        pcList = new ArrayList<PlayerCharacter>();
        javaVersion = System.getProperty("java.version");
        javaVersionMajor = Integer.valueOf(javaVersion.substring(0, javaVersion.indexOf(46)));
        javaVersionMinor = Integer.valueOf(javaVersion.substring(javaVersion.indexOf(46) + 1, javaVersion.lastIndexOf(46)));
        defaultPath = System.getProperty("user.dir");
        defaultPcgPath = Globals.getDefaultPath() + File.separator + "characters";
        dieSizes = new int[]{1, 2, 3, 4, 6, 8, 10, 12, 20, 100, 1000};
        language = "en";
        country = "US";
        bioSet = new BioSet();
        custColumnWidth = new ArrayList<String>();
        sourceDisplay = SourceEntry.SourceFormat.LONG;
        selectedPaper = -1;
        abilityStore = new CategorisableStore();
        campaignMap = new HashMap<URI, Campaign>();
        domainMap = new TreeMap<String, Domain>();
        raceMap = new TreeMap<String, Race>();
        spellMap = new TreeMap<String, Object>();
        eqSlotMap = new HashMap<String, String>();
        companionModMap = new TreeMap<String, List<CompanionMod>>();
        armorProfList = new ArrayList<String>();
        campaignList = new ArrayList<Campaign>(85);
        classList = new ArrayList<PCClass>(380);
        deityList = new ArrayList<Deity>(275);
        domainList = new ArrayList<Domain>(100);
        kitMap = new HashMap<String, Kit>();
        languageList = new ArrayList<Language>(200);
        pcClassTypeList = new ArrayList<String>();
        skillList = new ArrayList<Skill>(400);
        templateList = new ArrayList<PCTemplate>(350);
        saSet = new TreeSet<SpecialAbility>();
        sponsors = new HashMap<String, Map<String, String>>();
        sponsorList = new ArrayList<Map<String, String>>();
        weaponProfs = new PObjectDataStore("WeaponProf");
        random = new Random(System.currentTimeMillis());
        pantheonsSet = new TreeSet<String>();
        raceTypesSet = new TreeSet<String>();
        subschoolsSet = new TreeSet<String>();
        weaponTypes = new TreeSet<String>();
        castingTimesSet = new TreeSet<String>();
        componentSet = new TreeSet<String>();
        descriptorSet = new TreeSet<String>();
        durationSet = new TreeSet<String>();
        typeForSpellsSet = new TreeSet<String>();
        rangesSet = new TreeSet<String>();
        saveInfoSet = new TreeSet<String>();
        srSet = new TreeSet<String>();
        statSet = new TreeSet<String>();
        targetSet = new TreeSet<String>();
        section15 = new StringBuffer(30000);
        useGUI = true;
        pObjectComp = new Comparator<PObject>(){

            @Override
            public int compare(PObject pObject, PObject pObject2) {
                return pObject.getKeyName().compareToIgnoreCase(pObject2.getKeyName());
            }
        };
        pObjectNameComp = new Comparator<PObject>(){

            @Override
            public int compare(PObject pObject, PObject pObject2) {
                Collator collator = Collator.getInstance();
                return collator.compare(pObject.getDisplayName(), pObject2.getDisplayName());
            }
        };
        pObjectStringComp = new Comparator<Object>(){

            @Override
            public int compare(Object object, Object object2) {
                String string = object instanceof PObject ? ((PObject)object).getKeyName() : object.toString();
                String string2 = object2 instanceof PObject ? ((PObject)object2).getKeyName() : object2.toString();
                return string.compareToIgnoreCase(string2);
            }
        };
        EMPTY_CLASS_ARRAY = new Class[0];
        EMPTY_DOUBLE_ARRAY = new Double[0];
        EMPTY_OBJECT_ARRAY = new Object[0];
        EMPTY_STRING_ARRAY = new String[0];
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("pcgen/gui/prop/PCGenProp");
            resourceBundle.getString("VersionNumber");
        }
        catch (MissingResourceException missingResourceException) {
            Logging.errorPrint("Can't find the VersionNumber property.", missingResourceException);
        }
        finally {
            Object var0_1 = null;
        }
    }
}

