/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.PrereqHandler;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;

public final class KitUtilities {
    private KitUtilities() {
    }

    public static final void makeKitSelections(int n, String string, int n2, PlayerCharacter playerCharacter) {
        Object object;
        int n3;
        int n4;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        String string2 = stringTokenizer.nextToken();
        try {
            n4 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint("Badly formed kitString: " + string2);
            n4 = 0;
        }
        if (n4 > n) {
            return;
        }
        string2 = stringTokenizer.nextToken();
        try {
            n3 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint("Badly formed number of kit selections attribute: " + string2);
            n3 = 0;
        }
        List<Kit> list = new ArrayList<Kit>();
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            Kit kit = Globals.getKitKeyed((String)object);
            if (kit == null) {
                Logging.errorPrint("Nonexistant kit: " + object);
                return;
            }
            if (!PrereqHandler.passesAll(kit.getPreReqList(), playerCharacter, kit)) continue;
            list.add(kit);
        }
        if (n3 != list.size()) {
            object = ChooserFactory.getChooserInstance();
            object.setTitle("Kit Selection");
            object.setPool(n3);
            object.setPoolFlag(false);
            object.setAvailableList(list);
            object.setVisible(true);
            list = object.getSelectedList();
        }
        if (list.size() > 0) {
            for (Kit kit : list) {
                Kit.applyKit(kit, playerCharacter);
            }
        }
    }
}

