/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.util.Logging;

public class Movement {
    private String[] movementTypes;
    private Double[] movements;
    private Double[] movementMult;
    private String[] movementMultOp;
    private int moveRatesFlag;
    private Double movement;

    public Movement() {
        this(0);
    }

    private Movement(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Argument of array length to ConcreteMovementconstructor cannot be negative");
        }
        this.movementTypes = new String[n];
        this.movements = new Double[n];
        this.movementMult = new Double[n];
        this.movementMultOp = new String[n];
    }

    public void setMoveRatesFlag(int n) {
        this.moveRatesFlag = n;
    }

    public int getMoveRatesFlag() {
        return this.moveRatesFlag;
    }

    public Double getDoubleMovement() {
        return this.movement;
    }

    public Double getMovementMult(int n) {
        return this.movementMult[n];
    }

    public String getMovementMultOp(int n) {
        return this.movementMultOp[n];
    }

    public Double[] getMovementMult() {
        return (Double[])this.movementMult.clone();
    }

    public String[] getMovementMultOp() {
        return (String[])this.movementMultOp.clone();
    }

    public int getNumberOfMovementTypes() {
        return this.movementTypes != null ? this.movementTypes.length : 0;
    }

    public void setMovementTypes(String[] stringArray) {
        this.movementTypes = stringArray;
    }

    public String getMovementType(int n) {
        if (this.movementTypes != null && n < this.movementTypes.length) {
            return this.movementTypes[n];
        }
        return "";
    }

    public String getMovementTypeAt(int n) {
        return this.movementTypes[n];
    }

    public String[] getMovementTypes() {
        return (String[])this.movementTypes.clone();
    }

    public double getMovementAt(int n) {
        return this.movements[n];
    }

    public Double getMovement(int n) {
        if (this.movements != null && n < this.movements.length) {
            return this.movements[n];
        }
        return 0.0;
    }

    public int getNumberOfMovements() {
        return this.movements != null ? this.movements.length : 0;
    }

    public boolean isInitialized() {
        return this.movements != null;
    }

    public Double[] getMovements() {
        return (Double[])this.movements.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.movementTypes[0]);
        stringBuffer.append(' ').append(Globals.getGameModeUnitSet().convertDistanceToUnitSet(this.movements[0]));
        stringBuffer.append(Globals.getGameModeUnitSet().getDistanceUnit());
        if (this.movementMult[0] != 0.0) {
            stringBuffer.append('(').append(this.movementMultOp[0]).append(this.movementMult[0]).append(')');
        }
        for (int i = 1; i < this.movementTypes.length; ++i) {
            stringBuffer.append(", ");
            stringBuffer.append(this.movementTypes[i]);
            stringBuffer.append(' ').append(Globals.getGameModeUnitSet().convertDistanceToUnitSet(this.movements[i]));
            stringBuffer.append(Globals.getGameModeUnitSet().getDistanceUnit());
            if (this.movementMult[i] == 0.0) continue;
            stringBuffer.append('(').append(this.movementMultOp[i]).append(this.movementMult[i]).append(')');
        }
        return stringBuffer.toString();
    }

    public String toLSTString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\tMOVE");
        switch (this.moveRatesFlag) {
            case 1: {
                stringBuffer.append('A');
                break;
            }
            case 2: {
                stringBuffer.append("CLONE");
                break;
            }
        }
        stringBuffer.append(':');
        for (int i = 0; i < this.movementTypes.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            if (this.movementTypes[i] != null && this.movementTypes[i].length() > 0) {
                stringBuffer.append(this.movementTypes[i]).append(',');
            }
            if (this.movementMultOp[i].length() > 0) {
                stringBuffer.append(this.movementMultOp[i]).append(this.movementMult[i]);
                continue;
            }
            stringBuffer.append(this.movements[i]);
        }
        return stringBuffer.toString();
    }

    public static Movement getMovementFrom(String string) {
        Movement movement;
        if (string == null) {
            throw new IllegalArgumentException("Null initialization String illegal");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() == 1) {
            String string2 = stringTokenizer.nextToken();
            movement = new Movement(1);
            if (string2.length() > 0 && (string2.charAt(0) == '*' || string2.charAt(0) == '/')) {
                movement.movements[0] = 0.0;
                movement.movement = 0.0;
                try {
                    double d = Double.parseDouble(string2.substring(1));
                    if (d <= 0.0) {
                        Logging.errorPrint("Illegal movement multiplier: " + d + " in movement string " + string2);
                    }
                    movement.movementMult[0] = d;
                    movement.movementMultOp[0] = string2.substring(0, 1);
                }
                catch (NumberFormatException numberFormatException) {
                    Logging.errorPrint("Badly formed MOVE token: " + string2);
                    movement.movementMult[0] = 0.0;
                    movement.movementMultOp[0] = "";
                }
            } else if (string2.length() > 0) {
                try {
                    movement.movements[0] = movement.movement = new Double(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    Logging.errorPrint("Badly formed movement string: " + string2);
                    movement.movements[0] = 0.0;
                }
                movement.movementMult[0] = 0.0;
                movement.movementMultOp[0] = "";
            }
            movement.movementTypes[0] = "Walk";
        } else {
            movement = new Movement(stringTokenizer.countTokens() / 2);
            int n = 0;
            while (stringTokenizer.countTokens() > 1) {
                movement.movementTypes[n] = stringTokenizer.nextToken();
                movement.movementMult[n] = 0.0;
                movement.movementMultOp[n] = "";
                String string3 = stringTokenizer.nextToken();
                if (string3.length() > 0 && (string3.charAt(0) == '*' || string3.charAt(0) == '/')) {
                    movement.movements[n] = 0.0;
                    try {
                        double d = Double.parseDouble(string3.substring(1));
                        if (d <= 0.0) {
                            Logging.errorPrint("Illegal movement multiplier: " + d + " in movement string " + string3);
                        }
                        movement.movementMult[n] = d;
                        movement.movementMultOp[n] = string3.substring(0, 1);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Logging.errorPrint("Badly formed MOVE token: " + string3);
                        movement.movementMult[n] = 0.0;
                        movement.movementMultOp[n] = "";
                    }
                } else if (string3.length() > 0) {
                    movement.movementMult[n] = 0.0;
                    movement.movementMultOp[n] = "";
                    try {
                        movement.movements[n] = new Double(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Logging.errorPrint("Badly formed MOVE token: " + string3);
                        movement.movements[n] = 0.0;
                    }
                    if ("Walk".equals(movement.movementTypes[n])) {
                        movement.movement = movement.movements[n];
                    }
                }
                ++n;
            }
            if (stringTokenizer.countTokens() != 0) {
                Logging.errorPrint("Badly formed MOVE token (extra value at end of list): " + string);
            }
        }
        return movement;
    }
}

