/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.CharacterDomain;
import pcgen.core.ClassType;
import pcgen.core.Constants;
import pcgen.core.DamageReduction;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.Globals;
import pcgen.core.KitUtilities;
import pcgen.core.LevelProperty;
import pcgen.core.Movement;
import pcgen.core.PCSpell;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.PrereqObject;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SpecialAbility;
import pcgen.core.SpellFilter;
import pcgen.core.SpellProgressionInfo;
import pcgen.core.SpellProhibitor;
import pcgen.core.SubClass;
import pcgen.core.SubstitutionClass;
import pcgen.core.Variable;
import pcgen.core.Vision;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.character.CharacterSpell;
import pcgen.core.levelability.LevelAbility;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.pclevelinfo.PCLevelInfoStat;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.core.utils.ChoiceList;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.ListKey;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.util.DoubleKeyMap;
import pcgen.util.InputFactory;
import pcgen.util.InputInterface;
import pcgen.util.Logging;
import pcgen.util.MapCollection;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;
import pcgen.util.enumeration.AttackType;
import pcgen.util.enumeration.DefaultTriState;
import pcgen.util.enumeration.Load;
import pcgen.util.enumeration.Visibility;
import pcgen.util.enumeration.VisionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PCClass
extends PObject {
    public static final int NO_LEVEL_LIMIT = -1;
    private List<LevelProperty<Domain>> domainList = null;
    private List<LevelProperty<Movement>> movementList = null;
    private List<LevelProperty<String>> featAutos = null;
    private List<LevelProperty<String>> featList = null;
    private List<SpellFilter> knownSpellsList = null;
    private List<String> specialtyList = null;
    private List<LevelProperty<String>> templates = null;
    private List<LevelProperty<String>> SR = null;
    private List<LevelProperty<Load>> encumberedLoadMove = null;
    private List<LevelProperty<Load>> encumberedArmorMove = null;
    private List<LevelProperty<Domain>> addDomains = null;
    private List<LevelProperty<Equipment>> naturalWeapons = null;
    private List<SubClass> subClassList = null;
    private List<SubstitutionClass> substitutionClassList = null;
    private List<String> uattList = new ArrayList<String>();
    private HashMap<Integer, Integer> castForLevelMap = null;
    private HashMap<Integer, Integer> hitPointMap = null;
    private List<LevelProperty<List<Ability>>> vFeatList = null;
    private DoubleKeyMap<AbilityCategory, Integer, List<Ability>> vAbilityMap = null;
    private List<LevelProperty<String>> hitDieLockList = null;
    private int skillPool = 0;
    private List<String> classSkillList = null;
    private List<String> classSpellList = null;
    private List<String> skillList = null;
    private List<LevelProperty<Vision>> visionList = null;
    private String CRFormula = null;
    private DefaultTriState XPPenalty = DefaultTriState.DEFAULT;
    private String abbrev = "";
    private String castAs = "";
    private ChoiceList<String> classSkillChoices = null;
    private ChoiceList<String> classSpellChoices = null;
    private List<String> deityList = new ArrayList<String>(2);
    private String exClass = "";
    private String itemCreationMultiplier = "";
    private String levelExchange = "";
    private Boolean monsterFlag = null;
    private String preRaceType = null;
    private List<String> prohibitedSchools = null;
    private String stableSpellKey = null;
    private String subClassKey = "None";
    private Map<Integer, String> substitutionClassKey = null;
    private boolean hasSubClass = false;
    private boolean hasSubstitutionClass = false;
    private boolean modToSkills = true;
    private boolean multiPreReqs = false;
    private List<SpellProhibitor> prohibitSpellDescriptorList = null;
    private int hitDie = 0;
    private int initMod = 0;
    private int initialFeats = 0;
    private Integer levelsPerFeat = null;
    private int maxLevel = -1;
    private String skillPointFormula = "0";
    private String classKey = "";
    protected int level = 0;
    private HashMap<AttackType, String> attackCycleMap = null;
    private SpellProgressionInfo castInfo = null;

    public PCClass() {
        this.deityList.add("ANY");
    }

    public final void setAbbrev(String string) {
        this.abbrev = string;
    }

    public final String getAbbrev() {
        return this.abbrev;
    }

    @Override
    public void setKeyName(String string) {
        super.setKeyName(string);
        this.classKey = "CLASS:" + this.keyName;
    }

    @Override
    public String getQualifiedKey() {
        return this.classKey;
    }

    public final List<Domain> getAddDomains(int n) {
        if (this.addDomains == null) {
            List list = Collections.emptyList();
            return Collections.unmodifiableList(list);
        }
        ArrayList<Domain> arrayList = new ArrayList<Domain>();
        for (LevelProperty<Domain> levelProperty : this.addDomains) {
            if (levelProperty.getLevel() != n) continue;
            arrayList.add(levelProperty.getObject());
        }
        return arrayList;
    }

    public List<LevelProperty<Domain>> getAddDomains() {
        if (this.addDomains == null) {
            return null;
        }
        return Collections.unmodifiableList(this.addDomains);
    }

    @Deprecated
    public final void setCastAs(String string) {
        this.castAs = string;
    }

    @Deprecated
    public final String getCastAs() {
        if (this.castAs == null || this.castAs.equals("")) {
            return this.keyName;
        }
        return this.castAs;
    }

    public final void setBonusSpellBaseStat(String string) {
        this.getConstructingSpellProgressionInfo().setBonusSpellBaseStatAbbr(string);
    }

    public final String getBonusSpellBaseStat() {
        return this.castInfo == null ? "Default" : this.castInfo.getBonusSpellBaseStatAbbr();
    }

    public double getBonusTo(String string, String string2, int n, PlayerCharacter playerCharacter) {
        double d = 0.0;
        if (n == 0 || this.getBonusList().isEmpty()) {
            return 0.0;
        }
        String string3 = string.toUpperCase();
        String string4 = string2.toUpperCase();
        for (BonusObj bonusObj : this.getBonusList()) {
            StringTokenizer stringTokenizer = new StringTokenizer(bonusObj.toString().toUpperCase(), "|", false);
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            String string5 = stringTokenizer.nextToken();
            if (!string5.equals(string3)) continue;
            String string6 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string6, ",", false);
            while (stringTokenizer2.hasMoreTokens()) {
                String string7 = stringTokenizer2.nextToken();
                if (n2 > n || !string7.equals(string4)) continue;
                String string8 = stringTokenizer.nextToken();
                ArrayList<Prerequisite> arrayList = new ArrayList<Prerequisite>();
                if (bonusObj.hasPreReqs()) {
                    arrayList.addAll(bonusObj.getPreReqList());
                }
                while (stringTokenizer.hasMoreTokens()) {
                    String string9 = stringTokenizer.nextToken();
                    if (!PreParserFactory.isPreReqString(string9)) continue;
                    Logging.debugPrint("Why is this prerequisite '" + string9 + "' parsed in '" + this.getClass().getName() + ".getBonusTo(String,String,int)' rather than in the persistence layer?");
                    try {
                        PreParserFactory preParserFactory = PreParserFactory.getInstance();
                        arrayList.add(preParserFactory.parse(string9));
                    }
                    catch (PersistenceLayerException persistenceLayerException) {
                        Logging.errorPrint(persistenceLayerException.getMessage(), persistenceLayerException);
                    }
                }
                if (!PrereqHandler.passesAll(arrayList, playerCharacter, null)) continue;
                double d2 = playerCharacter.getVariableValue(string8, this.classKey).doubleValue();
                d += d2;
            }
        }
        return d;
    }

    public int getCastForLevel(int n, String string, PlayerCharacter playerCharacter) {
        return this.getCastForLevel(n, string, true, true, playerCharacter);
    }

    public int getCastForLevel(int n, String string, boolean bl, boolean bl2, PlayerCharacter playerCharacter) {
        int n2;
        Object object;
        int n3;
        int n4;
        int n5 = this.getLevel();
        int n6 = 0;
        int n7 = 0;
        String string2 = "CLASS." + this.getKeyName();
        String string3 = ";LEVEL." + n;
        n5 += (int)playerCharacter.getTotalBonusTo("PCLEVEL", this.keyName);
        if (this.getNumFromCastList(n5 += (int)playerCharacter.getTotalBonusTo("PCLEVEL", "TYPE." + this.getSpellType()), n, playerCharacter) < 0) {
            return (int)playerCharacter.getTotalBonusTo("SPELLCAST", string2 + string3);
        }
        n6 += (int)playerCharacter.getTotalBonusTo("SPELLCAST", string2 + string3);
        n6 += (int)playerCharacter.getTotalBonusTo("SPELLCAST", "TYPE." + this.getSpellType() + string3);
        n6 += (int)playerCharacter.getTotalBonusTo("SPELLCAST", "CLASS.Any" + string3);
        n6 += (int)playerCharacter.getTotalBonusTo("SPELLCAST", string2 + ";LEVEL.All");
        n6 += (int)playerCharacter.getTotalBonusTo("SPELLCAST", "TYPE." + this.getSpellType() + ";LEVEL.All");
        n6 += (int)playerCharacter.getTotalBonusTo("SPELLCAST", "CLASS.Any;LEVEL.All");
        int n8 = this.bonusSpellIndex();
        if (n8 != -2 && n8 >= 0 && n8 < playerCharacter.getStatList().size()) {
            PCStat pCStat = playerCharacter.getStatList().getStatAt(n8);
            n7 = playerCharacter.getStatList().getTotalStatFor(pCStat.getAbb());
        }
        String string4 = "None";
        if (n8 >= 0) {
            string4 = SettingsHandler.getGame().s_ATTRIBSHORT[n8];
        }
        int n9 = (int)playerCharacter.getTotalBonusTo("STAT", "CAST." + string4) + (int)playerCharacter.getTotalBonusTo("STAT", "BASESPELLSTAT") + (int)playerCharacter.getTotalBonusTo("STAT", "BASESPELLSTAT;CLASS." + this.keyName);
        if (n8 > -2 && bl2 && (n4 = playerCharacter.getVariableValue("MAXLEVELSTAT=" + string4, "").intValue()) + n9 < n) {
            return n6;
        }
        n7 += n9;
        n4 = 0;
        if (bl && !string.equals(Globals.getDefaultSpellBook()) && (this.hasSpecialtyList() || playerCharacter.hasCharacterDomainList())) {
            for (n3 = 0; n3 <= n; ++n3) {
                List<CharacterSpell> list = this.getSpellSupport().getCharacterSpell(null, "", n3);
                object = new ArrayList();
                if (!list.isEmpty()) {
                    if (n3 > 0 && "DIVINE".equalsIgnoreCase(this.castInfo.getSpellType())) {
                        for (CharacterDomain n11 : playerCharacter.getCharacterDomainList()) {
                            if (!n11.isFromPCClass(this.getKeyName()) || n11.getDomain() == null) continue;
                            object = Globals.getSpellsIn(n3, "", n11.getDomain().getKeyName());
                        }
                    }
                    for (CharacterSpell characterSpell : list) {
                        n2 = -1;
                        if (!object.isEmpty()) {
                            if (object.contains(characterSpell.getSpell())) {
                                n2 = 0;
                            }
                        } else {
                            n2 = characterSpell.getInfoIndexFor("", n3, 1);
                        }
                        if (n2 <= -1) continue;
                        n4 = 1;
                        break;
                    }
                }
                if (n4 == 1) break;
            }
        }
        n3 = (int)playerCharacter.getTotalBonusTo("SPELLCASTMULT", string2 + string3);
        if ((n3 += (int)playerCharacter.getTotalBonusTo("SPELLCASTMULT", "TYPE." + this.getSpellType() + string3)) < 1) {
            n3 = 1;
        }
        int n10 = this.getNumFromCastList(n5, n, playerCharacter);
        n6 += n10 * n3 + n4;
        object = Globals.getBonusSpellMap().get(String.valueOf(n));
        if (object != null && !((String)object).equals("0|0")) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, "|");
            int n11 = Integer.parseInt(stringTokenizer.nextToken());
            n2 = Integer.parseInt(stringTokenizer.nextToken());
            if (n7 >= n11) {
                n6 += Math.max(0, (n7 - n11 + n2) / n2);
            }
        }
        return n6;
    }

    public void setClassSkillChoices(int n, List<String> list) {
        this.classSkillChoices = ChoiceList.getChoiceList(n, list);
    }

    public final List<String> getClassSpellList() {
        return this.classSpellList;
    }

    public final void addDeity(String string) {
        this.deityList.add(string);
    }

    public final void clearDeityList() {
        this.deityList.clear();
    }

    public final List<String> getDeityList() {
        return this.deityList;
    }

    public final List<Domain> getDomainList(int n) {
        if (this.domainList == null) {
            return Collections.emptyList();
        }
        ArrayList<Domain> arrayList = new ArrayList<Domain>();
        for (LevelProperty<Domain> levelProperty : this.domainList) {
            if (levelProperty.getLevel() != n) continue;
            arrayList.add(levelProperty.getObject());
        }
        return arrayList;
    }

    public final void setExClass(String string) {
        this.exClass = string;
    }

    public final String getExClass() {
        return this.exClass;
    }

    public final Collection<LevelProperty<String>> getAllFeatAutos() {
        Collection<LevelProperty<String>> collection = null;
        if (this.featAutos == null) {
            List list = Collections.emptyList();
            collection = Collections.unmodifiableCollection(list);
        } else {
            collection = Collections.unmodifiableCollection(this.featAutos);
        }
        return collection;
    }

    public final Collection<String> getFeatAutos(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.featAutos != null) {
            for (LevelProperty<String> levelProperty : this.featAutos) {
                if (levelProperty.getLevel() != n) continue;
                arrayList.add(levelProperty.getObject());
            }
        }
        return arrayList;
    }

    public boolean removeFeatAuto(String string) {
        if (this.featAutos == null) {
            return false;
        }
        for (LevelProperty<String> levelProperty : this.featAutos) {
            if (!levelProperty.getObject().equals(string)) continue;
            return this.featAutos.remove(levelProperty);
        }
        return false;
    }

    public boolean removeFeatAuto(int n, String string) {
        if (this.featAutos == null) {
            return false;
        }
        for (LevelProperty<String> levelProperty : this.featAutos) {
            if (levelProperty.getLevel() != n || !levelProperty.getObject().equals(string)) continue;
            return this.featAutos.remove(levelProperty);
        }
        return false;
    }

    public final List<LevelProperty<String>> getFeatList() {
        if (this.featList == null) {
            List list = Collections.emptyList();
            return Collections.unmodifiableList(list);
        }
        return Collections.unmodifiableList(this.featList);
    }

    public final void setHitDie(int n) {
        this.hitDie = n;
    }

    public int getBaseHitDie() {
        return this.hitDie;
    }

    public void putHitDieLock(String string, int n) {
        if (this.hitDieLockList == null) {
            this.hitDieLockList = new ArrayList<LevelProperty<String>>();
        }
        this.hitDieLockList.add(LevelProperty.getLevelProperty(n, string));
    }

    protected String getHitDieLock(int n) {
        if (this.hitDieLockList != null) {
            for (LevelProperty<String> levelProperty : this.hitDieLockList) {
                if (levelProperty.getLevel() != n) continue;
                return levelProperty.getObject();
            }
        }
        return null;
    }

    public final void setInitialFeats(int n) {
        this.initialFeats = n;
    }

    public final int getInitialFeats() {
        return this.initialFeats;
    }

    public final void setItemCreationMultiplier(String string) {
        this.itemCreationMultiplier = string;
    }

    public final String getItemCreationMultiplier() {
        return this.itemCreationMultiplier;
    }

    public final int getLevel() {
        return this.level;
    }

    public final void setLevelExchange(String string) {
        this.levelExchange = string;
    }

    public final String getLevelExchange() {
        return this.levelExchange;
    }

    public final void setLevelWithoutConsequence(int n) {
        this.level = n;
    }

    public final void setMaxLevel(int n) {
        this.maxLevel = n;
    }

    public final int getMaxLevel() {
        return this.maxLevel;
    }

    public final boolean hasMaxLevel() {
        return this.maxLevel != -1;
    }

    public final void setMemorizeSpells(boolean bl) {
        this.getConstructingSpellProgressionInfo().setMemorizeSpells(bl);
    }

    public final boolean getMemorizeSpells() {
        return this.castInfo == null || this.castInfo.memorizesSpells();
    }

    public final void setMultiPreReqs(boolean bl) {
        this.multiPreReqs = bl;
    }

    public final void setPreRaceType(String string) {
        this.preRaceType = string.toUpperCase();
    }

    public final int getSkillPool(PlayerCharacter playerCharacter) {
        int n = 0;
        for (PCLevelInfo pCLevelInfo : playerCharacter.getLevelInfo()) {
            if (!pCLevelInfo.getClassKeyName().equals(this.getKeyName())) continue;
            n += pCLevelInfo.getSkillPointsRemaining();
        }
        return n;
    }

    public final Collection<String> getSpecialtyList() {
        if (this.specialtyList == null) {
            List list = Collections.emptyList();
            return Collections.unmodifiableList(list);
        }
        return Collections.unmodifiableList(this.specialtyList);
    }

    public final boolean hasSpecialtyList() {
        return this.specialtyList != null && this.specialtyList.size() > 0;
    }

    public final void addSpecialty(String string) {
        if (this.specialtyList == null) {
            this.specialtyList = new ArrayList<String>();
        }
        this.specialtyList.add(string);
    }

    public void addAddDomain(int n, Domain domain) {
        if (this.addDomains == null) {
            this.addDomains = new ArrayList<LevelProperty<Domain>>();
        }
        this.addDomains.add(LevelProperty.getLevelProperty(n, domain));
    }

    public String getDisplayClassName() {
        if (this.subClassKey.length() > 0 && !this.subClassKey.equals("None")) {
            return this.getSubClassKeyed(this.subClassKey).getDisplayName();
        }
        return this.getDisplayName();
    }

    public String getDisplayClassName(int n) {
        String string = this.getSubstitutionClassKey(n);
        if (string == null) {
            return this.getDisplayClassName();
        }
        String string2 = this.getSubstitutionClassKeyed(string).getDisplayName();
        if (string2 == null) {
            return this.getDisplayClassName();
        }
        return string2;
    }

    public String getFullDisplayClassName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDisplayClassName());
        return stringBuffer.append(" ").append(this.level).toString();
    }

    public final void setHasSubClass(boolean bl) {
        this.hasSubClass = bl;
    }

    public final void setHasSubstitutionClass(boolean bl) {
        this.hasSubstitutionClass = bl;
    }

    public final void setHasSpellFormula(boolean bl) {
        this.getConstructingSpellProgressionInfo().setContainsSpellFormula(bl);
    }

    public final boolean addProhibitedSchool(String string) {
        if (this.prohibitedSchools == null) {
            this.prohibitedSchools = new ArrayList<String>();
        }
        boolean bl = false;
        if (!this.prohibitedSchools.contains(string)) {
            bl = this.prohibitedSchools.add(string);
        }
        return bl;
    }

    public final void clearProhibitedSchools() {
        this.prohibitedSchools = null;
    }

    public final List<String> getProhibitedSchools() {
        return this.prohibitedSchools;
    }

    public int getLevelHitDie(PlayerCharacter playerCharacter, int n) {
        int n2 = this.getBaseHitDie();
        String string = playerCharacter.getRace().getHitDieLock();
        if (string.length() != 0) {
            n2 = this.calcHitDieLock(string, n2);
        }
        for (PCTemplate pCTemplate : playerCharacter.getTemplateList()) {
            if (pCTemplate == null || (string = pCTemplate.getHitDieLock()).length() == 0) continue;
            n2 = this.calcHitDieLock(string, n2);
        }
        string = this.getHitDieLock(n);
        if (string != null && string.length() != 0) {
            n2 = this.calcHitDieLock(string, n2);
        }
        return n2;
    }

    private int calcHitDieLock(String string, int n) {
        int n2;
        int[] nArray = Globals.getDieSizes();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        string = stringTokenizer.nextToken();
        String string2 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (string2 != null && (string2.startsWith("CLASS.TYPE") ? !this.isType(string2.substring(string2.indexOf("=") + 1, string2.length())) : string2.startsWith("CLASS=") && !this.getKeyName().equals(string2.substring(string2.indexOf("="), string2.length())))) {
            return n;
        }
        if (string.startsWith("%/")) {
            n2 = Integer.parseInt(string.substring(2));
            if (n2 <= 0) {
                n2 = 1;
            }
            n2 = n / n2;
        } else if (string.startsWith("%*")) {
            n2 = Integer.parseInt(string.substring(2));
            n2 *= n;
        } else if (string.startsWith("%+")) {
            n2 = Integer.parseInt(string.substring(2));
            n2 += n;
        } else if (string.startsWith("%-")) {
            n2 = Integer.parseInt(string.substring(2));
            n2 = n - n2;
        } else if (string.startsWith("%up")) {
            n2 = Integer.parseInt(string.substring(3));
            if (n2 > 4) {
                n2 = 4;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            for (int i = 3; i <= 7 - n2; ++i) {
                if (n != nArray[i]) continue;
                return nArray[i + n2];
            }
            n2 = nArray[7];
        } else if (string.startsWith("%Hup")) {
            n2 = Integer.parseInt(string.substring(4));
            for (int i = 0; i < nArray.length - n2; ++i) {
                if (n != nArray[i]) continue;
                return nArray[i + n2];
            }
            n2 = nArray[nArray.length];
        } else if (string.startsWith("%down")) {
            n2 = Integer.parseInt(string.substring(5));
            if (n2 > 4) {
                n2 = 4;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            for (int i = 3 + n2; i <= 7; ++i) {
                if (n != nArray[i]) continue;
                return nArray[i - n2];
            }
            n2 = nArray[3];
        } else if (string.startsWith("%Hdown")) {
            for (int i = n2 = Integer.parseInt(string.substring(5)); i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                return nArray[i - n2];
            }
            n2 = nArray[0];
        } else {
            n2 = Integer.parseInt(string);
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        return n2;
    }

    public final void setModToSkills(boolean bl) {
        this.modToSkills = bl;
    }

    public final boolean getModToSkills() {
        return this.modToSkills;
    }

    public final void setSkillPointFormula(String string) {
        this.skillPointFormula = string;
    }

    public String getSkillPointFormula() {
        return this.skillPointFormula;
    }

    public final void setSpellBaseStat(String string) {
        this.getConstructingSpellProgressionInfo().setSpellBaseStatAbbr(string);
    }

    public final String getSpellBaseStat() {
        return this.castInfo == null ? "None" : this.castInfo.getSpellBaseStatAbbr();
    }

    @Override
    public String getSpellKey() {
        if (this.stableSpellKey != null) {
            return this.stableSpellKey;
        }
        if (this.classSpellList == null) {
            this.chooseClassSpellList();
            if (this.classSpellList == null) {
                this.stableSpellKey = "CLASS|" + this.keyName;
                return this.stableSpellKey;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (String string : this.classSpellList) {
            if (bl) {
                stringBuffer.append("|");
            }
            bl = true;
            if (string.endsWith("(Domain)")) {
                stringBuffer.append("DOMAIN").append("|").append(string.substring(0, string.length() - 8));
                continue;
            }
            stringBuffer.append("CLASS").append("|").append(string);
        }
        this.stableSpellKey = stringBuffer.toString();
        return this.stableSpellKey;
    }

    public final void setClassSpellChoices(int n, List<String> list) {
        this.classSpellChoices = ChoiceList.getChoiceList(n, list);
    }

    public final ChoiceList<String> getClassSpellChoices() {
        return this.classSpellChoices;
    }

    public final void setSpellType(String string) {
        if (this.castInfo == null && "None".equals(string)) {
            return;
        }
        this.getConstructingSpellProgressionInfo().setSpellType(string);
    }

    public final String getSpellType() {
        return this.castInfo == null ? "None" : this.castInfo.getSpellType();
    }

    public void setCast(int n, List<String> list) {
        this.getConstructingSpellProgressionInfo().setCast(n, list);
    }

    public List<String> getCastListForLevel(int n) {
        if (this.castInfo == null) {
            return null;
        }
        return this.castInfo.getCastForLevel(n);
    }

    public boolean hasCastList() {
        return this.castInfo != null && this.castInfo.hasCastProgression();
    }

    public Map<Integer, List<String>> getCastProgression() {
        if (this.castInfo == null) {
            return null;
        }
        return this.castInfo.getCastProgression();
    }

    public int getHighestLevelSpell() {
        if (this.castInfo == null) {
            return -1;
        }
        return Math.max(this.castInfo.getHighestCastSpellLevel(), this.castInfo.getHighestKnownSpellLevel());
    }

    public int getHighestLevelSpell(PlayerCharacter playerCharacter) {
        int n;
        String string = "CLASS." + this.getKeyName();
        int n2 = n = this.getHighestLevelSpell();
        for (int i = n; i < n + 30; ++i) {
            String string2 = ";LEVEL." + i;
            StringBuilder stringBuilder = new StringBuilder();
            if (playerCharacter.getTotalBonusTo("SPELLCAST", stringBuilder.append(string).append(string2).toString()) > 0.0) {
                n2 = i;
                continue;
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            if (!(playerCharacter.getTotalBonusTo("SPELLKNOWN", stringBuilder2.append(string).append(string2).toString()) > 0.0)) continue;
            n2 = i;
        }
        return n2;
    }

    public int getKnownForLevel(int n, PlayerCharacter playerCharacter) {
        return this.getKnownForLevel(n, "null", playerCharacter);
    }

    public void setLevelsPerFeat(Integer n) {
        if (n < 0) {
            return;
        }
        this.levelsPerFeat = n;
    }

    public final Integer getLevelsPerFeat() {
        return this.levelsPerFeat;
    }

    public Map<Integer, List<String>> getKnownMap() {
        if ("".equals(this.castAs) || this.getKeyName().equals(this.castAs)) {
            if (this.castInfo == null) {
                return null;
            }
            return this.castInfo.getKnownProgression();
        }
        PCClass pCClass = Globals.getClassKeyed(this.castAs);
        if (pCClass != null) {
            return pCClass.getKnownMap();
        }
        throw new IllegalStateException("Unknown Class for CASTAS: " + this.castAs);
    }

    public boolean hasKnownList() {
        PCClass pCClass;
        if (!"".equals(this.castAs) && !this.getKeyName().equals(this.castAs) && (pCClass = Globals.getClassKeyed(this.castAs)) != null) {
            return pCClass.hasKnownList();
        }
        return this.castInfo != null && this.castInfo.hasKnownProgression();
    }

    public List<SpellFilter> getKnownSpellsList() {
        if (this.knownSpellsList == null) {
            List<SpellFilter> list = Collections.emptyList();
            return list;
        }
        return Collections.unmodifiableList(this.knownSpellsList);
    }

    public final Map<Integer, List<String>> getSpecialtyKnownList() {
        if (this.castInfo == null) {
            return null;
        }
        return this.castInfo.getSpecialtyKnownMap();
    }

    public final void addSpecialtyKnown(int n, List<String> list) {
        this.getConstructingSpellProgressionInfo().setSpecialtyKnown(n, list);
    }

    public int getNumFromCastList(int n, int n2, PlayerCharacter playerCharacter) {
        int n3;
        if (n == 0) {
            return -1;
        }
        List<String> list = this.getCastListForLevel(n);
        if (list == null || n2 >= list.size()) {
            return -1;
        }
        String string = list.get(n2);
        if (playerCharacter != null && this.hasSpellFormula()) {
            n3 = playerCharacter.getVariableValue(string, "").intValue();
        } else {
            try {
                n3 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n3 = 0;
            }
        }
        return n3;
    }

    public String getBonusCastForLevelString(int n, String string, PlayerCharacter playerCharacter) {
        if (this.getCastForLevel(n, string, true, true, playerCharacter) > 0) {
            if (this.hasSpecialtyList()) {
                return "+1";
            }
            if (!playerCharacter.hasCharacterDomainList()) {
                return "";
            }
            if (n > 0 && "DIVINE".equalsIgnoreCase(this.getSpellType())) {
                for (CharacterDomain characterDomain : playerCharacter.getCharacterDomainList()) {
                    if (!characterDomain.isFromPCClass(this.getKeyName())) continue;
                    return "+1";
                }
            }
        }
        return "";
    }

    public int getCastForLevel(int n, PlayerCharacter playerCharacter) {
        return this.getCastForLevel(n, Globals.getDefaultSpellBook(), true, true, playerCharacter);
    }

    public int getSpecialtyKnownForLevel(int n, PlayerCharacter playerCharacter) {
        int n2;
        List<String> list;
        int n3 = (int)playerCharacter.getTotalBonusTo("SPECIALTYSPELLKNOWN", "CLASS." + this.getKeyName() + ";LEVEL." + n);
        n3 += (int)playerCharacter.getTotalBonusTo("SPECIALTYSPELLKNOWN", "TYPE." + this.getSpellType() + ";LEVEL." + n);
        int n4 = this.getLevel();
        n4 += (int)playerCharacter.getTotalBonusTo("PCLEVEL", this.keyName);
        n4 += (int)playerCharacter.getTotalBonusTo("PCLEVEL", "TYPE." + this.getSpellType());
        int n5 = this.baseSpellIndex();
        if (n5 != -2) {
            list = playerCharacter.getStatList().getStatAt(n5);
            n2 = playerCharacter.getVariableValue("MAXLEVELSTAT=" + ((PCStat)((Object)list)).getAbb(), "").intValue();
            if (n > n2) {
                return n3;
            }
        }
        if (this.castInfo != null) {
            list = this.castInfo.getSpecialtyKnownForLevel(n4);
            if (list != null && list.size() > n) {
                n2 = this.castInfo.containsSpellFormula() ? playerCharacter.getVariableValue((String)list.get(n), "").intValue() : Integer.parseInt((String)list.get(n));
                n3 += n2;
            }
            if (n3 > 0 && n > 0) {
                n3 += this.castInfo.getKnownSpellsFromSpecialty();
            }
        }
        return n3;
    }

    public void setSubstitutionClassKey(String string, Integer n) {
        if (this.substitutionClassKey == null) {
            this.substitutionClassKey = new HashMap<Integer, String>();
        }
        this.substitutionClassKey.put(n, string);
    }

    public String getSubstitutionClassKey(Integer n) {
        if (this.substitutionClassKey == null) {
            return null;
        }
        return this.substitutionClassKey.get(n);
    }

    public void setSubClassKey(String string) {
        SubClass subClass;
        this.subClassKey = string;
        if (!string.equals(this.getKeyName()) && (subClass = this.getSubClassKeyed(string)) != null) {
            this.inheritAttributesFrom(subClass);
        }
        this.stableSpellKey = null;
        this.getSpellKey();
    }

    public String getSubClassKey() {
        if (this.subClassKey == null) {
            this.subClassKey = "";
        }
        return this.subClassKey;
    }

    public final SubClass getSubClassKeyed(String string) {
        if (this.subClassList == null) {
            return null;
        }
        for (SubClass subClass : this.subClassList) {
            if (!subClass.getKeyName().equals(string)) continue;
            return subClass;
        }
        return null;
    }

    public final SubstitutionClass getSubstitutionClassKeyed(String string) {
        if (this.substitutionClassList == null) {
            return null;
        }
        for (SubstitutionClass substitutionClass : this.substitutionClassList) {
            if (!substitutionClass.getKeyName().equals(string)) continue;
            return substitutionClass;
        }
        return null;
    }

    public List<LevelProperty<String>> getTemplates() {
        if (this.templates == null) {
            List<LevelProperty<String>> list = Collections.emptyList();
            return list;
        }
        return Collections.unmodifiableList(this.templates);
    }

    public void clearTemplates() {
        this.templates = null;
    }

    public final void addUatt(String string) {
        this.uattList.add(string);
    }

    public void addFeatAuto(int n, String string) {
        if (this.featAutos == null) {
            this.featAutos = new ArrayList<LevelProperty<String>>();
        }
        this.featAutos.add(LevelProperty.getLevelProperty(n, string));
    }

    public void clearFeatAutos() {
        this.featAutos = null;
    }

    public void setHitPoint(int n, Integer n2) {
        if (this.hitPointMap == null) {
            this.hitPointMap = new HashMap();
        }
        this.hitPointMap.put(n, n2);
    }

    public Map<Integer, Integer> getHitPointMap() {
        return new HashMap<Integer, Integer>(this.hitPointMap);
    }

    public int getHitPoint(int n) {
        if (this.hitPointMap == null) {
            return 0;
        }
        Integer n2 = this.hitPointMap.get(n);
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    public final void setHitPointMap(Map<Integer, Integer> map) {
        this.hitPointMap = null;
        if (map != null) {
            this.hitPointMap = new HashMap<Integer, Integer>(map);
        }
    }

    public String getUattForLevel(int n) {
        if (this.uattList.isEmpty()) {
            return "0";
        }
        for (String string : this.uattList) {
            if (n == 1) {
                return string;
            }
            if (--n >= 1) continue;
            break;
        }
        return null;
    }

    public void setProhibitSpell(SpellProhibitor spellProhibitor) {
        if (this.prohibitSpellDescriptorList == null) {
            this.prohibitSpellDescriptorList = new ArrayList<SpellProhibitor>();
        }
        this.prohibitSpellDescriptorList.add(spellProhibitor);
    }

    public final void addVision(int n, Vision vision) {
        if (this.visionList == null) {
            this.visionList = new ArrayList<LevelProperty<Vision>>();
        }
        this.visionList.add(LevelProperty.getLevelProperty(n, vision));
    }

    @Override
    public void clearVisionList() {
        if (this.visionList != null) {
            this.visionList.clear();
        }
    }

    @Override
    public boolean removeVisionType(VisionType visionType) {
        if (this.visionList == null) {
            return false;
        }
        for (LevelProperty<Vision> levelProperty : this.visionList) {
            if (!levelProperty.getObject().getType().equals(visionType)) continue;
            return this.visionList.remove(levelProperty);
        }
        return false;
    }

    public boolean isAutoKnownSpell(String string, int n, PlayerCharacter playerCharacter) {
        return this.isAutoKnownSpell(string, n, false, playerCharacter);
    }

    public void setLevel(int n, PlayerCharacter playerCharacter) {
        int n2 = this.level;
        if (n >= 0) {
            this.level = n;
        }
        if (this.level == 1) {
            if (this.level > n2 || playerCharacter.isImporting()) {
                try {
                    Object object;
                    Serializable serializable;
                    PreParserFactory preParserFactory = PreParserFactory.getInstance();
                    String string = Globals.getBonusFeatString();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
                    int n3 = Integer.parseInt(stringTokenizer.nextToken());
                    int n4 = Integer.parseInt(stringTokenizer.nextToken());
                    int n5 = 1;
                    if (playerCharacter.getRace().getMonsterClass(playerCharacter, false) != null && playerCharacter.getRace().getMonsterClass(playerCharacter, false).equalsIgnoreCase(this.getKeyName())) {
                        int n6 = playerCharacter.getRace().getMonsterClassLevels(playerCharacter, false);
                        serializable = this.getLevelsPerFeat();
                        n5 = serializable != null && (Integer)serializable >= 1 ? (Integer)serializable : n4;
                        StringBuffer comparable = new StringBuffer("max(0,floor((CL-");
                        comparable.append(n6);
                        comparable.append(")/");
                        comparable.append(n5);
                        comparable.append("))");
                        object = new StringBuffer("0|FEAT|MONSTERPOOL|");
                        ((StringBuffer)object).append(comparable);
                        BonusObj bonusObj = Bonus.newBonus(((StringBuffer)object).toString());
                        bonusObj.setCreatorObject(this);
                        Prerequisite prerequisite = preParserFactory.parse("PREDEFAULTMONSTER:Y");
                        bonusObj.addPreReq(prerequisite);
                        this.addBonusList(bonusObj);
                    } else {
                        n5 = n4;
                        StringBuffer stringBuffer = new StringBuffer("CL/");
                        stringBuffer.append(n5);
                        StringBuffer stringBuffer2 = new StringBuffer("0|FEAT|MONSTERPOOL|");
                        stringBuffer2.append(stringBuffer);
                        serializable = Bonus.newBonus(stringBuffer2.toString());
                        ((BonusObj)serializable).setCreatorObject(this);
                        object = preParserFactory.parse("PREDEFAULTMONSTER:Y");
                        ((PrereqObject)((Object)serializable)).addPreReq((Prerequisite)object);
                        this.addBonusList((BonusObj)serializable);
                    }
                    StringBuffer stringBuffer = new StringBuffer("0|FEAT|PCPOOL|CL/");
                    stringBuffer.append(n4);
                    serializable = Bonus.newBonus(stringBuffer.toString());
                    ((BonusObj)serializable).setCreatorObject(this);
                    object = preParserFactory.parse("PREDEFAULTMONSTER:N");
                    ((PrereqObject)((Object)serializable)).addPreReq((Prerequisite)object);
                    this.addBonusList((BonusObj)serializable);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    Logging.errorPrint("Caught " + persistenceLayerException);
                }
            }
            this.chooseClassSkillList();
        }
        if (!playerCharacter.isImporting()) {
            playerCharacter.calcActiveBonuses();
            playerCharacter.getSpellTracker().buildSpellLevelMap(n);
        }
        if (this.level == 1 && !playerCharacter.isImporting() && n2 == 0) {
            this.checkForSubClass(playerCharacter);
            this.getSpellKey();
        }
        if (!playerCharacter.isImporting() && n2 < this.level) {
            this.checkForSubstitutionClass(this.level, playerCharacter);
        }
        for (PCClass pCClass : playerCharacter.getClassList()) {
            pCClass.calculateKnownSpellsForClassLevel(playerCharacter);
        }
    }

    protected void removeKnownSpellsForClassLevel(PlayerCharacter playerCharacter) {
        String string = this.getSpellKey();
        if (this.knownSpellsList != null && this.knownSpellsList.size() == 0 || playerCharacter.isImporting() || !playerCharacter.getAutoSpells()) {
            return;
        }
        if (this.getSpellSupport().getCharacterSpellCount() == 0) {
            return;
        }
        Iterator<CharacterSpell> iterator = this.getSpellSupport().getCharacterSpellList().iterator();
        while (iterator.hasNext()) {
            CharacterSpell characterSpell = iterator.next();
            Spell spell = characterSpell.getSpell();
            int[] nArray = spell.levelForKey(string, playerCharacter);
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                boolean bl = this.isAutoKnownSpell(spell.getKeyName(), n, true, playerCharacter);
                if (bl) continue;
                iterator.remove();
            }
        }
    }

    protected void calculateKnownSpellsForClassLevel(PlayerCharacter playerCharacter) {
        if (this.knownSpellsList != null && this.knownSpellsList.size() > 0 && !playerCharacter.isImporting() && playerCharacter.getAutoSpells()) {
            List<Spell> list = Globals.getSpellsIn(-1, this.getSpellKey(), "");
            if (list.isEmpty()) {
                return;
            }
            this.calcCastPerDayMapForLevel(playerCharacter);
            int n = this.getMaxCastLevel();
            String string = this.getSpellKey();
            for (Spell object : list) {
                int[] nArray = object.levelForKey(string, playerCharacter);
                for (int i = 0; i < nArray.length; ++i) {
                    int n2 = nArray[i];
                    if (n2 > n || !this.isAutoKnownSpell(object.getKeyName(), n2, true, playerCharacter)) continue;
                    CharacterSpell characterSpell = this.getSpellSupport().getCharacterSpellForSpell(object, this);
                    if (characterSpell == null) {
                        characterSpell = new CharacterSpell(this, object);
                        characterSpell.addInfo(n2, 1, Globals.getDefaultSpellBook());
                        this.getSpellSupport().addCharacterSpell(characterSpell);
                        continue;
                    }
                    if (characterSpell.getSpellInfoFor(Globals.getDefaultSpellBook(), n2, -1) != null) continue;
                    characterSpell.addInfo(n2, 1, Globals.getDefaultSpellBook());
                }
            }
            for (CharacterDomain characterDomain : playerCharacter.getCharacterDomainList()) {
                if (characterDomain.getDomain() == null || !characterDomain.isFromPCClass(this.getKeyName())) continue;
                characterDomain.getDomain().addSpellsToClassForLevels(this, 0, n);
            }
        }
    }

    public int getMaxCastLevel() {
        int n = -1;
        if (this.castForLevelMap != null) {
            for (int n2 : this.castForLevelMap.keySet()) {
                Integer n3 = this.castForLevelMap.get(n2);
                if (n3 == null || n3 <= 0 || n2 <= n) continue;
                n = n2;
            }
        }
        return n;
    }

    public boolean isMonster() {
        if (this.monsterFlag != null) {
            return this.monsterFlag;
        }
        if (this.getMyTypeCount() == 0) {
            return false;
        }
        for (String string : this.getTypeList(false)) {
            ClassType classType = SettingsHandler.getGame().getClassTypeByName(string);
            if (classType == null || !classType.isMonster()) continue;
            return true;
        }
        return false;
    }

    public List<Equipment> getNaturalWeapons(int n) {
        if (this.naturalWeapons == null) {
            return new ArrayList<Equipment>();
        }
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>();
        for (LevelProperty<Equipment> levelProperty : this.naturalWeapons) {
            if (levelProperty.getLevel() != this.level) continue;
            arrayList.add(levelProperty.getObject());
        }
        return arrayList;
    }

    public List<LevelProperty<Equipment>> getAllNaturalWeapons() {
        if (this.naturalWeapons == null) {
            return new ArrayList<LevelProperty<Equipment>>();
        }
        return this.naturalWeapons;
    }

    public boolean isQualified(PlayerCharacter playerCharacter) {
        if (playerCharacter == null) {
            return false;
        }
        if (this.isMonster() && this.preRaceType != null && !playerCharacter.getRace().getRaceType().equalsIgnoreCase(this.preRaceType) && playerCharacter.getCritterType().indexOf(this.preRaceType) < 0) {
            return false;
        }
        if (this.multiPreReqs && playerCharacter.getClassList().isEmpty()) {
            return true;
        }
        return PrereqHandler.passesAll(this.getPreReqList(), playerCharacter, this);
    }

    @Override
    public void setSR(int n, String string) {
        if (this.SR == null) {
            this.SR = new ArrayList<LevelProperty<String>>();
        }
        this.SR.add(LevelProperty.getLevelProperty(n, string));
    }

    public void clearSR() {
        this.SR = null;
    }

    @Override
    protected int getSR(PlayerCharacter playerCharacter) {
        if (playerCharacter == null) {
            return 0;
        }
        LevelProperty<String> levelProperty = null;
        if (this.SR != null) {
            int n = this.level;
            for (LevelProperty<String> levelProperty2 : this.SR) {
                if (levelProperty2.getLevel() > n || levelProperty != null && levelProperty.getLevel() >= levelProperty2.getLevel()) continue;
                levelProperty = levelProperty2;
            }
        }
        if (levelProperty != null) {
            return playerCharacter.getVariableValue((String)levelProperty.getObject(), this.getQualifiedKey()).intValue();
        }
        return 0;
    }

    public List<LevelProperty<String>> getSRlist() {
        if (this.SR == null) {
            this.SR = new ArrayList<LevelProperty<String>>();
        }
        return this.SR;
    }

    public LevelProperty<String> getSRforLevel(int n) {
        if (this.SR != null) {
            for (LevelProperty<String> levelProperty : this.SR) {
                if (levelProperty.getLevel() != n) continue;
                return levelProperty;
            }
        }
        return null;
    }

    public final void setSpellBookUsed(boolean bl) {
        this.getConstructingSpellProgressionInfo().setSpellBookUsed(bl);
    }

    public final boolean getSpellBookUsed() {
        return this.castInfo != null && this.castInfo.usesSpellBook();
    }

    public void setCRFormula(String string) {
        this.CRFormula = string;
    }

    public void setMonsterFlag(boolean bl) {
        this.monsterFlag = bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getPCCText() {
        List<String> list;
        List<String> list2;
        List<SpecialAbility> list3;
        void var6_20;
        Object object;
        void var6_18;
        void var6_15;
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("CLASS:").append(this.getDisplayName());
        stringBuffer.append(super.getPCCText(false));
        stringBuffer.append("\tABB:").append(this.getAbbrev());
        PCClass.checkAdd(stringBuffer, "", "EXCLASS:", this.exClass);
        PCClass.checkAdd(stringBuffer, "", "EXCHANGELEVEL:", this.levelExchange);
        if (this.hasSubClass) {
            stringBuffer.append("\tHASSUBCLASS:Y");
        }
        if (this.hasSubstitutionClass) {
            stringBuffer.append("\tHASSUBSTITUTIONLEVEL:Y");
        }
        stringBuffer.append("\tHD:").append(this.hitDie);
        PCClass.checkAdd(stringBuffer, "ANY", "DEITY:", CoreUtility.join(this.deityList, '|'));
        if (this.attackCycleMap != null) {
            PCClass.checkAdd(stringBuffer, "", "ATTACKCYCLE", CoreUtility.join(new MapCollection(this.attackCycleMap), "|"));
        }
        PCClass.checkAdd(stringBuffer, "", "CASTAS:", this.castAs);
        if (this.prohibitedSchools != null) {
            stringBuffer.append('\t').append("PROHIBITED:");
            stringBuffer.append(CoreUtility.join(this.prohibitedSchools, ","));
        }
        if (this.castInfo != null) {
            PCClass.checkAdd(stringBuffer, "None", "SPELLSTAT:", this.castInfo.getSpellBaseStatAbbr());
            PCClass.checkAdd(stringBuffer, "None", "SPELLTYPE:", this.castInfo.getSpellType());
            if (this.castInfo.usesSpellBook()) {
                stringBuffer.append("\tSPELLBOOK:Y");
            }
        }
        if (this.skillPointFormula.length() != 0) {
            stringBuffer.append("\tSTARTSKILLPTS:").append(this.skillPointFormula);
        }
        if (!this.getVisibility().equals((Object)Visibility.DEFAULT)) {
            stringBuffer.append("\tVISIBLE:" + this.getVisibility().toString());
        }
        if (this.initialFeats != 0) {
            stringBuffer.append("\tXTRAFEATS:").append(this.initialFeats);
        }
        if (this.levelsPerFeat != null) {
            stringBuffer.append("\tLEVELSPERFEAT:").append(this.levelsPerFeat);
        }
        if (this.maxLevel != 0) {
            stringBuffer.append("\tMAXLEVEL:").append(this.maxLevel);
        }
        if (this.castInfo != null) {
            stringBuffer.append("\tMEMORIZE:" + (this.castInfo.memorizesSpells() ? "Y" : "N"));
        }
        if (this.multiPreReqs) {
            stringBuffer.append("\tMULTIPREREQS:Y");
        }
        if (!this.getKnownSpellsList().isEmpty()) {
            stringBuffer.append("\tKNOWNSPELLS:");
            stringBuffer.append(CoreUtility.join(this.knownSpellsList, "|"));
        }
        if (this.itemCreationMultiplier.length() != 0) {
            stringBuffer.append("\tITEMCREATE:").append(this.itemCreationMultiplier);
        }
        if (this.classSpellChoices != null) {
            PCClass.checkAdd(stringBuffer, "", "SPELLLIST:", this.classSpellChoices.toString());
        }
        if (this.classSkillChoices != null) {
            PCClass.checkAdd(stringBuffer, "", "SKILLLIST:", this.classSkillChoices.toString());
        }
        if (this.getWeaponProfBonus().size() != 0) {
            stringBuffer.append("\tWEAPONBONUS:");
            stringBuffer.append(CoreUtility.join(this.getWeaponProfBonus(), "|"));
        }
        String string = System.getProperty("line.separator");
        String string2 = this.getRegionString();
        if (string2 != null && !string2.startsWith("0|")) {
            int n2 = string2.indexOf(124);
            stringBuffer.append(string).append(string2.substring(0, n2)).append("\tREGION:").append(string2.substring(n2 + 1));
        }
        List<String> list4 = this.getSafeListFor(ListKey.KITS);
        for (int i = 0; i < list4.size(); ++i) {
            String object2 = list4.get(i);
            int n = object2.indexOf(124);
            if (n < 0) continue;
            stringBuffer.append(string + object2.substring(0, n)).append("\tKIT:").append(object2.substring(n + 1));
        }
        if (this.castInfo != null && this.castInfo.hasSpecialtyKnownProgression()) {
            stringBuffer.append(this.castInfo.getSpecialtyKnownPCC(string));
        }
        if (this.castInfo != null && this.castInfo.hasCastProgression()) {
            stringBuffer.append(this.castInfo.getCastPCC(string));
        }
        if (this.castInfo != null && this.castInfo.hasKnownProgression()) {
            stringBuffer.append(this.castInfo.getKnownPCC(string));
        }
        for (DamageReduction damageReduction : this.getDRList()) {
            for (Prerequisite i : damageReduction.getPreReqList()) {
                if (!DamageReduction.isPrereqForClassLevel(i, this.getKeyName())) continue;
                stringBuffer.append(string).append(i.getOperand()).append("\t").append(damageReduction.getPCCText(false));
            }
        }
        if (this.SR != null) {
            for (LevelProperty list6 : this.SR) {
                stringBuffer.append(string).append(list6.getLevel()).append("\tSR:").append((String)list6.getObject());
            }
        }
        int n4 = this.getSpellSupport().getMaxSpellListLevel();
        if (this.hasMaxLevel() && n4 > this.maxLevel) {
            n4 = this.maxLevel;
        }
        boolean bl = false;
        while (var6_15 <= n4) {
            List<PCSpell> list5 = this.getSpellSupport().getSpellListForLevel((int)var6_15);
            if (list5 != null) {
                for (PCSpell pCSpell : list5) {
                    stringBuffer.append(string).append((int)var6_15).append("\tSPELLS:").append(pCSpell.getPCCText());
                }
            }
            ++var6_15;
        }
        if (this.templates != null) {
            for (LevelProperty<String> levelProperty : this.templates) {
                stringBuffer.append(string).append(levelProperty.getLevel());
                stringBuffer.append("\tTEMPLATE:").append(levelProperty.getObject());
            }
        }
        boolean bl2 = false;
        while (var6_18 < this.getBonusList().size()) {
            void var8_36;
            BonusObj bonusObj = this.getBonusList().get((int)var6_18);
            String string3 = bonusObj.toString();
            int n = string3.indexOf(124);
            object = string3.substring(0, n);
            stringBuffer.append(string);
            if (CoreUtility.isIntegerString((String)object)) {
                stringBuffer.append((String)object);
                String string4 = string3.substring(n + 1);
            } else {
                stringBuffer.append("0");
            }
            stringBuffer.append("\tBONUS:").append((String)var8_36);
            ++var6_18;
        }
        boolean bl3 = false;
        while (var6_20 < this.getVariableCount()) {
            String string5 = this.getVariableDefinition((int)var6_20);
            int n = string5.indexOf(124);
            stringBuffer.append(string).append(string5.substring(0, n)).append("\tDEFINE:").append(string5.substring(n + 1));
            ++var6_20;
        }
        List<LevelAbility> list6 = this.getLevelAbilityList();
        if (list6 != null && !list6.isEmpty()) {
            for (LevelAbility levelAbility : list6) {
                stringBuffer.append(string).append(String.valueOf(levelAbility.level())).append("\tADD:").append(levelAbility.getTagData());
            }
        }
        if ((list3 = this.getListFor(ListKey.SPECIAL_ABILITY)) != null && list3.size() != 0) {
            for (SpecialAbility specialAbility : list3) {
                object = specialAbility.getSASource();
                String string6 = ((String)object).substring(((String)object).lastIndexOf(124) + 1);
                stringBuffer.append(string).append(string6).append("\tSA:").append(specialAbility.toString());
            }
        }
        if (this.addDomains != null) {
            for (LevelProperty<Domain> levelProperty : this.addDomains) {
                stringBuffer.append(string).append(levelProperty.getLevel());
                stringBuffer.append("\tADDDOMAINS:").append(levelProperty.getObject().getKeyName());
            }
        }
        if (this.domainList != null) {
            for (LevelProperty<Domain> levelProperty : this.domainList) {
                stringBuffer.append(string).append(levelProperty.getLevel());
                stringBuffer.append("\tDOMAIN:").append(levelProperty.getObject().getKeyName());
            }
        }
        if (this.featList != null) {
            for (LevelProperty<String> levelProperty : this.featList) {
                stringBuffer.append(string).append(levelProperty.getLevel());
                stringBuffer.append("\tFEATAUTO:").append(levelProperty.getObject());
            }
        }
        if (this.featAutos != null) {
            for (LevelProperty<String> levelProperty : this.featAutos) {
                stringBuffer.append(string).append(levelProperty.getLevel());
                stringBuffer.append("\tFEATAUTO:").append(levelProperty.getObject());
            }
        }
        if (this.uattList != null && this.uattList.size() != 0) {
            void var8_45;
            boolean bl4 = false;
            while (var8_45 < this.uattList.size()) {
                stringBuffer.append(string).append(String.valueOf((int)(var8_45 + true))).append("\tUATT:").append(this.uattList.get((int)var8_45));
                ++var8_45;
            }
        }
        if ((list2 = this.getListFor(ListKey.UDAM)) != null && list2.size() != 0) {
            for (int i = 0; i < list2.size(); ++i) {
                stringBuffer.append(string).append(String.valueOf(i + 1)).append("\tUDAM:").append(list2.get(i));
            }
        }
        if ((list = this.getListFor(ListKey.UMULT)) != null) {
            for (String string6 : list) {
                int n = string6.indexOf("|");
                stringBuffer.append(string).append(string6.substring(0, n)).append("\tUMULT:").append(string6.substring(n + 1));
            }
        }
        return stringBuffer.toString();
    }

    public List<Ability> getVirtualFeatList(int n) {
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        if (this.vFeatList != null) {
            for (LevelProperty<List<Ability>> levelProperty : this.vFeatList) {
                if (levelProperty.getLevel() > n) continue;
                arrayList.addAll((Collection<Ability>)levelProperty.getObject());
            }
        }
        return arrayList;
    }

    @Override
    public List<Vision> getVision() {
        List<Vision> list = super.getVision();
        if (this.visionList != null) {
            if (list == null) {
                list = new ArrayList<Vision>();
            }
            for (LevelProperty<Vision> levelProperty : this.visionList) {
                if (levelProperty.getLevel() > this.level) continue;
                list.add(levelProperty.getObject());
            }
        }
        return list;
    }

    public void setXPPenalty(DefaultTriState defaultTriState) {
        this.XPPenalty = defaultTriState;
    }

    @Override
    public void activateBonuses(PlayerCharacter playerCharacter) {
        for (BonusObj bonusObj : this.getBonusList()) {
            if (bonusObj.getPCLevel() > this.level) continue;
            if (bonusObj.hasPreReqs()) {
                if (bonusObj.qualifies(playerCharacter)) {
                    bonusObj.setApplied(true);
                    continue;
                }
                bonusObj.setApplied(false);
                continue;
            }
            bonusObj.setApplied(true);
        }
    }

    public void addClassSkill(String string) {
        if (this.classSkillList == null) {
            this.classSkillList = new ArrayList<String>();
        }
        this.classSkillList.add(string);
    }

    public void clearClassSkillList() {
        this.classSkillList = null;
    }

    public void addClassSpellList(String string) {
        if (this.classSpellList == null) {
            this.classSpellList = new ArrayList<String>();
        }
        this.classSpellList.add(string);
        this.stableSpellKey = null;
    }

    public void clearClassSpellList() {
        this.classSpellList = null;
    }

    public void addDomain(int n, Domain domain) {
        if (this.domainList == null) {
            this.domainList = new ArrayList<LevelProperty<Domain>>();
        }
        this.domainList.add(LevelProperty.getLevelProperty(n, domain));
    }

    public final void addSubClass(SubClass subClass) {
        if (this.subClassList == null) {
            this.subClassList = new ArrayList<SubClass>();
        }
        subClass.setHitPointMap(this.hitPointMap);
        subClass.setHitDie(this.hitDie);
        this.subClassList.add(subClass);
    }

    public final void addSubstitutionClass(SubstitutionClass substitutionClass) {
        if (this.substitutionClassList == null) {
            this.substitutionClassList = new ArrayList<SubstitutionClass>();
        }
        substitutionClass.setHitPointMap(this.hitPointMap);
        substitutionClass.setHitDie(this.hitDie);
        this.substitutionClassList.add(substitutionClass);
    }

    public void addFeatList(int n, String string) {
        if (this.featList == null) {
            this.featList = new ArrayList<LevelProperty<String>>();
        }
        this.featList.add(LevelProperty.getLevelProperty(n, string));
    }

    private SpellProgressionInfo getConstructingSpellProgressionInfo() {
        if (this.castInfo == null) {
            this.castInfo = new SpellProgressionInfo();
        }
        return this.castInfo;
    }

    public void setKnown(int n, List<String> list) {
        this.getConstructingSpellProgressionInfo().setKnown(n, list);
    }

    public void addKnownSpell(SpellFilter spellFilter) {
        if (this.knownSpellsList == null) {
            this.knownSpellsList = new ArrayList<SpellFilter>();
        }
        this.knownSpellsList.add(spellFilter);
    }

    public void clearKnownSpellsList() {
        this.knownSpellsList = null;
    }

    public void addLevel(PCLevelInfo pCLevelInfo, boolean bl, PlayerCharacter playerCharacter) {
        this.addLevel(pCLevelInfo, bl, false, playerCharacter, true);
    }

    public void addSkillToList(String string) {
        if (this.skillList == null) {
            this.skillList = new ArrayList<String>();
        }
        if (!this.skillList.contains(string)) {
            this.skillList.add(string);
        }
    }

    public void addTemplate(int n, String string) {
        if (this.templates == null) {
            this.templates = new ArrayList<LevelProperty<String>>();
        }
        this.templates.add(LevelProperty.getLevelProperty(n, string));
    }

    public void addVirtualFeats(int n, List<Ability> list) {
        if (this.vFeatList == null) {
            this.vFeatList = new ArrayList<LevelProperty<List<Ability>>>();
        }
        boolean bl = false;
        for (LevelProperty<List<Ability>> levelProperty : this.vFeatList) {
            if (levelProperty.getLevel() != n) continue;
            bl = true;
            levelProperty.getObject().addAll(list);
        }
        if (!bl) {
            ArrayList<Ability> arrayList = new ArrayList<Ability>(list);
            this.vFeatList.add(LevelProperty.getLevelProperty(n, arrayList));
        }
        super.addVirtualFeats(list);
    }

    public int attackCycle(AttackType attackType) {
        String string;
        if (this.attackCycleMap != null && (string = this.attackCycleMap.get((Object)attackType)) != null) {
            return Integer.parseInt(string);
        }
        return SettingsHandler.getGame().getBabAttCyc();
    }

    public int baseAttackBonus(PlayerCharacter playerCharacter) {
        if (this.level == 0) {
            return 0;
        }
        int n = (int)this.getBonusTo("COMBAT", "BAB", this.level, playerCharacter);
        return n;
    }

    public int baseSpellIndex() {
        String string = this.getSpellBaseStat();
        return "SPELL".equals(string) ? -2 : SettingsHandler.getGame().getStatFromAbbrev(string);
    }

    public int bonusSpellIndex() {
        String string = this.getBonusSpellBaseStat();
        if (string.equals("None")) {
            return -1;
        }
        if (string.equals("Default")) {
            string = this.getSpellBaseStat();
        }
        return SettingsHandler.getGame().getStatFromAbbrev(string);
    }

    public int calcCR(PlayerCharacter playerCharacter) {
        String string = "0";
        if (this.CRFormula != null) {
            string = this.CRFormula;
        } else {
            for (String string2 : this.getTypeList(false)) {
                ClassType classType = SettingsHandler.getGame().getClassTypeByName(string2);
                if (classType == null || "0".equals(classType.getCRFormula())) continue;
                string = classType.getCRFormula();
            }
        }
        return playerCharacter.getVariableValue(string, this.classKey).intValue();
    }

    public String classLevelString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.getSubClassKey().equals("None") && !"".equals(this.getSubClassKey())) {
            stringBuffer.append(this.getSubClassKey());
        } else {
            stringBuffer.append(this.getKeyName());
        }
        stringBuffer = stringBuffer.append(' ').append(this.level);
        return stringBuffer.toString();
    }

    @Override
    public PCClass clone() {
        PCClass pCClass = null;
        try {
            pCClass = (PCClass)super.clone();
            pCClass.setSubClassKey(this.getSubClassKey());
            if (this.prohibitedSchools != null) {
                pCClass.prohibitedSchools = new ArrayList<String>(this.prohibitedSchools);
            }
            if (this.castInfo != null) {
                pCClass.castInfo = this.castInfo.clone();
            }
            pCClass.uattList = new ArrayList<String>(this.uattList);
            if (this.featList != null) {
                pCClass.featList = new ArrayList<LevelProperty<String>>(this.featList);
            }
            if (this.vFeatList != null) {
                pCClass.vFeatList = new ArrayList<LevelProperty<List<Ability>>>(this.vFeatList);
            }
            if (this.vAbilityMap != null) {
                pCClass.vAbilityMap = new DoubleKeyMap<AbilityCategory, Integer, List<Ability>>(this.vAbilityMap);
            }
            if (this.hitDieLockList != null) {
                pCClass.hitDieLockList = new ArrayList<LevelProperty<String>>(this.hitDieLockList);
            }
            if (this.featAutos != null) {
                pCClass.featAutos = new ArrayList<LevelProperty<String>>(this.featAutos);
            }
            pCClass.skillList = null;
            pCClass.classSkillList = null;
            pCClass.classSpellList = null;
            pCClass.stableSpellKey = null;
            pCClass.setLevelExchange(this.levelExchange);
            pCClass.multiPreReqs = this.multiPreReqs;
            pCClass.deityList = new ArrayList<String>(this.deityList);
            if (this.knownSpellsList != null) {
                pCClass.knownSpellsList = new ArrayList<SpellFilter>(this.knownSpellsList);
            }
            if (this.attackCycleMap != null) {
                pCClass.attackCycleMap = new HashMap<AttackType, String>(this.attackCycleMap);
            }
            pCClass.modToSkills = this.modToSkills;
            pCClass.initMod = this.initMod;
            if (this.specialtyList != null) {
                pCClass.specialtyList = new ArrayList<String>(this.specialtyList);
            }
            if (this.domainList != null) {
                pCClass.domainList = new ArrayList<LevelProperty<Domain>>(this.domainList);
            }
            if (this.addDomains != null) {
                pCClass.addDomains = new ArrayList<LevelProperty<Domain>>(this.addDomains);
            }
            if (this.hitPointMap != null) {
                pCClass.hitPointMap = new HashMap<Integer, Integer>(this.hitPointMap);
            }
            pCClass.substitutionClassList = this.substitutionClassList;
            if (this.naturalWeapons != null) {
                pCClass.naturalWeapons = new ArrayList<LevelProperty<Equipment>>(this.naturalWeapons);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ShowMessageDelegate.showMessageDialog(cloneNotSupportedException.getMessage(), "PCGen", MessageType.ERROR);
        }
        return pCClass;
    }

    public final boolean hasSpellFormula() {
        return this.castInfo != null && this.castInfo.containsSpellFormula();
    }

    public final boolean hasSubClass() {
        return this.hasSubClass;
    }

    public final boolean hasSubstitutionClass() {
        return this.hasSubstitutionClass;
    }

    public final boolean multiPreReqs() {
        return this.multiPreReqs;
    }

    @Override
    public final String toString() {
        return this.displayName;
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        int n = 3;
        if ("".equals(this.abbrev)) {
            if (string.length() < 3) {
                n = string.length();
            }
            this.abbrev = string.substring(0, n);
        }
        this.stableSpellKey = null;
        this.getSpellKey();
    }

    public boolean isSpecialtySpell(Spell spell) {
        Collection<String> collection = this.getSpecialtyList();
        if (collection == null || collection.size() == 0) {
            return false;
        }
        return spell.descriptorListContains(collection) || spell.schoolContains(collection) || spell.subschoolContains(collection);
    }

    public List<SubClass> getSubClassList() {
        return this.subClassList;
    }

    public List getSubstitutionClassList() {
        return this.substitutionClassList;
    }

    @Override
    public double calcBonusFrom(BonusObj bonusObj, Object object, PlayerCharacter playerCharacter) {
        String string;
        double d = 0.0;
        int n = 1;
        String string2 = bonusObj.getTypeOfBonus();
        if ("VAR".equals(string2)) {
            n = Math.max(1, this.getAssociatedCount());
            string = this.getChoiceString();
            if (string.startsWith("SALIST|") && string.indexOf("|VAR|") >= 0) {
                n = 1;
            }
        }
        string = bonusObj.toString();
        if (this.getAssociatedCount() != 0) {
            int n2 = 4;
            int n3 = string.indexOf("%VAR");
            if (n3 == -1) {
                n3 = string.indexOf("%LIST");
                n2 = 5;
            }
            if (n3 >= 0) {
                String string3 = string.substring(0, n3);
                String string4 = string.substring(n3 + n2);
                for (int i = 1; i < this.getAssociatedCount(); ++i) {
                    String string5 = new StringBuffer().append(string3).append(this.getAssociated(i)).append(string4).toString();
                    d += this.calcPartialBonus(string5, n, bonusObj, object);
                }
                string = new StringBuffer().append(string3).append(this.getAssociated(0)).append(string4).toString();
            }
        }
        return d += this.calcPartialBonus(string, n, bonusObj, object);
    }

    @Override
    public double calcBonusFrom(BonusObj bonusObj, Object object, String string, PlayerCharacter playerCharacter) {
        return this.calcBonusFrom(bonusObj, object, playerCharacter);
    }

    public boolean hasClassSkill(String string) {
        if (this.classSkillList == null || this.classSkillList.isEmpty()) {
            return false;
        }
        for (String string2 : this.classSkillList) {
            PCClass pCClass = Globals.getClassKeyed(string2);
            if (pCClass == null || !pCClass.hasCSkill(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasKnownSpells(PlayerCharacter playerCharacter) {
        for (int i = 0; i <= this.getHighestLevelSpell(); ++i) {
            if (this.getKnownForLevel(i, playerCharacter) <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasSkill(String string) {
        if (this.skillList == null) {
            return false;
        }
        for (String string2 : this.skillList) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasXPPenalty() {
        if (this.XPPenalty.equals((Object)DefaultTriState.DEFAULT)) {
            for (String string : this.getTypeList(false)) {
                ClassType classType = SettingsHandler.getGame().getClassTypeByName(string);
                if (classType == null || classType.getXPPenalty()) continue;
                return false;
            }
            return true;
        }
        return this.XPPenalty.booleanValue();
    }

    public int hitPoints(int n) {
        int n2 = 0;
        for (int i = 0; i <= this.getLevel(); ++i) {
            if (this.getHitPoint(i) <= 0) continue;
            int n3 = this.getHitPoint(i) + n;
            if (n3 < 1) {
                n3 = 1;
            }
            n2 += n3;
        }
        return n2;
    }

    public int recalcSkillPointMod(PlayerCharacter playerCharacter, int n) {
        int n2 = this.isMonster() && playerCharacter.isMonsterDefault() ? this.getMonsterSkillPointMod(playerCharacter, n) : this.getNonMonsterSkillPointMod(playerCharacter, n);
        return n2;
    }

    public final int skillPool() {
        return this.skillPool;
    }

    public void setSkillPool(int n) {
        this.skillPool = n;
    }

    public boolean zeroCastSpells() {
        if (this.castInfo == null || !this.castInfo.hasCastProgression()) {
            return true;
        }
        for (List<String> list : this.castInfo.getCastProgression().values()) {
            for (String string : list) {
                try {
                    if (Integer.parseInt(string) <= 0) continue;
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
        return true;
    }

    @Override
    protected List<SpecialAbility> addSpecialAbilitiesToList(List<SpecialAbility> list, PlayerCharacter playerCharacter) {
        List<SpecialAbility> list2 = this.getListFor(ListKey.SPECIAL_ABILITY);
        if (list2 == null || list2.isEmpty()) {
            return list;
        }
        ArrayList<SpecialAbility> arrayList = new ArrayList<SpecialAbility>();
        for (SpecialAbility specialAbility : list2) {
            if (!specialAbility.pcQualifiesFor(playerCharacter)) continue;
            String string = specialAbility.getKeyName();
            if (string.startsWith(".CLEAR")) {
                if (".CLEARALL".equals(string)) {
                    arrayList.clear();
                    continue;
                }
                if (!string.startsWith(".CLEAR.")) continue;
                String string2 = string.substring(7);
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    String string3 = ((SpecialAbility)arrayList.get(i)).getKeyName();
                    if (string3.equals(string2)) {
                        arrayList.remove(i);
                        continue;
                    }
                    if (string3.indexOf(40) < 0 || !string3.substring(0, string3.indexOf(40)).trim().equals(string2)) continue;
                    arrayList.remove(i);
                }
                continue;
            }
            arrayList.add(specialAbility);
        }
        list.addAll(arrayList);
        return list;
    }

    @Override
    protected void doGlobalTypeUpdate(String string) {
        if (!Globals.getPCClassTypeList().contains(string)) {
            Globals.getPCClassTypeList().add(string);
        }
    }

    final List<String> getClassSkillList() {
        return this.classSkillList;
    }

    int getKnownForLevel(int n, String string, PlayerCharacter playerCharacter) {
        int n2;
        Object object;
        int n3 = 0;
        int n4 = 0;
        String string2 = "CLASS." + this.getKeyName();
        String string3 = ";LEVEL." + n;
        int n5 = this.getLevel();
        n5 += (int)playerCharacter.getTotalBonusTo("PCLEVEL", this.keyName);
        if (this.castInfo != null && this.castInfo.hasCastProgression() && this.getNumFromCastList(n5 += (int)playerCharacter.getTotalBonusTo("PCLEVEL", "TYPE." + this.getSpellType()), n, playerCharacter) < 0) {
            return (int)playerCharacter.getTotalBonusTo("SPELLKNOWN", string2 + string3);
        }
        n3 += (int)playerCharacter.getTotalBonusTo("SPELLKNOWN", string2 + string3);
        n3 += (int)playerCharacter.getTotalBonusTo("SPELLKNOWN", "TYPE." + this.getSpellType() + string3);
        n3 += (int)playerCharacter.getTotalBonusTo("SPELLKNOWN", "CLASS.Any" + string3);
        n3 += (int)playerCharacter.getTotalBonusTo("SPELLKNOWN", string2 + ";LEVEL.All");
        n3 += (int)playerCharacter.getTotalBonusTo("SPELLKNOWN", "TYPE." + this.getSpellType() + ";LEVEL.All");
        n3 += (int)playerCharacter.getTotalBonusTo("SPELLKNOWN", "CLASS.Any;LEVEL.All");
        int n6 = this.baseSpellIndex();
        if (n6 != -2 && n6 >= 0 && n6 < playerCharacter.getStatList().size()) {
            object = playerCharacter.getStatList().getStatAt(n6);
            n4 = playerCharacter.getStatList().getTotalStatFor(((PCStat)object).getAbb());
        }
        object = "None";
        if (n6 >= 0) {
            object = SettingsHandler.getGame().s_ATTRIBSHORT[n6];
        }
        int n7 = (int)playerCharacter.getTotalBonusTo("STAT", "KNOWN." + (String)object) + (int)playerCharacter.getTotalBonusTo("STAT", "BASESPELLKNOWNSTAT") + (int)playerCharacter.getTotalBonusTo("STAT", "BASESPELLKNOWNSTAT;CLASS." + this.keyName);
        if (n6 > -2 && (n2 = playerCharacter.getVariableValue("MAXLEVELSTAT=" + (String)object, "").intValue()) + n7 < n) {
            return n3;
        }
        n4 += n7;
        n2 = (int)playerCharacter.getTotalBonusTo("SPELLKNOWNMULT", string2 + string3);
        if ((n2 += (int)playerCharacter.getTotalBonusTo("SPELLKNOWNMULT", "TYPE." + this.getSpellType() + string3)) < 1) {
            n2 = 1;
        }
        if (this.castInfo == null) {
            return n3;
        }
        boolean bl = false;
        if (this.castInfo.hasKnownProgression()) {
            List<String> list = this.castInfo.getKnownForLevel(n5);
            if (n >= 0 && n < list.size()) {
                String string4 = list.get(n);
                if (string4.endsWith("+d")) {
                    bl = true;
                    string4 = string4.substring(0, string4.length() - 2);
                }
                int n8 = this.castInfo.containsSpellFormula() ? playerCharacter.getVariableValue(string4, "").intValue() : Integer.parseInt(string4);
                n3 += n8 * n2;
                String string5 = Globals.getBonusSpellMap().get(String.valueOf(n));
                if (Globals.checkRule("BONUSSPELLKNOWN") && string5 != null && !string5.equals("0|0")) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string5, "|");
                    int n9 = Integer.parseInt(stringTokenizer.nextToken());
                    int n10 = Integer.parseInt(stringTokenizer.nextToken());
                    if (n4 >= n9) {
                        n3 += Math.max(0, (n4 - n9 + n10) / n10);
                    }
                }
                if (bl) {
                    n3 += this.castInfo.getKnownSpellsFromSpecialty();
                }
            }
        }
        if (n3 > 0 && n > 0 && !bl) {
            n3 += this.castInfo.getKnownSpellsFromSpecialty();
        }
        return n3;
    }

    public boolean isProhibited(Spell spell, PlayerCharacter playerCharacter) {
        if (!PrereqHandler.passesAll(spell.getPreReqList(), playerCharacter, this)) {
            return true;
        }
        if (this.prohibitSpellDescriptorList != null) {
            for (SpellProhibitor object : this.prohibitSpellDescriptorList) {
                if (!object.isProhibited(spell, playerCharacter)) continue;
                return true;
            }
        }
        if (this.prohibitedSchools != null) {
            for (String string : this.prohibitedSchools) {
                if (!spell.getSchools().contains(string) && !spell.getSubschools().contains(string)) continue;
                return true;
            }
        }
        return false;
    }

    String getUdamForLevel(int n, boolean bl, boolean bl2, PlayerCharacter playerCharacter, boolean bl3) {
        String string;
        Object object;
        List<String> list;
        int n2 = n += (int)playerCharacter.getTotalBonusTo("UDAM", "CLASS." + this.keyName);
        Equipment equipment = EquipmentList.getEquipmentKeyed("KEY_Unarmed Strike");
        String string2 = equipment != null ? equipment.getDamage(playerCharacter) : "1d3";
        int n3 = Globals.sizeInt(playerCharacter.getSize());
        if (bl3) {
            string2 = Globals.adjustDamage(string2, SettingsHandler.getGame().getDefaultSizeAdjustment().getAbbreviation(), SettingsHandler.getGame().getSizeAdjustmentAtIndex(n3).getAbbreviation());
        }
        if ((list = Globals.getClassKeyed(this.keyName).getListFor(ListKey.UDAM)) != null && !list.isEmpty()) {
            if (list.size() == 1 && (((String)(object = list.get(0))).startsWith("CLASS=") || ((String)object).startsWith("CLASS."))) {
                PCClass pCClass = Globals.getClassKeyed(((String)object).substring(6));
                if (pCClass != null) {
                    return pCClass.getUdamForLevel(n, bl, bl2, playerCharacter, bl3);
                }
                Logging.errorPrint(this.keyName + " refers to " + ((String)object).substring(6) + " which isn't loaded.");
                return string2;
            }
            if (n > list.size()) {
                n2 = list.size();
            }
            object = new StringTokenizer(list.get(Math.max(n2 - 1, 0)), ",", false);
            while (n3 > -1 && ((StringTokenizer)object).hasMoreTokens()) {
                string2 = ((StringTokenizer)object).nextToken();
                if (n3 == 0) break;
                --n3;
            }
        }
        object = new StringBuffer(string2);
        int n4 = (int)playerCharacter.getStatBonusTo("DAMAGE", "TYPE.MELEE");
        if (bl2 && (n4 += (int)playerCharacter.getStatBonusTo("DAMAGE", "TYPE=MELEE")) > 0) {
            ((StringBuffer)object).append('+');
        }
        if (bl2 && n4 != 0) {
            ((StringBuffer)object).append(String.valueOf(n4));
        }
        if (bl && !"0".equals(string = this.getUMultForLevel(n))) {
            ((StringBuffer)object).append("(x").append(string).append(')');
        }
        return ((StringBuffer)object).toString();
    }

    public void addInitMod(int n) {
        this.initMod += n;
    }

    boolean addLevel(PCLevelInfo pCLevelInfo, boolean bl, boolean bl2, PlayerCharacter playerCharacter, boolean bl3) {
        PCLevelInfo pCLevelInfo2;
        int n;
        int n2;
        int n3;
        int n4 = this.level + 1;
        boolean bl4 = bl;
        ++this.level;
        if (!bl3) {
            n3 = 0;
            if (!PrereqHandler.passesAll(this.getPreReqList(), playerCharacter, this)) {
                n3 = 1;
                if (!bl2) {
                    ShowMessageDelegate.showMessageDialog("This character does not qualify for level " + this.level, "PCGen", MessageType.ERROR);
                }
            }
            --this.level;
            if (n3 != 0) {
                return false;
            }
        }
        if (this.isMonster()) {
            bl4 = false;
        }
        if (this.hasMaxLevel() && n4 > this.maxLevel && bl4) {
            if (!bl2) {
                ShowMessageDelegate.showMessageDialog("This class cannot be raised above level " + Integer.toString(this.maxLevel), "PCGen", MessageType.ERROR);
            }
            return false;
        }
        n3 = playerCharacter.getTotalLevels();
        this.setLevel(n4, playerCharacter);
        for (String string : this.getTemplates(playerCharacter.isImporting(), playerCharacter)) {
            playerCharacter.addTemplateKeyed(string);
        }
        int n5 = playerCharacter.getMaxCharacterDomains(this, playerCharacter) - playerCharacter.getCharacterDomainUsed();
        if (!playerCharacter.hasDomainSource("PCClass", this.getKeyName(), n4) && n5 > 0) {
            playerCharacter.addDomainSource("PCClass", this.getKeyName(), n4, n5);
        }
        playerCharacter.setAutomaticAbilitiesStable(null, false);
        this.doPlusLevelMods(n4, playerCharacter, pCLevelInfo);
        if (Globals.getUseGUI()) {
            this.rollHP(playerCharacter, this.level, playerCharacter.getTotalLevels() == 1);
        }
        if (!playerCharacter.isImporting()) {
            this.modDomainsForLevel(n4, true, playerCharacter);
        }
        int n6 = 0;
        if (playerCharacter.getTotalLevels() > n3) {
            n2 = 1;
            boolean bl5 = true;
            n3 = playerCharacter.getTotalLevels();
            if (this.isMonster()) {
                if (n3 <= playerCharacter.getRace().getMonsterClassLevels(playerCharacter)) {
                    n2 = 0;
                }
                if (playerCharacter.isMonsterDefault() && n3 <= playerCharacter.getRace().getMonsterClassLevels(playerCharacter)) {
                    bl5 = false;
                }
            }
            if (!playerCharacter.isImporting() && n2 != 0 && (n = Globals.getBonusStatsForLevel(n3)) > 0) {
                playerCharacter.setPoolAmount(playerCharacter.getPoolAmount() + n);
                if (!bl2 && SettingsHandler.getShowStatDialogAtLevelUp()) {
                    n6 = this.askForStatIncrease(playerCharacter, n, true);
                }
            }
        }
        n2 = this.recalcSkillPointMod(playerCharacter, n3);
        if (playerCharacter.getLevelInfoSize() > 0 && (pCLevelInfo2 = playerCharacter.getLevelInfo().get(playerCharacter.getLevelInfoSize() - 1)) != null) {
            pCLevelInfo2.setLevel(this.level);
            pCLevelInfo2.setSkillPointsGained(n2);
            pCLevelInfo2.setSkillPointsRemaining(pCLevelInfo2.getSkillPointsGained());
        }
        this.skillPool = this.skillPool() + n2;
        playerCharacter.setSkillPoints(n2 + playerCharacter.getSkillPoints());
        if (!playerCharacter.isImporting()) {
            int n7;
            if (n6 > 0) {
                this.askForStatIncrease(playerCharacter, n6, false);
            }
            if (n4 == 1) {
                List<String> list = this.getSafeListFor(ListKey.KITS);
                for (n7 = 0; n7 > list.size(); ++n7) {
                    KitUtilities.makeKitSelections(0, list.get(n7), n7, playerCharacter);
                }
                this.makeRegionSelection(0, playerCharacter);
            }
            List<String> list = this.getSafeListFor(ListKey.KITS);
            for (n7 = 0; n7 > list.size(); ++n7) {
                KitUtilities.makeKitSelections(n4, list.get(n7), n7, playerCharacter);
            }
            this.makeRegionSelection(n4, playerCharacter);
            if (this.naturalWeapons != null) {
                ArrayList<Equipment> arrayList = new ArrayList<Equipment>();
                for (LevelProperty<Equipment> levelProperty : this.naturalWeapons) {
                    if (levelProperty.getLevel() > n4) continue;
                    arrayList.add(levelProperty.getObject());
                }
                playerCharacter.addNaturalWeapons(arrayList);
            }
        }
        if (this.isMonster()) {
            return true;
        }
        if (!playerCharacter.isImporting()) {
            this.checkRemovals(playerCharacter);
            n = playerCharacter.minXPForECL();
            if (playerCharacter.getXP() < n) {
                playerCharacter.setXP(n);
            } else if (playerCharacter.getXP() >= playerCharacter.minXPForNextECL() && !bl2) {
                ShowMessageDelegate.showMessageDialog(SettingsHandler.getGame().getLevelUpMessage(), "PCGen", MessageType.INFORMATION);
            }
        }
        if (this.levelExchange.length() != 0 && this.getLevel() == 1 && !playerCharacter.isImporting()) {
            this.exchangeLevels(playerCharacter);
        }
        return true;
    }

    private void exchangeLevels(PlayerCharacter playerCharacter) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.levelExchange, "|", false);
        if (stringTokenizer.countTokens() != 4) {
            Logging.errorPrint("levelExhange: invalid token count: " + stringTokenizer.countTokens());
        } else {
            try {
                int n;
                String string = stringTokenizer.nextToken();
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                int n4 = Integer.parseInt(stringTokenizer.nextToken());
                PCClass pCClass = playerCharacter.getClassKeyed(string);
                if (pCClass != null && (n = pCClass.getLevel()) >= n2) {
                    n3 = Math.min(n3, n - n4);
                    if (this.hasMaxLevel()) {
                        n3 = Math.min(n3, this.getMaxLevel() - 1);
                    }
                    if (n3 > 0) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        for (int i = 0; i <= n3; ++i) {
                            arrayList.add(Integer.toString(i));
                        }
                        ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
                        chooserInterface.setTitle("Select number of levels to convert from " + pCClass.getDisplayName() + " to " + this.getDisplayName());
                        chooserInterface.setPool(1);
                        chooserInterface.setPoolFlag(false);
                        chooserInterface.setAvailableList(arrayList);
                        chooserInterface.setVisible(true);
                        List list = chooserInterface.getSelectedList();
                        int n5 = 0;
                        if (!list.isEmpty()) {
                            n5 = Integer.parseInt((String)list.get(0));
                        }
                        if (n5 > 0) {
                            playerCharacter.giveClassesAway(this, pCClass, n5);
                        }
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                ShowMessageDelegate.showMessageDialog("levelExchange:" + Constants.s_LINE_SEP + numberFormatException.getMessage(), "PCGen", MessageType.ERROR);
            }
        }
    }

    void doMinusLevelMods(PlayerCharacter playerCharacter, int n) {
        if (!this.isMonster()) {
            this.changeFeatsForLevel(n, false, playerCharacter);
        }
        this.subAddsForLevel(n, playerCharacter);
        playerCharacter.removeVariable("CLASS:" + this.getKeyName() + "|" + Integer.toString(n));
    }

    void doPlusLevelMods(int n, PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo) {
        if (!this.isMonster()) {
            this.changeFeatsForLevel(n, true, playerCharacter);
        }
        this.addVariablesForLevel(n, playerCharacter);
        playerCharacter.calcActiveBonuses();
        this.addAddsForLevel(n, playerCharacter, pCLevelInfo);
    }

    @Override
    void fireNameChanged(String string, String string2) {
        Object object;
        int n;
        if (string.equals(string2)) {
            return;
        }
        List<SpecialAbility> list = this.getListFor(ListKey.SPECIAL_ABILITY);
        if (list != null) {
            for (n = list.size() - 1; n >= 0; --n) {
                SpecialAbility specialAbility = list.get(n);
                if (specialAbility.getSASource().length() == 0) continue;
                this.removeSpecialAbility(specialAbility);
                SpecialAbility specialAbility2 = new SpecialAbility(specialAbility.getKeyName(), specialAbility.getSASource(), specialAbility.getSADesc());
                specialAbility2.setQualificationClass(string, string2);
                this.addSpecialAbilityToList(specialAbility2);
            }
        }
        if (this.getVariableCount() > 0) {
            for (n = this.getVariableCount() - 1; n >= 0; --n) {
                Variable variable = this.getVariable(n);
                object = variable.getValue();
                object = ((String)object).replaceAll("=" + string, "=" + string2);
                variable.setValue((String)object);
            }
        }
        if (this.getBonusList() != null) {
            for (BonusObj bonusObj : this.getBonusList()) {
                object = bonusObj.toString();
                int n2 = -1;
                while ((n2 = ((String)object).indexOf('=' + string, n2 + 1)) >= 0) {
                    this.addBonusList(((String)object).substring(0, n2 + 1) + string2 + ((String)object).substring(n2 + string.length() + 1));
                    this.removeBonusList(bonusObj);
                }
            }
        }
        for (DamageReduction damageReduction : this.getDRList()) {
            for (Prerequisite prerequisite : damageReduction.getPreReqList()) {
                if (!DamageReduction.isPrereqForClassLevel(prerequisite, string)) continue;
                prerequisite.setKey(string2);
            }
        }
    }

    @Override
    String makeBonusString(String string, String string2, PlayerCharacter playerCharacter) {
        return "0|" + super.makeBonusString(string, string2, playerCharacter);
    }

    int memorizedSpecialtiesForLevelBook(int n, String string) {
        int n2 = 0;
        List<CharacterSpell> list = this.getSpellSupport().getCharacterSpell(null, string, n);
        if (list.isEmpty()) {
            return n2;
        }
        for (CharacterSpell characterSpell : list) {
            if (!characterSpell.isSpecialtySpell()) continue;
            n2 += characterSpell.getSpellInfoFor(string, n, -1).getTimes();
        }
        return n2;
    }

    int memorizedSpellForLevelBook(int n, String string) {
        int n2 = 0;
        List<CharacterSpell> list = this.getSpellSupport().getCharacterSpell(null, string, n);
        if (list.isEmpty()) {
            return n2;
        }
        for (CharacterSpell characterSpell : list) {
            n2 += characterSpell.getSpellInfoFor(string, n, -1).getTimes();
        }
        return n2;
    }

    void subLevel(boolean bl, PlayerCharacter playerCharacter) {
        if (playerCharacter != null) {
            Cloneable cloneable;
            int n;
            int n2 = playerCharacter.getTotalLevels();
            List<SpecialAbility> list = this.getListFor(ListKey.SPECIAL_ABILITY);
            if (list != null && !list.isEmpty()) {
                for (n = list.size() - 1; n >= 0; --n) {
                    cloneable = list.get(n);
                    if (!((SpecialAbility)cloneable).getSASource().startsWith("PCCLASS|") || ((SpecialAbility)cloneable).pcQualifiesFor(playerCharacter)) continue;
                    list.remove(cloneable);
                }
            }
            n = 0;
            cloneable = playerCharacter.getLevelInfoFor(this.keyName, this.level);
            if (cloneable != null) {
                n = ((PCLevelInfo)cloneable).getSkillPointsGained();
            } else {
                Logging.errorPrint("ERROR: could not find class/level info for " + this.displayName + "/" + this.level);
            }
            List<LevelAbility> list2 = this.getLevelAbilityList();
            if (list2 != null && !list2.isEmpty()) {
                for (LevelAbility levelAbility : list2) {
                    if (levelAbility.level() != this.level || !levelAbility.isFeat()) continue;
                    playerCharacter.adjustFeats(-1.0);
                }
            }
            Integer n3 = 0;
            int n4 = this.level - 1;
            if (this.level > 0) {
                this.setHitPoint(this.level - 1, n3);
            }
            this.setLevel(n4, playerCharacter);
            this.removeKnownSpellsForClassLevel(playerCharacter);
            this.doMinusLevelMods(playerCharacter, n4 + 1);
            this.modDomainsForLevel(n4, false, playerCharacter);
            if (n4 == 0) {
                this.setSubClassKey("None");
                for (Skill object : playerCharacter.getSkillList()) {
                    object.setZeroRanks(this, playerCharacter);
                }
                n = this.skillPool();
            }
            if (!this.isMonster() && n2 > playerCharacter.getTotalLevels()) {
                n2 = playerCharacter.getTotalLevels();
                Iterator<Equipment> iterator = new ArrayList();
                if (((PCLevelInfo)cloneable).getModifiedStats(true) != null) {
                    iterator.addAll(((PCLevelInfo)cloneable).getModifiedStats(true));
                }
                if (((PCLevelInfo)cloneable).getModifiedStats(false) != null) {
                    iterator.addAll(((PCLevelInfo)cloneable).getModifiedStats(false));
                }
                if (!iterator.isEmpty()) {
                    Iterator iterator2 = iterator.iterator();
                    block3: while (iterator2.hasNext()) {
                        PCLevelInfoStat pCLevelInfoStat = (PCLevelInfoStat)iterator2.next();
                        for (PCStat pCStat : playerCharacter.getStatList()) {
                            if (!pCStat.getAbb().equalsIgnoreCase(pCLevelInfoStat.getStatAbb())) continue;
                            pCStat.setBaseScore(pCStat.getBaseScore() - pCLevelInfoStat.getStatMod());
                            continue block3;
                        }
                    }
                }
            }
            if (!this.isMonster() && n2 == 0) {
                playerCharacter.setSkillPoints(0);
                playerCharacter.getSkillList().clear();
                playerCharacter.clearRealAbilities(null);
                playerCharacter.setDirty(true);
            } else {
                playerCharacter.setSkillPoints(playerCharacter.getSkillPoints() - n);
                this.skillPool = this.skillPool() - n;
            }
            if (this.getLevel() == 0) {
                playerCharacter.getClassList().remove(this);
            }
            playerCharacter.validateCharacterDomains();
            for (Equipment equipment : this.getNaturalWeapons(n4 + 1)) {
                playerCharacter.removeEquipment(equipment);
                playerCharacter.delEquipSetItem(equipment);
                playerCharacter.setDirty(true);
            }
        } else {
            Logging.errorPrint("No current pc in subLevel()? How did this happen?");
            return;
        }
    }

    private static int getExtraHD(PlayerCharacter playerCharacter, int n) {
        int n2;
        int n3 = Globals.sizeInt(playerCharacter.getRace().getSize());
        switch (n3) {
            case 8: {
                n2 = 32;
                break;
            }
            case 7: {
                n2 = 16;
                break;
            }
            case 6: {
                n2 = 4;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 1;
            }
        }
        return Math.max(0, n - n2);
    }

    private boolean isAutoKnownSpell(String string, int n, boolean bl, PlayerCharacter playerCharacter) {
        Object object;
        if (this.knownSpellsList == null || this.knownSpellsList.size() == 0) {
            return false;
        }
        Spell spell = Globals.getSpellKeyed(string);
        if (bl ? (object = this.castForLevelMap.get(n)) == null || (Integer)object == 0 || spell == null : this.getCastForLevel(n, playerCharacter) == 0 || spell == null) {
            return false;
        }
        if (this.isProhibited(spell, playerCharacter) && !this.isSpecialtySpell(spell)) {
            return false;
        }
        for (SpellFilter spellFilter : this.knownSpellsList) {
            if (!spellFilter.matchesFilter(string, n)) continue;
            return true;
        }
        return false;
    }

    private int getMonsterSkillPointMod(PlayerCharacter playerCharacter, int n) {
        int n2 = 0;
        int n3 = (int)playerCharacter.getTotalBonusTo("MONSKILLPTS", "LOCKNUMBER");
        if (n == 1) {
            n2 = n3 == 0 ? (int)playerCharacter.getTotalBonusTo("MONSKILLPTS", "NUMBER") : n3;
        } else if (PCClass.getExtraHD(playerCharacter, n) > 0) {
            n2 = playerCharacter.getVariableValue(this.getSkillPointFormula(), this.classKey).intValue();
            n2 = n3 == 0 ? (n2 += (int)playerCharacter.getTotalBonusTo("SKILLPOINTS", "NUMBER")) : (n2 += n3);
            n2 = this.updateBaseSkillMod(playerCharacter, n2);
        }
        if (n2 < 0) {
            n2 = 0;
        }
        return n2;
    }

    private int getNonMonsterSkillPointMod(PlayerCharacter playerCharacter, int n) {
        int n2 = playerCharacter.getVariableValue(this.getSkillPointFormula(), this.classKey).intValue();
        n2 += (int)playerCharacter.getTotalBonusTo("SKILLPOINTS", "NUMBER");
        if (this.isMonster()) {
            int n3;
            int n4 = (int)playerCharacter.getTotalBonusTo("MONSKILLPTS", "LOCKNUMBER");
            if (n4 > 0) {
                n2 = n4;
            } else if (n == 1 && (n3 = (int)playerCharacter.getTotalBonusTo("MONSKILLPTS", "NUMBER")) != 0) {
                n2 = n3;
            }
            if (n != 1 && n <= (n3 = (int)playerCharacter.getTotalBonusTo("MONNONSKILLHD", "NUMBER"))) {
                n2 = 0;
            }
        }
        n2 = this.updateBaseSkillMod(playerCharacter, n2);
        if (n == 1) {
            if (SettingsHandler.getGame().isPurchaseStatMode()) {
                playerCharacter.setPoolAmount(0);
            }
            n2 *= Math.min(Globals.getSkillMultiplierForLevel(n), playerCharacter.getRace().getInitialSkillMultiplier());
            Globals.getBioSet().randomize("AGE", playerCharacter);
        } else {
            n2 *= Globals.getSkillMultiplierForLevel(n);
        }
        return n2;
    }

    private void calcCastPerDayMapForLevel(PlayerCharacter playerCharacter) {
        if (this.castForLevelMap == null) {
            this.castForLevelMap = new HashMap(100);
        }
        for (int i = 0; i < 100; ++i) {
            int n = this.getCastForLevel(i, playerCharacter);
            this.castForLevelMap.put(i, n);
        }
    }

    @Override
    public List<String> getTemplates(boolean bl, PlayerCharacter playerCharacter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            return arrayList;
        }
        for (LevelProperty<String> levelProperty : this.getTemplates()) {
            if (this.level < levelProperty.getLevel()) continue;
            String string = levelProperty.getObject();
            if (string.startsWith("CHOOSE:")) {
                arrayList.add(PCTemplate.chooseTemplate(this, string.substring(7), true, playerCharacter));
                continue;
            }
            for (String string2 : string.split("\\|")) {
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private String getUMultForLevel(int n) {
        String string = "0";
        List<String> list = this.getListFor(ListKey.UMULT);
        if (list == null || list.isEmpty()) {
            return string;
        }
        for (String string2 : list) {
            int n2 = string2.lastIndexOf(124);
            if (n2 < 0 || n > Integer.parseInt(string2.substring(0, n2))) continue;
            string = string2.substring(n2 + 1);
        }
        return string;
    }

    private void addVariablesForLevel(int n, PlayerCharacter playerCharacter) {
        if (this.getVariableCount() == 0) {
            return;
        }
        if (n == 1) {
            this.addVariablesForLevel(0, playerCharacter);
        }
        String string = this.classKey + '|';
        Iterator<Variable> iterator = this.getVariableIterator();
        while (iterator.hasNext()) {
            Variable variable = iterator.next();
            if (variable.getLevel() != n) continue;
            playerCharacter.addVariable(string + variable.getDefinition());
        }
    }

    private final int askForStatIncrease(PlayerCharacter playerCharacter, int n, boolean bl) {
        if (bl && !Globals.checkRule("INTBEFORE")) {
            return n;
        }
        String string = "";
        if (bl) {
            string = "\nRaising a stat here may award more skill points.";
        }
        int n2 = 0;
        block0: for (int i = 0; i < n; ++i) {
            Object object2;
            StringBuffer stringBuffer = new StringBuffer();
            for (Object object2 : playerCharacter.getStatList()) {
                int n3 = playerCharacter.getStatList().getTotalStatFor(((PCStat)object2).getAbb());
                int n4 = playerCharacter.getStatList().getBaseStatFor(((PCStat)object2).getAbb());
                stringBuffer.append(((PCStat)object2).getAbb()).append(": ").append(n4);
                if (n4 != n3) {
                    stringBuffer.append(" adjusted: ").append(n3);
                }
                stringBuffer.append(" (").append(playerCharacter.getStatList().getStatModFor(((PCStat)object2).getAbb())).append(")\n");
            }
            InputInterface inputInterface = InputFactory.getInputInstance();
            object2 = inputInterface.showInputDialog(null, "Choose stat to increment or select Cancel to increment stat on the Summary tab." + string + "\n\n" + "Current Stats:\n" + stringBuffer + "\n", "PCGen", MessageType.INFORMATION, SettingsHandler.getGame().s_ATTRIBLONG, SettingsHandler.getGame().s_ATTRIBLONG[0]);
            if (object2 == null) continue;
            for (PCStat pCStat : playerCharacter.getStatList()) {
                if (!pCStat.getDisplayName().equalsIgnoreCase(object2.toString())) continue;
                playerCharacter.saveStatIncrease(pCStat.getAbb(), 1, bl);
                pCStat.setBaseScore(pCStat.getBaseScore() + 1);
                playerCharacter.setPoolAmount(playerCharacter.getPoolAmount() - 1);
                ++n2;
                continue block0;
            }
        }
        return n - n2;
    }

    private void buildSubstitutionClassChoiceList(List<PCClass> list, int n, PlayerCharacter playerCharacter) {
        for (SubstitutionClass substitutionClass : this.substitutionClassList) {
            if (!PrereqHandler.passesAll(substitutionClass.getPreReqList(), playerCharacter, this) || !substitutionClass.hasLevelArrayModsForLevel(n)) continue;
            list.add(substitutionClass);
        }
    }

    private double calcPartialBonus(String string, int n, BonusObj bonusObj, Object object) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        if (bonusObj.getPCLevel() >= 0) {
            stringTokenizer.nextToken();
        }
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        double d = 0.0;
        if (string2.equals("ALL")) {
            return 0.0;
        }
        if (object instanceof PlayerCharacter) {
            d = ((PlayerCharacter)object).getVariableValue(string3, this.classKey).doubleValue();
        } else {
            try {
                d = Float.parseFloat(string3);
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint("PCClass calcPartialBonus NumberFormatException in BONUS: " + string);
            }
        }
        return d * (double)n;
    }

    private void changeFeatsForLevel(int n, boolean bl, PlayerCharacter playerCharacter) {
        if (playerCharacter == null || this.featList == null || this.featList.isEmpty()) {
            return;
        }
        PCLevelInfo object = null;
        for (PCLevelInfo object2 : playerCharacter.getLevelInfo()) {
            if (!object2.getClassKeyName().equalsIgnoreCase(this.getKeyName()) || object2.getLevel() != n) continue;
            object = object2;
            break;
        }
        for (LevelProperty levelProperty : this.featList) {
            if (levelProperty.getLevel() != n) continue;
            double d = playerCharacter.getUsedFeatCount();
            AbilityUtilities.modFeatsFromList(playerCharacter, object, (String)levelProperty.getObject(), bl, n == 1);
            double d2 = playerCharacter.getUsedFeatCount();
            playerCharacter.adjustFeats(d2 - d);
        }
    }

    private static void checkAdd(StringBuffer stringBuffer, String string, String string2, String string3) {
        if (string3 != null && !string.equals(string3)) {
            stringBuffer.append('\t').append(string2).append(string3);
        }
    }

    private void checkForSubClass(PlayerCharacter playerCharacter) {
        Cloneable cloneable;
        if (!this.hasSubClass || this.subClassList == null || this.subClassList.isEmpty()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add("Name");
        arrayList.add("Cost");
        arrayList.add("Other");
        ArrayList arrayList2 = new ArrayList();
        for (SubClass object2 : this.subClassList) {
            if (!PrereqHandler.passesAll(object2.getPreReqList(), playerCharacter, this)) continue;
            cloneable = new ArrayList<Object>(3);
            cloneable.add(object2);
            cloneable.add(Integer.toString(object2.getCost()));
            cloneable.add(object2.getSupplementalDisplayInfo());
            if (!this.getSubClassKey().equals("None")) {
                arrayList2.clear();
                arrayList2.add(cloneable);
                break;
            }
            arrayList2.add(cloneable);
        }
        ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
        chooserInterface.setTitle("School Choice (Specialisation)");
        chooserInterface.setMessageText("Make a selection.  The cost column indicates the cost of that selection. If this cost is non-zero, you will be asked to also select items from this list to give up to cover that cost.");
        chooserInterface.setPool(1);
        chooserInterface.setPoolFlag(false);
        chooserInterface.setAvailableColumnNames(arrayList);
        chooserInterface.setAvailableList(arrayList2);
        if (arrayList2.size() == 1) {
            chooserInterface.setSelectedList(arrayList2);
        } else if (arrayList2.size() != 0) {
            chooserInterface.setVisible(true);
        }
        List list = chooserInterface.getSelectedList();
        if (!list.isEmpty()) {
            this.clearProhibitedSchools();
            this.specialtyList = null;
            cloneable = (SubClass)((List)list.get(0)).get(0);
            arrayList2 = new ArrayList();
            for (SubClass subClass : this.subClassList) {
                if (subClass.equals(cloneable) || !PrereqHandler.passesAll(subClass.getPreReqList(), playerCharacter, this)) continue;
                List list2 = new ArrayList<Object>(3);
                int n = subClass.getProhibitCost();
                if (n == 0) continue;
                list2.add(subClass);
                list2.add(Integer.toString(n));
                list2.add(subClass.getSupplementalDisplayInfo());
                arrayList2.add(list2);
            }
            this.setSubClassKey(((PObject)cloneable).getKeyName());
            if (((SubClass)cloneable).getChoice().length() > 0) {
                this.addSpecialty(((SubClass)cloneable).getChoice());
            }
            if (((SubClass)cloneable).getCost() != 0) {
                ChooserInterface chooserInterface2 = ChooserFactory.getChooserInstance();
                chooserInterface2.setTitle("School Choice (Prohibited)");
                chooserInterface2.setAvailableColumnNames(arrayList);
                chooserInterface2.setAvailableList(arrayList2);
                chooserInterface2.setMessageText("Make a selection.  You must make as many selections necessary to cover the cost of your previous selections.");
                chooserInterface2.setPool(((SubClass)cloneable).getCost());
                chooserInterface2.setPoolFlag(true);
                chooserInterface2.setCostColumnNumber(1);
                chooserInterface2.setNegativeAllowed(true);
                chooserInterface2.setVisible(true);
                List list3 = chooserInterface2.getSelectedList();
                for (List list2 : list3) {
                    cloneable = (SubClass)list2.get(0);
                    this.addProhibitedSchool(((SubClass)cloneable).getChoice());
                }
            }
        }
    }

    private void checkForSubstitutionClass(int n, PlayerCharacter playerCharacter) {
        if (!this.hasSubstitutionClass || this.substitutionClassList == null || this.substitutionClassList.isEmpty()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add("Name");
        ArrayList<PCClass> arrayList2 = new ArrayList<PCClass>();
        this.buildSubstitutionClassChoiceList(arrayList2, this.level, playerCharacter);
        if (arrayList2.size() == 0) {
            return;
        }
        ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
        chooserInterface.setTitle("Substitution Levels");
        chooserInterface.setMessageText("Choose one of the listed substitution levels or press Close to take the standard class level.");
        chooserInterface.setPool(1);
        chooserInterface.setPoolFlag(false);
        chooserInterface.setAvailableColumnNames(arrayList);
        chooserInterface.setAvailableList(arrayList2);
        chooserInterface.setVisible(true);
        List list = chooserInterface.getSelectedList();
        if (!list.isEmpty()) {
            SubstitutionClass substitutionClass = (SubstitutionClass)list.get(0);
            this.setSubstitutionClassKey(substitutionClass.getKeyName(), n);
            substitutionClass.applyLevelArrayModsToLevel(this, n);
            return;
        }
        this.setSubstitutionClassKey(null, n);
    }

    private void chooseClassSkillList() {
        if (this.classSkillChoices == null) {
            return;
        }
        this.clearClassSkillList();
        List<String> list = this.classSkillChoices.getList();
        if (list.size() == 1) {
            this.addClassSkill(list.get(0));
            return;
        }
        ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
        chooserInterface.setTitle("Select class whose class-skills this class will inherit");
        chooserInterface.setPool(this.classSkillChoices.getCount());
        chooserInterface.setPoolFlag(false);
        chooserInterface.setAvailableList(list);
        chooserInterface.setVisible(true);
        List list2 = chooserInterface.getSelectedList();
        for (String string : list2) {
            this.addClassSkill(string);
        }
    }

    private void chooseClassSpellList() {
        if (this.classSpellChoices == null || this.level < 1) {
            return;
        }
        this.clearClassSpellList();
        List<String> list = this.classSpellChoices.getList();
        if (list.size() == 1) {
            this.addClassSpellList(list.get(0));
            return;
        }
        ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
        chooserInterface.setTitle("Select class whose list of spells this class will use");
        chooserInterface.setPool(this.classSpellChoices.getCount());
        chooserInterface.setPoolFlag(false);
        chooserInterface.setAvailableList(list);
        chooserInterface.setVisible(true);
        List list2 = chooserInterface.getSelectedList();
        for (String string : list2) {
            this.addClassSpellList(string);
        }
    }

    private void inheritAttributesFrom(PCClass pCClass) {
        if (pCClass.getBonusSpellBaseStat() != null) {
            this.setBonusSpellBaseStat(pCClass.getBonusSpellBaseStat());
        }
        if (pCClass.getSpellBaseStat() != null) {
            this.setSpellBaseStat(pCClass.getSpellBaseStat());
        }
        this.classSpellChoices = pCClass.classSpellChoices;
        Set<String> set = pCClass.getAutoMapKeys();
        if (set != null) {
            for (String object : set) {
                this.addAutoArray(object, pCClass.getAuto(object));
            }
        }
        if (!pCClass.getBonusList().isEmpty()) {
            this.getBonusList().addAll(pCClass.getBonusList());
        }
        if (pCClass.getVariableCount() > 0) {
            this.addAllVariablesFrom(pCClass);
        }
        if (pCClass.getCSkillList() != null) {
            this.clearCSkills();
            this.addAllCSkills(pCClass.getCSkillList());
        }
        if (pCClass.getCcSkillList() != null) {
            this.clearCcSkills();
            this.addAllCcSkills(pCClass.getCcSkillList());
        }
        pCClass.setKitList(this.getSafeListFor(ListKey.KITS));
        if (pCClass.getRegionString() != null) {
            this.setRegionString(pCClass.getRegionString());
        }
        List<SpecialAbility> list = this.getSafeListFor(ListKey.SPECIAL_ABILITY);
        list.addAll(pCClass.getSafeListFor(ListKey.SPECIAL_ABILITY));
        if (!pCClass.getDRList().isEmpty()) {
            for (DamageReduction damageReduction : pCClass.getDRList()) {
                try {
                    this.addDR(damageReduction.clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    Logging.errorPrint("Failed to clone DR for PCClass " + this.keyName + ".", cloneNotSupportedException);
                }
            }
        }
        if (pCClass.SR != null) {
            this.SR = new ArrayList<LevelProperty<String>>(pCClass.SR);
        }
        if (pCClass.vision != null) {
            this.vision = pCClass.vision;
        }
        if (pCClass instanceof SubClass) {
            ((SubClass)pCClass).applyLevelArrayModsTo(this);
        }
        if (pCClass.naturalWeapons != null) {
            this.naturalWeapons = new ArrayList<LevelProperty<Equipment>>(pCClass.naturalWeapons);
        }
        this.hitDie = pCClass.hitDie;
    }

    private void modDomainsForLevel(int n, boolean bl, PlayerCharacter playerCharacter) {
        if (playerCharacter.isImporting()) {
            return;
        }
        ArrayList<Domain> arrayList = new ArrayList<Domain>();
        for (int i = 0; i <= n; ++i) {
            for (Domain domain : this.getDomainList(i)) {
                arrayList.add(domain);
            }
        }
        for (Domain domain : arrayList) {
            if (!domain.qualifies(playerCharacter)) continue;
            String string = domain.getKeyName();
            if (bl) {
                if (playerCharacter.containsCharacterDomain(this.getKeyName(), string)) continue;
                Domain domain2 = domain.clone();
                CharacterDomain characterDomain = playerCharacter.getNewCharacterDomain(this.getKeyName());
                characterDomain.setDomain(domain2, playerCharacter);
                playerCharacter.addCharacterDomain(characterDomain);
                domain2 = characterDomain.getDomain();
                domain2.setIsLocked(true, playerCharacter);
                continue;
            }
            if (!playerCharacter.containsCharacterDomain(string)) continue;
            playerCharacter.removeCharacterDomain(string);
        }
    }

    public void rollHP(PlayerCharacter playerCharacter, int n, boolean bl) {
        int n2 = 0;
        int n3 = 1 + (int)playerCharacter.getTotalBonusTo("HD", "MIN") + (int)playerCharacter.getTotalBonusTo("HD", "MIN;CLASS." + this.keyName);
        int n4 = this.getLevelHitDie(playerCharacter, n) + (int)playerCharacter.getTotalBonusTo("HD", "MAX") + (int)playerCharacter.getTotalBonusTo("HD", "MAX;CLASS." + this.keyName);
        if (Globals.getGameModeHPFormula().length() == 0) {
            if (bl && n == 1 && SettingsHandler.isHPMaxAtFirstLevel()) {
                n2 = n4;
            } else if (!playerCharacter.isImporting()) {
                n2 = Globals.rollHP(n3, n4, this.getDisplayName(), n);
            }
        }
        this.setHitPoint(n - 1, n2 += (int)playerCharacter.getTotalBonusTo("HP", "CURRENTMAXPERLEVEL"));
        playerCharacter.setCurrentHP(playerCharacter.hitPoints());
    }

    private int updateBaseSkillMod(PlayerCharacter playerCharacter, int n) {
        int n2;
        int n3 = n2 = n > 0 ? 1 : 0;
        if (this.modToSkills && (n += (int)playerCharacter.getStatBonusTo("MODSKILLPOINTS", "NUMBER")) < 1) {
            n = 1;
        }
        n += playerCharacter.getRace().getBonusSkillsPerLevel();
        n = Math.max(n2, n);
        if (!playerCharacter.getTemplateList().isEmpty()) {
            for (PCTemplate pCTemplate : playerCharacter.getTemplateList()) {
                n += pCTemplate.getBonusSkillsPerLevel();
            }
        }
        return n;
    }

    @Override
    public void addNaturalWeapon(Equipment equipment, int n) {
        if (this.naturalWeapons == null) {
            this.naturalWeapons = new ArrayList<LevelProperty<Equipment>>();
        }
        this.naturalWeapons.add(LevelProperty.getLevelProperty(n, equipment));
    }

    @Override
    public List<PCSpell> getSpellList() {
        return this.getSpellSupport().getSpellList(this.getLevel());
    }

    public final void setAttackCycle(AttackType attackType, String string) {
        if (this.attackCycleMap == null) {
            this.attackCycleMap = new HashMap();
        }
        this.attackCycleMap.put(attackType, string);
    }

    public final Map<AttackType, String> getAttackCycle() {
        if (this.attackCycleMap == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.attackCycleMap);
    }

    public void removeAllAutoFeats(int n) {
        if (this.featAutos != null) {
            Iterator<LevelProperty<String>> iterator = this.featAutos.iterator();
            while (iterator.hasNext()) {
                LevelProperty<String> levelProperty = iterator.next();
                if (levelProperty.getLevel() != n) continue;
                iterator.remove();
            }
        }
    }

    public int getMinLevelForSpellLevel(int n, boolean bl) {
        if (this.castInfo == null) {
            return -1;
        }
        return this.castInfo.getMinLevelForSpellLevel(n, bl);
    }

    public int getMaxSpellLevelForClassLevel(int n) {
        if (this.castInfo == null) {
            return -1;
        }
        return this.castInfo.getMaxSpellLevelForClassLevel(n);
    }

    public void setKnownSpellsFromSpecialty(int n) {
        if (this.castInfo == null && n == 0) {
            return;
        }
        this.getConstructingSpellProgressionInfo().setKnownSpellsFromSpecialty(n);
    }

    public int getKnownSpellsFromSpecialty() {
        return this.castInfo == null ? 0 : this.castInfo.getKnownSpellsFromSpecialty();
    }

    @Override
    public Load getEncumberedArmorMove() {
        LevelProperty<Load> levelProperty = null;
        if (this.encumberedArmorMove != null) {
            for (LevelProperty<Load> levelProperty2 : this.encumberedArmorMove) {
                if (levelProperty2.getLevel() > this.level || levelProperty != null && levelProperty.getLevel() >= levelProperty2.getLevel()) continue;
                levelProperty = levelProperty2;
            }
        }
        return levelProperty == null ? super.getEncumberedArmorMove() : (Load)((Object)levelProperty.getObject());
    }

    @Override
    public Load getEncumberedLoadMove() {
        LevelProperty<Load> levelProperty = null;
        if (this.encumberedLoadMove != null) {
            for (LevelProperty<Load> levelProperty2 : this.encumberedLoadMove) {
                if (levelProperty2.getLevel() > this.level || levelProperty != null && levelProperty.getLevel() >= levelProperty2.getLevel()) continue;
                levelProperty = levelProperty2;
            }
        }
        return levelProperty == null ? super.getEncumberedLoadMove() : (Load)((Object)levelProperty.getObject());
    }

    @Override
    public void setEncumberedArmorMove(Load load, int n) {
        if (this.encumberedArmorMove == null) {
            this.encumberedArmorMove = new ArrayList<LevelProperty<Load>>();
        }
        this.encumberedArmorMove.add(LevelProperty.getLevelProperty(n, load));
    }

    @Override
    public void setEncumberedLoadMove(Load load, int n) {
        if (this.encumberedLoadMove == null) {
            this.encumberedLoadMove = new ArrayList<LevelProperty<Load>>();
        }
        this.encumberedLoadMove.add(LevelProperty.getLevelProperty(n, load));
    }

    @Override
    public void setMovement(Movement movement, int n) {
        if (this.movementList == null) {
            this.movementList = new ArrayList<LevelProperty<Movement>>();
        }
        this.movementList.add(LevelProperty.getLevelProperty(n, movement));
    }

    @Override
    public List<Movement> getMovements() {
        if (this.movementList == null) {
            return Collections.emptyList();
        }
        ArrayList<Movement> arrayList = new ArrayList<Movement>();
        for (LevelProperty<Movement> levelProperty : this.movementList) {
            if (levelProperty.getLevel() > this.level) continue;
            arrayList.add(levelProperty.getObject());
        }
        return arrayList;
    }
}

