/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.AbilityCategory;
import pcgen.core.DamageReduction;
import pcgen.core.Globals;
import pcgen.core.HasCost;
import pcgen.core.Language;
import pcgen.core.PCStat;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.PrereqObject;
import pcgen.core.SettingsHandler;
import pcgen.core.SpecialAbility;
import pcgen.core.levelability.LevelAbility;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.ListKey;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.util.DoubleKeyMap;
import pcgen.util.PropertyFactory;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PCTemplate
extends PObject
implements HasCost {
    private List<String> featStrings = null;
    private List<String> hitDiceStrings = null;
    private List<String> templates = new ArrayList<String>();
    private HashMap<String, String> chosenFeatStrings = null;
    private Map<AbilityCategory, Map<String, String>> theChosenAbilityKeys = null;
    private List<String> templatesAdded = null;
    private String cost = "1";
    private String favoredClass = "";
    private String gender = "None";
    private String handed = "None";
    private String levelAdjustment = "0";
    private String region = "None";
    private String subRace = "None";
    private String subregion = "None";
    private String templateSize = "";
    private boolean removable = true;
    private int ChallengeRating = 0;
    private int bonusInitialFeats = 0;
    private int bonusSkillsPerLevel = 0;
    private String hitDieLock = "";
    private int levelsPerFeat = 3;
    private int nonProficiencyPenalty = 1;
    private String raceType = "";
    private Integer hands;
    private Integer legs;
    private Integer reach;
    private List<String> addedSubTypes = new ArrayList<String>();
    private Point2D.Double face = null;
    private List<String> removedSubTypes = new ArrayList<String>();
    private List<String> levelMods = new ArrayList<String>();
    private DoubleKeyMap<Integer, String, String> theLevelAbilities = null;

    public void setBonusInitialFeats(int n) {
        this.bonusInitialFeats = n;
    }

    public int getBonusInitialFeats() {
        return this.bonusInitialFeats;
    }

    public void setBonusSkillsPerLevel(int n) {
        this.bonusSkillsPerLevel = n;
    }

    public int getBonusSkillsPerLevel() {
        return this.bonusSkillsPerLevel;
    }

    public void setCR(int n) {
        this.ChallengeRating = n;
    }

    public int getCR(int n, int n2) {
        int n3;
        int n4 = this.ChallengeRating;
        if (this.theLevelAbilities != null) {
            for (n3 = 0; n3 < n; ++n3) {
                String string = this.theLevelAbilities.get(n3, "CR");
                if (string == null) continue;
                n4 += Integer.parseInt(string);
            }
        }
        for (n3 = 0; n3 < PCTemplate.getListSize(this.hitDiceStrings); ++n3) {
            if (!PCTemplate.contains(this.hitDiceStrings.get(n3), "CR:") || !this.doesHitDiceQualify(n2, n3)) continue;
            n4 += Integer.parseInt(PCTemplate.getStringAfter("CR:", this.hitDiceStrings.get(n3)));
        }
        return n4;
    }

    public HashMap<String, String> getChosenFeatStrings() {
        return this.chosenFeatStrings;
    }

    public Map<String, String> getChosenAbilityKeys(AbilityCategory abilityCategory) {
        if (this.theChosenAbilityKeys != null) {
            return this.theChosenAbilityKeys.get(abilityCategory);
        }
        return null;
    }

    @Override
    public void setCost(String string) {
        this.cost = string;
    }

    @Override
    public double getCost() {
        return Double.parseDouble(this.cost);
    }

    public void setFavoredClass(String string) {
        this.favoredClass = string;
    }

    public String getFavoredClass() {
        return this.favoredClass;
    }

    public void setGenderLock(String string) {
        if ("Female".equalsIgnoreCase(string)) {
            this.gender = PropertyFactory.getString("in_genderFemale");
        } else if ("Male".equalsIgnoreCase(string)) {
            this.gender = PropertyFactory.getString("in_genderMale");
        } else if ("Neuter".equalsIgnoreCase(string)) {
            this.gender = PropertyFactory.getString("in_genderNeuter");
        }
    }

    public String getGenderLock() {
        return this.gender;
    }

    public void setHitDieLock(String string) {
        this.hitDieLock = string;
    }

    protected String getHitDieLock() {
        return this.hitDieLock;
    }

    public void setLevelAdjustment(String string) {
        this.levelAdjustment = string;
    }

    public int getLevelAdjustment(PlayerCharacter playerCharacter) {
        int n;
        if (playerCharacter != null) {
            return playerCharacter.getVariableValue(this.levelAdjustment, "").intValue();
        }
        try {
            n = Integer.parseInt(this.levelAdjustment);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    public String getLevelAdjustmentFormula() {
        return this.levelAdjustment;
    }

    public void setLevelsPerFeat(int n) {
        this.levelsPerFeat = n;
    }

    public boolean isNonAbility(int n) {
        List<PCStat> list = SettingsHandler.getGame().getUnmodifiableStatList();
        if (n < 0 || n >= list.size()) {
            return true;
        }
        String string = "|LOCK." + list.get(n).getAbb() + "|10";
        int n2 = this.getVariableCount();
        for (int i = 0; i < n2; ++i) {
            String string2 = this.getVariableDefinition(i);
            if (!string2.endsWith(string)) continue;
            return true;
        }
        return false;
    }

    public void setNonProficiencyPenalty(int n) {
        this.nonProficiencyPenalty = n;
    }

    public int getNonProficiencyPenalty() {
        return this.nonProficiencyPenalty;
    }

    @Override
    public String getPCCText() {
        Object object2;
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(this.getDisplayName());
        if (this.bonusInitialFeats != 0) {
            stringBuffer.append("\tBONUSFEATS:").append(this.bonusInitialFeats);
        }
        if (this.bonusSkillsPerLevel != 0) {
            stringBuffer.append("\tBONUSSKILLPOINTS:").append(this.bonusSkillsPerLevel);
        }
        if (this.getChooseLanguageAutos() != null && this.getChooseLanguageAutos().length() > 0) {
            stringBuffer.append("\tCHOOSE:LANGAUTO:").append(this.getChooseLanguageAutos());
        }
        if (!CoreUtility.doublesEqual(this.getCost(), 1.0)) {
            stringBuffer.append("\tCOST:").append(String.valueOf(this.getCost()));
        }
        if (this.ChallengeRating != 0) {
            stringBuffer.append("\tCR:").append(this.ChallengeRating);
        }
        if (this.favoredClass != null && this.favoredClass.length() > 0) {
            stringBuffer.append("\tFAVOREDCLASS:").append(this.favoredClass);
        }
        if (PCTemplate.getListSize(this.featStrings) > 0) {
            object2 = new StringBuffer();
            for (String string : this.featStrings) {
                if (((StringBuffer)object2).length() != 0) {
                    ((StringBuffer)object2).append('|');
                }
                ((StringBuffer)object2).append(string);
            }
            stringBuffer.append("\tFEAT:").append(((StringBuffer)object2).toString());
        }
        if (!"None".equals(this.gender)) {
            stringBuffer.append("\tGENDERLOCK:").append(this.gender);
        }
        if (!"None".equals(this.handed)) {
            stringBuffer.append("\tHANDEDLOCK:").append(this.handed);
        }
        if (PCTemplate.getListSize(this.hitDiceStrings) > 0) {
            for (String string : this.hitDiceStrings) {
                stringBuffer.append("\tHD:").append(string);
            }
        }
        if (!this.hitDieLock.equals("")) {
            stringBuffer.append("\tHITDIE:").append(this.hitDieLock);
        }
        if (this.getLanguageBonus() != null && !this.getLanguageBonus().isEmpty()) {
            object2 = new StringBuffer();
            for (Language language : this.getLanguageBonus()) {
                if (((StringBuffer)object2).length() != 0) {
                    ((StringBuffer)object2).append(',');
                }
                ((StringBuffer)object2).append(language);
            }
            stringBuffer.append("\tLANGBONUS:").append(((StringBuffer)object2).toString());
        }
        object2 = this.getLevelAbilities();
        Iterator<String> iterator = object2.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            stringBuffer.append("\t").append(string);
        }
        if (!"0".equals(this.levelAdjustment)) {
            stringBuffer.append("\tLEVELADJUSTMENT:").append(this.levelAdjustment);
        }
        if (this.levelsPerFeat != 3) {
            stringBuffer.append("\tLEVELSPERFEAT:").append(this.levelsPerFeat);
        }
        if (this.nonProficiencyPenalty <= 0) {
            stringBuffer.append("\tNONPP:").append(this.nonProficiencyPenalty);
        }
        if (this.templateSize != null && this.templateSize.length() > 0) {
            stringBuffer.append("\tSIZE:").append(this.templateSize);
        }
        if (!"None".equals(this.region)) {
            stringBuffer.append("\tREGION:");
            if (this.region.equals(this.getDisplayName())) {
                stringBuffer.append("Yes");
            } else {
                stringBuffer.append(this.region);
            }
        }
        if (!this.removable) {
            stringBuffer.append("\tREMOVABLE:No");
        }
        if (!"None".equals(this.subRace)) {
            stringBuffer.append("\tSUBRACE:");
            if (this.subRace.equals(this.getDisplayName())) {
                stringBuffer.append("Yes");
            } else {
                stringBuffer.append(this.subRace);
            }
        }
        if (!"None".equals(this.subregion)) {
            stringBuffer.append("\tSUBREGION:");
            if (this.subregion.equals(this.getDisplayName())) {
                stringBuffer.append("Yes");
            } else {
                stringBuffer.append(this.subregion);
            }
        }
        if (PCTemplate.getListSize(this.templates) > 0) {
            Iterator<String> iterator2 = this.templates.iterator();
            while (iterator2.hasNext()) {
                stringBuffer.append("\tTEMPLATE:").append(iterator2.next());
            }
        }
        switch (this.getVisibility()) {
            case DISPLAY_ONLY: {
                stringBuffer.append("\tVISIBLE:DISPLAY");
                break;
            }
            case OUTPUT_ONLY: {
                stringBuffer.append("\tVISIBLE:EXPORT");
                break;
            }
            case HIDDEN: {
                stringBuffer.append("\tVISIBLE:NO");
                break;
            }
            default: {
                stringBuffer.append("\tVISIBLE:YES");
            }
        }
        if (this.getWeaponProfBonus().size() > 0) {
            StringBuffer stringBuffer2 = new StringBuffer();
            for (String string : this.getWeaponProfBonus()) {
                if (stringBuffer2.length() != 0) {
                    stringBuffer2.append('|');
                }
                stringBuffer2.append(string);
            }
            stringBuffer.append("\tWEAPONBONUS:").append(stringBuffer2.toString());
        }
        if (this.face != null) {
            if (CoreUtility.doublesEqual(this.face.getY(), 0.0)) {
                stringBuffer.append("\tFACE:").append(this.face.getX());
            } else {
                stringBuffer.append("\tFACE:").append(this.face.getX() + "," + this.face.getY());
            }
        }
        if (this.hands != null) {
            stringBuffer.append("\tHANDS:").append(this.hands);
        }
        if (this.legs != null) {
            stringBuffer.append("\tLEGS:").append(this.legs);
        }
        if (this.reach != null) {
            stringBuffer.append("\tREACH:").append(this.reach);
        }
        stringBuffer.append(super.getPCCText(false));
        return stringBuffer.toString();
    }

    public boolean isQualified(PlayerCharacter playerCharacter) {
        if (playerCharacter == null) {
            return false;
        }
        return PrereqHandler.passesAll(this.getPreReqList(), playerCharacter, this);
    }

    public String getRaceType() {
        return this.raceType;
    }

    public void setRaceType(String string) {
        this.raceType = string;
    }

    public String getSubRace() {
        return this.subRace;
    }

    public void setSubRace(String string) {
        this.subRace = string;
    }

    public void setRegion(String string) {
        this.region = string;
    }

    public String getRegion() {
        return this.region;
    }

    public void setSubRegion(String string) {
        this.subregion = string;
    }

    public String getSubRegion() {
        return this.subregion;
    }

    public void setRemovable(boolean bl) {
        this.removable = bl;
    }

    public boolean isRemovable() {
        boolean bl = false;
        if (this.getVisibility() == Visibility.DEFAULT || this.getVisibility() == Visibility.DISPLAY_ONLY) {
            bl = this.removable;
        }
        return bl;
    }

    public int getSR(int n, int n2, PlayerCharacter playerCharacter) {
        int n3;
        int n4 = this.getSR(playerCharacter);
        if (this.theLevelAbilities != null) {
            for (n3 = 0; n3 < n; ++n3) {
                String string = this.theLevelAbilities.get(n3, "SR");
                if (string == null) continue;
                int n5 = Integer.parseInt(string);
                n4 = Math.max(n4, n5);
            }
        }
        for (n3 = 0; n3 < PCTemplate.getListSize(this.hitDiceStrings); ++n3) {
            if (!PCTemplate.contains(this.hitDiceStrings.get(n3), "SR:") || !this.doesHitDiceQualify(n2, n3)) continue;
            n4 = Math.max(Integer.parseInt(PCTemplate.getStringAfter("SR:", this.hitDiceStrings.get(n3))), n4);
        }
        return n4;
    }

    public List<SpecialAbility> getSpecialAbilityList(int n, int n2) {
        String string;
        int n3;
        List<SpecialAbility> list = this.getListFor(ListKey.SPECIAL_ABILITY);
        if (list == null) {
            return list;
        }
        if (this.theLevelAbilities != null) {
            for (n3 = 0; n3 < n; ++n3) {
                string = this.theLevelAbilities.get(n3, "SA");
                if (string == null) continue;
                list.add(new SpecialAbility(string));
            }
        }
        for (n3 = 0; n3 < PCTemplate.getListSize(this.hitDiceStrings); ++n3) {
            if (!PCTemplate.contains(this.hitDiceStrings.get(n3), "SA:") || !this.doesHitDiceQualify(n2, n3)) continue;
            string = PCTemplate.getStringAfter("SA:", this.hitDiceStrings.get(n3));
            SpecialAbility specialAbility = new SpecialAbility(string);
            list.add(specialAbility);
        }
        return list;
    }

    public void addSubTypeString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith(".REMOVE.")) {
                this.removedSubTypes.add(string2.substring(8));
                continue;
            }
            this.addedSubTypes.add(string2);
        }
    }

    public List<String> getAddedSubTypes() {
        return Collections.unmodifiableList(this.addedSubTypes);
    }

    public List<String> getRemovedSubTypes() {
        return Collections.unmodifiableList(this.removedSubTypes);
    }

    @Override
    public List<String> getTemplateList() {
        return this.templates;
    }

    public void setTemplateSize(String string) {
        this.templateSize = string;
    }

    public String getTemplateSize() {
        return this.templateSize;
    }

    public void addHitDiceString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        if ("DR".equals(string3)) {
            String string4 = stringTokenizer.nextToken();
            String[] stringArray = string4.split("/");
            if (stringArray.length == 2) {
                DamageReduction damageReduction = new DamageReduction(stringArray[0], stringArray[1]);
                Prerequisite prerequisite = null;
                try {
                    PreParserFactory preParserFactory = PreParserFactory.getInstance();
                    prerequisite = preParserFactory.parse("PREHD:" + string2);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    // empty catch block
                }
                if (prerequisite != null) {
                    damageReduction.addPreReq(prerequisite);
                }
                this.addDR(damageReduction);
            }
            return;
        }
        if (this.hitDiceStrings == null) {
            this.hitDiceStrings = new ArrayList<String>();
        }
        this.hitDiceStrings.add(string);
    }

    public void clearHitDiceStrings() {
        if (this.hitDiceStrings != null) {
            this.hitDiceStrings.clear();
        }
    }

    public List<String> getHitDiceStrings() {
        List<String> list = this.hitDiceStrings != null ? this.hitDiceStrings : Collections.emptyList();
        return list;
    }

    public void addLevelAbility(int n, String string, String string2) {
        if (this.theLevelAbilities == null) {
            this.theLevelAbilities = new DoubleKeyMap();
        }
        if ("DR".equals(string)) {
            String[] stringArray = string2.split("/");
            if (stringArray.length == 2) {
                DamageReduction damageReduction = new DamageReduction(stringArray[0], stringArray[1]);
                Prerequisite prerequisite = null;
                try {
                    PreParserFactory preParserFactory = PreParserFactory.getInstance();
                    prerequisite = preParserFactory.parse("PRELEVEL:" + n);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    // empty catch block
                }
                if (prerequisite != null) {
                    damageReduction.addPreReq(prerequisite);
                }
                this.addDR(damageReduction);
            }
            return;
        }
        this.theLevelAbilities.put(n, string, string2);
    }

    public void clearLevelAbilities() {
        this.theLevelAbilities = null;
    }

    public List<String> getLevelAbilities() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.theLevelAbilities != null) {
            for (int n : this.theLevelAbilities.getKeySet()) {
                for (String string : this.theLevelAbilities.getSecondaryKeySet(n)) {
                    String string2 = this.theLevelAbilities.get(n, string);
                    StringBuffer stringBuffer = new StringBuffer(200);
                    stringBuffer.append("LEVEL:").append(n).append(":").append(string).append(":").append(string2);
                    arrayList.add(stringBuffer.toString());
                }
            }
        }
        return arrayList;
    }

    @Override
    public void addTemplate(String string) {
        if (string.startsWith("CHOOSE:")) {
            this.templates.add(string);
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            block0: while (stringTokenizer.hasMoreTokens()) {
                int n;
                String string2 = stringTokenizer.nextToken();
                if (".CLEAR".equalsIgnoreCase(string2)) {
                    this.templates.clear();
                    continue;
                }
                if (string2.regionMatches(true, 0, ".CLEAR.", 0, 7)) {
                    string2 = string2.substring(7);
                    for (n = 0; n < this.templates.size(); ++n) {
                        if (!string2.equalsIgnoreCase(this.templates.get(n))) continue;
                        this.templates.remove(n);
                        continue block0;
                    }
                    continue;
                }
                if (string2.startsWith("ADDCHOICE:")) {
                    string2 = string2.substring(10);
                    for (n = 0; n < this.templates.size(); ++n) {
                        String string3 = this.templates.get(n);
                        if (!string3.startsWith("CHOOSE:")) continue;
                        string3 = string3 + "|" + string2;
                        this.templates.set(n, string3);
                        continue block0;
                    }
                    continue;
                }
                this.templates.add(string2);
            }
        }
    }

    @Override
    public PCTemplate clone() throws CloneNotSupportedException {
        PCTemplate pCTemplate = (PCTemplate)super.clone();
        pCTemplate.templates = new ArrayList<String>(this.templates);
        if (this.theLevelAbilities != null) {
            pCTemplate.theLevelAbilities = new DoubleKeyMap<Integer, String, String>(this.theLevelAbilities);
        }
        if (PCTemplate.getListSize(this.hitDiceStrings) != 0) {
            pCTemplate.hitDiceStrings = new ArrayList<String>(this.hitDiceStrings);
        }
        if (PCTemplate.getListSize(this.featStrings) != 0) {
            pCTemplate.featStrings = new ArrayList<String>(this.featStrings);
        }
        if (this.chosenFeatStrings != null) {
            pCTemplate.chosenFeatStrings = new HashMap<String, String>(this.chosenFeatStrings);
        }
        if (this.theChosenAbilityKeys != null) {
            pCTemplate.theChosenAbilityKeys = new HashMap<AbilityCategory, Map<String, String>>(this.theChosenAbilityKeys);
        }
        return pCTemplate;
    }

    public String modifierString(PlayerCharacter playerCharacter) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(50);
        for (n = 0; n < SettingsHandler.getGame().getUnmodifiableStatList().size(); ++n) {
            if (this.isNonAbility(n)) {
                stringBuffer.append(PCTemplate.statName(n)).append(":nonability ");
                continue;
            }
            int n2 = this.getStatMod(n, playerCharacter);
            if (n2 == 0) continue;
            stringBuffer.append(PCTemplate.statName(n)).append(':').append(n2).append(' ');
        }
        if (!this.hitDieLock.equals("")) {
            stringBuffer.append("HITDIE:" + this.hitDieLock);
        }
        if (this.getDRList().size() != 0) {
            stringBuffer.append("DR:").append(DamageReduction.getDRString(playerCharacter, this.getDRList()));
        }
        if (playerCharacter == null) {
            if (this.ChallengeRating != 0) {
                stringBuffer.append("CR:").append(this.ChallengeRating).append(' ');
            }
            if ((n = this.getSR(playerCharacter)) != 0) {
                stringBuffer.append("SR:").append(n).append(' ');
            }
            return stringBuffer.toString();
        }
        n = (int)this.bonusTo("COMBAT", "AC", playerCharacter, playerCharacter);
        if (n != 0) {
            stringBuffer.append("AC BONUS:").append(n);
        }
        if (this.getCR(playerCharacter.getTotalLevels(), playerCharacter.totalHitDice()) != 0) {
            stringBuffer.append("CR:").append(this.getCR(playerCharacter.getTotalLevels(), playerCharacter.totalHitDice())).append(' ');
        }
        if (this.getSR(playerCharacter.getTotalLevels(), playerCharacter.totalHitDice(), playerCharacter) != 0) {
            stringBuffer.append("SR:").append(this.getSR(playerCharacter.getTotalLevels(), playerCharacter.totalHitDice(), playerCharacter)).append(' ');
        }
        return stringBuffer.toString();
    }

    @Override
    List<String> getTemplates(boolean bl, PlayerCharacter playerCharacter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.templatesAdded = new ArrayList<String>();
        if (!bl) {
            for (String string : this.templates) {
                if (string.startsWith("CHOOSE:")) {
                    string = PCTemplate.chooseTemplate(this, string.substring(7), true, playerCharacter);
                }
                if (string.length() == 0) continue;
                arrayList.add(string);
                this.templatesAdded.add(string);
            }
        }
        return arrayList;
    }

    List<SpecialAbility> addSpecialAbilitiesToList(List<SpecialAbility> list, int n, int n2) {
        if (this.containsListFor((ListKey)ListKey.SPECIAL_ABILITY)) {
            list.addAll(this.getSpecialAbilityList(n, n2));
        }
        return list;
    }

    static String chooseTemplate(PObject pObject, String string, boolean bl, PlayerCharacter playerCharacter) {
        Cloneable cloneable;
        ArrayList<Cloneable> arrayList = new ArrayList<Cloneable>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            cloneable = Globals.getTemplateKeyed(stringTokenizer.nextToken());
            if (cloneable == null || !PrereqHandler.passesAll(((PrereqObject)cloneable).getPreReqList(), playerCharacter, (PObject)cloneable)) continue;
            arrayList.add(cloneable);
        }
        cloneable = new ArrayList(1);
        String string2 = "Template Choice";
        if (pObject != null) {
            string2 = string2 + " (" + pObject.getDisplayName() + ")";
        }
        if (arrayList.size() == 1) {
            return ((PCTemplate)arrayList.get(0)).getKeyName();
        }
        if (arrayList.size() < 1) {
            return "";
        }
        Globals.getChoiceFromList(string2, arrayList, cloneable, 1, bl);
        if (cloneable != null && cloneable.size() == 1) {
            return ((PCTemplate)cloneable.get(0)).getKeyName();
        }
        return "";
    }

    public void addTemplateName(String string) {
        if (this.templatesAdded == null) {
            this.templatesAdded = new ArrayList<String>();
        }
        this.templatesAdded.add(string);
    }

    @Override
    public List<String> templatesAdded() {
        List<String> list = this.templatesAdded != null ? this.templatesAdded : Collections.emptyList();
        return list;
    }

    private static int getListSize(List<?> list) {
        int n = 0;
        if (list != null) {
            n = list.size();
        }
        return n;
    }

    private static String getStringAfter(String string, String string2) {
        int n = string2.indexOf(string) + string.length();
        return string2.substring(n);
    }

    private static boolean contains(String string, String string2) {
        return string.indexOf(string2) > -1;
    }

    private static String statName(int n) {
        return SettingsHandler.getGame().s_ATTRIBSHORT[n];
    }

    private boolean doesHitDiceQualify(int n, int n2) {
        if (n2 >= PCTemplate.getListSize(this.hitDiceStrings)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.hitDiceStrings.get(n2), ":");
        String string = stringTokenizer.nextToken();
        if (string.endsWith("+")) {
            return Integer.parseInt(string.substring(0, string.length() - 1)) <= n;
        }
        stringTokenizer = new StringTokenizer(string, "-");
        return n >= Integer.parseInt(stringTokenizer.nextToken()) && n <= Integer.parseInt(stringTokenizer.nextToken());
    }

    private void getLevelFeat(String string, int n, String string2, PlayerCharacter playerCharacter) {
        String string3 = null;
        List<String> list = new ArrayList<String>();
        LevelAbility levelAbility = LevelAbility.createAbility(this, n, "FEAT(" + string + ")");
        levelAbility.process(list, playerCharacter, null);
        switch (list.size()) {
            case 1: {
                string3 = (String)list.get(0);
                break;
            }
            default: {
                if (playerCharacter != null && !playerCharacter.isImporting()) {
                    Collections.sort(list);
                    ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
                    chooserInterface.setPool(1);
                    chooserInterface.setTitle("Feat Choice");
                    chooserInterface.setAvailableList(list);
                    chooserInterface.setVisible(true);
                    list = chooserInterface.getSelectedList();
                    if (list != null && list.size() != 0) {
                        string3 = list.get(0);
                        break;
                    }
                }
            }
            case 0: {
                return;
            }
        }
        this.addChosenFeat(string2, string3);
    }

    public void addChosenFeat(String string, String string2) {
        if (this.chosenFeatStrings == null) {
            this.chosenFeatStrings = new HashMap();
        }
        this.chosenFeatStrings.put(string, string2);
    }

    public void addChosenAbility(AbilityCategory abilityCategory, String string, String string2) {
        Map<String, String> map;
        if (abilityCategory == AbilityCategory.FEAT) {
            this.addChosenFeat(string, string2);
            return;
        }
        if (this.theChosenAbilityKeys == null) {
            this.theChosenAbilityKeys = new HashMap<AbilityCategory, Map<String, String>>();
        }
        if ((map = this.theChosenAbilityKeys.get(abilityCategory)) == null) {
            map = new HashMap<String, String>();
            this.theChosenAbilityKeys.put(abilityCategory, map);
        }
        map.put(string, string2);
    }

    public void addFeatString(String string) {
        if (".CLEAR".equals(string)) {
            this.featStrings = null;
            return;
        }
        if (this.featStrings == null) {
            this.featStrings = new ArrayList<String>();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (this.featStrings == null) {
                this.featStrings = new ArrayList<String>();
            }
            this.featStrings.add(string2);
        }
    }

    public List<String> feats(int n, int n2, PlayerCharacter playerCharacter, boolean bl) {
        String string;
        String string2;
        int n3;
        ArrayList<Object> arrayList = PCTemplate.getListSize(this.featStrings) != 0 ? new ArrayList<String>(this.featStrings) : new ArrayList();
        if (this.chosenFeatStrings != null) {
            arrayList.addAll(this.chosenFeatStrings.values());
        }
        if (this.theLevelAbilities != null) {
            for (n3 = 0; n3 <= n; ++n3) {
                String string3;
                string2 = "L" + String.valueOf(n3);
                string = null;
                if (this.chosenFeatStrings != null) {
                    string = this.chosenFeatStrings.get(string2);
                }
                if (string != null || !bl || (string3 = this.theLevelAbilities.get(n3, "FEAT")) == null) continue;
                this.getLevelFeat(string3, n3, string2, playerCharacter);
            }
        }
        for (n3 = 0; n3 < PCTemplate.getListSize(this.hitDiceStrings); ++n3) {
            string2 = "H" + Integer.toString(n3);
            string = null;
            if (this.chosenFeatStrings != null) {
                string = this.chosenFeatStrings.get(string2);
            }
            if (string != null || !bl || !this.doesHitDiceQualify(n2, n3)) continue;
            this.getLevelFeat(this.hitDiceStrings.get(n3), -1, string2, playerCharacter);
        }
        return arrayList;
    }

    public void setFace(double d, double d2) {
        this.face = new Point2D.Double(d, d2);
    }

    public Point2D.Double getFace() {
        return this.face;
    }

    public void setHands(int n) {
        this.hands = n;
    }

    public Integer getHands() {
        return this.hands;
    }

    public void setLegs(int n) {
        this.legs = n;
    }

    public Integer getLegs() {
        return this.legs;
    }

    public void setReach(int n) {
        this.reach = n;
    }

    public Integer getReach() {
        return this.reach;
    }

    public void addLevelMod(String string) {
        this.levelMods.add(string);
    }

    public List<String> getLevelMods() {
        return Collections.unmodifiableList(this.levelMods);
    }
}

