/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.Serializable;
import java.io.StringWriter;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.AssociatedChoice;
import pcgen.core.Campaign;
import pcgen.core.DamageReduction;
import pcgen.core.Description;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.FeatMultipleChoice;
import pcgen.core.FollowerOption;
import pcgen.core.Globals;
import pcgen.core.KeyedObject;
import pcgen.core.KitUtilities;
import pcgen.core.Language;
import pcgen.core.Movement;
import pcgen.core.PCClass;
import pcgen.core.PCSpell;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.core.PrereqObject;
import pcgen.core.QualifiedObject;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SourceEntry;
import pcgen.core.SourcedObject;
import pcgen.core.SpecialAbility;
import pcgen.core.SpellSupport;
import pcgen.core.Variable;
import pcgen.core.VariableList;
import pcgen.core.Vision;
import pcgen.core.WeaponProf;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.bonus.BonusUtilities;
import pcgen.core.chooser.ChooserUtilities;
import pcgen.core.levelability.LevelAbility;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.EmptyIterator;
import pcgen.core.utils.IntegerKey;
import pcgen.core.utils.KeyedListContainer;
import pcgen.core.utils.ListKey;
import pcgen.core.utils.ListKeyMapToList;
import pcgen.core.utils.MapKey;
import pcgen.core.utils.MapKeyMapToObject;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.core.utils.StringKey;
import pcgen.io.EntityEncoder;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.util.DoubleKeyMap;
import pcgen.util.Logging;
import pcgen.util.StringPClassUtil;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;
import pcgen.util.enumeration.Load;
import pcgen.util.enumeration.Visibility;
import pcgen.util.enumeration.VisionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PObject
extends PrereqObject
implements Cloneable,
Serializable,
Comparable<Object>,
SourcedObject,
KeyedListContainer,
KeyedObject {
    private static final long serialVersionUID = 1L;
    private static boolean dontRecurse = false;
    protected Map<StringKey, String> stringChar = new HashMap<StringKey, String>();
    protected Map<IntegerKey, Integer> integerChar = new HashMap<IntegerKey, Integer>();
    protected ListKeyMapToList listChar = new ListKeyMapToList();
    private final MapKeyMapToObject mapChar = new MapKeyMapToObject();
    private ArrayList<AssociatedChoice<String>> associatedList = null;
    private List<LevelAbility> levelAbilityList = null;
    private SourceEntry theSource = new SourceEntry();
    protected List<Vision> vision = null;
    private HashMap<String, String> pluginDataMap = new HashMap();
    protected String keyName = "";
    protected String displayName = "";
    protected Visibility visibility = Visibility.DEFAULT;
    private HashMap<String, String> bonusMap = null;
    private List<BonusObj> bonusList = new ArrayList<BonusObj>();
    private HashMap<String, String> changeProfMap = new HashMap();
    private Movement movement;
    private SpellSupport spellSupport = new SpellSupport();
    private VariableList variableList = null;
    private boolean descIsPI = false;
    private boolean nameIsPI = false;
    private boolean isNewItem = true;
    private Load encumberedArmorMove = Load.LIGHT;
    private Load encumberedLoadMove = Load.LIGHT;
    private List<DamageReduction> drList = new ArrayList<DamageReduction>();
    private String chooseLanguageAutos = "";
    private TreeSet<Language> theBonusLangs = null;
    private Map<String, List<String>> followerNumbers = null;
    private Map<String, List<FollowerOption>> theAvailableFollowers = null;
    private List<String> weaponProfBonus = null;
    private List<Description> theDescriptions = null;
    private DoubleKeyMap<Class, String, List<String>> qualifyKeys = null;
    private URI sourceURI = null;
    private Set<String> types = new LinkedHashSet<String>();
    private DoubleKeyMap<AbilityCategory, Ability.Nature, List<QualifiedObject<String>>> theAbilities = new DoubleKeyMap();

    public final void setAssociated(int n, String string) {
        this.associatedList.set(n, new AssociatedChoice<String>(string));
    }

    public final String getAssociated(int n) {
        return this.getAssociated(n, false);
    }

    public final String getAssociated(int n, boolean bl) {
        if (this.associatedList == null) {
            return "";
        }
        if (bl) {
            int n2 = 0;
            for (AssociatedChoice<String> associatedChoice : this.associatedList) {
                int n3 = associatedChoice.size() - 1;
                if (n <= n2 + n3) {
                    if (n3 == 0) {
                        return associatedChoice.getDefaultChoice();
                    }
                    return associatedChoice.getChoice(String.valueOf(n - n2));
                }
                n2 += associatedChoice.size();
            }
        } else if (this.associatedList.get(n) instanceof FeatMultipleChoice) {
            return this.associatedList.get(n).toString();
        }
        return this.associatedList.get(n).getDefaultChoice();
    }

    public final int getAssociatedCount() {
        return this.getAssociatedCount(false);
    }

    public final int getAssociatedCount(boolean bl) {
        if (this.associatedList == null) {
            return 0;
        }
        if (bl) {
            int n = 0;
            for (AssociatedChoice<String> associatedChoice : this.associatedList) {
                n += associatedChoice.size();
            }
            return n;
        }
        return this.associatedList.size();
    }

    public final Object getAssociatedObject(int n) {
        if (this.associatedList == null) {
            return "";
        }
        return this.associatedList.get(n);
    }

    public final void addCcSkill(String string) {
        if (string.startsWith(".CLEAR")) {
            if (".CLEAR".equals(string)) {
                this.clearCcSkills();
            } else {
                if (string.startsWith(".CLEAR")) {
                    string = string.substring(7);
                }
                if (string.startsWith("TYPE.") || string.startsWith("TYPE=")) {
                    String string2 = string.substring(5);
                    for (Skill skill : Globals.getSkillList()) {
                        boolean bl = true;
                        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
                        while (stringTokenizer.hasMoreTokens() && bl) {
                            if (skill.isType(stringTokenizer.nextToken())) continue;
                            bl = false;
                        }
                        if (!bl) continue;
                        this.listChar.removeFromListFor(ListKey.CROSS_CLASS_SKILLS, skill.getKeyName());
                    }
                } else {
                    this.listChar.removeFromListFor(ListKey.CROSS_CLASS_SKILLS, string);
                }
            }
        } else if (string.startsWith("TYPE.") || string.startsWith("TYPE=")) {
            for (Skill skill : Globals.getSkillList()) {
                if (!skill.isType(string.substring(5))) continue;
                this.listChar.addToListFor(ListKey.CROSS_CLASS_SKILLS, skill.getKeyName());
            }
        } else if ("ALL".equals(string)) {
            for (Skill skill : Globals.getSkillList()) {
                this.listChar.addToListFor(ListKey.CROSS_CLASS_SKILLS, skill.getKeyName());
            }
        } else {
            this.listChar.addToListFor(ListKey.CROSS_CLASS_SKILLS, string);
        }
    }

    public final void addAllCcSkills(List<String> list) {
        this.listChar.addAllToListFor(ListKey.CROSS_CLASS_SKILLS, list);
    }

    public void clearCcSkills() {
        this.listChar.removeListFor(ListKey.CROSS_CLASS_SKILLS);
    }

    public final List<String> getCcSkillList() {
        return this.listChar.getListFor(ListKey.CROSS_CLASS_SKILLS);
    }

    public final void setDescIsPI(boolean bl) {
        this.descIsPI = bl;
    }

    public final boolean getDescIsPI() {
        return this.descIsPI;
    }

    public final void setDescription(String string) {
        this.stringChar.put(StringKey.DESCRIPTION, string);
    }

    public void addDescription(Description description) {
        if (this.theDescriptions == null) {
            this.theDescriptions = new ArrayList<Description>();
        }
        description.setOwner(this);
        this.theDescriptions.add(description);
    }

    public void removeAllDescriptions() {
        this.theDescriptions = null;
    }

    public void removeDescription(String string) {
        if (this.theDescriptions == null) {
            return;
        }
        Pattern pattern = Pattern.compile(string);
        Iterator<Description> iterator = this.theDescriptions.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().getPCCText();
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.find()) continue;
            iterator.remove();
        }
    }

    public final String getDescription() {
        String string = this.stringChar.get(StringKey.DESCRIPTION);
        return string == null ? "" : string;
    }

    public String getDescription(PlayerCharacter playerCharacter) {
        if (this.theDescriptions == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (Description description : this.theDescriptions) {
            String string;
            if (bl) {
                stringBuffer.append(",");
            }
            if ((string = description.getDescription(playerCharacter)).length() > 0) {
                stringBuffer.append(string);
                bl = true;
                continue;
            }
            bl = false;
        }
        return stringBuffer.toString();
    }

    public List<Description> getDescriptionList() {
        if (this.theDescriptions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.theDescriptions);
    }

    public final String getPluginData(String string) {
        return this.pluginDataMap.get(string);
    }

    public final void putPluginData(String string, String string2) {
        this.pluginDataMap.put(string, string2);
    }

    public final void setKitString(String string) {
        if (string.equals(".CLEAR")) {
            this.listChar.removeListFor(ListKey.KITS);
        } else if (!this.containsInList(ListKey.KITS, string)) {
            this.listChar.addToListFor(ListKey.KITS, string);
        }
    }

    public final List<LevelAbility> getLevelAbilityList() {
        return this.levelAbilityList;
    }

    public final void setNameIsPI(boolean bl) {
        this.nameIsPI = bl;
    }

    public final boolean getNameIsPI() {
        return this.nameIsPI;
    }

    public final void addCSkill(String string) {
        if (string.startsWith(".CLEAR")) {
            if (".CLEAR".equals(string)) {
                this.clearCSkills();
            } else {
                if (string.startsWith(".CLEAR")) {
                    string = string.substring(7);
                }
                if (string.startsWith("TYPE.") || string.startsWith("TYPE=")) {
                    String string2 = string.substring(5);
                    for (Skill skill : Globals.getSkillList()) {
                        boolean bl = true;
                        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
                        while (stringTokenizer.hasMoreTokens() && bl) {
                            if (skill.isType(stringTokenizer.nextToken())) continue;
                            bl = false;
                        }
                        if (!bl) continue;
                        this.listChar.removeFromListFor(ListKey.CLASS_SKILLS, skill.getKeyName());
                    }
                } else {
                    this.listChar.removeFromListFor(ListKey.CLASS_SKILLS, string);
                }
            }
        } else if (string.startsWith("TYPE.") || string.startsWith("TYPE=")) {
            for (Skill skill : Globals.getSkillList()) {
                if (!skill.isType(string.substring(5))) continue;
                this.listChar.addToListFor(ListKey.CLASS_SKILLS, skill.getKeyName());
            }
        } else if ("ALL".equals(string)) {
            for (Skill skill : Globals.getSkillList()) {
                this.listChar.addToListFor(ListKey.CLASS_SKILLS, skill.getKeyName());
            }
        } else {
            this.listChar.addToListFor(ListKey.CLASS_SKILLS, string);
        }
    }

    public final void addAllCSkills(List<String> list) {
        this.listChar.addAllToListFor(ListKey.CLASS_SKILLS, list);
    }

    public void clearCSkills() {
        this.listChar.removeListFor(ListKey.CLASS_SKILLS);
    }

    public final List<String> getCSkillList() {
        return this.listChar.getListFor(ListKey.CLASS_SKILLS);
    }

    public List<Movement> getMovements() {
        if (this.movement == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.movement);
    }

    public Load getEncumberedArmorMove() {
        return this.encumberedArmorMove;
    }

    public Load getEncumberedLoadMove() {
        return this.encumberedLoadMove;
    }

    public void setEncumberedArmorMove(Load load, int n) {
        this.encumberedArmorMove = load;
    }

    public void setEncumberedLoadMove(Load load, int n) {
        this.encumberedLoadMove = load;
    }

    public void setNaturalWeapons(List<Equipment> list) {
        this.listChar.removeListFor(ListKey.NATURAL_WEAPONS);
        this.listChar.addAllToListFor(ListKey.NATURAL_WEAPONS, list);
    }

    public List<Equipment> getNaturalWeapons() {
        return this.getSafeListFor(ListKey.NATURAL_WEAPONS);
    }

    public List<BonusObj> getTempBonusList() {
        return this.getSafeListFor(ListKey.TEMP_BONUS);
    }

    public final void setTempDescription(String string) {
        this.stringChar.put(StringKey.TEMP_DESCRIPTION, string);
    }

    public final String getTempDescription() {
        String string = this.stringChar.get(StringKey.TEMP_DESCRIPTION);
        return string == null ? "" : string;
    }

    public final int getVariableCount() {
        if (this.variableList == null) {
            return 0;
        }
        return this.variableList.size();
    }

    public final Set<String> getVariableNamesAsUnmodifiableSet() {
        if (this.variableList == null) {
            this.variableList = new VariableList();
        }
        return this.variableList.getVariableNamesAsUnmodifiableSet();
    }

    public List<Ability> getVirtualFeatList() {
        return this.getSafeListFor(ListKey.VIRTUAL_FEATS);
    }

    public final void addAllToAssociated(Collection<String> collection) {
        if (this.associatedList == null) {
            this.associatedList = new ArrayList();
        }
        for (String string : collection) {
            this.addAssociated(string);
        }
    }

    public final void addAssociated(String string) {
        if (this.associatedList == null) {
            this.associatedList = new ArrayList();
        }
        this.associatedList.add(new AssociatedChoice<String>(string));
    }

    public final void addAssociated(AssociatedChoice<String> associatedChoice) {
        if (this.associatedList == null) {
            this.associatedList = new ArrayList();
        }
        this.associatedList.add(associatedChoice);
    }

    public final void addAssociatedTo(List<String> list) {
        if (this.associatedList != null) {
            for (AssociatedChoice<String> associatedChoice : this.associatedList) {
                String string = associatedChoice.getDefaultChoice();
                if (string.equals("")) {
                    list.add(null);
                    continue;
                }
                list.add(associatedChoice.getDefaultChoice());
            }
        }
    }

    public final void addSave(String string) {
        this.listChar.addToListFor(ListKey.SAVE, string);
    }

    public final void addSelectedWeaponProfBonus(String string) {
        this.listChar.addToListFor(ListKey.SELECTED_WEAPON_PROF_BONUS, string);
    }

    public final void addSpecialAbilityToList(SpecialAbility specialAbility) {
        this.listChar.addToListFor(ListKey.SPECIAL_ABILITY, specialAbility);
    }

    public void addTempBonus(BonusObj bonusObj) {
        this.listChar.addToListFor(ListKey.TEMP_BONUS, bonusObj);
    }

    public void removeTempBonus(BonusObj bonusObj) {
        this.listChar.removeFromListFor(ListKey.TEMP_BONUS, bonusObj);
    }

    public final void addUdamList(String string) {
        if (".CLEAR".equals(string)) {
            this.listChar.removeListFor(ListKey.UDAM);
        } else {
            this.listChar.addToListFor(ListKey.UDAM, string);
        }
    }

    public final void addUmult(String string) {
        if (".CLEAR".equals(string)) {
            this.listChar.removeListFor(ListKey.UMULT);
        } else {
            this.listChar.addToListFor(ListKey.UMULT, string);
        }
    }

    public final void addVariable(int n, String string, String string2) {
        if (this.variableList == null) {
            this.variableList = new VariableList();
        }
        this.variableList.add(n, string, string2);
    }

    public final void addVirtualFeat(Ability ability) {
        this.listChar.addToListFor(ListKey.VIRTUAL_FEATS, ability);
    }

    public final void addVirtualFeats(List<Ability> list) {
        this.listChar.addAllToListFor(ListKey.VIRTUAL_FEATS, list);
    }

    public final void clearVariableList() {
        if (this.variableList != null) {
            this.variableList.clear();
        }
    }

    public List<String> getChangeProfList(PlayerCharacter playerCharacter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.changeProfMap.keySet()) {
            String string2;
            Object object;
            String string3 = this.changeProfMap.get(string);
            if (string.startsWith("TYPE.")) {
                object = EquipmentList.getEquipmentOfType(string.substring(5), "").iterator();
                while (object.hasNext()) {
                    string2 = ((Equipment)object.next()).profKey(playerCharacter);
                    arrayList.add(string2 + "|" + string3);
                }
                continue;
            }
            object = EquipmentList.getEquipmentNamed(string);
            if (object == null) continue;
            string2 = ((Equipment)object).profKey(playerCharacter);
            arrayList.add(string2 + "|" + string3);
        }
        return arrayList;
    }

    public void addVision(Vision vision) {
        if (this.vision == null) {
            this.vision = new ArrayList<Vision>();
        }
        this.vision.add(vision);
    }

    public void clearVisionList() {
        if (this.vision != null) {
            this.vision.clear();
        }
    }

    public boolean removeVisionType(VisionType visionType) {
        if (this.vision == null) {
            return false;
        }
        for (Vision vision : this.vision) {
            if (!vision.getType().equals(visionType)) continue;
            return this.vision.remove(vision);
        }
        return false;
    }

    public List<Vision> getVision() {
        return this.vision;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public void addChangeProf(String string, String string2) {
        this.changeProfMap.put(string, string2);
    }

    public final boolean containsAssociated(String string) {
        if (this.associatedList == null) {
            return false;
        }
        for (AssociatedChoice<String> associatedChoice : this.associatedList) {
            for (String string2 : associatedChoice.getChoices()) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    public void addNaturalWeapon(Equipment equipment, int n) {
        this.listChar.addToListFor(ListKey.NATURAL_WEAPONS, equipment);
    }

    public final boolean hasVariableNamed(String string) {
        if (this.variableList == null) {
            return false;
        }
        return this.variableList.hasVariableNamed(string);
    }

    public final void clearAssociated() {
        this.associatedList = null;
    }

    @Override
    public PObject clone() throws CloneNotSupportedException {
        PObject pObject = (PObject)super.clone();
        pObject.stringChar = new HashMap<StringKey, String>();
        pObject.stringChar.putAll(this.stringChar);
        pObject.integerChar = new HashMap<IntegerKey, Integer>();
        pObject.integerChar.putAll(this.integerChar);
        pObject.listChar = new ListKeyMapToList();
        pObject.listChar.addAllLists(this.listChar);
        pObject.listChar.removeListFor(ListKey.SAVE);
        pObject.types = new LinkedHashSet<String>();
        pObject.types.addAll(this.types);
        pObject.setName(this.displayName);
        pObject.visibility = this.visibility;
        pObject.setKeyName(this.keyName);
        pObject.spellSupport = this.spellSupport.clone();
        pObject.theSource = this.theSource;
        pObject.changeProfMap = new HashMap<String, String>(this.changeProfMap);
        if (this.associatedList != null) {
            pObject.associatedList = new ArrayList<AssociatedChoice<String>>(this.associatedList);
        }
        if (this.bonusList != null) {
            pObject.bonusList = new ArrayList<BonusObj>();
            for (BonusObj prereqObject : this.bonusList) {
                pObject.bonusList.add(prereqObject.clone());
            }
            pObject.ownBonuses();
        }
        if (this.drList != null) {
            pObject.drList = new ArrayList<DamageReduction>();
            for (DamageReduction damageReduction : this.drList) {
                pObject.drList.add(damageReduction.clone());
            }
        }
        if (this.variableList != null) {
            pObject.variableList = (VariableList)this.variableList.clone();
        }
        if (this.bonusMap != null) {
            pObject.bonusMap = new HashMap<String, String>(this.bonusMap);
        }
        pObject.vision = this.vision;
        if (this.levelAbilityList != null && !this.levelAbilityList.isEmpty()) {
            pObject.levelAbilityList = new ArrayList<LevelAbility>();
            for (LevelAbility levelAbility : this.levelAbilityList) {
                LevelAbility levelAbility2 = (LevelAbility)levelAbility.clone();
                levelAbility2.setOwner(pObject);
                pObject.levelAbilityList.add(levelAbility2);
            }
        }
        if (this.followerNumbers != null) {
            pObject.followerNumbers = new HashMap<String, List<String>>(this.followerNumbers);
        }
        if (this.theAvailableFollowers != null) {
            pObject.theAvailableFollowers = new HashMap<String, List<FollowerOption>>(this.theAvailableFollowers);
        }
        if (this.theBonusLangs != null) {
            pObject.theBonusLangs = new TreeSet<Language>((SortedSet<Language>)this.theBonusLangs);
        }
        if (this.weaponProfBonus != null) {
            pObject.weaponProfBonus = new ArrayList<String>(this.weaponProfBonus);
        }
        if (this.theDescriptions != null) {
            pObject.theDescriptions = new ArrayList<Description>();
            for (Description description : this.theDescriptions) {
                description.setOwner(pObject);
                pObject.theDescriptions.add(description);
            }
        }
        return pObject;
    }

    @Override
    public int compareTo(Object object) {
        if (object != null) {
            return this.getKeyName().compareToIgnoreCase(((PObject)object).getKeyName());
        }
        return 1;
    }

    public boolean equals(Object object) {
        String string;
        String string2;
        if (object == null) {
            return false;
        }
        if (object instanceof PObject) {
            string2 = this.getKeyName();
            string = ((PObject)object).getKeyName();
        } else {
            string2 = this.toString();
            string = object.toString();
        }
        return string2.equalsIgnoreCase(string);
    }

    public void setChoiceString(String string) {
        this.stringChar.put(StringKey.CHOICE_STRING, string);
    }

    public final String getChoiceString() {
        String string = this.stringChar.get(StringKey.CHOICE_STRING);
        return string == null ? "" : string;
    }

    public final void getChoices(String string, PlayerCharacter playerCharacter) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ChooserUtilities.getChoices(this, string, arrayList, arrayList2, playerCharacter);
    }

    public void addDR(DamageReduction damageReduction) {
        this.drList.add(damageReduction);
    }

    public void clearDR() {
        this.drList.clear();
    }

    public List<DamageReduction> getDRList() {
        return Collections.unmodifiableList(this.drList);
    }

    @Override
    public void setKeyName(String string) {
        this.keyName = string;
    }

    @Override
    public final String getKeyName() {
        return this.keyName;
    }

    public String getQualifiedKey() {
        return "";
    }

    @Override
    public void setName(String string) {
        if (!string.endsWith(".MOD")) {
            this.fireNameChanged(this.displayName, string);
            this.displayName = string;
            this.setKeyName(string);
        }
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public final void setNewItem(boolean bl) {
        this.isNewItem = bl;
    }

    public final boolean isNewItem() {
        return this.isNewItem;
    }

    public final void setOutputName(String string) {
        String string2 = string;
        int n = string2.indexOf("[NAME]");
        if (n >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string2.substring(0, n));
            stringBuffer.append(this.getPreFormatedOutputName());
            if (string2.length() > n + 6) {
                stringBuffer.append(string2.substring(n + 6));
            }
            string2 = stringBuffer.toString();
        }
        this.stringChar.put(StringKey.OUTPUT_NAME, string2);
    }

    public final String getOutputName() {
        String string = this.stringChar.get(StringKey.OUTPUT_NAME);
        if (string == null || string.length() == 0) {
            return this.displayName;
        }
        return string;
    }

    public void putQualifyString(Class clazz, String string, String string2) {
        List<String> list;
        if (this.qualifyKeys == null) {
            this.qualifyKeys = new DoubleKeyMap();
        }
        if ((list = this.qualifyKeys.get(clazz, string)) == null) {
            list = new ArrayList<String>();
            this.qualifyKeys.put(clazz, string, list);
        }
        list.add(string2);
    }

    public final boolean grantsQualify(PObject pObject) {
        if (this.qualifyKeys == null) {
            return false;
        }
        Class<?> clazz = pObject.getClass();
        String string = pObject.getKeyName();
        String string2 = Ability.class.equals(clazz) ? ((Ability)pObject).getCategory() : null;
        List<String> list = this.qualifyKeys.get(clazz, string2);
        List<String> list2 = this.qualifyKeys.get(Object.class, string2);
        return list != null && list.contains(string) || list2 != null && list2.contains(string);
    }

    public final DoubleKeyMap<Class, String, List<String>> getQualifyMap() {
        return this.qualifyKeys;
    }

    public void setSR(int n, String string) {
        this.stringChar.put(StringKey.SR_FORMULA, string);
    }

    public void clearSRList() {
        this.stringChar.remove(StringKey.SR_FORMULA);
    }

    public String getSRFormula() {
        return this.stringChar.get(StringKey.SR_FORMULA);
    }

    public final void setSourceURI(URI uRI) {
        this.sourceURI = uRI;
    }

    public final URI getSourceURI() {
        return this.sourceURI;
    }

    public final void setSourceMap(Map<String, String> map) throws ParseException {
        this.theSource.setFromMap(map);
    }

    @Override
    public SourceEntry getSourceEntry() {
        if (this.theSource == null) {
            return new SourceEntry();
        }
        return this.theSource;
    }

    public void setSource(SourceEntry sourceEntry) {
        this.theSource = sourceEntry;
    }

    public String getDefaultSourceString() {
        return this.theSource.toString();
    }

    public final SpecialAbility getSpecialAbilityKeyed(String string) {
        for (SpecialAbility specialAbility : this.getListFor(ListKey.SPECIAL_ABILITY)) {
            if (!specialAbility.getKeyName().equalsIgnoreCase(string)) continue;
            return specialAbility;
        }
        return null;
    }

    public String getSpellKey() {
        return "POBJECT|" + this.getKeyName();
    }

    public final void addLanguageAuto(String string) {
        ListKey<Language> listKey = ListKey.AUTO_LANGUAGES;
        if (".CLEAR".equals(string)) {
            this.listChar.removeListFor(listKey);
        } else if ("ALL".equals(string)) {
            this.listChar.addAllToListFor(listKey, Globals.getLanguageList());
        } else if (string.startsWith("TYPE=") || string.startsWith("TYPE.")) {
            String string2 = string.substring(5);
            List<Language> list = Globals.getLanguageList();
            list = Globals.getLanguagesFromListOfType(list, string2);
            this.listChar.addAllToListFor(listKey, list);
        } else {
            Language language = Globals.getLanguageKeyed(string);
            if (language != null) {
                this.listChar.addToListFor(listKey, language);
            }
        }
    }

    public void clearLanguageAuto() {
        this.listChar.removeListFor(ListKey.AUTO_LANGUAGES);
    }

    public String getMyType(int n) {
        if (n < this.getMyTypeCount()) {
            return new ArrayList<String>(this.types).get(n);
        }
        return null;
    }

    public int getMyTypeCount() {
        return this.types.size();
    }

    public List<PCSpell> getSpellList() {
        return this.spellSupport.getSpellList(-1);
    }

    public final void clearSpecialAbilityList() {
        this.listChar.removeListFor(ListKey.SPECIAL_ABILITY);
    }

    public String getType() {
        return CoreUtility.join(this.getTypeList(false), ".");
    }

    boolean isTypeHidden(String string) {
        return false;
    }

    public List<String> getTypeList(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(this.types);
        if (bl) {
            for (String string : this.types) {
                if (!this.isTypeHidden(string)) continue;
                arrayList.remove(string);
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public boolean isType(String string) {
        String string2 = string.length() > 0 && string.charAt(0) == '!' ? string.substring(1).toUpperCase() : string.toUpperCase();
        return this.types.contains(string2);
    }

    public void setTypeInfo(String string) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string.toUpperCase().trim(), ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (bl) {
                this.removeMyType(string2);
                bl = false;
                continue;
            }
            if ("ADD".equals(string2)) {
                bl = false;
                continue;
            }
            if ("REMOVE".equals(string2)) {
                bl = true;
                continue;
            }
            if ("CLEAR".equals(string2)) {
                this.clearMyType();
                continue;
            }
            if (this.types.contains(string2)) continue;
            this.doGlobalTypeUpdate(string2);
            this.addMyType(string2);
        }
    }

    public final Variable getVariable(int n) {
        if (this.variableList != null) {
            return this.variableList.getVariable(n);
        }
        return null;
    }

    public final String getVariableDefinition(int n) {
        if (this.variableList != null) {
            return this.variableList.getDefinition(n);
        }
        return null;
    }

    public final Iterator<Variable> getVariableIterator() {
        if (this.variableList == null) {
            return EmptyIterator.emptyIterator();
        }
        return this.variableList.iterator();
    }

    public String parseOutputName(String string, PlayerCharacter playerCharacter) {
        CharSequence charSequence;
        int n = string.indexOf(124);
        if (n <= 0) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = stringTokenizer.nextToken();
        ArrayList<Float> arrayList = new ArrayList<Float>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        while (stringTokenizer.hasMoreElements()) {
            charSequence = stringTokenizer.nextToken();
            arrayList2.add(((String)charSequence).toUpperCase());
            arrayList.add(playerCharacter.getVariableValue((String)charSequence, ""));
        }
        charSequence = new StringBuffer();
        int n2 = 0;
        int n3 = string2.indexOf(37);
        int n4 = 0;
        while (n3 >= 0) {
            if (n3 > 0) {
                ((StringBuffer)charSequence).append(string2.substring(n4, n3));
            }
            String string3 = (String)arrayList2.get(n2);
            Float f = (Float)arrayList.get(n2);
            if (string3.endsWith(".INTVAL")) {
                ((StringBuffer)charSequence).append(String.valueOf(f.intValue()));
            } else {
                ((StringBuffer)charSequence).append(f.toString());
            }
            n4 = n3 + 1;
            ++n2;
            n3 = string2.indexOf(37, n4);
        }
        if (string2.length() > n4) {
            ((StringBuffer)charSequence).append(string2.substring(n4));
        }
        return ((StringBuffer)charSequence).toString();
    }

    public final boolean removeAssociated(String string) {
        boolean bl = false;
        if (this.associatedList == null) {
            return bl;
        }
        Iterator<AssociatedChoice<String>> iterator = this.associatedList.iterator();
        while (iterator.hasNext()) {
            AssociatedChoice<String> associatedChoice = iterator.next();
            bl = associatedChoice.removeDefaultChoice(string);
            if (!bl || associatedChoice.size() != 0) continue;
            iterator.remove();
        }
        if (this.associatedList.size() == 0) {
            this.associatedList = null;
        }
        return bl;
    }

    public final void removeSave(String string) {
        boolean bl = this.listChar.removeFromListFor(ListKey.SAVE, string);
        if (!bl) {
            Logging.errorPrint("removeSave: Could not find bonus: " + string + " in saveList.");
        }
    }

    public final void removeType(String string) {
        String string2 = string.toUpperCase().trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            this.removeMyType(string3);
        }
    }

    public void resetTempBonusList() {
        this.listChar.removeListFor(ListKey.TEMP_BONUS);
    }

    public final void setRegionString(String string) {
        this.stringChar.put(StringKey.REGION, string);
    }

    public final String getRegionString() {
        return this.stringChar.get(StringKey.REGION);
    }

    public final void setRemoveString(String string) {
        if (string.equals(".CLEAR")) {
            this.listChar.removeListFor(ListKey.REMOVE_STRING_LIST);
        } else {
            this.listChar.addToListFor(ListKey.REMOVE_STRING_LIST, string);
        }
    }

    public void checkRemovals(PlayerCharacter playerCharacter) {
        if (!this.containsListFor((ListKey)ListKey.REMOVE_STRING_LIST)) {
            return;
        }
        Iterator<String> iterator = this.getListFor(ListKey.REMOVE_STRING_LIST).iterator();
        while (iterator.hasNext()) {
            this.checkRemoval(playerCharacter, iterator.next());
        }
    }

    private void checkRemoval(PlayerCharacter playerCharacter, String string) {
        block17: {
            int n;
            Object object;
            ArrayList<Object> arrayList;
            block16: {
                int n2;
                Object object2;
                int n3;
                int n4;
                String string2 = string.substring(string.indexOf("|") + 1);
                if (this instanceof PCClass) {
                    n4 = Integer.parseInt(string.substring(0, string.indexOf("|")));
                    PCClass pCClass = (PCClass)this;
                    if (pCClass.getLevel() != n4) {
                        return;
                    }
                }
                if (!string2.startsWith("FEAT(")) {
                    return;
                }
                n4 = string2.indexOf("(");
                StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(n4 + 1, n3 = string2.lastIndexOf(")")), "(),", false);
                if (stringTokenizer.countTokens() == 0) {
                    return;
                }
                arrayList = new ArrayList<Object>();
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (string3.startsWith("TYPE.")) {
                        object2 = string3.substring(5);
                        for (Ability ability : playerCharacter.getRealAbilitiesList(AbilityCategory.FEAT)) {
                            if (!ability.isType((String)object2) || arrayList.contains(ability)) continue;
                            arrayList.add(ability);
                        }
                        continue;
                    }
                    if (string3.startsWith("CLASS.")) {
                        object2 = playerCharacter.getClassKeyed(string3.substring(6));
                        if (object2 == null) continue;
                        for (PCLevelInfo pCLevelInfo : playerCharacter.getLevelInfo()) {
                            if (!pCLevelInfo.getClassKeyName().equalsIgnoreCase(((PObject)object2).getKeyName())) continue;
                            for (Ability ability : pCLevelInfo.getObjects()) {
                                if (arrayList.contains(ability)) continue;
                                arrayList.add(ability);
                            }
                        }
                        continue;
                    }
                    if (string3.equals("CHOICE")) {
                        object2 = playerCharacter.getRealAbilitiesList(AbilityCategory.FEAT).iterator();
                        while (object2.hasNext()) {
                            object = object2.next();
                            arrayList.add(object);
                        }
                        continue;
                    }
                    object2 = playerCharacter.getFeatNamed(string3);
                    if (object2 == null || arrayList.contains(object2)) continue;
                    arrayList.add(object2);
                }
                n = arrayList.size();
                if (string2.length() > n3 + 1 && !((String)(object2 = string2.substring(n3 + 1))).equalsIgnoreCase("ALL")) {
                    n = Integer.parseInt(object2);
                }
                if (n == arrayList.size() || arrayList.size() <= 0) break block16;
                object2 = ChooserFactory.getChooserInstance();
                object2.setPoolFlag(true);
                object2.setAllowsDups(false);
                object2.setVisible(false);
                object2.setPool(n);
                object = "Select for removal";
                object2.setTitle((String)object);
                ArrayList arrayList2 = new ArrayList();
                Globals.sortChooserLists(arrayList, arrayList2);
                while (true) {
                    object2.setAvailableList(arrayList);
                    object2.setSelectedList(arrayList2);
                    object2.setVisible(true);
                    n2 = object2.getSelectedList().size();
                    if (n <= 0 || n2 == n) break;
                    ShowMessageDelegate.showMessageDialog("You must make " + (n - n2) + " more selection(s).", "PCGen", MessageType.INFORMATION);
                }
                for (n2 = 0; n2 < object2.getSelectedList().size(); ++n2) {
                    String string3 = (String)object2.getSelectedList().get(n2);
                    AbilityUtilities.modFeat(playerCharacter, null, string3, false, false);
                }
                break block17;
            }
            if (n != arrayList.size()) break block17;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                object = (Ability)arrayList.get(i);
                AbilityUtilities.modFeat(playerCharacter, null, ((PObject)object).getKeyName(), false, false);
                if (i <= arrayList.size()) continue;
                i = arrayList.size();
            }
        }
    }

    public final void addAutoArray(String string, String string2) {
        this.mapChar.put(MapKey.AUTO_ARRAY, string, string2);
    }

    public final void addSelectedArmorProfs(List<String> list) {
        for (String string : list) {
            if (this.containsInList(ListKey.SELECTED_ARMOR_PROF, string)) continue;
            this.listChar.addToListFor(ListKey.SELECTED_ARMOR_PROF, string);
        }
    }

    public final void addSelectedShieldProfs(List<String> list) {
        for (String string : list) {
            if (this.containsInList(ListKey.SELECTED_SHIELD_PROFS, string)) continue;
            this.listChar.addToListFor(ListKey.SELECTED_SHIELD_PROFS, string);
        }
    }

    public final void clearAutoMap() {
        this.mapChar.removeAll(MapKey.AUTO_ARRAY);
    }

    public final void clearAutoTag(String string) {
        this.mapChar.remove(MapKey.AUTO_ARRAY, string);
    }

    public final Set<String> getAutoMapKeys() {
        return this.mapChar.getKeySet(MapKey.AUTO_ARRAY);
    }

    public final String getAuto(String string) {
        return this.mapChar.get(MapKey.AUTO_ARRAY, string);
    }

    public void setSourceCampaign(Campaign campaign) {
        this.theSource.getSourceBook().setCampaign(campaign);
    }

    public Campaign getSourceCampaign() {
        return this.theSource.getSourceBook().getCampaign();
    }

    public int getStatMod(int n, PlayerCharacter playerCharacter) {
        List<PCStat> list = SettingsHandler.getGame().getUnmodifiableStatList();
        if (n < 0 || n >= list.size()) {
            return 0;
        }
        String string = list.get(n).getAbb();
        return (int)this.bonusTo("STAT", string, playerCharacter, playerCharacter);
    }

    public LevelAbility addAddList(int n, String string) {
        if (this.levelAbilityList == null) {
            this.levelAbilityList = new ArrayList<LevelAbility>();
        }
        if (string.startsWith(".CLEAR")) {
            if (".CLEAR".equals(string)) {
                if (n > 0) {
                    Logging.errorPrint("Warning: You performed a Dangerous .CLEAR in a ADD: Token");
                    Logging.errorPrint("  A non-level limited .CLEAR was used in a Class Level line");
                    Logging.errorPrint("  Today, this performs a .CLEAR on the entire PCClass");
                    Logging.errorPrint("  However, you are using undocumented behavior that is subject to change");
                    Logging.errorPrint("  Hint: It will change after PCGen 5.12");
                    Logging.errorPrint("  Please level limit the .CLEAR (e.g. .CLEAR.LEVEL2)");
                    Logging.errorPrint("  ... or put the ADD:.CLEAR on a non-level Class line");
                }
                this.levelAbilityList.clear();
            } else if (string.indexOf(".LEVEL") >= 0) {
                int n2;
                try {
                    n2 = Integer.parseInt(string.substring(12));
                }
                catch (NumberFormatException numberFormatException) {
                    Logging.errorPrint("Badly formed addAddList attribute: " + string.substring(12));
                    n2 = -1;
                }
                if (n > 0 && n != n2) {
                    Logging.errorPrint("Warning: You performed a Dangerous .CLEAR in a ADD: Token");
                    Logging.errorPrint("  A level limited .CLEAR was used in a Class Level line");
                    Logging.errorPrint("  But was asked to clear a different Class Level than the Class Level Line it appeared on");
                    Logging.errorPrint("  However, you are using undocumented behavior");
                    Logging.errorPrint("  Please match the level to the limit on the .CLEAR (e.g. 2<tab>ADD:.CLEAR.LEVEL2)");
                    Logging.errorPrint("  ... or put the ADD:.CLEAR on a non-level Class line");
                }
                if (n2 >= 0) {
                    for (int i = this.levelAbilityList.size() - 1; i >= 0; --i) {
                        LevelAbility levelAbility = this.levelAbilityList.get(i);
                        if (levelAbility.level() != n2) continue;
                        this.levelAbilityList.remove(i);
                    }
                }
            }
        } else {
            LevelAbility levelAbility = LevelAbility.createAbility(this, n, string);
            this.levelAbilityList.add(levelAbility);
            return levelAbility;
        }
        return null;
    }

    public void makeChoices(PlayerCharacter playerCharacter) {
        this.getChoices(this.getChoiceString(), playerCharacter);
    }

    public boolean passesPreApplied(PlayerCharacter playerCharacter, PObject pObject) {
        if (!playerCharacter.getUseTempMods()) {
            return false;
        }
        if (pObject == null) {
            for (BonusObj bonusObj : this.getTempBonusList()) {
                Object object = bonusObj.getTargetObject();
                if (!(object instanceof PlayerCharacter)) continue;
                PlayerCharacter playerCharacter2 = (PlayerCharacter)object;
                if (!bonusObj.isApplied() || playerCharacter2 != playerCharacter) continue;
                return true;
            }
            return false;
        }
        for (BonusObj bonusObj : pObject.getTempBonusList()) {
            Object object = bonusObj.getTargetObject();
            if (!(object instanceof Equipment)) continue;
            Equipment equipment = (Equipment)object;
            if (!bonusObj.isApplied() || !equipment.equals(pObject)) continue;
            return true;
        }
        return false;
    }

    public String piDescString(PlayerCharacter playerCharacter) {
        return this.piDescString(playerCharacter, true);
    }

    public String piDescSubString(PlayerCharacter playerCharacter) {
        return this.piDescString(playerCharacter, false);
    }

    public String piString() {
        return this.piString(true);
    }

    public String piSubString() {
        return this.piString(false);
    }

    public void removeAllLevelAbilities(int n) {
        if (this.levelAbilityList != null) {
            for (int i = this.levelAbilityList.size() - 1; i >= 0; --i) {
                if (this.levelAbilityList.get(i).level() != n) continue;
                this.levelAbilityList.remove(i);
            }
        }
    }

    public boolean removeLevelAbility(int n, String string) {
        for (int i = this.levelAbilityList.size() - 1; i >= 0; --i) {
            LevelAbility levelAbility = this.levelAbilityList.get(i);
            if (levelAbility.level() != n || !levelAbility.getTagData().equals(string)) continue;
            this.levelAbilityList.remove(i);
            return true;
        }
        return false;
    }

    public String toString() {
        return this.displayName;
    }

    protected int getSR(PlayerCharacter playerCharacter) {
        String string = this.getSRFormula();
        if (string != null && playerCharacter != null) {
            return playerCharacter.getVariableValue(string, this.getQualifiedKey()).intValue();
        }
        return 0;
    }

    protected final void setVariable(int n, int n2, String string, String string2) {
        if (this.variableList == null) {
            this.variableList = new VariableList();
        }
        this.variableList.set(n, n2, string, string2);
    }

    protected final void addAllVariablesFrom(PObject pObject) {
        if (pObject.getVariableCount() > 0) {
            if (this.variableList == null) {
                this.variableList = new VariableList();
            }
            this.variableList.addAll(pObject.variableList);
        }
    }

    @Override
    public String getPCCText() {
        return this.getPCCText(true);
    }

    protected String getPCCText(boolean bl) {
        String string;
        DoubleKeyMap<Class, String, List<String>> doubleKeyMap;
        String string2;
        List<String> list;
        Object object2;
        String string22;
        StringBuffer stringBuffer = new StringBuffer(200);
        if (bl) {
            stringBuffer.append(this.getDisplayName());
        }
        if (this.getNameIsPI()) {
            stringBuffer.append("\tNAMEISPI:Y");
        }
        if ((string22 = this.stringChar.get(StringKey.OUTPUT_NAME)) != null && string22.length() > 0 && !string22.equals(this.getDisplayName())) {
            stringBuffer.append("\tOUTPUTNAME:").append(string22);
        }
        for (Description object42 : this.getDescriptionList()) {
            stringBuffer.append("\tDESC:").append(EntityEncoder.encode(object42.getPCCText()));
            if (!this.getDescIsPI()) continue;
            stringBuffer.append("\tDESCISPI:Yes");
        }
        stringBuffer.append("\tKEY:").append(this.getKeyName());
        Set<String> set = this.mapChar.getKeySet(MapKey.AUTO_ARRAY);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                stringBuffer.append("\tAUTO:").append((String)object2).append("|").append(this.mapChar.get(MapKey.AUTO_ARRAY, object2));
            }
        }
        if (!(this instanceof PCClass) && this.getBonusList().size() != 0) {
            for (Object object2 : this.getBonusList()) {
                stringBuffer.append("\tBONUS:").append(((BonusObj)object2).getPCCText());
            }
        }
        if ((list = this.getCcSkillList()) != null && list.size() != 0) {
            stringBuffer.append("\tCCSKILL:").append(CoreUtility.join(list, "|"));
        }
        if ((object2 = this.getCSkillList()) != null && object2.size() != 0) {
            stringBuffer.append("\tCSKILL:").append(CoreUtility.join(object2, "|"));
        }
        if ((string2 = this.getChoiceString()) != null && string2.length() != 0) {
            stringBuffer.append("\tCHOOSE:").append(string2);
        }
        int n = this.getVariableCount();
        if (!(this instanceof PCClass) && n != 0) {
            for (int i = 0; i < n; ++i) {
                string2 = this.getVariableDefinition(i);
                if (string2.startsWith("-9|")) {
                    string2 = string2.substring(3);
                }
                stringBuffer.append("\tDEFINE:").append(string2);
            }
        }
        for (DamageReduction damageReduction : this.getDRList()) {
            boolean bl2 = false;
            if (this instanceof PCClass) {
                bl2 = damageReduction.isForClassLevel(this.getKeyName());
            }
            if (bl2) continue;
            stringBuffer.append("\t").append(damageReduction.getPCCText(true));
        }
        List<String> list2 = CoreUtility.toStringRepresentation(this.getSafeListFor(ListKey.AUTO_LANGUAGES));
        if (list2.size() != 0) {
            stringBuffer.append("\tLANGAUTO:").append(CoreUtility.join(list2, ","));
        }
        if (this.movement != null && this.movement.getNumberOfMovements() > 0) {
            stringBuffer.append(this.movement.toLSTString());
        }
        if (this.hasPreReqs()) {
            StringWriter stringWriter = new StringWriter();
            for (Prerequisite prerequisite : this.getPreReqList()) {
                PrerequisiteWriter prerequisiteWriter = new PrerequisiteWriter();
                try {
                    stringWriter.write("\t");
                    prerequisiteWriter.write(stringWriter, prerequisite);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    persistenceLayerException.printStackTrace();
                }
            }
            stringBuffer.append(stringWriter);
        }
        List<SpecialAbility> list3 = this.getListFor(ListKey.SPECIAL_ABILITY);
        if (!(this instanceof PCClass) && list3 != null && list3.size() != 0) {
            for (SpecialAbility specialAbility : list3) {
                stringBuffer.append("\tSA:").append(specialAbility.toString());
            }
        }
        if ((doubleKeyMap = this.getQualifyMap()) != null) {
            for (Class clazz : doubleKeyMap.getKeySet()) {
                Iterator<String> iterator = StringPClassUtil.getStringFor(clazz);
                for (String string3 : doubleKeyMap.getSecondaryKeySet(clazz)) {
                    List<String> list4 = doubleKeyMap.get(clazz, string3);
                    if (list4 == null) continue;
                    boolean bl3 = false;
                    for (String string4 : list4) {
                        if ("alwaysValid".equals(string4)) continue;
                        if (bl3) {
                            stringBuffer.append("|");
                        } else {
                            stringBuffer.append("\tQUALIFY:");
                            if (iterator != null && ((String)((Object)iterator)).length() > 0) {
                                stringBuffer.append((String)((Object)iterator));
                            }
                            if (string3 != null) {
                                stringBuffer.append('=').append(string3);
                            }
                            stringBuffer.append("|");
                            bl3 = true;
                        }
                        stringBuffer.append(string4);
                    }
                }
            }
        }
        if (!(this instanceof PCClass)) {
            for (PCSpell pCSpell : this.getSpellList()) {
                stringBuffer.append("\tSPELLS:").append(pCSpell.getPCCText());
            }
        }
        String string5 = this.stringChar.get(StringKey.SR_FORMULA);
        if (!(this instanceof PCClass) && string5 != null && string5.length() != 0) {
            stringBuffer.append("\tSR:").append(string5);
        }
        if (this.vision != null && this.vision.size() != 0) {
            StringBuffer stringBuffer2 = new StringBuffer();
            for (Vision vision : this.vision) {
                if ("0".equals(vision.getDistance())) continue;
                if (stringBuffer2.length() > 0) {
                    stringBuffer2.append('|');
                }
                stringBuffer2.append(vision);
            }
            if (stringBuffer2.length() > 0) {
                stringBuffer.append("\tVISION:").append(stringBuffer2.toString());
            }
        }
        if (this.getMyTypeCount() != 0) {
            stringBuffer.append('\t').append("TYPE:").append(this.getType());
        }
        if ((string2 = this.theSource.getPageNumber()) != null && string2.length() != 0) {
            stringBuffer.append("\tSOURCEPAGE:").append(string2);
        }
        if ((string = this.stringChar.get(StringKey.REGION)) != null && string.startsWith("0|")) {
            stringBuffer.append("\tREGION:").append(string.substring(2));
        }
        for (String string6 : this.getSafeListFor(ListKey.KITS)) {
            if (!string6.startsWith("0|")) continue;
            stringBuffer.append("\tKIT:").append(string6.substring(2));
        }
        stringBuffer.append('\t').append(this.getSpellSupport().getPCCText());
        return stringBuffer.toString();
    }

    protected void addAddsForLevel(int n, PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo) {
        if (playerCharacter == null || playerCharacter.isImporting() || this.levelAbilityList == null || this.levelAbilityList.isEmpty() || !playerCharacter.doLevelAbilities()) {
            return;
        }
        for (LevelAbility levelAbility : this.levelAbilityList) {
            levelAbility.setOwner(this);
            if (this instanceof PCClass && (levelAbility.level() != n || !levelAbility.canProcess())) continue;
            boolean bl = true;
            if (levelAbility.isFeat() && !SettingsHandler.getShowFeatDialogAtLevelUp()) {
                Logging.errorPrint("PObject addAddsForLevel");
                bl = false;
                ArrayList<String> arrayList = new ArrayList<String>();
                levelAbility.process(arrayList, playerCharacter, pCLevelInfo);
                block4: for (String string : arrayList) {
                    Ability ability = Globals.getAbilityKeyed("FEAT", string);
                    if (ability == null) continue;
                    switch (ability.getVisibility()) {
                        case HIDDEN: 
                        case OUTPUT_ONLY: {
                            bl = true;
                            break block4;
                        }
                    }
                }
            }
            if (bl) {
                levelAbility.process(playerCharacter, pCLevelInfo);
                continue;
            }
            playerCharacter.adjustFeats(1.0);
        }
    }

    protected List<SpecialAbility> addSpecialAbilitiesToList(List<SpecialAbility> list, PlayerCharacter playerCharacter) {
        list.addAll(this.getSafeListFor(ListKey.SPECIAL_ABILITY));
        return list;
    }

    protected void doGlobalTypeUpdate(String string) {
    }

    protected void globalChecks(PlayerCharacter playerCharacter) {
        this.globalChecks(false, playerCharacter);
    }

    protected void globalChecks(boolean bl, PlayerCharacter playerCharacter) {
        playerCharacter.setArmorProfListStable(false);
        List<String> list = this.getSafeListFor(ListKey.KITS);
        for (int i = 0; i > list.size(); ++i) {
            KitUtilities.makeKitSelections(0, list.get(i), i, playerCharacter);
        }
        this.makeRegionSelection(playerCharacter);
        if (bl) {
            this.makeChoices(playerCharacter);
        }
        if (this instanceof PCClass) {
            PCClass pCClass = (PCClass)this;
            PCLevelInfo pCLevelInfo = playerCharacter.getLevelInfoFor(this.getKeyName(), pCClass.level);
            this.addAddsForLevel(pCClass.level, playerCharacter, pCLevelInfo);
        } else {
            this.addAddsForLevel(0, playerCharacter, null);
        }
        this.activateBonuses(playerCharacter);
    }

    protected void subAddsForLevel(int n, PlayerCharacter playerCharacter) {
        if (playerCharacter == null || this.levelAbilityList == null || this.levelAbilityList.isEmpty()) {
            return;
        }
        for (LevelAbility levelAbility : this.levelAbilityList) {
            if (levelAbility.level() != n) continue;
            levelAbility.subForLevel(playerCharacter);
        }
    }

    public final ArrayList<AssociatedChoice<String>> getAssociatedList() {
        if (this.associatedList == null) {
            return new ArrayList<AssociatedChoice<String>>();
        }
        return this.associatedList;
    }

    final String getUdamFor(boolean bl, boolean bl2, PlayerCharacter playerCharacter) {
        String string;
        if (!this.containsListFor((ListKey)ListKey.UDAM)) {
            return playerCharacter.getRace().getUdam();
        }
        StringBuffer stringBuffer = new StringBuffer(this.getElementInList(ListKey.UDAM, 0));
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), ",", false);
        for (int i = Globals.sizeInt(playerCharacter.getSize()); i > -1 && stringTokenizer.hasMoreTokens(); --i) {
            stringBuffer.replace(0, stringBuffer.length(), stringTokenizer.nextToken());
            if (i == 0) break;
        }
        int n = (int)playerCharacter.getStatBonusTo("DAMAGE", "TYPE=MELEE");
        if (bl2 && n > 0) {
            stringBuffer.append('+');
        }
        if (bl2 && n != 0) {
            stringBuffer.append(String.valueOf(n));
        }
        List<String> list = this.getListFor(ListKey.UMULT);
        if (bl && list != null && !list.isEmpty() && !"0".equals(string = list.get(0))) {
            stringBuffer.append("(x").append(string).append(')');
        }
        return stringBuffer.toString();
    }

    public final void addAutoTagsToList(String string, Collection collection, PlayerCharacter playerCharacter, boolean bl) {
        Object object;
        Object object2;
        String string2 = this.mapChar.get(MapKey.AUTO_ARRAY, string);
        if (string2 == null) {
            return;
        }
        ArrayList<Prerequisite> arrayList = new ArrayList<Prerequisite>();
        int n = string2.lastIndexOf(91);
        int n2 = string2.lastIndexOf(93);
        if (n2 < n) {
            n2 = string.length();
        }
        if (n >= 0) {
            String string3 = string2.substring(n + 1, n2);
            object2 = null;
            try {
                object = PreParserFactory.getInstance();
                object2 = ((PreParserFactory)object).parse(string3);
            }
            catch (PersistenceLayerException persistenceLayerException) {
                Logging.errorPrint(persistenceLayerException.getMessage(), persistenceLayerException);
            }
            if (object2 != null) {
                arrayList.add((Prerequisite)object2);
            }
            if (!PrereqHandler.passesAll(arrayList, playerCharacter, null)) {
                return;
            }
            string2 = string2.substring(0, n);
        }
        object2 = new StringTokenizer(string2, "|");
        while (((StringTokenizer)object2).hasMoreTokens()) {
            Object object3;
            Object object4;
            object = ((StringTokenizer)object2).nextToken();
            if ((((String)object).startsWith("TYPE=") || ((String)object).startsWith("TYPE.")) && string.startsWith("WEAPON") && bl) {
                object4 = this.processWeaponAutoTags(playerCharacter, (String)object);
                collection.addAll(object4);
                continue;
            }
            if ((((String)object).startsWith("TYPE=") || ((String)object).startsWith("TYPE.")) && string.startsWith("ARMOR")) {
                collection.add(object);
                continue;
            }
            if (string.startsWith("EQUIP")) {
                object4 = EquipmentList.getEquipmentFromName((String)object, playerCharacter);
                if (object4 == null) continue;
                object3 = ((Equipment)object4).clone();
                ((Equipment)object3).setQty(1.0);
                ((Equipment)object3).setAutomatic(true);
                int n3 = playerCharacter.getCachedOutputIndex(((PObject)object3).getKeyName());
                ((Equipment)object3).setOutputIndex(n3 >= 0 ? n3 : collection.size() + 1);
                collection.add(object3);
                continue;
            }
            if ("%LIST".equals(object)) {
                object4 = this.getAssociatedList().iterator();
                while (object4.hasNext()) {
                    collection.add(object4.next().getDefaultChoice());
                }
                continue;
            }
            if ("DEITYWEAPONS".equals(object)) {
                if (playerCharacter.getDeity() == null || "ALL".equalsIgnoreCase((String)(object4 = playerCharacter.getDeity().getFavoredWeapon())) || "ANY".equalsIgnoreCase((String)object4)) continue;
                object3 = new StringTokenizer((String)object4, "|");
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    String string4 = ((StringTokenizer)object3).nextToken();
                    WeaponProf weaponProf = Globals.getWeaponProfKeyed(string4);
                    if (weaponProf.isType("Natural")) continue;
                    collection.add(string4);
                }
                continue;
            }
            collection.add(object);
        }
    }

    private List<String> processWeaponAutoTags(PlayerCharacter playerCharacter, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(5), ".");
        ArrayList<String> arrayList = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string22;
            String string3 = stringTokenizer.nextToken();
            List<WeaponProf> list = Globals.getWeaponProfs(string3, playerCharacter);
            ArrayList<Equipment> arrayList2 = new ArrayList<Equipment>();
            if (list.size() == 0) {
                arrayList2.addAll(EquipmentList.getEquipmentOfType("Weapon." + string3, ""));
            }
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                for (WeaponProf weaponProf : list) {
                    string22 = weaponProf.getKeyName();
                    if (arrayList.contains(string22)) continue;
                    arrayList.add(string22);
                }
                for (Equipment equipment : arrayList2) {
                    string22 = equipment.profKey(playerCharacter);
                    if (arrayList.contains(string22)) continue;
                    arrayList.add(string22);
                }
                continue;
            }
            Iterator<String> iterator = new ArrayList();
            for (String string22 : arrayList) {
                String string4;
                boolean bl = false;
                for (WeaponProf weaponProf : list) {
                    string4 = weaponProf.getKeyName();
                    if (!string22.equals(string4)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                for (Equipment equipment : arrayList2) {
                    string4 = equipment.profKey(playerCharacter);
                    if (!string22.equals(string4)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                iterator.add(string22);
            }
            Iterator iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                string22 = (String)iterator2.next();
                arrayList.remove(string22);
            }
        }
        return arrayList;
    }

    void addMyType(String string) {
        this.types.add(string);
    }

    void fireNameChanged(String string, String string2) {
    }

    final boolean hasCcSkill(String string) {
        List<String> list = this.getCcSkillList();
        if (list == null || list.isEmpty()) {
            return false;
        }
        if (list.contains(string)) {
            return true;
        }
        for (String string2 : this.getCcSkillList()) {
            if (string2.lastIndexOf(37) < 0 || !string.startsWith(string2 = string2.substring(0, string2.length() - 1))) continue;
            return true;
        }
        return false;
    }

    final boolean hasCSkill(String string) {
        List<String> list = this.getCSkillList();
        if (list == null || list.isEmpty()) {
            return false;
        }
        if (list.contains(string)) {
            return true;
        }
        if (list.contains("LIST")) {
            for (int i = 0; i < this.getAssociatedCount(); ++i) {
                String string2 = this.getAssociated(i);
                if (!string.startsWith(string2) && !string2.startsWith(string)) continue;
                return true;
            }
        }
        for (String string3 : list) {
            if (string3.lastIndexOf(37) >= 0 && string.startsWith(string3 = string3.substring(0, string3.length() - 1))) {
                return true;
            }
            if (!string.equalsIgnoreCase(string3)) continue;
            return true;
        }
        return false;
    }

    final void makeRegionSelection(PlayerCharacter playerCharacter) {
        this.makeRegionSelection(0, playerCharacter);
    }

    final void makeRegionSelection(int n, PlayerCharacter playerCharacter) {
        int n2;
        int n3;
        String string = this.stringChar.get(StringKey.REGION);
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = stringTokenizer.nextToken();
        try {
            n3 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint("Badly formed preLevel attribute in makeRegionSelection: " + string2);
            n3 = 0;
        }
        if (n3 > n) {
            return;
        }
        string2 = stringTokenizer.nextToken();
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint("Badly formed number of selection attribute in makeRegionSelection: " + string2);
            n2 = -1;
        }
        List<String> list = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            list.add(stringTokenizer.nextToken());
        }
        if (n2 != list.size()) {
            ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
            chooserInterface.setTitle("Region Selection");
            chooserInterface.setPool(n2);
            chooserInterface.setPoolFlag(false);
            chooserInterface.setAvailableList(list);
            chooserInterface.setVisible(true);
            list = chooserInterface.getSelectedList();
        }
        if (list.size() > 0) {
            for (String string3 : list) {
                if (playerCharacter.getRegion().equalsIgnoreCase(string3)) continue;
                playerCharacter.setRegion(string3);
            }
        }
    }

    int numberInList(String string) {
        return 0;
    }

    public final Object removeAssociated(int n) {
        if (this.associatedList == null) {
            throw new IndexOutOfBoundsException("size is 0, i=" + n);
        }
        return this.associatedList.remove(n);
    }

    final void sortAssociated() {
        if (this.associatedList != null) {
            Collections.sort(this.associatedList);
        }
    }

    private String getPreFormatedOutputName() {
        if (this.displayName.indexOf(40) < 0 || this.displayName.indexOf(41) < 0) {
            return this.displayName;
        }
        String string = this.displayName.substring(this.displayName.indexOf(40) + 1, this.displayName.indexOf(41));
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.insert(0, stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.insert(0, " ");
        }
        return stringBuffer.toString();
    }

    protected void clearMyType() {
        this.types.clear();
    }

    public void clearSelectedWeaponProfBonus() {
        this.listChar.removeListFor(ListKey.SELECTED_WEAPON_PROF_BONUS);
    }

    private String piDescString(PlayerCharacter playerCharacter, boolean bl) {
        String string = this.getDescription(playerCharacter);
        if (this.descIsPI) {
            StringBuffer stringBuffer = new StringBuffer(string.length() + 30);
            if (bl) {
                stringBuffer.append("<html>");
            }
            stringBuffer.append("<b><i>").append(string).append("</i></b>");
            if (bl) {
                stringBuffer.append("</html>");
            }
            return stringBuffer.toString();
        }
        return string;
    }

    private String piString(boolean bl) {
        String string = this.toString();
        if (SettingsHandler.guiUsesOutputNameEquipment()) {
            string = this.getOutputName();
        }
        if (this.nameIsPI) {
            StringBuffer stringBuffer = new StringBuffer(string.length() + 30);
            if (bl) {
                stringBuffer.append("<html>");
            }
            stringBuffer.append("<b><i>").append(string).append("</i></b>");
            if (bl) {
                stringBuffer.append("</html>");
            }
            return stringBuffer.toString();
        }
        return string;
    }

    protected void removeMyType(String string) {
        this.types.remove(string);
    }

    public List<String> getTemplateList() {
        return this.getSafeListFor(ListKey.TEMPLATES);
    }

    public void addTemplate(String string) {
        if (string.startsWith("CHOOSE:")) {
            this.listChar.addToListFor(ListKey.TEMPLATES, string);
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (".CLEAR".equalsIgnoreCase(string2)) {
                    this.listChar.removeListFor(ListKey.TEMPLATES);
                    continue;
                }
                if (string2.regionMatches(true, 0, ".CLEAR.", 0, 7)) {
                    if (this.listChar.removeFromListFor(ListKey.TEMPLATES, string2 = string2.substring(7))) continue;
                    Logging.errorPrint("addTemplate: Could not find template: " + string2 + " in templateList.");
                    continue;
                }
                this.listChar.addToListFor(ListKey.TEMPLATES, string2);
            }
        }
    }

    List<String> getTemplates(boolean bl, PlayerCharacter playerCharacter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.listChar.removeListFor(ListKey.TEMPLATES_ADDED);
        if (!bl) {
            for (String string : this.getTemplateList()) {
                if (string.startsWith("CHOOSE:")) {
                    string = PCTemplate.chooseTemplate(this, string.substring(7), true, playerCharacter);
                }
                if (string.length() == 0) continue;
                arrayList.add(string);
                this.listChar.addToListFor(ListKey.TEMPLATES_ADDED, string);
                playerCharacter.addTemplateKeyed(string);
            }
        }
        return arrayList;
    }

    public List<String> templatesAdded() {
        return this.getSafeListFor(ListKey.TEMPLATES_ADDED);
    }

    public void setMovement(Movement movement, int n) {
        this.movement = movement;
    }

    public void setKitList(List<String> list) {
        this.listChar.removeListFor(ListKey.KITS);
        this.listChar.addAllToListFor(ListKey.KITS, list);
    }

    public SpellSupport getSpellSupport() {
        return this.spellSupport;
    }

    public void removeSpecialAbility(SpecialAbility specialAbility) {
        this.listChar.removeFromListFor(ListKey.SPECIAL_ABILITY, specialAbility);
    }

    public void setStringFor(StringKey stringKey, String string) {
        this.stringChar.put(stringKey, string);
    }

    public String getStringFor(StringKey stringKey) {
        return this.stringChar.get(stringKey);
    }

    public boolean containsListFor(ListKey listKey) {
        return this.listChar.containsListFor(listKey);
    }

    @Override
    public <T> List<T> getListFor(ListKey<T> listKey) {
        return this.listChar.getListFor(listKey);
    }

    @Override
    public final <T> List<T> getSafeListFor(ListKey<T> listKey) {
        return this.listChar.containsListFor(listKey) ? this.listChar.getListFor(listKey) : new ArrayList();
    }

    public int getSizeOfListFor(ListKey listKey) {
        return this.listChar.sizeOfListFor(listKey);
    }

    public int getSafeSizeOfListFor(ListKey listKey) {
        return this.listChar.containsListFor(listKey) ? this.listChar.sizeOfListFor(listKey) : 0;
    }

    @Override
    public <T> boolean containsInList(ListKey<T> listKey, T t) {
        return this.listChar.containsInList(listKey, t);
    }

    @Override
    public <T> T getElementInList(ListKey<T> listKey, int n) {
        return this.listChar.getElementInList(listKey, n);
    }

    public void setChooseLanguageAutos(String string) {
        this.chooseLanguageAutos = string;
    }

    public String getChooseLanguageAutos() {
        return this.chooseLanguageAutos;
    }

    void chooseLanguageAutos(boolean bl, PlayerCharacter playerCharacter) {
        if (!bl && !"".equals(this.chooseLanguageAutos)) {
            ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
            chooserInterface.setPool(1);
            chooserInterface.setPoolFlag(false);
            chooserInterface.setTitle("Pick a Language: ");
            SortedSet<Language> sortedSet = Globals.getLanguagesFromString(this.chooseLanguageAutos);
            chooserInterface.setAvailableList(new ArrayList<Language>(sortedSet));
            chooserInterface.setVisible(true);
            List list = chooserInterface.getSelectedList();
            if (list != null && list.size() != 0) {
                playerCharacter.addFreeLanguage((Language)list.get(0));
            }
        }
    }

    public Set<Language> getLanguageBonus() {
        if (this.theBonusLangs == null) {
            Set set = Collections.emptySet();
            return Collections.unmodifiableSet(set);
        }
        return Collections.unmodifiableSortedSet(this.theBonusLangs);
    }

    public void setLanguageBonus(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            SortedSet<Language> sortedSet;
            String string2 = stringTokenizer.nextToken();
            if (".CLEAR".equals(string2)) {
                this.theBonusLangs = null;
                continue;
            }
            if (this.theBonusLangs == null) {
                this.theBonusLangs = new TreeSet();
            }
            if ((sortedSet = Globals.getLanguagesFromString(string2)) == null) continue;
            this.theBonusLangs.addAll(sortedSet);
        }
    }

    public void addWeaponProfBonus(String string) {
        if (this.weaponProfBonus == null) {
            this.weaponProfBonus = new ArrayList<String>();
        }
        this.weaponProfBonus.add(string);
    }

    public List<String> getWeaponProfBonus() {
        if (this.weaponProfBonus == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.weaponProfBonus);
    }

    public void setNumFollowers(String string, String string2) {
        List<String> list;
        if (this.followerNumbers == null) {
            this.followerNumbers = new HashMap<String, List<String>>();
        }
        if ((list = this.followerNumbers.get(string)) == null) {
            list = new ArrayList<String>();
            this.followerNumbers.put(string.toUpperCase(), list);
        }
        list.add(string2);
    }

    public List<String> getNumFollowers(String string) {
        if (this.followerNumbers == null) {
            return null;
        }
        List<String> list = this.followerNumbers.get(string.toUpperCase());
        if (list == null) {
            return null;
        }
        return Collections.unmodifiableList(list);
    }

    public void addToFollowerList(String string, FollowerOption followerOption) {
        List<FollowerOption> list;
        String string2 = string.toUpperCase();
        if (this.theAvailableFollowers == null) {
            this.theAvailableFollowers = new HashMap<String, List<FollowerOption>>();
        }
        if ((list = this.theAvailableFollowers.get(string2)) == null) {
            list = new ArrayList<FollowerOption>();
            this.theAvailableFollowers.put(string2, list);
        }
        list.add(followerOption);
    }

    public List<FollowerOption> getPotentialFollowers(String string) {
        if (this.theAvailableFollowers == null) {
            return null;
        }
        String string2 = string.toUpperCase();
        List<FollowerOption> list = this.theAvailableFollowers.get(string2);
        if (list != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                FollowerOption followerOption = list.get(i);
                if (followerOption.getRace() != null) continue;
                Collection<FollowerOption> collection = followerOption.getExpandedOptions();
                if (collection != null) {
                    list.addAll(collection);
                }
                list.remove(i);
            }
        }
        return list;
    }

    public void addAbility(AbilityCategory abilityCategory, Ability.Nature nature, QualifiedObject<String> qualifiedObject) {
        List<QualifiedObject<String>> list = this.theAbilities.get(abilityCategory, nature);
        if (list == null) {
            list = new ArrayList<QualifiedObject<String>>();
            this.theAbilities.put(abilityCategory, nature, list);
        }
        list.add(qualifiedObject);
    }

    public List<String> getAbilityKeys(PlayerCharacter playerCharacter, AbilityCategory abilityCategory, Ability.Nature nature) {
        List<QualifiedObject<String>> list = this.theAbilities.get(abilityCategory, nature);
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (QualifiedObject<String> qualifiedObject : list) {
            if (!qualifiedObject.qualifies(playerCharacter)) continue;
            arrayList.add(qualifiedObject.getObject(playerCharacter));
        }
        return arrayList;
    }

    public List<BonusObj> getBonusList() {
        return this.bonusList;
    }

    public List<BonusObj> getBonusListOfType(String string, String string2) {
        return BonusUtilities.getBonusFromList(this.getBonusList(), string, string2);
    }

    public HashMap<String, String> getBonusMap() {
        if (this.bonusMap == null) {
            this.bonusMap = new HashMap();
        }
        return this.bonusMap;
    }

    public double bonusTo(String string, String string2, Object object, PlayerCharacter playerCharacter) {
        return this.bonusTo(string, string2, object, this.getBonusList(), playerCharacter);
    }

    public double bonusTo(String string, String string2, Object object, List<BonusObj> list, PlayerCharacter playerCharacter) {
        int n;
        if (list == null || list.size() == 0) {
            return 0.0;
        }
        double d = 0.0;
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        String string3 = new StringBuffer(string).append('.').append(string2).append('.').toString();
        if (!dontRecurse && this instanceof Ability && !Globals.checkRule("FEATPRE")) {
            dontRecurse = true;
            n = 0;
            if (!PrereqHandler.passesAll(this.getPreReqList(), playerCharacter, this)) {
                n = 1;
            }
            dontRecurse = false;
            if (n != 0) {
                return 0.0;
            }
        }
        n = 1;
        if ("VAR".equals(string)) {
            n = Math.max(1, this.getAssociatedCount());
            String string4 = this.getChoiceString();
            if (string4.startsWith("SALIST|") && string4.indexOf("|VAR|") >= 0) {
                n = 1;
            }
        }
        for (BonusObj bonusObj : list) {
            String string5 = bonusObj.toString().toUpperCase();
            if (this.getAssociatedCount() != 0) {
                int n2 = 4;
                int n3 = string5.indexOf("%VAR");
                if (n3 == -1) {
                    n3 = string5.indexOf("%LIST|");
                    n2 = 5;
                }
                if (n3 >= 0) {
                    String string6 = string5.substring(0, n3);
                    String string7 = string5.substring(n3 + n2);
                    for (int i = 1; i < this.getAssociatedCount(); ++i) {
                        String string8 = new StringBuffer().append(string6).append(this.getAssociated(i)).append(string7).toString().toUpperCase();
                        d += this.calcBonus(string8, string, string2, string3, object, n, bonusObj, playerCharacter);
                    }
                    string5 = new StringBuffer().append(string6).append(this.getAssociated(0)).append(string7).toString().toUpperCase();
                }
            }
            d += this.calcBonus(string5, string, string2, string3, object, n, bonusObj, playerCharacter);
        }
        return d;
    }

    public double calcBonusFrom(BonusObj bonusObj, Object object, PlayerCharacter playerCharacter) {
        return this.calcBonusFrom(bonusObj, object, null, playerCharacter);
    }

    public double calcBonusFrom(BonusObj bonusObj, Object object, String string, PlayerCharacter playerCharacter) {
        int n = 1;
        String string2 = bonusObj.getTypeOfBonus();
        if ("VAR".equals(string2)) {
            n = Math.max(1, this.getAssociatedCount());
            String string3 = this.getChoiceString();
            if (string3.startsWith("SALIST|") && string3.indexOf("|VAR|") >= 0) {
                n = 1;
            }
        }
        return this.calcPartialBonus(n, bonusObj, object, string, playerCharacter);
    }

    public final boolean addBonusList(String string) {
        return this.addBonusList(string, false);
    }

    private final boolean addBonusList(String string, boolean bl) {
        BonusObj bonusObj;
        if (this.bonusList == null) {
            this.bonusList = new ArrayList<BonusObj>();
        }
        if ((bonusObj = Bonus.newBonus(string)) != null) {
            bonusObj.setCreatorObject(this);
            bonusObj.setAddOnceOnly(bl);
            this.addBonusList(bonusObj);
        }
        return bonusObj != null;
    }

    public List<BonusObj> getActiveBonuses(PlayerCharacter playerCharacter) {
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>();
        for (BonusObj bonusObj : this.getBonusList()) {
            if (!bonusObj.isApplied()) continue;
            arrayList.add(bonusObj);
        }
        return arrayList;
    }

    public boolean getBonusListString(String string) {
        for (BonusObj bonusObj : this.getBonusList()) {
            if (!bonusObj.getBonusInfo().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public void activateBonuses(PlayerCharacter playerCharacter) {
        for (BonusObj bonusObj : this.getBonusList()) {
            bonusObj.setApplied(false);
            if (!bonusObj.qualifies(playerCharacter) || bonusObj.getPCLevel() > playerCharacter.getTotalLevels()) continue;
            bonusObj.setApplied(true);
        }
    }

    public final void addBonusList(BonusObj bonusObj) {
        this.bonusList.add(bonusObj);
    }

    public void deactivateBonuses() {
        for (BonusObj bonusObj : this.getBonusList()) {
            bonusObj.setApplied(false);
        }
    }

    public void ownBonuses() {
        for (BonusObj bonusObj : this.getBonusList()) {
            bonusObj.setCreatorObject(this);
        }
    }

    public void putBonusMap(String string, String string2) {
        this.getBonusMap().put(string, string2);
    }

    public void removeBonusList(BonusObj bonusObj) {
        this.getBonusList().remove(bonusObj);
    }

    public void removeAllBonuses(int n) {
        if (this.bonusList != null) {
            for (int i = this.bonusList.size() - 1; i >= 0; --i) {
                if (this.bonusList.get(i).getPCLevel() != n) continue;
                this.bonusList.remove(i);
            }
        }
    }

    final void setBonusStackFor(double d, String string) {
        String string2;
        if (string != null) {
            string = string.toUpperCase();
        }
        int n = -1;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (string != null && stringTokenizer.countTokens() >= 2) {
            stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            if (string2.equals("BASE")) {
                if (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                }
                string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
            } else {
                string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
            }
            if (string2 != null) {
                n = SettingsHandler.getGame().getUnmodifiableBonusStackList().indexOf(string2);
            }
            if (string2 == null) {
                n = 1;
            } else if (string2.equals("NULL")) {
                n = 1;
            }
        }
        if (string != null && (string.endsWith(".STACK") || string.endsWith(".REPLACE"))) {
            n = 1;
        }
        if (d < 0.0) {
            n = 1;
        }
        if (n == -1) {
            string2 = this.getBonusMap().get(string);
            if (string2 == null) {
                this.putBonusMap(string, String.valueOf(d));
            } else {
                this.putBonusMap(string, String.valueOf(Math.max(d, (double)Float.parseFloat(string2))));
            }
        } else {
            if (string == null) {
                string = "";
            } else if (string.endsWith(".REPLACE.STACK")) {
                string = string.substring(0, string.length() - 6);
            }
            string2 = this.getBonusMap().get(string);
            if (string2 == null) {
                this.putBonusMap(string, String.valueOf(d));
            } else {
                this.putBonusMap(string, String.valueOf(d + (double)Float.parseFloat(string2)));
            }
        }
    }

    public final void applyBonus(String string, String string2, PlayerCharacter playerCharacter, boolean bl) {
        string = this.makeBonusString(string, string2, playerCharacter);
        this.addBonusList(string, bl);
        this.addSave("BONUS|" + string);
    }

    String makeBonusString(String string, String string2, PlayerCharacter playerCharacter) {
        boolean bl;
        int n = string2.lastIndexOf(32);
        String string3 = "";
        String string4 = "";
        if (string.startsWith("BONUS:")) {
            string = string.substring(6);
        }
        if (bl = string.endsWith(".LOCK")) {
            string = string.substring(0, string.lastIndexOf(".LOCK"));
        }
        if (n >= 0) {
            string3 = string2.substring(0, n);
            if (n < string2.length()) {
                string4 = string2.substring(n + 1);
            }
        }
        while (string.lastIndexOf("TYPE=%") >= 0) {
            n = string.lastIndexOf("TYPE=%");
            string = string.substring(0, n + 5) + string3 + string.substring(n + 6);
        }
        while (string.lastIndexOf("CLASS=%") >= 0) {
            n = string.lastIndexOf("CLASS=%");
            string = string.substring(0, n + 6) + string3 + string.substring(n + 7);
        }
        while (string.lastIndexOf("LEVEL=%") >= 0) {
            n = string.lastIndexOf("LEVEL=%");
            string = string.substring(0, n + 6) + string4 + string.substring(n + 7);
        }
        if (bl) {
            n = string.lastIndexOf(124);
            Float f = playerCharacter.getVariableValue(string.substring(n + 1), "");
            string = string.substring(0, n) + "|" + f;
        }
        return string;
    }

    public final void removeBonus(String string, String string2, PlayerCharacter playerCharacter) {
        String string3 = this.makeBonusString(string, string2, playerCharacter);
        int n = -1;
        BonusObj bonusObj = Bonus.newBonus(string3);
        String string4 = String.valueOf(bonusObj);
        if (this.getBonusList() != null) {
            int n2 = 0;
            for (BonusObj bonusObj2 : this.getBonusList()) {
                if (bonusObj2.getCreatorObject().equals(this) && bonusObj2.toString().equals(string4)) {
                    n = n2;
                }
                ++n2;
            }
        }
        if (n >= 0) {
            this.getBonusList().remove(n);
        } else {
            Logging.errorPrint("removeBonus: Could not find bonus: " + string3 + " in bonusList " + this.getBonusList());
        }
        this.removeSave("BONUS|" + string3);
    }

    private double calcBonus(String string, String string2, String string3, String string4, Object object, int n, BonusObj bonusObj, PlayerCharacter playerCharacter) {
        int n2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        if (stringTokenizer.countTokens() < 3) {
            Logging.errorPrint("Badly formed BONUS:" + string);
            return 0.0;
        }
        String string5 = stringTokenizer.nextToken();
        if (!string5.equalsIgnoreCase(string2) && !string5.endsWith("%LIST") || string5.endsWith("%LIST") && this.numberInList(string2) == 0 || string3.equals("ALL")) {
            return 0.0;
        }
        String string6 = stringTokenizer.nextToken();
        if (!string6.equals("LIST") && !string6.equals("ALL") && string6.toUpperCase().indexOf(string3.toUpperCase()) < 0) {
            return 0.0;
        }
        if (string6.equals("ALL") && (string3.indexOf("STAT=") >= 0 || string3.indexOf("TYPE=") >= 0 || string3.indexOf("LIST") >= 0 || string3.indexOf("VAR") >= 0)) {
            return 0.0;
        }
        if (stringTokenizer.hasMoreTokens()) {
            string5 = stringTokenizer.nextToken();
        }
        double d = 0.0;
        if (object instanceof PlayerCharacter) {
            d = ((PlayerCharacter)object).getVariableValue(string5, "").doubleValue();
        } else if (object instanceof Equipment) {
            d = ((Equipment)object).getVariableValue(string5, "", playerCharacter).doubleValue();
        } else {
            try {
                d = Float.parseFloat(string5);
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint("calcBonus NumberFormatException in BONUS: " + string5, numberFormatException);
            }
        }
        String string7 = bonusObj.getTypeString();
        if (object instanceof PlayerCharacter ? !bonusObj.qualifies((PlayerCharacter)object) : !bonusObj.passesPreReqToGain((Equipment)object, playerCharacter)) {
            return 0.0;
        }
        double d2 = 0.0;
        if ("LIST".equalsIgnoreCase(string6) && (n2 = this.numberInList(string3)) != 0) {
            d2 += d * (double)n2;
        }
        String string8 = null;
        StringTokenizer stringTokenizer2 = new StringTokenizer(string6, ",");
        if (string6.equalsIgnoreCase("LIST")) {
            stringTokenizer2.nextToken();
        } else if (string6.equalsIgnoreCase("ALL")) {
            string4 = new StringBuffer(string2).append('.').append(string3).append('.').toString();
            d2 = d;
            string8 = string7;
        }
        while (stringTokenizer2.hasMoreTokens()) {
            if (!stringTokenizer2.nextToken().equalsIgnoreCase(string3)) continue;
            d2 += d;
            string8 = string7;
        }
        if (object instanceof Equipment) {
            ((Equipment)object).setBonusStackFor(d2 * (double)n, string4 + string8);
        } else {
            this.setBonusStackFor(d2 * (double)n, string4 + string8);
        }
        if (string6.equals("ALL")) {
            return 0.0;
        }
        return d2 * (double)n;
    }

    private double calcPartialBonus(int n, BonusObj bonusObj, Object object, String string, PlayerCharacter playerCharacter) {
        String string2 = bonusObj.getBonusInfo();
        String string3 = bonusObj.getValue();
        double d = 0.0;
        if (string2.equals("ALL")) {
            return 0.0;
        }
        if (string != null) {
            int n2 = string3.indexOf("%LIST");
            while (n2 >= 0) {
                boolean bl = false;
                for (int i = 0; i < this.getAssociatedCount(); ++i) {
                    String string4 = this.getAssociated(i).toUpperCase();
                    if (string.indexOf(string4) < 0) continue;
                    StringBuffer stringBuffer = new StringBuffer();
                    if (n2 > 0) {
                        stringBuffer.append(string3.substring(0, n2));
                    }
                    stringBuffer.append(string4);
                    if (string3.length() > n2 + 5) {
                        stringBuffer.append(string3.substring(n2 + 5));
                    }
                    string3 = stringBuffer.toString();
                    bl = true;
                    break;
                }
                n2 = bl ? string3.indexOf("%LIST") : -1;
            }
        }
        if (bonusObj.isValueStatic()) {
            d = bonusObj.getValueAsdouble();
        } else if (object instanceof PlayerCharacter) {
            d = ((PlayerCharacter)object).getVariableValue(string3, "").doubleValue();
        } else if (object instanceof Equipment) {
            d = ((Equipment)object).getVariableValue(string3, "", playerCharacter).doubleValue();
        } else {
            try {
                d = Float.parseFloat(string3);
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint("calcPartialBonus NumberFormatException in BONUS: " + string3);
            }
        }
        return d * (double)n;
    }

    public void clearAdds() {
        this.levelAbilityList.clear();
    }
}

