/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import pcgen.core.Equipment;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteUtilities;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.persistence.lst.prereq.PreParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrereqObject
implements Cloneable {
    private List<Prerequisite> thePrereqs = null;
    private static final String angleSplit = "[<>\\|]";
    private static final String squareSplit = "[\\[\\]\\|]";

    public void addPrerequisites(Collection<Prerequisite> collection) {
        if (collection == null) {
            return;
        }
        if (this.thePrereqs == null) {
            this.thePrereqs = new ArrayList<Prerequisite>(collection.size());
        }
        for (Prerequisite prerequisite : collection) {
            this.addPreReq(prerequisite);
        }
    }

    public void addPrerequisites(String string, char c) {
        String[] stringArray = string.split(c == '<' ? angleSplit : squareSplit);
        try {
            PreParserFactory preParserFactory = PreParserFactory.getInstance();
            for (String string2 : stringArray) {
                Prerequisite prerequisite = preParserFactory.parse(string2);
                if (prerequisite == null) continue;
                this.addPreReq(prerequisite);
            }
        }
        catch (PersistenceLayerException persistenceLayerException) {
            persistenceLayerException.printStackTrace();
        }
    }

    public boolean qualifies(PlayerCharacter playerCharacter) {
        if (this.thePrereqs == null) {
            return true;
        }
        return PrereqHandler.passesAll(this.thePrereqs, playerCharacter, null);
    }

    public final boolean passesPreReqToGain(Equipment equipment, PlayerCharacter playerCharacter) {
        if (!this.hasPreReqs()) {
            return true;
        }
        return PrereqHandler.passesAll(this.thePrereqs, equipment, playerCharacter);
    }

    public List<Prerequisite> getPreReqList() {
        if (this.thePrereqs != null) {
            return Collections.unmodifiableList(this.thePrereqs);
        }
        return Collections.emptyList();
    }

    public final void clearPreReq() {
        this.thePrereqs = null;
    }

    public final void addPreReq(Prerequisite prerequisite) {
        this.addPreReq(prerequisite, -1);
    }

    public boolean hasPreReqs() {
        return this.thePrereqs != null;
    }

    public final void addPreReq(Prerequisite prerequisite, int n) {
        if (prerequisite == null) {
            return;
        }
        if ("clear".equals(prerequisite.getKind())) {
            this.thePrereqs = null;
        } else {
            if (this.thePrereqs == null) {
                this.thePrereqs = new ArrayList<Prerequisite>();
            }
            if (n > 0) {
                prerequisite.setLevelQualifier(n);
            }
            this.thePrereqs.add(prerequisite);
        }
    }

    public final boolean hasPreReqTypeOf(String string) {
        if (!this.hasPreReqs()) {
            return false;
        }
        for (Prerequisite prerequisite : this.getPreReqList()) {
            if (prerequisite == null) continue;
            if (string == null && prerequisite.getKind() == null) {
                return true;
            }
            if (!string.equalsIgnoreCase(prerequisite.getKind())) continue;
            return true;
        }
        return false;
    }

    public final int getPreReqCount() {
        if (this.thePrereqs == null) {
            return 0;
        }
        return this.thePrereqs.size();
    }

    public final String preReqHTMLStrings(PlayerCharacter playerCharacter) {
        return PrerequisiteUtilities.preReqHTMLStringsForList(playerCharacter, null, this.thePrereqs, true);
    }

    public String preReqHTMLStrings(PlayerCharacter playerCharacter, boolean bl) {
        return PrerequisiteUtilities.preReqHTMLStringsForList(playerCharacter, null, this.thePrereqs, bl);
    }

    public final String preReqHTMLStrings(PlayerCharacter playerCharacter, PObject pObject) {
        return PrerequisiteUtilities.preReqHTMLStringsForList(playerCharacter, pObject, this.thePrereqs, true);
    }

    public final String preReqStrings() {
        return PrereqHandler.toHtmlString(this.thePrereqs);
    }

    final void addPreReqTo(Collection<Prerequisite> collection) {
        if (this.thePrereqs != null) {
            collection.addAll(this.thePrereqs);
        }
    }

    public String getPCCText() {
        if (this.thePrereqs == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        for (Prerequisite prerequisite : this.thePrereqs) {
            PrerequisiteWriter prerequisiteWriter = new PrerequisiteWriter();
            stringWriter.write("|");
            try {
                prerequisiteWriter.write(stringWriter, prerequisite);
            }
            catch (PersistenceLayerException persistenceLayerException) {
                persistenceLayerException.printStackTrace();
            }
        }
        return stringWriter.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        PrereqObject prereqObject = (PrereqObject)super.clone();
        if (this.thePrereqs != null) {
            prereqObject.thePrereqs = new ArrayList<Prerequisite>(this.thePrereqs);
        }
        return prereqObject;
    }
}

