/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifiedObject<T> {
    private T theObject = null;
    private List<Prerequisite> thePrereqs = null;
    private static final String angleSplit = "[<>\\|]";
    private static final String squareSplit = "[\\[\\]\\|]";

    public QualifiedObject() {
    }

    public QualifiedObject(T t) {
        this.theObject = t;
    }

    public QualifiedObject(T t, List<Prerequisite> list) {
        this.theObject = t;
        this.thePrereqs = new ArrayList<Prerequisite>(list);
    }

    public T getObject(PlayerCharacter playerCharacter) {
        if (playerCharacter == null || this.qualifies(playerCharacter)) {
            return this.theObject;
        }
        return null;
    }

    public List<Prerequisite> getPrereqs() {
        if (this.thePrereqs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.thePrereqs);
    }

    public void setObject(T t) {
        this.theObject = t;
    }

    public void addPrerequisites(List<Prerequisite> list) {
        if (this.thePrereqs == null) {
            this.thePrereqs = new ArrayList<Prerequisite>(list.size());
        }
        this.thePrereqs.addAll(list);
    }

    public boolean qualifies(PlayerCharacter playerCharacter) {
        if (this.thePrereqs == null) {
            return true;
        }
        return PrereqHandler.passesAll(this.thePrereqs, playerCharacter, null);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Object:");
        stringBuffer.append(this.theObject.toString());
        stringBuffer.append(", Prereq:");
        stringBuffer.append(this.thePrereqs.toString());
        return stringBuffer.toString();
    }

    public static QualifiedObject<String> createQualifiedObject(String string, char c) {
        int n = string.indexOf(c);
        if (n < 0) {
            return new QualifiedObject<String>(string);
        }
        ArrayList<Prerequisite> arrayList = new ArrayList<Prerequisite>();
        String string2 = "";
        List<String> list = Arrays.asList(string.split(c == '<' ? angleSplit : squareSplit));
        Iterator<String> iterator = list.iterator();
        string2 = iterator.next();
        try {
            PreParserFactory preParserFactory = PreParserFactory.getInstance();
            while (iterator.hasNext()) {
                Prerequisite prerequisite = preParserFactory.parse(iterator.next());
                if (prerequisite == null) continue;
                arrayList.add(prerequisite);
            }
        }
        catch (PersistenceLayerException persistenceLayerException) {
            persistenceLayerException.printStackTrace();
        }
        return new QualifiedObject<String>(string2, arrayList);
    }
}

