/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.StringTokenizer;
import pcgen.util.Logging;

final class RollInfo {
    protected int sides = 0;
    protected int times = 0;
    private boolean[] keepList = null;
    private int modifier = 0;
    private int rerollAbove = Integer.MAX_VALUE;
    private int rerollBelow = Integer.MIN_VALUE;
    private int totalCeiling = Integer.MAX_VALUE;
    private int totalFloor = Integer.MIN_VALUE;

    RollInfo(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", true);
        try {
            String string2 = stringTokenizer.nextToken("d");
            if ("d".equals(string2)) {
                this.times = 1;
            } else {
                this.times = Integer.parseInt(string2);
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken("d");
                    if (!"d".equals(string2)) {
                        Logging.errorPrint("Bad roll parsing in '" + string + "': missing 'd'");
                        return;
                    }
                } else {
                    this.sides = 1;
                    return;
                }
            }
            String string3 = "/\\|mM+-tT";
            this.sides = Integer.parseInt(stringTokenizer.nextToken(string3));
            if (this.sides < 1) {
                Logging.errorPrint("Bad roll parsing in '" + string + "': sides < 1: " + this.sides);
                return;
            }
            block13: while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken(string3);
                switch (string2.charAt(0)) {
                    case '/': {
                        int n;
                        string3 = "mM+-tT";
                        int n2 = Integer.parseInt(stringTokenizer.nextToken(string3));
                        if (n2 > this.times) {
                            Logging.errorPrint("Bad keepTop in '" + string + "': times: " + this.times + "; keepTop: " + n2);
                            return;
                        }
                        this.keepList = new boolean[this.times];
                        for (n = this.times - n2; n < this.times; ++n) {
                            this.keepList[n] = true;
                        }
                        continue block13;
                    }
                    case '\\': {
                        string3 = "mM+-tT";
                        int n = Integer.parseInt(stringTokenizer.nextToken(string3));
                        if (n > this.times) {
                            Logging.errorPrint("Bad keepBottom in '" + string + "': times: " + this.times + "; keepBottom: " + n);
                            return;
                        }
                        this.keepList = new boolean[this.times];
                        for (int i = 0; i < n; ++i) {
                            this.keepList[i] = true;
                        }
                        continue block13;
                    }
                    case '|': {
                        string3 = "mM+-tT";
                        string2 = stringTokenizer.nextToken(string3);
                        this.keepList = new boolean[this.times];
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
                        while (stringTokenizer2.hasMoreTokens()) {
                            this.keepList[Integer.parseInt((String)stringTokenizer2.nextToken((String)",")) - 1] = true;
                        }
                        continue block13;
                    }
                    case 'm': {
                        string3 = "M+-tT";
                        this.rerollBelow = Integer.parseInt(stringTokenizer.nextToken(string3));
                        break;
                    }
                    case 'M': {
                        string3 = "m+-tT";
                        this.rerollAbove = Integer.parseInt(stringTokenizer.nextToken(string3));
                        break;
                    }
                    case '+': {
                        string3 = "tT";
                        this.modifier = Integer.parseInt(stringTokenizer.nextToken(" "));
                        break;
                    }
                    case '-': {
                        string3 = "tT";
                        this.modifier = -Integer.parseInt(stringTokenizer.nextToken(" "));
                        break;
                    }
                    case 't': {
                        string3 = "T";
                        this.totalFloor = Integer.parseInt(stringTokenizer.nextToken(" "));
                        break;
                    }
                    case 'T': {
                        string3 = "t";
                        this.totalCeiling = Integer.parseInt(stringTokenizer.nextToken(" "));
                        break;
                    }
                    default: {
                        Logging.errorPrint("Bizarre dice parser error in '" + string + "': not a valid delimiter");
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint("Bad roll string in '" + string + "': " + numberFormatException, numberFormatException);
        }
    }

    public static void main(String[] stringArray) {
        Logging.setDebugMode(true);
        for (int i = 0; i < stringArray.length; ++i) {
            RollInfo rollInfo = new RollInfo(stringArray[i]);
            Logging.debugPrint(rollInfo + ": " + RollInfo.roll());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.times > 1) {
            stringBuffer.append(this.times);
        }
        stringBuffer.append("d").append(this.sides);
        while (this.keepList != null) {
            int n;
            for (n = 0; n < this.times && !this.keepList[n]; ++n) {
            }
            if (n == this.times) {
                Logging.errorPrint("Bad rolls: nothing to keep!");
                return null;
            }
            for (n = 0; n < this.times && this.keepList[n]; ++n) {
            }
            if (n == this.times) break;
            int n2 = n;
            while (n < this.times && !this.keepList[n]) {
                ++n;
            }
            if (n2 > 0 && n == this.times) {
                stringBuffer.append("\\").append(n2);
                break;
            }
            for (n = 0; n < this.times && !this.keepList[n]; ++n) {
            }
            n2 = n;
            while (n < this.times && this.keepList[n]) {
                ++n;
            }
            if (n2 > 0 && n == this.times) {
                stringBuffer.append("/").append(this.times - n2);
                break;
            }
            stringBuffer.append("|");
            boolean bl = true;
            for (n = 0; n < this.times; ++n) {
                if (!this.keepList[n]) continue;
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(",");
                }
                stringBuffer.append(n + 1);
            }
        }
        if (this.rerollBelow != Integer.MIN_VALUE) {
            stringBuffer.append("m").append(this.rerollBelow);
        }
        if (this.rerollAbove != Integer.MAX_VALUE) {
            stringBuffer.append("M").append(this.rerollAbove);
        }
        if (this.modifier > 0) {
            stringBuffer.append("+").append(this.modifier);
        } else if (this.modifier < 0) {
            stringBuffer.append("-").append(-this.modifier);
        }
        if (this.totalFloor != Integer.MIN_VALUE) {
            stringBuffer.append("t").append(this.totalFloor);
        }
        if (this.totalCeiling != Integer.MAX_VALUE) {
            stringBuffer.append("T").append(this.totalCeiling);
        }
        return stringBuffer.toString();
    }

    private static int roll() {
        return 0;
    }
}

