/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import pcgen.core.Campaign;
import pcgen.core.SourceEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Source {
    private Campaign theCampaign = null;
    private String theLongName = null;
    private String theShortName = null;
    private String theWebsite = null;
    private Date theDate = null;
    private static List<Source> theSources = null;

    private static Source getSource(Source source) {
        if (theSources == null) {
            return null;
        }
        for (Source source2 : theSources) {
            if (!source2.equals(source)) continue;
            return source2;
        }
        return null;
    }

    public static Source getSource(Map<String, String> map) throws ParseException {
        if (map == null) {
            return null;
        }
        Source source = new Source();
        source.theLongName = map.get(SourceEntry.SourceFormat.LONG.toString());
        source.theShortName = map.get(SourceEntry.SourceFormat.SHORT.toString());
        source.theWebsite = map.get(SourceEntry.SourceFormat.WEB.toString());
        source.setDate(map.get(SourceEntry.SourceFormat.DATE.toString()));
        Source source2 = Source.getSource(source);
        if (source2 == null) {
            if (theSources == null) {
                theSources = new ArrayList<Source>();
            }
            theSources.add(source);
            source2 = source;
        }
        return source2;
    }

    public static boolean hasSource(Source source) {
        return theSources.contains(source);
    }

    public static void addSource(Source source) {
        if (!theSources.contains(source)) {
            theSources.add(source);
        }
    }

    public String getShortName(int n) {
        if (this.theShortName != null) {
            int n2 = Math.min(n, this.theShortName.length());
            return this.theShortName.substring(0, n2);
        }
        return "";
    }

    public Campaign getCampaign() {
        return this.theCampaign;
    }

    public void setCampaign(Campaign campaign) {
        this.theCampaign = campaign;
    }

    public Date getDate() {
        return this.theDate;
    }

    public void setDate(String string) throws ParseException {
        if (string == null) {
            return;
        }
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        try {
            this.theDate = dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            dateFormat = DateFormat.getDateInstance();
            this.theDate = dateFormat.parse(string);
        }
    }

    public String getLongName() {
        return this.theLongName;
    }

    public void setLongName(String string) {
        this.theLongName = string;
    }

    public String getShortName() {
        return this.theShortName;
    }

    public void setShortName(String string) {
        this.theShortName = string;
    }

    public String getWebsite() {
        return this.theWebsite;
    }

    public void setWebsite(String string) {
        this.theWebsite = string;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.theDate == null ? 0 : this.theDate.hashCode());
        n = 31 * n + (this.theLongName == null ? 0 : this.theLongName.hashCode());
        n = 31 * n + (this.theShortName == null ? 0 : this.theShortName.hashCode());
        n = 31 * n + (this.theWebsite == null ? 0 : this.theWebsite.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Source source = (Source)object;
        if (this.theDate == null ? source.theDate != null : !this.theDate.equals(source.theDate)) {
            return false;
        }
        if (this.theLongName == null ? source.theLongName != null : !this.theLongName.equals(source.theLongName)) {
            return false;
        }
        if (this.theShortName == null ? source.theShortName != null : !this.theShortName.equals(source.theShortName)) {
            return false;
        }
        return !(this.theWebsite == null ? source.theWebsite != null : !this.theWebsite.equals(source.theWebsite));
    }
}

