/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import pcgen.core.utils.CoreUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellProgressionInfo
implements Cloneable {
    private Progression knownProgression = null;
    private Progression specialtyKnownProgression = null;
    private Progression castProgression = null;
    private String spellType = null;
    private String spellBaseStatAbbr = "None";
    private String bonusSpellBaseStatAbbr = "Default";
    private boolean hasSpellFormulas = false;
    private boolean memorizeSpells = true;
    private boolean usesSpellBook = false;
    private int knownSpellsFromSpecialty = 0;

    public List<String> setKnown(int n, List<String> list) {
        if (this.knownProgression == null) {
            this.knownProgression = new Progression();
        }
        return this.knownProgression.setProgression(n, list);
    }

    public boolean hasKnownProgression() {
        return this.knownProgression != null && this.knownProgression.hasProgression();
    }

    public Map<Integer, List<String>> getKnownProgression() {
        return this.knownProgression == null ? null : this.knownProgression.getProgression();
    }

    public List<String> getKnownForLevel(int n) {
        return this.knownProgression == null ? null : this.knownProgression.getProgressionForLevel(n);
    }

    public String getKnownPCC(String string) {
        return this.knownProgression == null ? null : this.knownProgression.getProgressionPCC("KNOWN", string);
    }

    public int getHighestKnownSpellLevel() {
        return this.knownProgression == null ? 0 : this.knownProgression.getHighestSpellLevel();
    }

    public List<String> setSpecialtyKnown(int n, List<String> list) {
        if (this.specialtyKnownProgression == null) {
            this.specialtyKnownProgression = new Progression();
        }
        return this.specialtyKnownProgression.setProgression(n, list);
    }

    public boolean hasSpecialtyKnownProgression() {
        return this.specialtyKnownProgression != null && this.specialtyKnownProgression.hasProgression();
    }

    public Map<Integer, List<String>> getSpecialtyKnownMap() {
        return this.specialtyKnownProgression == null ? null : this.specialtyKnownProgression.getProgression();
    }

    public List<String> getSpecialtyKnownForLevel(int n) {
        return this.specialtyKnownProgression == null ? null : this.specialtyKnownProgression.getProgressionForLevel(n);
    }

    public String getSpecialtyKnownPCC(String string) {
        return this.specialtyKnownProgression == null ? null : this.specialtyKnownProgression.getProgressionPCC("SPECIALTYKNOWN", string);
    }

    public List<String> setCast(int n, List<String> list) {
        if (this.castProgression == null) {
            this.castProgression = new Progression();
        }
        return this.castProgression.setProgression(n, list);
    }

    public boolean hasCastProgression() {
        return this.castProgression != null && this.castProgression.hasProgression();
    }

    public Map<Integer, List<String>> getCastProgression() {
        return this.castProgression == null ? null : this.castProgression.getProgression();
    }

    public List<String> getCastForLevel(int n) {
        return this.castProgression == null ? null : this.castProgression.getProgressionForLevel(n);
    }

    public int getHighestCastSpellLevel() {
        return this.castProgression == null ? 0 : this.castProgression.getHighestSpellLevel();
    }

    public String getCastPCC(String string) {
        return this.castProgression == null ? null : this.castProgression.getProgressionPCC("CAST", string);
    }

    public void setSpellType(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Spell type cannot be null");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("Spell type cannot be empty string");
        }
        this.spellType = string.trim();
    }

    public String getSpellType() {
        if (this.spellType == null) {
            return "None";
        }
        return this.spellType;
    }

    public void setContainsSpellFormula(boolean bl) {
        this.hasSpellFormulas = bl;
    }

    public boolean containsSpellFormula() {
        return this.hasSpellFormulas;
    }

    public void setMemorizeSpells(boolean bl) {
        this.memorizeSpells = bl;
    }

    public boolean memorizesSpells() {
        return this.memorizeSpells;
    }

    public void setSpellBookUsed(boolean bl) {
        this.usesSpellBook = bl;
    }

    public boolean usesSpellBook() {
        return this.usesSpellBook;
    }

    public void setSpellBaseStatAbbr(String string) {
        if (string != null && string.trim().length() == 0) {
            throw new IllegalArgumentException("Cannot set Spell Base Stat to an empty String.");
        }
        this.spellBaseStatAbbr = string == null ? null : string.trim();
    }

    public String getSpellBaseStatAbbr() {
        return this.spellBaseStatAbbr;
    }

    public void setBonusSpellBaseStatAbbr(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot set Bonus Spell Base Stat to null.  Use s_DEFAULT to reset");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("Cannot set Bonus Spell Base Stat to an empty string.  Use s_DEFAULT to reset");
        }
        this.bonusSpellBaseStatAbbr = string.trim();
    }

    public String getBonusSpellBaseStatAbbr() {
        return this.bonusSpellBaseStatAbbr;
    }

    public void setKnownSpellsFromSpecialty(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Known Spells from Specialty must be greater than or equal to zero");
        }
        this.knownSpellsFromSpecialty = n;
    }

    public int getKnownSpellsFromSpecialty() {
        return this.knownSpellsFromSpecialty;
    }

    public int getMinLevelForSpellLevel(int n, boolean bl) {
        int n2;
        if (this.castProgression != null && (n2 = this.castProgression.getMinLevelForSpellLevel(n, bl)) != -1) {
            return n2;
        }
        if (this.knownProgression != null && (n2 = this.knownProgression.getMinLevelForSpellLevel(n, bl)) != -1) {
            return n2;
        }
        return -1;
    }

    public int getMaxSpellLevelForClassLevel(int n) {
        List<String> list;
        if (this.castProgression != null && (list = this.castProgression.getProgressionForLevel(n)) != null) {
            return list.size() - 1;
        }
        if (this.knownProgression != null && (list = this.knownProgression.getProgressionForLevel(n)) != null) {
            return list.size() - 1;
        }
        return -1;
    }

    public SpellProgressionInfo clone() throws CloneNotSupportedException {
        SpellProgressionInfo spellProgressionInfo = (SpellProgressionInfo)super.clone();
        if (this.knownProgression != null) {
            spellProgressionInfo.knownProgression = this.knownProgression.clone();
        }
        if (this.specialtyKnownProgression != null) {
            spellProgressionInfo.specialtyKnownProgression = this.specialtyKnownProgression.clone();
        }
        if (this.castProgression != null) {
            spellProgressionInfo.castProgression = this.castProgression.clone();
        }
        return spellProgressionInfo;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Progression
    implements Cloneable {
        private TreeMap<Integer, List<String>> progressionMap = null;

        private Progression() {
        }

        public List<String> setProgression(int n, List<String> list) {
            if (n < 1) {
                throw new IllegalArgumentException("Level must be >= 1 in spell progression");
            }
            if (list == null) {
                throw new IllegalArgumentException("Cannot add null spell progression list to level " + n);
            }
            if (list.isEmpty()) {
                throw new IllegalArgumentException("Cannot add empty spell progression list to level " + n);
            }
            if (list.contains(null)) {
                throw new IllegalArgumentException("Cannot have null value in spell progrssion list in level " + n);
            }
            if (this.progressionMap == null) {
                this.progressionMap = new TreeMap();
            }
            return this.progressionMap.put(n, new ArrayList<String>(list));
        }

        public int getMinLevelForSpellLevel(int n, boolean bl) {
            for (Map.Entry<Integer, List<String>> entry : this.progressionMap.entrySet()) {
                List<String> list = entry.getValue();
                for (int i = n; i < list.size(); ++i) {
                    if (!bl && Integer.parseInt(list.get(i)) == 0) continue;
                    return entry.getKey();
                }
            }
            return -1;
        }

        public boolean hasProgression() {
            return this.progressionMap != null;
        }

        public Map<Integer, List<String>> getProgression() {
            if (this.progressionMap == null) {
                return null;
            }
            return this.progressionMap;
        }

        public List<String> getProgressionForLevel(int n) {
            ArrayList<String> arrayList = null;
            boolean bl = false;
            if (this.progressionMap != null) {
                Integer n2 = n;
                if (!this.progressionMap.containsKey(n2)) {
                    if (this.progressionMap.firstKey() < n) {
                        n2 = this.progressionMap.headMap(n2).lastKey();
                        bl = true;
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    List<String> list = this.progressionMap.get(n2);
                    arrayList = new ArrayList<String>(list);
                }
            }
            return arrayList;
        }

        public String getProgressionPCC(String string, String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("Line Separator cannot be null");
            }
            if (this.progressionMap != null) {
                StringBuffer stringBuffer = new StringBuffer();
                for (Map.Entry<Integer, List<String>> entry : this.progressionMap.entrySet()) {
                    stringBuffer.append(string2).append(entry.getKey()).append("\t");
                    stringBuffer.append(string).append(":");
                    stringBuffer.append(CoreUtility.join((Collection)entry.getValue(), ","));
                }
                return stringBuffer.append(string2).toString();
            }
            return null;
        }

        public int getHighestSpellLevel() {
            if (this.progressionMap != null) {
                int n = -1;
                for (List<String> list : this.progressionMap.values()) {
                    n = Math.max(n, list.size() - 1);
                }
                return n;
            }
            return -1;
        }

        public Progression clone() throws CloneNotSupportedException {
            Progression progression = (Progression)super.clone();
            if (this.progressionMap != null) {
                progression.progressionMap = new TreeMap<Integer, List<String>>((SortedMap<Integer, List<String>>)this.progressionMap);
            }
            return progression;
        }
    }
}

