/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.bonus.BonusObj;
import pcgen.core.utils.CoreUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StatList
implements Iterable<PCStat> {
    private List<PCStat> stats = new ArrayList<PCStat>();
    private PlayerCharacter ownerPC;

    public StatList(PlayerCharacter playerCharacter) {
        this.ownerPC = playerCharacter;
    }

    public int getBaseStatFor(String string) {
        int n = this.getIndexOfStatFor(string);
        if (n == -1) {
            return 0;
        }
        PCStat pCStat = this.stats.get(n);
        PlayerCharacter playerCharacter = this.ownerPC;
        int n2 = playerCharacter.getVariableValue("LOCK." + pCStat.getAbb(), "").intValue();
        if (n2 != 0 || n2 == 0 && playerCharacter.hasVariable("LOCK." + pCStat.getAbb())) {
            return n2;
        }
        n2 = playerCharacter.getVariableValue("BASE." + pCStat.getAbb(), "").intValue();
        if (n2 != 0) {
            return n2;
        }
        return pCStat.getBaseScore();
    }

    public List<BonusObj> getBonusListOfType(String string, String string2) {
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>();
        for (PCStat pCStat : this.stats) {
            arrayList.addAll(pCStat.getBonusListOfType(string, string2));
        }
        return arrayList;
    }

    public int getModForNumber(int n) {
        return this.getModForNumber(n, 1);
    }

    public int getModForNumber(int n, int n2) {
        PCStat pCStat = this.stats.get(n2);
        String string = pCStat.getStatMod();
        string = CoreUtility.replaceAll(string, "SCORE", Integer.toString(n));
        return this.ownerPC.getVariableValue(string, "").intValue();
    }

    public String getPenaltyVar(String string) {
        int n = this.getIndexOfStatFor(string);
        if (n == -1) {
            return "";
        }
        PCStat pCStat = this.stats.get(n);
        return pCStat.getPenaltyVar();
    }

    public int getStatModFor(String string) {
        int n = this.getIndexOfStatFor(string);
        if (n == -1) {
            return 0;
        }
        PCStat pCStat = this.stats.get(n);
        return this.ownerPC.getVariableValue(pCStat.getStatMod(), "STAT:" + pCStat.getAbb()).intValue();
    }

    public int size() {
        return this.stats.size();
    }

    public PCStat getStatAt(int n) {
        return this.stats.get(n);
    }

    @Override
    public Iterator<PCStat> iterator() {
        return this.stats.iterator();
    }

    public void clear() {
        this.stats.clear();
    }

    public void addStat(PCStat pCStat) {
        this.stats.add(pCStat);
    }

    public List<PCStat> getStatList() {
        return Collections.unmodifiableList(this.stats);
    }

    public int getTotalStatFor(String string) {
        int n = this.getBaseStatFor(string);
        int n2 = this.getIndexOfStatFor(string);
        if (n2 == -1) {
            return n;
        }
        PCStat pCStat = this.stats.get(n2);
        PlayerCharacter playerCharacter = this.ownerPC;
        n2 = playerCharacter.getVariableValue("LOCK." + pCStat.getAbb(), "").intValue();
        if (n2 != 0 || n2 == 0 && playerCharacter.hasVariable("LOCK." + pCStat.getAbb())) {
            return n2;
        }
        n = (int)((double)n + playerCharacter.getTotalBonusTo("STAT", pCStat.getAbb()));
        return n;
    }

    public int getIndexOfStatFor(String string) {
        if (string.startsWith("STAT")) {
            int n = Integer.parseInt(string.substring(4));
            if (n < 0 || n >= this.stats.size()) {
                return -1;
            }
            return n;
        }
        return SettingsHandler.getGame().getStatFromAbbrev(string);
    }

    public int getPartialStatFor(String string, boolean bl, boolean bl2) {
        int n = this.getBaseStatFor(string);
        int n2 = this.getIndexOfStatFor(string);
        if (n2 == -1) {
            return n;
        }
        PCStat pCStat = this.stats.get(n2);
        PlayerCharacter playerCharacter = this.ownerPC;
        n2 = playerCharacter.getVariableValue("LOCK." + pCStat.getAbb(), "").intValue();
        if (n2 != 0 || n2 == 0 && playerCharacter.hasVariable("LOCK." + pCStat.getAbb())) {
            return n2;
        }
        return n += playerCharacter.getPartialStatBonusFor(pCStat.getAbb(), bl, bl2);
    }
}

