/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import pcgen.core.PlayerCharacter;
import pcgen.core.PrereqObject;
import pcgen.util.enumeration.VisionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vision
extends PrereqObject
implements Comparable<Vision> {
    private final VisionType visionType;
    private final String distance;

    public Vision(VisionType visionType, String string) {
        if (visionType == null) {
            throw new IllegalArgumentException("Vision Type cannot be null");
        }
        this.visionType = visionType;
        this.distance = string;
    }

    public String getDistance() {
        return this.distance;
    }

    public VisionType getType() {
        return this.visionType;
    }

    public String toString() {
        try {
            return this.toString(Integer.parseInt(this.distance));
        }
        catch (NumberFormatException numberFormatException) {
            return this.visionType + " (" + this.distance + "')";
        }
    }

    private String toString(int n) {
        String string = this.visionType + " (" + n + "')";
        if (n <= 0) {
            string = this.visionType.toString();
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object instanceof Vision) {
            Vision vision = (Vision)object;
            return this.distance.equals(vision.distance) && this.visionType.equals(vision.visionType);
        }
        return false;
    }

    public int hashCode() {
        return this.distance.hashCode() ^ this.visionType.hashCode();
    }

    public String toString(PlayerCharacter playerCharacter) {
        return this.toString(playerCharacter.getVariableValue(this.distance, "").intValue());
    }

    @Override
    public int compareTo(Vision vision) {
        return this.toString().compareTo(vision.toString());
    }
}

