/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.List;
import pcgen.core.Equipment;
import pcgen.core.EquipmentModifier;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SizeAdjustment;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.util.Delta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeaponEquipment
implements Cloneable {
    private Equipment theEquipment;
    private String theDamage = "";
    private String theDamageMod = "";
    private Integer theRange = 0;
    private String theCritRange = "";
    private int theCritMult = 0;
    private String theRateOfFire = "";
    private String theWieldString = "";
    private boolean hasWield = false;
    private int theReach = 0;
    private int theReachMult = 1;
    private boolean doAttacksProgress = true;
    private String theAltDamage = "";
    private String theAltCritRange = "";
    private int theAltCritMult = 0;

    public WeaponEquipment(Equipment equipment) {
        this.setOwner(equipment);
    }

    public void setOwner(Equipment equipment) {
        this.theEquipment = equipment;
    }

    public int getBonusToDamage(PlayerCharacter playerCharacter, boolean bl) {
        return (int)this.theEquipment.bonusTo(playerCharacter, "WEAPON", "DAMAGE", bl);
    }

    public int getBonusToHit(PlayerCharacter playerCharacter, boolean bl) {
        return (int)this.theEquipment.bonusTo(playerCharacter, "WEAPON", "TOHIT", bl);
    }

    public String getCritRange(PlayerCharacter playerCharacter) {
        return this.getCritRange(playerCharacter, true);
    }

    public String getAltCritRange(PlayerCharacter playerCharacter) {
        return this.getCritRange(playerCharacter, false);
    }

    public int getCritRangeAdd(PlayerCharacter playerCharacter, boolean bl) {
        return (int)this.theEquipment.bonusTo(playerCharacter, "EQMWEAPON", "CRITRANGEADD", bl);
    }

    public int getCritRangeDouble(PlayerCharacter playerCharacter, boolean bl) {
        return (int)this.theEquipment.bonusTo(playerCharacter, "EQMWEAPON", "CRITRANGEDOUBLE", bl);
    }

    public void setDamage(String string) {
        this.theDamage = string;
    }

    public String getDamage(PlayerCharacter playerCharacter) {
        return this.getDamage(playerCharacter, true);
    }

    public String getAltDamage(PlayerCharacter playerCharacter) {
        return this.getDamage(playerCharacter, false);
    }

    public void setAltDamage(String string) {
        this.theAltDamage = string;
    }

    public void setRange(String string) {
        try {
            this.theRange = Delta.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public Integer getRange(PlayerCharacter playerCharacter) {
        String string;
        Integer n = this.theRange;
        if (n == 0 && (string = this.getWeaponInfo("RANGE", true)).length() != 0) {
            n = Integer.valueOf(string);
        }
        int n2 = n + (int)this.theEquipment.bonusTo(playerCharacter, "EQMWEAPON", "RANGEADD", true);
        int n3 = (int)this.theEquipment.bonusTo(playerCharacter, "EQMWEAPON", "RANGEMULT", true);
        double d = 1.0;
        if (n3 > 0) {
            d += (double)(n3 - 1);
        }
        int n4 = 0;
        if (playerCharacter != null) {
            if (this.theEquipment.isThrown()) {
                n2 += (int)playerCharacter.getTotalBonusTo("RANGEADD", "THROWN");
                n4 = (int)playerCharacter.getTotalBonusTo("POSTRANGEADD", "THROWN");
                d += (double)((int)playerCharacter.getTotalBonusTo("RANGEMULT", "THROWN")) / 100.0;
            } else if (this.theEquipment.isProjectile()) {
                n2 += (int)playerCharacter.getTotalBonusTo("RANGEADD", "PROJECTILE");
                n4 = (int)playerCharacter.getTotalBonusTo("POSTRANGEADD", "PROJECTILE");
                d += (double)((int)playerCharacter.getTotalBonusTo("RANGEMULT", "PROJECTILE")) / 100.0;
            }
        }
        n2 = (int)((double)n2 * d);
        if ((this.theEquipment.isRanged() || this.theEquipment.isThrown() || this.theEquipment.isProjectile()) && (n2 += n4) <= 0) {
            n2 = 10;
        }
        return n2;
    }

    public List<String> getRangeList(boolean bl, PlayerCharacter playerCharacter) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = n = this.getRange(playerCharacter).intValue();
        int n3 = 0;
        if (this.theEquipment.isRanged()) {
            n3 = this.theEquipment.isThrown() ? 5 : 10;
        }
        for (int i = 0; i < n3; ++i) {
            if (n2 == SettingsHandler.getGame().getShortRangeDistance()) {
                bl = false;
            }
            if (n2 > SettingsHandler.getGame().getShortRangeDistance() && bl) {
                arrayList.add(Integer.toString(SettingsHandler.getGame().getShortRangeDistance()));
                bl = false;
            }
            arrayList.add(Integer.toString(n2));
            n2 += n;
        }
        return arrayList;
    }

    public void setCritRange(String string) {
        this.theCritRange = string;
    }

    public void setAltCritRange(String string) {
        this.theAltCritRange = string;
    }

    public int getRawCritRange() {
        return this.getRawCritRange(true);
    }

    public int getRawCritRange(boolean bl) {
        String string;
        String string2 = string = bl ? this.theCritRange : this.theAltCritRange;
        if (string.length() == 0) {
            string = this.getWeaponInfo("CRITRANGE", true);
        }
        if (string.length() != 0) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public String getDamageMod() {
        return this.theDamageMod;
    }

    public void setDamageMod(String string) {
        this.theDamageMod = string;
    }

    public Integer getRange() {
        return this.theRange;
    }

    public WeaponEquipment clone() {
        WeaponEquipment weaponEquipment = null;
        try {
            weaponEquipment = (WeaponEquipment)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ShowMessageDelegate.showMessageDialog(cloneNotSupportedException.getMessage(), "PCGen", MessageType.ERROR);
        }
        return weaponEquipment;
    }

    private String getDamage(PlayerCharacter playerCharacter, boolean bl) {
        String string;
        String string2 = string = bl ? this.theDamage : this.theAltDamage;
        if (!this.theEquipment.isWeapon() || !bl && !this.theEquipment.isDouble()) {
            return string;
        }
        if (bl && this.theDamage.length() == 0 && this.theAltDamage.length() != 0) {
            string = this.theAltDamage;
        }
        if (bl && this.theDamageMod.length() != 0) {
            string = this.theDamageMod;
        }
        if (string.length() == 0) {
            string = this.getWeaponInfo("DAMAGE", bl);
        }
        int n = this.theEquipment.sizeInt();
        int n2 = n + (int)this.theEquipment.bonusTo(playerCharacter, "EQMWEAPON", "DAMAGESIZE", bl);
        if ((n2 += (int)this.theEquipment.bonusTo(playerCharacter, "WEAPON", "DAMAGESIZE", bl)) < 0) {
            n2 = 0;
        } else if (n2 >= SettingsHandler.getGame().getSizeAdjustmentListSize() - 1) {
            n2 = SettingsHandler.getGame().getSizeAdjustmentListSize() - 1;
        }
        SizeAdjustment sizeAdjustment = SettingsHandler.getGame().getSizeAdjustmentAtIndex(n2);
        String string3 = "";
        if (sizeAdjustment != null) {
            string3 = sizeAdjustment.getAbbreviation();
        }
        return this.adjustDamage(string, string3);
    }

    private String getWeaponInfo(String string, boolean bl) {
        String string2 = string + "|";
        EquipmentModifier equipmentModifier = this.theEquipment.getEqModifierKeyed("PCGENi_WEAPON", bl);
        if (equipmentModifier != null) {
            for (int i = 0; i < equipmentModifier.getAssociatedCount(); ++i) {
                String string3 = equipmentModifier.getAssociated(i);
                if (!string3.startsWith(string2)) continue;
                return string3.substring(string2.length());
            }
        }
        return "";
    }

    private String getCritRange(PlayerCharacter playerCharacter, boolean bl) {
        String string;
        String string2 = string = bl ? this.theCritRange : this.theAltCritRange;
        if (string.length() == 0) {
            string = this.getWeaponInfo("CRITRANGE", bl);
        }
        if (string.length() == 0 || !bl && !this.theEquipment.isDouble()) {
            return "";
        }
        return Integer.toString(this.getRawCritRange(bl) * (this.getCritRangeDouble(playerCharacter, bl) + 1) + this.getCritRangeAdd(playerCharacter, bl));
    }

    private String adjustDamage(String string, String string2) {
        if (!string.equalsIgnoreCase("special") && !string.equals("-")) {
            return Globals.adjustDamage(string, this.theEquipment.getSize(), string2);
        }
        return string;
    }

    protected String getAltDamageAdjustedForSize(String string) {
        return this.getDamageAdjustedForSize(string, false);
    }

    private String getDamageAdjustedForSize(String string, boolean bl) {
        String string2;
        String string3 = string2 = bl ? this.theDamage : this.theAltDamage;
        if (this.theEquipment.isWeapon()) {
            if (string2.length() == 0) {
                string2 = this.getWeaponInfo("DAMAGE", bl);
            }
            if (string2.length() != 0) {
                return this.adjustDamage(string2, string);
            }
        }
        return string2;
    }

    protected String getDamageAdjustedForSize(String string) {
        return this.getDamageAdjustedForSize(string, true);
    }

    private int getCritMultiplier(boolean bl) {
        String string;
        int n;
        int n2 = n = bl ? this.theCritMult : this.theAltCritMult;
        if (n == 0 && (string = this.getWeaponInfo("CRITMULT", bl)).length() != 0) {
            n = Integer.parseInt(string);
        }
        return n;
    }

    public void setCritMult(int n) {
        this.theCritMult = n;
    }

    public String getCritMult() {
        return WeaponEquipment.multAsString(this.getCritMultiplier(true));
    }

    public int getRawCritMult() {
        return this.theCritMult;
    }

    public void setAltCritMult(int n) {
        this.theAltCritMult = n;
    }

    public String getAltCritMult() {
        if (this.theAltCritMult == 0) {
            return this.getCritMult();
        }
        return WeaponEquipment.multAsString(this.getCritMultiplier(false));
    }

    public int getRawAltCritMult() {
        return this.theAltCritMult;
    }

    public int getCritMultiplier() {
        return WeaponEquipment.multAsInt(this.getCritMultiplier(true));
    }

    public int getAltCritMultiplier() {
        if (this.theAltCritMult == 0) {
            return this.getCritMultiplier();
        }
        return WeaponEquipment.multAsInt(this.getCritMultiplier(false));
    }

    private static int multAsInt(int n) {
        if (n < 0) {
            return 0;
        }
        return n;
    }

    private static String multAsString(int n) {
        if (n == 0) {
            return "";
        }
        if (n < 0) {
            return "-";
        }
        return "x" + Integer.toString(n);
    }

    public void setRateOfFire(String string) {
        this.theRateOfFire = string;
    }

    public String getRateOfFire() {
        return this.theRateOfFire;
    }

    public void setWield(String string) {
        this.theWieldString = string;
        this.hasWield = true;
    }

    public String getWield() {
        return this.theWieldString;
    }

    public boolean hasWield() {
        return this.hasWield;
    }

    public void setReach(int n) {
        this.theReach = n;
    }

    public int getReach() {
        return this.theReach;
    }

    public void setAttacksProgress(boolean bl) {
        this.doAttacksProgress = bl;
    }

    public boolean isAttacksProgress() {
        return this.doAttacksProgress;
    }

    public void setReachMult(int n) {
        this.theReachMult = n;
    }

    public int getReachMult() {
        return this.theReachMult;
    }
}

