/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.bonus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.Equipment;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.PrereqObject;
import pcgen.core.bonus.Bonus;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.utils.CoreUtility;
import pcgen.util.Delta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BonusObj
extends PrereqObject
implements Serializable,
Cloneable {
    private List<Object> bonusInfo = new ArrayList<Object>();
    private Map<String, String> dependMap = new HashMap<String, String>();
    private Object bonusValue;
    private Object creatorObj;
    private Object targetObj;
    private String bonusName = "";
    private String bonusType = "";
    private String varPart = "";
    private boolean isApplied;
    private boolean valueIsStatic = true;
    private int pcLevel = -1;
    private int typeOfBonus = -1;
    private String stringRepresentation = null;
    private boolean addOnceOnly = false;
    private StackType theStackingFlag = StackType.NORMAL;
    private static final String VALUE_TOKEN_REPLACEMENT = "%LIST";
    private static final String LIST_TOKEN_REPLACEMENT = "LIST";

    public void setApplied(boolean bl) {
        this.isApplied = bl;
    }

    public boolean isApplied() {
        return this.isApplied;
    }

    public String getBonusInfo() {
        StringBuffer stringBuffer = new StringBuffer(50);
        if (this.bonusInfo.size() > 0) {
            for (int i = 0; i < this.bonusInfo.size(); ++i) {
                stringBuffer.append(i == 0 ? "" : ",");
                stringBuffer.append(this.unparseToken(this.bonusInfo.get(i)));
            }
        } else {
            stringBuffer.append("|ERROR");
        }
        return stringBuffer.toString().toUpperCase();
    }

    public List<String> getUnparsedBonusInfoList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object : this.bonusInfo) {
            arrayList.add(this.unparseToken(object));
        }
        return arrayList;
    }

    public List<?> getBonusInfoList() {
        return this.bonusInfo;
    }

    public String getBonusName() {
        return this.bonusName;
    }

    public void setCreatorObject(Object object) {
        this.creatorObj = object;
    }

    public Object getCreatorObject() {
        return this.creatorObj;
    }

    public boolean getDependsOn(String string) {
        return this.dependMap.containsKey(string);
    }

    public boolean getDependsOn(List<String> list) {
        for (String string : list) {
            if (!this.dependMap.containsKey(string)) continue;
            return true;
        }
        return false;
    }

    public String listDependsMap() {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (String string : this.dependMap.keySet()) {
            if (stringBuffer.length() > 1) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String getName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.creatorObj instanceof PlayerCharacter) {
            stringBuffer.append(((PlayerCharacter)this.creatorObj).getName());
        } else if (this.creatorObj instanceof PObject) {
            stringBuffer.append(this.creatorObj.toString());
        } else {
            stringBuffer.append("NONE");
        }
        stringBuffer.append(" [");
        if (this.targetObj instanceof PlayerCharacter) {
            stringBuffer.append("PC");
        } else if (this.targetObj instanceof Equipment) {
            stringBuffer.append(((Equipment)this.targetObj).getName());
        } else {
            stringBuffer.append("NONE");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public void setPCLevel(int n) {
        this.pcLevel = n;
    }

    public int getPCLevel() {
        return this.pcLevel;
    }

    public boolean isTempBonus() {
        if (!this.hasPreReqs()) {
            return false;
        }
        for (Prerequisite prerequisite : this.getPreReqList()) {
            if (prerequisite.getKind() == null || !prerequisite.getKind().equalsIgnoreCase("APPLY")) continue;
            return true;
        }
        return false;
    }

    public boolean isTempBonusTarget(TempBonusTarget tempBonusTarget) {
        if (!this.isTempBonus() || !this.hasPreReqs()) {
            return false;
        }
        for (Prerequisite prerequisite : this.getPreReqList()) {
            if (prerequisite.getOperand().equalsIgnoreCase(tempBonusTarget.toString())) {
                return true;
            }
            for (Prerequisite prerequisite2 : prerequisite.getPrerequisites()) {
                if (!prerequisite2.getOperand().equalsIgnoreCase(tempBonusTarget.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public void setTargetObject(Object object) {
        this.targetObj = object;
    }

    public Object getTargetObject() {
        return this.targetObj;
    }

    public String getTypeOfBonus() {
        return Bonus.getBonusNameFromType(this.typeOfBonus);
    }

    public int getTypeOfBonusAsInt() {
        return this.typeOfBonus;
    }

    public String getTypeString() {
        return this.bonusType;
    }

    public void setValue(String string) {
        try {
            this.bonusValue = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                this.bonusValue = new Float(string);
            }
            catch (Exception exception) {
                this.bonusValue = string.toUpperCase();
                this.valueIsStatic = false;
                this.buildDependMap(string.toUpperCase());
            }
        }
    }

    public String getValue() {
        return this.bonusValue.toString();
    }

    public double getValueAsdouble() {
        return Double.parseDouble(this.bonusValue.toString());
    }

    public double getCalculatedValue(PlayerCharacter playerCharacter) {
        double d = 0.0;
        if (this.bonusValue != null) {
            d = this.bonusValue instanceof Integer ? (double)((Integer)this.bonusValue).longValue() : (this.bonusValue instanceof Float ? (double)((Float)this.bonusValue).floatValue() : (this.bonusValue instanceof String && this.creatorObj instanceof PObject ? ((PObject)this.creatorObj).calcBonusFrom(this, playerCharacter, "", playerCharacter) : this.getValueAsdouble()));
        }
        return d;
    }

    public boolean isValueStatic() {
        return this.valueIsStatic;
    }

    public void setVariable(String string) {
        this.varPart = string.toUpperCase();
    }

    public String getVariable() {
        return this.varPart;
    }

    public boolean hasTypeString() {
        return this.bonusType.length() > 0;
    }

    public boolean hasVariable() {
        return this.varPart.length() > 0;
    }

    @Override
    public String getPCCText() {
        if (this.stringRepresentation == null) {
            StringBuffer stringBuffer = new StringBuffer(50);
            if (this.pcLevel >= 0) {
                stringBuffer.append(this.pcLevel).append('|');
            }
            stringBuffer.append(this.getTypeOfBonus());
            if (this.varPart != null && this.varPart.length() > 0) {
                stringBuffer.append(this.varPart);
            }
            if (this.bonusInfo.size() > 0) {
                for (int i = 0; i < this.bonusInfo.size(); ++i) {
                    stringBuffer.append(i == 0 ? (char)'|' : ',').append(this.unparseToken(this.bonusInfo.get(i)));
                }
            } else {
                stringBuffer.append("|ERROR");
            }
            if (this.bonusValue != null) {
                stringBuffer.append('|').append(this.bonusValue.toString());
            }
            stringBuffer.append(super.getPCCText());
            if (this.bonusType.length() != 0) {
                stringBuffer.append("|TYPE=").append(this.bonusType);
            }
            this.stringRepresentation = stringBuffer.toString();
        }
        return this.stringRepresentation;
    }

    public String toString() {
        return this.getPCCText();
    }

    public String getDescription(boolean bl, PlayerCharacter playerCharacter) {
        StringBuffer stringBuffer = new StringBuffer(50);
        if (this.bonusValue != null) {
            if (this.bonusValue instanceof Integer) {
                stringBuffer.append(Delta.toString((Integer)this.bonusValue));
            } else if (this.bonusValue instanceof Float) {
                stringBuffer.append(Delta.toString((Float)this.bonusValue));
            } else if (this.bonusValue instanceof String && this.creatorObj instanceof PObject) {
                stringBuffer.append(Delta.toString((float)((PObject)this.creatorObj).calcBonusFrom(this, playerCharacter, "", playerCharacter)));
            } else {
                stringBuffer.append(this.bonusValue.toString());
            }
        } else {
            stringBuffer.append("+0");
        }
        boolean bl2 = true;
        stringBuffer.append('[');
        if (this.hasPreReqs()) {
            for (Prerequisite prerequisite : this.getPreReqList()) {
                if (!bl2) {
                    stringBuffer.append('|');
                }
                stringBuffer.append(prerequisite.getDescription(bl));
                bl2 = false;
            }
        }
        if (this.bonusType.length() != 0) {
            if (!bl) {
                if (!bl2) {
                    stringBuffer.append('|');
                }
                stringBuffer.append("TYPE=");
                bl2 = false;
            }
            if (!bl || stringBuffer.charAt(stringBuffer.length() - 1) == '[') {
                stringBuffer.append(this.bonusType);
                bl2 = false;
            }
        }
        if (bl2) {
            stringBuffer.append(this.getTypeOfBonus());
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    protected void setBonusName(String string) {
        this.bonusName = string;
    }

    protected void setTypeOfBonus(int n) {
        this.typeOfBonus = n;
    }

    protected void addBonusInfo(Object object) {
        this.bonusInfo.add(object);
    }

    protected void replaceBonusInfo(Object object, Object object2) {
        for (int i = 0; i < this.bonusInfo.size(); ++i) {
            Object object3 = this.bonusInfo.get(i);
            if (object3 != object) continue;
            this.bonusInfo.set(i, object2);
            break;
        }
    }

    protected boolean addType(String string) {
        if (this.bonusType.length() == 0) {
            this.bonusType = string.toUpperCase();
            return true;
        }
        return false;
    }

    public void setStackingFlag(StackType stackType) {
        this.theStackingFlag = stackType;
    }

    public StackType getStackingFlag() {
        return this.theStackingFlag;
    }

    public boolean isAddOnceOnly() {
        return this.addOnceOnly;
    }

    public void setAddOnceOnly(boolean bl) {
        this.addOnceOnly = bl;
    }

    protected boolean parseToken(String string) {
        System.err.println("Need to override parseToken in " + this.getClass().getName());
        return false;
    }

    protected String unparseToken(Object object) {
        System.err.println("Need to override unparseToken in " + this.getClass().getName());
        return "";
    }

    protected String[] getBonusesHandled() {
        System.err.println("Need to override getBonusesHandled " + this.getClass().getName());
        return new String[]{""};
    }

    private void buildDependMap(String string) {
        Object object;
        if (string.indexOf("SKILLINFO(") >= 0) {
            this.dependMap.put("JEPFORMULA", "1");
        }
        while (string.lastIndexOf(40) >= 0) {
            int n = CoreUtility.innerMostStringStart(string);
            int n2 = CoreUtility.innerMostStringEnd(string);
            if (n2 < n) {
                return;
            }
            object = string.substring(n + 1, n2);
            this.buildDependMap((String)object);
            string = new StringBuffer().append(string.substring(0, n)).append(string.substring(n2 + 1)).toString();
        }
        if (string.indexOf("(") >= 0 || string.indexOf(")") >= 0 || string.indexOf("%") >= 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".,");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("IF".equals(string2) || "THEN".equals(string2) || "ELSE".equals(string2) || "GT".equals(string2) || "GTEQ".equals(string2) || "EQ".equals(string2) || "LTEQ".equals(string2) || "LT".equals(string2)) continue;
            object = new StringTokenizer(string2, "+-/*>=<\"");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string3;
                String string4 = string3 = ((StringTokenizer)object).nextToken();
                boolean bl = false;
                while (!bl) {
                    if (string3.indexOf("MAX") >= 0) {
                        string4 = string3.substring(0, string3.indexOf("MAX"));
                        string3 = string3.substring(string3.indexOf("MAX") + 3);
                    } else if (string3.indexOf("MIN") >= 0) {
                        string4 = string3.substring(0, string3.indexOf("MIN"));
                        string3 = string3.substring(string3.indexOf("MIN") + 3);
                    } else {
                        bl = true;
                    }
                    try {
                        Float.parseFloat(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (string4.length() <= 0) continue;
                        if (string4.startsWith("MOVE[")) {
                            string4 = new StringBuffer().append("TYPE.").append(string4.substring(5, string4.length() - 1)).toString();
                        }
                        this.dependMap.put(string4, "1");
                    }
                }
            }
        }
    }

    @Override
    public BonusObj clone() throws CloneNotSupportedException {
        BonusObj bonusObj = (BonusObj)super.clone();
        bonusObj.bonusInfo = new ArrayList<Object>(this.bonusInfo);
        bonusObj.dependMap = new HashMap<String, String>();
        if (this.bonusValue != null) {
            bonusObj.setValue(this.bonusValue.toString());
        }
        return bonusObj;
    }

    public void expandToken(String string, String string2) {
        String string3 = this.getValue();
        this.setValue(CoreUtility.replaceAll(string3, string, string2));
        if (this.hasPreReqs()) {
            for (Prerequisite prerequisite : this.getPreReqList()) {
                prerequisite.expandToken(string, string2);
            }
        }
    }

    public List<String> getStringListFromBonus(PObject pObject) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getBonusInfo();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            CharSequence charSequence;
            String string2 = stringTokenizer.nextToken();
            if (pObject.getAssociatedCount() > 0) {
                String string3;
                StringBuffer stringBuffer;
                int n2;
                charSequence = this.getBonusName();
                if (((String)charSequence).indexOf(VALUE_TOKEN_REPLACEMENT) >= 0) {
                    for (n2 = 0; n2 < pObject.getAssociatedCount(); ++n2) {
                        stringBuffer = new StringBuffer();
                        string3 = CoreUtility.replaceFirst((String)charSequence, VALUE_TOKEN_REPLACEMENT, pObject.getAssociated(n2));
                        stringBuffer.append(string3).append('.');
                        stringBuffer.append(string2);
                        if (this.hasTypeString()) {
                            stringBuffer.append(':').append(this.getTypeString());
                        }
                        arrayList.add(stringBuffer.toString().toUpperCase());
                    }
                    continue;
                }
                if (string2.indexOf(VALUE_TOKEN_REPLACEMENT) >= 0) {
                    for (n2 = 0; n2 < pObject.getAssociatedCount(true); ++n2) {
                        stringBuffer = new StringBuffer();
                        string3 = CoreUtility.replaceFirst(string2, VALUE_TOKEN_REPLACEMENT, pObject.getAssociated(n2, true));
                        stringBuffer.append(this.getTypeOfBonus()).append('.');
                        stringBuffer.append(string3);
                        if (this.hasTypeString()) {
                            stringBuffer.append(':').append(this.getTypeString());
                        }
                        arrayList.add(stringBuffer.toString().toUpperCase());
                    }
                    continue;
                }
                n2 = pObject.getAssociatedCount();
                if (n2 <= n && string2.equals(LIST_TOKEN_REPLACEMENT)) continue;
                do {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(this.getTypeOfBonus()).append('.');
                    if (string2.equals(LIST_TOKEN_REPLACEMENT)) {
                        stringBuffer.append(pObject.getAssociated(n));
                    } else {
                        stringBuffer.append(string2);
                    }
                    if (this.hasTypeString()) {
                        stringBuffer.append(':').append(this.getTypeString());
                    }
                    arrayList.add(stringBuffer.toString().toUpperCase());
                } while (stringTokenizer.countTokens() <= 0 && ++n < n2 && !this.addOnceOnly);
                continue;
            }
            if (this.hasVariable()) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append(this.getTypeOfBonus());
                ((StringBuffer)charSequence).append(this.getVariable()).append('.');
                ((StringBuffer)charSequence).append(string2);
                if (this.hasTypeString()) {
                    ((StringBuffer)charSequence).append(':').append(this.getTypeString());
                }
                arrayList.add(((StringBuffer)charSequence).toString().toUpperCase());
                continue;
            }
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(this.getTypeOfBonus()).append('.');
            ((StringBuffer)charSequence).append(string2);
            if (this.hasTypeString()) {
                ((StringBuffer)charSequence).append(':').append(this.getTypeString());
            }
            arrayList.add(((StringBuffer)charSequence).toString().toUpperCase());
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TempBonusTarget {
        PC,
        ANYPC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StackType {
        NORMAL,
        STACK,
        REPLACE;

    }
}

