/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.chooser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import pcgen.core.Categorisable;
import pcgen.core.CategorisableStore;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.chooser.AbstractComplexChoiceManager;
import pcgen.core.chooser.ChoiceManagerCategorisable;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCategorisableChoiceManager
extends AbstractComplexChoiceManager<Categorisable>
implements ChoiceManagerCategorisable {
    HashMap<String, Categorisable> nameMap = new HashMap();
    HashMap<String, Categorisable> catMap = new HashMap();
    boolean useNameMap = true;

    public AbstractCategorisableChoiceManager(PObject pObject, PlayerCharacter playerCharacter) {
        super(pObject, playerCharacter);
    }

    @Override
    public void initialise(int n, int n2, int n3) {
        this.numberOfChoices = n;
        this.requestedSelections = n2;
        this.maxNewSelections = n3;
    }

    @Override
    public List<Categorisable> doChooser(PlayerCharacter playerCharacter, List<Categorisable> list, List<Categorisable> list2) {
        Logging.errorPrint("Wrong doChooser called, there is a bug somewhere");
        return Collections.emptyList();
    }

    public List doChooser(CategorisableStore categorisableStore, List list) {
        if (this.requestedSelections < 0) {
            this.requestedSelections = this.maxNewSelections;
        } else {
            this.requestedSelections -= list.size();
            this.requestedSelections = Math.min(this.requestedSelections, this.maxNewSelections);
        }
        int n = list.size();
        if (this.numberOfChoices > 0) {
            this.requestedSelections = this.numberOfChoices = Math.min(this.numberOfChoices, categorisableStore.size() - n);
        }
        boolean bl = true;
        Object object = categorisableStore.getKeyIterator("ALL");
        while (object.hasNext()) {
            this.addToMaps(object.next());
        }
        object = this.useNameMap ? new ArrayList<String>(this.nameMap.keySet()) : new ArrayList<String>(this.catMap.keySet());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Categorisable categorisable : list) {
            if (categorisableStore.getKeyed(categorisable.getCategory(), categorisable.getKeyName()) != null) {
                arrayList.add(this.useNameMap ? categorisable.getKeyName() : categorisable.getCategory() + " " + categorisable.getKeyName());
                continue;
            }
            Logging.errorPrint("alleged previous choice is not valid, Category = " + categorisable.getCategory() + ", Key = " + categorisable.getKeyName());
        }
        ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
        chooserInterface.setPoolFlag(false);
        chooserInterface.setAllowsDups(this.dupsAllowed);
        chooserInterface.setVisible(false);
        chooserInterface.setPool(this.requestedSelections);
        this.title = this.title + " (" + this.pobject.getDisplayName() + ')';
        chooserInterface.setTitle(this.title);
        Globals.sortChooserLists((List)object, arrayList);
        while (true) {
            chooserInterface.setAvailableList((List)object);
            chooserInterface.setSelectedList(arrayList);
            chooserInterface.setVisible(bl);
            int n2 = chooserInterface.getSelectedList().size() - n;
            if (this.numberOfChoices <= 0 || n2 == this.numberOfChoices) break;
            ShowMessageDelegate.showMessageDialog("You must make " + (this.numberOfChoices - n2) + " more selection(s).", "PCGen", MessageType.INFORMATION);
        }
        ArrayList<Categorisable> arrayList2 = new ArrayList<Categorisable>();
        for (String string : chooserInterface.getSelectedList()) {
            Categorisable categorisable = this.useNameMap ? this.nameMap.get(string) : this.catMap.get(string);
            arrayList2.add(categorisable);
        }
        return arrayList2;
    }

    protected void addToMaps(Categorisable categorisable) {
        Categorisable categorisable2 = this.nameMap.put(categorisable.getKeyName(), categorisable);
        this.catMap.put(categorisable.getCategory() + " " + categorisable.getKeyName(), categorisable);
        if (categorisable2 != null) {
            this.useNameMap = false;
        }
    }
}

