/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.chooser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.chooser.AbstractSimpleChoiceManager;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComplexChoiceManager<T>
extends AbstractSimpleChoiceManager<T> {
    protected boolean multiples = false;
    protected double cost = 1.0;
    protected boolean valid = true;
    protected int requestedSelections = -1;
    protected int maxNewSelections = 0;
    protected int maxSelections = 0;
    protected boolean remove = false;
    protected boolean infiniteAvail = false;
    protected int preChooserChoices = 0;
    protected AbilityCategory poolAbilityCat = null;

    public AbstractComplexChoiceManager(PObject pObject, PlayerCharacter playerCharacter) {
        super(pObject, playerCharacter);
    }

    public AbstractComplexChoiceManager(PObject pObject, String string, PlayerCharacter playerCharacter) {
        super(pObject, playerCharacter);
        this.initialise(string, playerCharacter);
    }

    private void initialise(String string, PlayerCharacter playerCharacter) {
        if (this.pobject instanceof Ability) {
            this.cost = ((Ability)this.pobject).getCost();
            this.dupsAllowed = ((Ability)this.pobject).isStacks();
            this.multiples = ((Ability)this.pobject).isMultiples();
        }
        List<String> list = Arrays.asList(string.split("[|]"));
        List<String> list2 = Arrays.asList(list.get(0).split("="));
        int n = -1;
        while (list2.get(0).equals("COUNT") || list2.get(0).equals("NUMCHOICES")) {
            String string2;
            if (++n == list.size()) {
                Logging.errorPrint("not enough tokens: " + string);
                this.valid = false;
                break;
            }
            list2 = Arrays.asList(list.get(n).split("="));
            if (list2.get(0).equals("COUNT")) {
                string2 = list2.get(1);
                this.requestedSelections = playerCharacter.getVariableValue(string2, "").intValue();
                continue;
            }
            if (!list2.get(0).equals("NUMCHOICES")) break;
            string2 = list2.get(1);
            this.numberOfChoices = playerCharacter.getVariableValue(string2, "").intValue();
        }
        if (!this.valid || n >= list.size()) {
            this.choices = Collections.emptyList();
            return;
        }
        n = n >= 0 ? n : 0;
        this.choices = list.subList(n, list.size());
        this.calcPool(playerCharacter);
    }

    protected void calcPool(PlayerCharacter playerCharacter) {
        double d = 0.0;
        if (this.pobject instanceof Ability) {
            AbilityCategory abilityCategory = this.poolAbilityCat != null ? this.poolAbilityCat : SettingsHandler.getGame().getAbilityCategory(((Ability)this.pobject).getCategory());
            d = this.pc.getAvailableAbilityPool(abilityCategory).doubleValue();
        } else {
            d = playerCharacter.getRawFeats(true);
        }
        this.maxSelections = this.cost <= 0.0 ? (int)(d + (double)this.pobject.getAssociatedCount()) : (int)((d + (double)this.pobject.getAssociatedCount()) / this.cost);
        int n = this.maxNewSelections = this.cost <= 0.0 ? (int)d : (int)(d / this.cost);
        if (this.cost == 0.0 && this.maxNewSelections == 0) {
            this.maxNewSelections = this.numberOfChoices > 0 ? this.numberOfChoices : 1;
        }
    }

    final boolean isValid() {
        return this.valid;
    }

    @Override
    public void doChooserRemove(PlayerCharacter playerCharacter, List<T> list, List<T> list2) {
        this.remove = true;
        List<T> list3 = this.doChooser(playerCharacter, list, list2);
        this.applyChoices(playerCharacter, list3);
        this.remove = false;
    }

    @Override
    public List<T> doChooser(PlayerCharacter playerCharacter, List<T> list, List<T> list2) {
        if (this.requestedSelections < 0) {
            this.requestedSelections = this.maxNewSelections;
        } else {
            this.requestedSelections -= list2.size();
            this.requestedSelections = Math.min(this.requestedSelections, this.maxNewSelections);
        }
        this.preChooserChoices = list2.size();
        int n = this.numberOfChoices;
        if (n > 0 && !this.infiniteAvail) {
            n = Math.min(n, list.size() - this.preChooserChoices);
            if (this.requestedSelections > 0) {
                this.requestedSelections = n;
            } else {
                n = 0;
            }
        }
        boolean bl = true;
        if (!this.infiniteAvail && list.size() == 1 && "NOCHOICE".equals(list.get(0).toString())) {
            if (this.remove) {
                try {
                    list2.remove(0);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            } else {
                list2.add(null);
            }
            bl = false;
            this.numberOfChoices = 0;
            n = 0;
        }
        ChooserInterface chooserInterface = this.getChooserInstance();
        chooserInterface.setPoolFlag(false);
        chooserInterface.setAllowsDups(this.dupsAllowed);
        chooserInterface.setVisible(false);
        chooserInterface.setPool(this.requestedSelections);
        Globals.sortChooserLists(list, list2);
        while (true) {
            chooserInterface.setAvailableList(list);
            chooserInterface.setSelectedList(list2);
            chooserInterface.setVisible(bl);
            int n2 = chooserInterface.getSelectedList().size() - this.preChooserChoices;
            if (n <= 0 || n2 == n) break;
            ShowMessageDelegate.showMessageDialog("You must make " + (n - n2) + " more selection(s).", "PCGen", MessageType.INFORMATION);
        }
        List list3 = chooserInterface.getSelectedList();
        if (list.get(0) instanceof PObject && list3.size() > 0 && !(list3.get(0) instanceof PObject)) {
            ArrayList<PObject> arrayList = new ArrayList<PObject>();
            for (String string : list3) {
                for (PObject pObject : list) {
                    if (!string.equalsIgnoreCase(pObject.getDisplayName())) continue;
                    arrayList.add(pObject);
                }
            }
            chooserInterface.setSelectedList(arrayList);
        }
        return chooserInterface.getSelectedList();
    }

    protected ChooserInterface getChooserInstance() {
        ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
        this.title = this.title + " (" + this.pobject.getDisplayName() + ')';
        chooserInterface.setTitle(this.title);
        return chooserInterface;
    }

    @Override
    public String typeHandled() {
        return this.chooserHandled;
    }

    @Override
    public void applyChoices(PlayerCharacter playerCharacter, List<T> list) {
        String string;
        this.cleanUpAssociated(playerCharacter, list.size());
        String string2 = string = this.pobject instanceof Domain ? this.chooserHandled + '?' : "";
        if (this.pobject instanceof Ability) {
            this.pobject.clearSelectedWeaponProfBonus();
        }
        for (T t : list) {
            if (t != null) {
                String string3 = t.toString();
                if (t instanceof PObject) {
                    string3 = ((PObject)t).getKeyName();
                }
                this.associateChoice(playerCharacter, string3, string);
                continue;
            }
            this.pobject.addAssociated("");
        }
        if (this.pobject instanceof Ability && ((Ability)this.pobject).isFeat()) {
            this.adjustFeats(playerCharacter, list);
        }
        if (string.length() != 0) {
            playerCharacter.setAutomaticAbilitiesStable(null, false);
        }
    }

    protected void cleanUpAssociated(PlayerCharacter playerCharacter, int n) {
        this.pobject.clearAssociated();
    }

    protected void associateChoice(PlayerCharacter playerCharacter, String string, String string2) {
        String string3 = string2 + string;
        if (this.multiples && !this.dupsAllowed) {
            if (!this.pobject.containsAssociated(string3)) {
                this.pobject.addAssociated(string3);
            }
        } else {
            this.pobject.addAssociated(string3);
        }
    }

    protected void adjustFeats(PlayerCharacter playerCharacter, List<T> list) {
        double d = playerCharacter.getFeats();
        if (this.cost > 0.0) {
            d = this.numberOfChoices > 0 ? d - (double)((list.size() - this.preChooserChoices) / this.numberOfChoices) * this.cost : (double)(this.maxSelections - list.size()) * this.cost;
        }
        playerCharacter.adjustFeats(d - playerCharacter.getFeats());
    }

    public AbilityCategory getPoolAbilityCat() {
        return this.poolAbilityCat;
    }

    public void setPoolAbilityCat(AbilityCategory abilityCategory) {
        this.poolAbilityCat = abilityCategory;
        this.calcPool(this.pc);
    }
}

