/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.chooser;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pcgen.core.AbilityCategory;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.chooser.AbstractComplexChoiceManager;
import pcgen.core.chooser.ArmorTypeChoiceManager;
import pcgen.core.chooser.ChoiceManagerList;
import pcgen.core.chooser.ClassSkillsChoiceManager;
import pcgen.core.chooser.DomainChoiceManager;
import pcgen.core.chooser.EquipmentTypeChoiceManager;
import pcgen.core.chooser.FeatAddChoiceManager;
import pcgen.core.chooser.FeatChoiceManager;
import pcgen.core.chooser.FeatListChoiceManager;
import pcgen.core.chooser.FeatSelectChoiceManager;
import pcgen.core.chooser.HPChoiceManager;
import pcgen.core.chooser.MiscChoiceManager;
import pcgen.core.chooser.ProficiencyChoiceManager;
import pcgen.core.chooser.RaceChoiceManager;
import pcgen.core.chooser.SAListChoiceManager;
import pcgen.core.chooser.SchoolsChoiceManager;
import pcgen.core.chooser.SimpleArmorProfChoiceManager;
import pcgen.core.chooser.SimpleFeatChoiceManager;
import pcgen.core.chooser.SimpleShieldProfChoiceManager;
import pcgen.core.chooser.SimpleWeaponProfChoiceManager;
import pcgen.core.chooser.SkillListChoiceManager;
import pcgen.core.chooser.SkillListCrossClassChoiceManager;
import pcgen.core.chooser.SkillListNonClassChoiceManager;
import pcgen.core.chooser.SkillsChoiceManager;
import pcgen.core.chooser.SkillsNamedChoiceManager;
import pcgen.core.chooser.SkillsNamedToCCSkillChoiceManager;
import pcgen.core.chooser.SkillsNamedToCSkillChoiceManager;
import pcgen.core.chooser.SpellClassesChoiceManager;
import pcgen.core.chooser.SpellLevelChoiceManager;
import pcgen.core.chooser.SpellListChoiceManager;
import pcgen.core.chooser.SpellsChoiceManager;
import pcgen.core.chooser.StatChoiceManager;
import pcgen.core.chooser.UserInputChoiceManager;
import pcgen.core.chooser.WeaponFocusChoiceManager;
import pcgen.core.chooser.WeaponProfChoiceManager;
import pcgen.core.chooser.WeaponProfTypeChoiceManager;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChooserUtilities {
    private static Map<String, String> classLookup = null;
    private static boolean mapconstructed = false;

    public static final void buildSpellTypeChoices(List<String> list, List<String> list2, PlayerCharacter playerCharacter, Enumeration<String> enumeration) {
        enumeration.nextElement();
        while (enumeration.hasMoreElements()) {
            int n;
            String string = enumeration.nextElement();
            while (!(string.startsWith("CLASS=") || string.startsWith("CLASS.") || string.startsWith("TYPE=") || string.startsWith("TYPE.") || !enumeration.hasMoreElements())) {
                string = enumeration.nextElement();
            }
            if (!enumeration.hasMoreElements()) break;
            boolean bl = false;
            int n2 = 1;
            try {
                n2 = Integer.parseInt(enumeration.nextElement());
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint("Badly formed minLevel token: " + string);
            }
            String string2 = enumeration.nextElement();
            if (string2.endsWith(".A")) {
                bl = true;
                string2 = string2.substring(0, string2.lastIndexOf(".A"));
            }
            int n3 = n2;
            if (string.startsWith("CLASS=") || string.startsWith("CLASS.")) {
                PCClass pCClass = playerCharacter.getClassKeyed(string.substring(6));
                if (string2.indexOf("MAXLEVEL") >= 0) {
                    int n4 = pCClass == null ? 0 : pCClass.getMaxSpellLevelForClassLevel(pCClass.getLevel());
                    string2 = string2.replaceAll("MAXLEVEL", String.valueOf(n4));
                }
                n3 = playerCharacter.getVariableValue(string2, "").intValue();
                if (pCClass != null) {
                    String string3 = pCClass.getKeyName() + " ";
                    for (n = n2; n <= n3; ++n) {
                        String string4 = string3 + n;
                        if (!list.contains(string4)) {
                            list.add(string4);
                        }
                        if (n != n3 || !bl) continue;
                        list2.add(string4);
                    }
                }
            }
            if (!string.startsWith("TYPE=") && !string.startsWith("TYPE.")) continue;
            string = string.substring(5);
            for (PCClass pCClass : playerCharacter.getClassList()) {
                if (!pCClass.getSpellType().equals(string)) continue;
                if (string2.indexOf("MAXLEVEL") >= 0) {
                    n = ChooserUtilities.calcMaxSpellLevel(pCClass, string, playerCharacter);
                    string2 = string2.replaceAll("MAXLEVEL", String.valueOf(n));
                }
                n3 = playerCharacter.getVariableValue(string2, "").intValue();
                String string5 = pCClass.getKeyName() + " ";
                for (int i = n2; i <= n3; ++i) {
                    String string6 = string5 + i;
                    if (!list.contains(string6)) {
                        list.add(string6);
                    }
                    if (i != n3 || !bl) continue;
                    list2.add(string6);
                }
            }
        }
    }

    private static int calcMaxSpellLevel(PCClass pCClass, String string, PlayerCharacter playerCharacter) {
        if (pCClass == null) {
            return 0;
        }
        int n = pCClass.getLevel();
        n += (int)playerCharacter.getTotalBonusTo("PCLEVEL", pCClass.getKeyName());
        return pCClass.getMaxSpellLevelForClassLevel(n += (int)playerCharacter.getTotalBonusTo("PCLEVEL", "TYPE." + string));
    }

    public static final boolean modChoices(PObject pObject, List list, List list2, boolean bl, PlayerCharacter playerCharacter, boolean bl2, AbilityCategory abilityCategory) {
        list.clear();
        list2.clear();
        ChoiceManagerList choiceManagerList = ChooserUtilities.getChoiceManager(pObject, "", playerCharacter);
        if (choiceManagerList == null) {
            return false;
        }
        if (abilityCategory != null && choiceManagerList instanceof AbstractComplexChoiceManager) {
            ((AbstractComplexChoiceManager)choiceManagerList).setPoolAbilityCat(abilityCategory);
        }
        choiceManagerList.getChoices(playerCharacter, list, list2);
        if (!bl) {
            return false;
        }
        if (list.size() > 0 || list2.size() > 0) {
            if (bl2) {
                List list3 = choiceManagerList.doChooser(playerCharacter, list, list2);
                choiceManagerList.applyChoices(playerCharacter, list3);
            } else {
                choiceManagerList.doChooserRemove(playerCharacter, list, list2);
            }
            return true;
        }
        return false;
    }

    public static void getChoices(PObject pObject, String string, List list, List list2, PlayerCharacter playerCharacter) {
        String string2 = pObject.getChoiceString();
        if (!(string2.startsWith("FEAT|") || string2.startsWith("ARMORPROF") || string2.startsWith("SPELLLEVEL") || string.startsWith("SPELLLEVEL") || string.startsWith("WEAPONPROF") || string.startsWith("SHIELDPROF"))) {
            return;
        }
        ChoiceManagerList choiceManagerList = ChooserUtilities.getChoiceManager(pObject, string, playerCharacter);
        choiceManagerList.getChoices(playerCharacter, list, list2);
        if (list.size() + list2.size() == 0) {
            return;
        }
        List list3 = choiceManagerList.doChooser(playerCharacter, list, list2);
        choiceManagerList.applyChoices(playerCharacter, list3);
    }

    private static void constructMap() {
        classLookup = new HashMap<String, String>();
        classLookup.put("ARMORTYPE", ArmorTypeChoiceManager.class.getName());
        classLookup.put("CSKILLS", ClassSkillsChoiceManager.class.getName());
        classLookup.put("DOMAIN", DomainChoiceManager.class.getName());
        classLookup.put("EQUIPTYPE", EquipmentTypeChoiceManager.class.getName());
        classLookup.put("FEATADD", FeatAddChoiceManager.class.getName());
        classLookup.put("SINGLEFEAT", FeatChoiceManager.class.getName());
        classLookup.put("FEATLIST", FeatListChoiceManager.class.getName());
        classLookup.put("FEATSELECT", FeatSelectChoiceManager.class.getName());
        classLookup.put("HP", HPChoiceManager.class.getName());
        classLookup.put("RACE", RaceChoiceManager.class.getName());
        classLookup.put("SALIST", SAListChoiceManager.class.getName());
        classLookup.put("SCHOOLS", SchoolsChoiceManager.class.getName());
        classLookup.put("MISC", MiscChoiceManager.class.getName());
        classLookup.put("PROFICIENCY", ProficiencyChoiceManager.class.getName());
        classLookup.put("SKILLS", SkillsChoiceManager.class.getName());
        classLookup.put("SKILLSNAMED", SkillsNamedChoiceManager.class.getName());
        classLookup.put("SKILLSNAMEDTOCCSKILL", SkillsNamedToCCSkillChoiceManager.class.getName());
        classLookup.put("SKILLSNAMEDTOCSKILL", SkillsNamedToCSkillChoiceManager.class.getName());
        classLookup.put("SPELLCLASSES", SpellClassesChoiceManager.class.getName());
        classLookup.put("SPELLLEVEL", SpellLevelChoiceManager.class.getName());
        classLookup.put("SPELLLIST", SpellListChoiceManager.class.getName());
        classLookup.put("SPELLS", SpellsChoiceManager.class.getName());
        classLookup.put("STAT", StatChoiceManager.class.getName());
        classLookup.put("WEAPONFOCUS", WeaponFocusChoiceManager.class.getName());
        classLookup.put("WEAPONPROFS", WeaponProfChoiceManager.class.getName());
        classLookup.put("WEAPONPROFTYPE", WeaponProfTypeChoiceManager.class.getName());
        classLookup.put("ARMORPROF", SimpleArmorProfChoiceManager.class.getName());
        classLookup.put("FEAT", SimpleFeatChoiceManager.class.getName());
        classLookup.put("SHIELDPROF", SimpleShieldProfChoiceManager.class.getName());
        classLookup.put("USERINPUT", UserInputChoiceManager.class.getName());
        classLookup.put("WEAPONPROF", SimpleWeaponProfChoiceManager.class.getName());
        classLookup.put("SKILLIST", SkillListChoiceManager.class.getName());
        classLookup.put("CCSKILLIST", SkillListCrossClassChoiceManager.class.getName());
        classLookup.put("NONCLASSSKILLLIST", SkillListNonClassChoiceManager.class.getName());
        mapconstructed = true;
    }

    public static ChoiceManagerList getChoiceManager(PObject pObject, String string, PlayerCharacter playerCharacter) {
        String string2;
        String string3;
        int n;
        String string4;
        if (!mapconstructed) {
            ChooserUtilities.constructMap();
        }
        if ((string4 = string != null && string.length() > 0 ? string : pObject.getChoiceString()) == null || string4.length() == 0) {
            return null;
        }
        List<String> list = Arrays.asList(string4.split("[|]"));
        for (n = 0; n <= list.size() - 1 && list.get(n).indexOf("=") > 0 && !list.get(n).startsWith("FEAT=") && !list.get(n).startsWith("FEAT."); ++n) {
        }
        String string5 = string3 = n >= list.size() ? "MISC" : list.get(n);
        if (string3.startsWith("FEAT=") || string3.startsWith("FEAT.")) {
            string3 = "SINGLEFEAT";
        }
        if ((string2 = classLookup.get(string3)) == null) {
            if (Globals.weaponTypesContains(string3)) {
                string3 = "WEAPONPROF";
                string2 = classLookup.get(string3);
            } else {
                string3 = "MISC";
                string2 = classLookup.get(string3);
            }
        }
        try {
            Class<?> clazz = Class.forName(string2);
            Class[] classArray = new Class[]{PObject.class, string4.getClass(), playerCharacter.getClass()};
            Object[] objectArray = new Object[]{pObject, string4, playerCharacter};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            ChoiceManagerList choiceManagerList = (ChoiceManagerList)constructor.newInstance(objectArray);
            return choiceManagerList;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logging.errorPrint("Can't create Choice Manager: " + string3 + " Class not found", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            Logging.errorPrint("Can't create Choice Manager: " + string3 + " Can't instantiate class", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logging.errorPrint("Can't create Choice Manager: " + string3 + " Illegal access", illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Logging.errorPrint("Can't create Choice Manager: " + string3 + " no constructor found", noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Logging.errorPrint("Can't create Choice Manager: " + string3 + " class threw an error", invocationTargetException);
        }
        return null;
    }
}

