/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.chooser;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.WeaponProf;
import pcgen.core.chooser.AbstractComplexChoiceManager;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProficiencyChoiceManager
extends AbstractComplexChoiceManager<WeaponProf> {
    static final int SCOPE_PC = 0;
    static final int SCOPE_ALL = 1;
    static final int SCOPE_UNIQUE = 2;
    int intScope = -1;
    String typeOfProf = "";

    public ProficiencyChoiceManager(PObject pObject, String string, PlayerCharacter playerCharacter) {
        super(pObject, string, playerCharacter);
        this.title = "Choose Proficiency";
        this.chooserHandled = "PROFICIENCY";
        if (this.choices != null && this.choices.size() > 0 && ((String)this.choices.get(0)).equals(this.chooserHandled)) {
            this.choices = this.choices.subList(1, this.choices.size());
        }
        switch (this.choices.size()) {
            case 0: {
                Logging.errorPrint("CHOOSE:PROFICIENCY - Incorrect format, not enough tokens. " + string);
                break;
            }
            case 1: {
                Logging.errorPrint("CHOOSE:PROFICIENCY - Incorrect format, not enough tokens. " + string);
                Logging.errorPrint("First token should be WEAPON, ARMOR, SHIELD - is " + (String)this.choices.get(0));
                Logging.errorPrint("Second token should be PC, ALL or UNIQUE - is missing");
                Logging.errorPrint("Third and subsequent tokens (missing) should be <proficency1>|TYPE=<proftyp> - is missing");
                break;
            }
            case 2: {
                Logging.errorPrint("CHOOSE:PROFICIENCY - Incorrect format, not enough tokens. " + string);
                Logging.errorPrint("First token should be WEAPON, ARMOR, SHIELD - is " + (String)this.choices.get(0));
                Logging.errorPrint("Second token should be PC, ALL or UNIQUE - is " + (String)this.choices.get(1));
                Logging.errorPrint("Third and subsequent tokens (missing) should be <proficency1>|TYPE=<proftyp> - is missing");
                break;
            }
            default: {
                this.typeOfProf = (String)this.choices.get(0);
                if ("PC".equals(this.choices.get(1))) {
                    this.intScope = 0;
                    break;
                }
                if ("ALL".equals(this.choices.get(1))) {
                    this.intScope = 1;
                    break;
                }
                if ("UNIQUE".equals(this.choices.get(1))) {
                    this.intScope = 2;
                    break;
                }
                Logging.errorPrint("CHOOSE:PROFICIENCY - Expecting PC, ALL or UNIQUE - got " + (String)this.choices.get(1));
            }
        }
    }

    @Override
    public void getChoices(PlayerCharacter playerCharacter, List<WeaponProf> list, List<WeaponProf> list2) {
        Object object;
        AbstractCollection abstractCollection;
        Iterator iterator = this.choices.subList(2, this.choices.size()).iterator();
        if ("WEAPON".equals(this.typeOfProf)) {
            Object object2;
            Object object3;
            abstractCollection = new TreeSet();
            while (iterator.hasNext()) {
                object3 = (String)iterator.next();
                if (((String)object3).startsWith("TYPE.") || ((String)object3).startsWith("TYPE=")) {
                    object2 = ((String)object3).substring(5);
                    object = Globals.getWeaponProfs((String)object2, playerCharacter).iterator();
                    while (object.hasNext()) {
                        abstractCollection.add(object.next());
                    }
                    continue;
                }
                object2 = Globals.getWeaponProfKeyed(object3);
                if (object2 == null) continue;
                abstractCollection.add(object2);
            }
            if (this.intScope == 1) {
                list.addAll(abstractCollection);
            } else {
                object3 = playerCharacter.getWeaponProfs();
                if (this.intScope == 0) {
                    abstractCollection.retainAll((Collection<?>)object3);
                    list.addAll(abstractCollection);
                } else if (this.intScope == 2) {
                    object2 = new TreeSet();
                    object2.addAll(abstractCollection);
                    object2.retainAll((Collection<?>)object3);
                    object = object2.iterator();
                    while (object.hasNext()) {
                        WeaponProf weaponProf = (WeaponProf)object.next();
                        if (weaponProf.getMyTypeCount() == 1) continue;
                        list.add(weaponProf);
                    }
                    abstractCollection.removeAll((Collection<?>)object3);
                    list.addAll(abstractCollection);
                }
            }
        } else if (!"ARMOR".equals(this.typeOfProf) && !"SHIELD".equals(this.typeOfProf)) {
            Logging.errorPrint("CHOOSE:PROFICIENCY - Unknown type " + this.typeOfProf);
        }
        abstractCollection = new ArrayList();
        this.pobject.addAssociatedTo((List<String>)((Object)abstractCollection));
        for (Object object2 : abstractCollection) {
            object = Globals.getWeaponProfKeyed(object2);
            if (object == null) continue;
            list2.add((WeaponProf)object);
        }
    }
}

