/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.chooser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.chooser.AbstractComplexChoiceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RaceChoiceManager
extends AbstractComplexChoiceManager<Race> {
    public RaceChoiceManager(PObject pObject, String string, PlayerCharacter playerCharacter) {
        super(pObject, string, playerCharacter);
        this.title = "Choose Race";
        this.chooserHandled = "RACE";
        if (this.choices != null && this.choices.size() > 0 && ((String)this.choices.get(0)).equals(this.chooserHandled)) {
            this.choices = this.choices.subList(1, this.choices.size());
        }
    }

    @Override
    public void getChoices(PlayerCharacter playerCharacter, List<Race> list, List<Race> list2) {
        Collection<Race> collection = Globals.getAllRaces();
        for (String string : this.choices) {
            if (string.indexOf("[") != -1) {
                this.processTokenWithBrackets(list, collection, string);
            }
            if (string.startsWith("RACETYPE=") || string.startsWith("RACETYPE.")) {
                for (Race race : collection) {
                    if (!race.getRaceType().equals(string.substring(9))) continue;
                    list.add(race);
                }
                continue;
            }
            if (string.startsWith("RACESUBTYPE=") || string.startsWith("RACESUBTYPE.")) {
                for (Race race : collection) {
                    if (!race.getRacialSubTypes().contains(string.substring(9))) continue;
                    list.add(race);
                }
                continue;
            }
            if (string.startsWith("TYPE=") || string.startsWith("TYPE.")) {
                for (Race race : collection) {
                    if (!race.getType().equals(string.substring(5))) continue;
                    list.add(race);
                }
                continue;
            }
            Race race = Globals.getRaceKeyed(string);
            if (race == null) continue;
            list.add(race);
        }
    }

    private void processTokenWithBrackets(List<Race> list, Collection<Race> collection, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        string = string.substring(1, string.length() - 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("RACETYPE=") || string2.startsWith("RACETYPE.")) {
                arrayList.add(string2.substring(9));
                continue;
            }
            if (string2.startsWith("RACESUBTYPE=") || string2.startsWith("RACESUBTYPE.")) {
                arrayList2.add(string2.substring(12));
                continue;
            }
            if (!string2.startsWith("TYPE=") && !string2.startsWith("TYPE.")) continue;
            arrayList3.add(string2.substring(5));
        }
        for (Race race : collection) {
            if (!RaceChoiceManager.checkRace(race, arrayList, arrayList2, arrayList3)) continue;
            list.add(race);
        }
    }

    private static boolean checkRace(Race race, List<String> list, List<String> list2, List<String> list3) {
        for (String string : list) {
            if (race.getRaceType().equals(string)) continue;
            return false;
        }
        for (String string : list2) {
            if (race.getRacialSubTypes().contains(string)) continue;
            return false;
        }
        for (String string : list3) {
            if (race.getType().equals(string)) continue;
            return false;
        }
        return true;
    }
}

