/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.chooser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import pcgen.core.Ability;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.chooser.AbstractComplexChoiceManager;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserInputChoiceManager
extends AbstractComplexChoiceManager<String> {
    protected int selectionsPerAbility = 0;

    public UserInputChoiceManager(PObject pObject, String string, PlayerCharacter playerCharacter) {
        super(pObject, playerCharacter);
        this.chooserHandled = "USERINPUT";
        this.infiniteAvail = true;
        this.parseParams(string, playerCharacter);
    }

    private void parseParams(String string, PlayerCharacter playerCharacter) {
        List<String> list = Arrays.asList(string.split("[|]"));
        this.choices = Collections.emptyList();
        if (list.size() < 1) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            if (i == 0) continue;
            if (string2.startsWith("TITLE=")) {
                if ((string2 = string2.substring(6)).startsWith("\"")) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                this.title = string2;
                continue;
            }
            if (i == 1) {
                this.requestedSelections = playerCharacter.getVariableValue(string2, "").intValue();
                continue;
            }
            Logging.errorPrintLocalised("in_uichooser_bad_param", string2);
        }
        this.selectionsPerAbility = this.requestedSelections;
        double d = 0.0;
        d = this.pobject instanceof Ability ? this.pc.getAvailableAbilityPool(SettingsHandler.getGame().getAbilityCategory(((Ability)this.pobject).getCategory())).doubleValue() : playerCharacter.getRawFeats(true);
        this.maxSelections = (int)(d * (double)this.requestedSelections + (double)this.pobject.getAssociatedCount());
        this.maxNewSelections = (int)(d * (double)this.requestedSelections);
        if (this.cost == 0.0 && this.maxNewSelections == 0) {
            this.maxNewSelections = this.requestedSelections;
        }
    }

    @Override
    public void getChoices(PlayerCharacter playerCharacter, List<String> list, List<String> list2) {
        if (this.pobject.getAssociatedCount() != 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.pobject.addAssociatedTo(arrayList);
            list2.addAll(arrayList);
        }
        list.clear();
        list.add("");
    }

    @Override
    protected ChooserInterface getChooserInstance() {
        ChooserInterface chooserInterface = ChooserFactory.getUserInputInstance();
        chooserInterface.setTitle(this.title);
        return chooserInterface;
    }

    @Override
    protected void adjustFeats(PlayerCharacter playerCharacter, List<String> list) {
        double d = playerCharacter.getFeats();
        if (this.cost > 0.0) {
            d = this.selectionsPerAbility > 0 ? d - (double)((list.size() - this.preChooserChoices) / this.selectionsPerAbility) * this.cost : (double)(this.maxSelections - list.size()) * this.cost;
        }
        playerCharacter.adjustFeats(d - playerCharacter.getFeats());
    }
}

