/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityInfo;
import pcgen.core.AbilityStore;
import pcgen.core.AbilityUtilities;
import pcgen.core.Categorisable;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.kit.BaseKit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KitAbilities
extends BaseKit
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private AbilityStore abilityStore = new AbilityStore();
    private boolean free = false;
    private String stringRep;
    private transient List<Ability> theAbilities = new ArrayList<Ability>();
    private transient List<AbilityInfo> abilitiesToAdd = null;

    public KitAbilities(String string, String string2, boolean bl) {
        this.abilityStore.addAbilityInfo(string, string2, "|", bl, false);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.choiceCount != 1 || this.abilityStore.size() != 1) {
            stringBuffer.append(this.choiceCount).append(" of ");
        }
        boolean bl2 = false;
        Iterator<Categorisable> iterator = this.getIterator();
        while (iterator.hasNext()) {
            if (bl2) {
                stringBuffer.append("; ");
            } else {
                bl2 = true;
            }
            stringBuffer.append(iterator.next().getKeyName());
        }
        if (this.free) {
            stringBuffer.append(" (free)");
        }
        this.stringRep = stringBuffer.toString();
    }

    public Iterator<Categorisable> getIterator() {
        return this.abilityStore.getKeyIterator("ALL");
    }

    public void setFree(boolean bl) {
        this.free = bl;
    }

    public String toString() {
        return this.stringRep;
    }

    @Override
    public boolean testApply(Kit kit, PlayerCharacter playerCharacter, List<String> list) {
        List list2;
        ArrayList arrayList;
        this.theAbilities = new ArrayList<Ability>();
        this.abilitiesToAdd = null;
        if (this.theAbilities == null) {
            return false;
        }
        HashMap<String, AbilityInfo> hashMap = new HashMap<String, AbilityInfo>();
        HashMap<String, AbilityInfo> hashMap2 = new HashMap<String, AbilityInfo>();
        boolean bl = true;
        AbilityCategory abilityCategory = AbilityCategory.FEAT;
        Iterator<Categorisable> iterator = this.getIterator();
        while (iterator.hasNext()) {
            AbilityInfo abilityInfo = (AbilityInfo)iterator.next();
            if (!abilityInfo.qualifies(playerCharacter)) continue;
            if (abilityInfo.getAbility() != null) {
                AbilityInfo abilityInfo2 = hashMap.put(abilityInfo.toString(), abilityInfo);
                hashMap2.put(abilityInfo.getCategory() + " " + abilityInfo.toString(), abilityInfo);
                abilityCategory = SettingsHandler.getGame().getAbilityCategory(abilityInfo.getCategory());
                if (abilityInfo2 == null) continue;
                bl = false;
                continue;
            }
            list.add("ABILITY: Non-existant Ability \"" + abilityInfo.getKeyName() + "\"");
        }
        int n = this.getChoiceCount();
        if (n > hashMap.size()) {
            n = hashMap.size();
        }
        boolean bl2 = false;
        int n2 = 0;
        if (!this.free && n > playerCharacter.getAvailableAbilityPool(abilityCategory).intValue() - n2) {
            n = playerCharacter.getAvailableAbilityPool(abilityCategory).intValue() - n2;
            bl2 = true;
        }
        if (n == 0) {
            return false;
        }
        ArrayList arrayList2 = arrayList = bl ? new ArrayList(hashMap.keySet()) : new ArrayList(hashMap2.keySet());
        if (n == hashMap.size()) {
            list2 = arrayList;
        } else {
            while ((list2 = Globals.getChoiceFromList("Choose abilities", arrayList, new ArrayList(), n)).size() == 0) {
            }
        }
        Iterator iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            AbilityInfo abilityInfo;
            if (this.abilitiesToAdd == null) {
                this.abilitiesToAdd = new ArrayList<AbilityInfo>();
            }
            String string = (String)iterator2.next();
            AbilityInfo abilityInfo3 = abilityInfo = bl ? (AbilityInfo)hashMap.get(string) : (AbilityInfo)hashMap2.get(string);
            if (abilityInfo != null) {
                this.abilitiesToAdd.add(abilityInfo);
                ++n2;
                AbilityCategory abilityCategory2 = SettingsHandler.getGame().getAbilityCategory(abilityInfo.getCategory());
                if (this.free && this.free) {
                    playerCharacter.adjustAbilities(abilityCategory2, new BigDecimal(1));
                }
                Iterator<String> iterator3 = abilityInfo.getChoicesIterator();
                String string2 = "";
                do {
                    if (iterator3.hasNext()) {
                        string2 = iterator3.next();
                    }
                    AbilityUtilities.modAbility(playerCharacter, null, abilityInfo.getAbility(), string2, true, abilityCategory2);
                } while (iterator3.hasNext());
                continue;
            }
            list.add("ABILITY: Non-existant Ability \"" + string + "\"");
        }
        if (bl2) {
            list.add("ABILITY: Some Abilities were not granted -- not enough remaining feats");
            return false;
        }
        return true;
    }

    @Override
    public void apply(PlayerCharacter playerCharacter) {
        for (AbilityInfo abilityInfo : this.abilitiesToAdd) {
            AbilityCategory abilityCategory = SettingsHandler.getGame().getAbilityCategory(abilityInfo.getCategory());
            Iterator<String> iterator = abilityInfo.getChoicesIterator();
            String string = "";
            do {
                if (iterator.hasNext()) {
                    string = iterator.next();
                }
                AbilityUtilities.modAbility(playerCharacter, null, abilityInfo.getAbility(), string, true, abilityCategory);
            } while (iterator.hasNext());
            if (!this.free) continue;
            playerCharacter.adjustAbilities(abilityCategory, new BigDecimal(1));
        }
    }

    @Override
    public KitAbilities clone() {
        return (KitAbilities)super.clone();
    }

    @Override
    public String getObjectName() {
        return "Abilities";
    }
}

