/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import pcgen.core.CharacterDomain;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PlayerCharacter;
import pcgen.core.kit.BaseKit;
import pcgen.gui.CharacterInfo;
import pcgen.gui.PCGen_Frame1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KitDeity
extends BaseKit
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String theDeityKey = null;
    private String countFormula = "";
    private List<String> theDomains = null;
    private transient Deity theDeity = null;
    private transient List<Domain> domainsToAdd = null;

    public KitDeity(String string) {
        this.theDeityKey = string;
    }

    public String getDeityKey() {
        return this.theDeityKey;
    }

    public void addDomain(String string) {
        if (this.theDomains == null) {
            this.theDomains = new ArrayList<String>(3);
        }
        this.theDomains.add(string);
    }

    public List<String> getDomains() {
        if (this.theDomains == null) {
            return null;
        }
        return Collections.unmodifiableList(this.theDomains);
    }

    public void setCountFormula(String string) {
        this.countFormula = string;
    }

    public String getCountFormula() {
        return this.countFormula;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.theDeityKey);
        if (this.theDomains != null && this.theDomains.size() > 0) {
            stringBuffer.append(" (");
            if (this.countFormula.length() > 0) {
                stringBuffer.append(this.countFormula);
                stringBuffer.append(" of ");
            }
            Iterator<String> iterator = this.theDomains.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean testApply(Kit kit, PlayerCharacter playerCharacter, List<String> list) {
        List<String> list2;
        this.theDeity = null;
        this.domainsToAdd = null;
        if (this.theDeityKey == null) {
            return false;
        }
        this.theDeity = Globals.getDeityKeyed(this.theDeityKey);
        if (this.theDeity == null) {
            list.add("DEITY: Could not find deity '" + this.getDeityKey() + "'");
            return false;
        }
        if (!playerCharacter.canSelectDeity(this.theDeity)) {
            list.add("DEITY: Cannot select deity \"" + this.theDeity.getDisplayName() + "\"");
            return false;
        }
        playerCharacter.setDeity(this.theDeity);
        List<String> list3 = this.getDomains();
        if (list3 == null || list3.size() == 0) {
            return true;
        }
        if (playerCharacter.getMaxCharacterDomains() <= 0) {
            list.add("DEITY: Not allowed to choose a domain");
            return true;
        }
        String string = this.getCountFormula();
        int n = string.length() == 0 ? list3.size() : playerCharacter.getVariableValue(string, "").intValue();
        if (n > list3.size()) {
            n = list3.size();
        }
        if (n == 0) {
            return true;
        }
        if (n == list3.size()) {
            list2 = list3;
        } else {
            while ((list2 = Globals.getChoiceFromList("Choose Domains", list3, new ArrayList(), n)).size() == 0) {
            }
        }
        for (String string2 : list2) {
            Domain domain = Globals.getDomainKeyed(string2);
            if (domain != null) {
                if (!domain.qualifiesForDomain(playerCharacter)) {
                    list.add("DEITY: Not qualified for domain \"" + domain.getDisplayName() + "\"");
                    continue;
                }
                CharacterDomain characterDomain = playerCharacter.getCharacterDomainForDomain(domain.getKeyName());
                if (characterDomain == null) {
                    characterDomain = playerCharacter.getNewCharacterDomain();
                }
                if (characterDomain == null || playerCharacter.getCharacterDomainUsed() >= playerCharacter.getMaxCharacterDomains()) {
                    list.add("DEITY: No more allowed domains");
                    return false;
                }
                if (this.domainsToAdd == null) {
                    this.domainsToAdd = new ArrayList<Domain>();
                }
                this.domainsToAdd.add(domain);
                domain.setIsLocked(true, playerCharacter);
                characterDomain.setDomain(domain, playerCharacter);
                playerCharacter.addCharacterDomain(characterDomain);
                continue;
            }
            list.add("DEITY: Non-existant domain \"" + string2 + "\"");
        }
        playerCharacter.calcActiveBonuses();
        return true;
    }

    @Override
    public void apply(PlayerCharacter playerCharacter) {
        if (this.theDeity == null) {
            return;
        }
        playerCharacter.setDeity(this.theDeity);
        if (this.domainsToAdd == null) {
            return;
        }
        for (Domain domain : this.domainsToAdd) {
            CharacterDomain characterDomain = playerCharacter.getCharacterDomainForDomain(domain.getKeyName());
            if (characterDomain == null) {
                characterDomain = playerCharacter.getNewCharacterDomain();
            }
            if (characterDomain == null) continue;
            domain.setIsLocked(true, playerCharacter);
            characterDomain.setDomain(domain, playerCharacter);
            playerCharacter.addCharacterDomain(characterDomain);
        }
        playerCharacter.calcActiveBonuses();
        CharacterInfo characterInfo = PCGen_Frame1.getCharacterPane();
        characterInfo.setPaneForUpdate(characterInfo.infoDomain());
        characterInfo.refresh();
        this.theDeity = null;
        this.domainsToAdd = null;
    }

    @Override
    public KitDeity clone() {
        return (KitDeity)super.clone();
    }

    @Override
    public String getObjectName() {
        return "Deity";
    }
}

