/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.character.EquipSet;
import pcgen.core.kit.BaseKit;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KitGear
extends BaseKit
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private List<String> eqMods = null;
    private String name = "";
    private int maxCost = 0;
    private String qty = "1";
    private String size = null;
    private String theLocationStr = null;
    private transient Equipment theEquipment = null;
    private transient int theQty = 0;
    private transient String theLocation = "";
    private transient Equipment theTarget = null;
    private transient BigDecimal theCost = BigDecimal.ZERO;

    public KitGear(String string) {
        this.name = string;
    }

    public List<String> getEqMods() {
        return this.eqMods;
    }

    public void setMaxCost(String string) {
        try {
            this.maxCost = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint("Invalid max cost \"" + string + "\" in KitGear.setMaxCost");
        }
    }

    public int getMaxCost() {
        return this.maxCost;
    }

    public void setQty(String string) {
        this.qty = string;
    }

    public String getQty() {
        return this.qty;
    }

    public void addEqMod(String string) {
        if (this.eqMods == null) {
            this.eqMods = new ArrayList<String>();
        }
        this.eqMods.add(string);
    }

    public void setSize(String string) {
        this.size = string;
    }

    public String getSize() {
        return this.size;
    }

    public void setLocation(String string) {
        this.theLocationStr = string;
    }

    public String getLocation() {
        return this.theLocationStr;
    }

    public String toString() {
        int n = 0;
        if (this.eqMods != null) {
            n = this.eqMods.size();
        }
        StringBuffer stringBuffer = new StringBuffer(n * 5);
        if (!"1".equals(this.qty)) {
            stringBuffer.append(this.qty).append('x');
        }
        stringBuffer.append(this.name);
        if (n > 0) {
            stringBuffer.append(" (");
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    stringBuffer.append('/');
                }
                stringBuffer.append(this.eqMods.get(i));
            }
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    private void processLookups(Kit kit, PlayerCharacter playerCharacter) {
        for (String string : this.getLookups()) {
            String string2 = kit.lookup(playerCharacter, string);
            this.processLookup(kit, playerCharacter, string2);
        }
    }

    private void processLookups(Kit kit, PlayerCharacter playerCharacter, String string) {
        String string2 = kit.lookup(playerCharacter, string);
        this.processLookup(kit, playerCharacter, string2);
    }

    private void processLookup(Kit kit, PlayerCharacter playerCharacter, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[]");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("EQMOD:")) {
                this.addEqMod(string2.substring(6));
                continue;
            }
            if (string2.startsWith("QTY:")) {
                this.setQty(string2.substring(4));
                continue;
            }
            if (string2.startsWith("MAXCOST:")) {
                this.setMaxCost(string2.substring(8));
                continue;
            }
            if (string2.startsWith("SIZE:")) {
                this.setSize(string2.substring(5));
                continue;
            }
            if (string2.startsWith("LOCATION:")) {
                this.setLocation(string2.substring(9));
                continue;
            }
            if (!string2.startsWith("LOOKUP:")) continue;
            this.processLookups(kit, playerCharacter, string2.substring(7));
        }
    }

    @Override
    public boolean testApply(Kit kit, PlayerCharacter playerCharacter, List<String> list) {
        Object object;
        Object object2;
        this.theEquipment = null;
        this.theQty = 0;
        this.theLocation = "";
        this.theTarget = null;
        this.theCost = BigDecimal.ZERO;
        this.processLookups(kit, playerCharacter);
        int n = kit.getBuyRate(playerCharacter);
        BigDecimal bigDecimal = playerCharacter.getGold();
        String string = this.name;
        if (this.name.startsWith("TYPE=") || this.name.startsWith("TYPE.")) {
            List<Equipment> list2 = EquipmentList.getEquipmentOfType(string.substring(5), "");
            int n2 = this.getMaxCost();
            if (n2 != 0) {
                object2 = new BigDecimal(Integer.toString(n2));
                Iterator<Equipment> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().getCost(playerCharacter).compareTo((BigDecimal)object2) <= 0) continue;
                    iterator.remove();
                }
            }
            object2 = new ArrayList(1);
            Globals.getChoiceFromList("Choose equipment", list2, object2, 1);
            if (object2.size() == 1) {
                this.theEquipment = (Equipment)object2.get(0);
            }
        } else {
            this.theEquipment = EquipmentList.getEquipmentKeyed(string);
        }
        if (this.theEquipment == null) {
            list.add("GEAR: Non-existant gear \"" + string + "\"");
            return false;
        }
        this.theEquipment = this.theEquipment.clone();
        boolean bl = false;
        String string2 = SettingsHandler.getGame().getSizeAdjustmentAtIndex(playerCharacter.sizeInt()).getAbbreviation();
        if (this.getSize() == null) {
            if (this.theEquipment.isType("Natural") || !this.theEquipment.isWeapon() && !this.theEquipment.isAmmunition()) {
                bl = Globals.canResizeHaveEffect(playerCharacter, this.theEquipment, null);
            }
        } else if ("PC".equals(this.getSize())) {
            bl = Globals.canResizeHaveEffect(playerCharacter, this.theEquipment, null);
        } else {
            string2 = this.getSize();
            bl = true;
        }
        if (bl) {
            this.theEquipment.resizeItem(playerCharacter, string2);
        } else {
            this.theEquipment.resizeItem(playerCharacter, this.theEquipment.getSize());
        }
        object2 = this.getEqMods();
        if (object2 != null) {
            for (int i = 0; i < object2.size(); ++i) {
                object = (String)object2.get(i);
                object = KitGear.eval(playerCharacter, (String)object);
                this.theEquipment.addEqModifiers((String)object, true);
            }
        }
        if (bl || object2 != null) {
            this.theEquipment.nameItemFromModifiers(playerCharacter);
        }
        int n3 = this.theQty = playerCharacter.getVariableValue(this.getQty(), "").intValue();
        object = this.theEquipment.getCost(playerCharacter);
        if (n != 0) {
            BigDecimal bigDecimal2 = new BigDecimal(Integer.toString(n)).multiply(new BigDecimal("0.01"));
            this.theCost = ((BigDecimal)object).multiply(new BigDecimal(Integer.toString(this.theQty))).multiply(bigDecimal2);
            while (this.theQty > 0 && this.theCost.compareTo(bigDecimal) > 0) {
                this.theCost = ((BigDecimal)object).multiply(new BigDecimal(Integer.toString(--this.theQty))).multiply(bigDecimal2);
            }
            playerCharacter.setGold(playerCharacter.getGold().subtract(this.theCost).toString());
        }
        boolean bl2 = false;
        if (this.theQty != n3) {
            bl2 = true;
        }
        if (this.theQty == 0) {
            return false;
        }
        if (bl2) {
            list.add("GEAR: Could not purchase " + (n3 - this.theQty) + " " + this.theEquipment.getName() + ". Not enough funds.");
        }
        this.theEquipment.setQty(new Float(this.theQty));
        playerCharacter.addEquipment(this.theEquipment);
        if (this.getLocation() != null) {
            this.theLocation = this.getLocation();
            if (!this.theLocation.equalsIgnoreCase("DEFAULT") && !this.theLocation.equalsIgnoreCase("Equipped")) {
                this.theTarget = playerCharacter.getEquipmentNamed(this.theLocation);
            } else {
                this.theLocation = "";
            }
            EquipSet equipSet = playerCharacter.addEquipToTarget(playerCharacter.getEquipSetByIdPath("0.1"), this.theTarget, this.theLocation, this.theEquipment, new Float(-1.0f));
            if (equipSet == null) {
                list.add("GEAR: Could not equip " + this.theEquipment.getName() + " to " + this.theLocation);
            }
        }
        return true;
    }

    @Override
    public void apply(PlayerCharacter playerCharacter) {
        Equipment equipment = playerCharacter.getEquipmentNamed(this.theEquipment.getName());
        if (equipment == null) {
            this.theEquipment.setQty(new Float(this.theQty));
            playerCharacter.addEquipment(this.theEquipment);
            EquipmentList.addEquipment(this.theEquipment);
        } else {
            equipment.setQty(equipment.qty() + (double)this.theQty);
        }
        playerCharacter.addEquipToTarget(playerCharacter.getEquipSetByIdPath("0.1"), this.theTarget, this.theLocation, this.theEquipment, new Float(this.theQty));
        playerCharacter.setGold(playerCharacter.getGold().subtract(this.theCost).toString());
    }

    @Override
    public KitGear clone() {
        return (KitGear)super.clone();
    }

    @Override
    public String getObjectName() {
        return "Gear";
    }
}

