/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.kit.BaseKit;
import pcgen.core.levelability.LevelAbility;
import pcgen.core.pclevelinfo.PCLevelInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KitLevelAbility
extends BaseKit
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String theClassName = "";
    private int theLevel = -1;
    private List<AbilityChoice> theAbilities = new ArrayList<AbilityChoice>();
    private transient PCClass theClass = null;

    public void setClass(String string) {
        this.theClassName = string;
    }

    public void setLevel(int n) {
        this.theLevel = n;
    }

    public void addAbility(String string, List<String> list) {
        this.theAbilities.add(new AbilityChoice(string, list));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (AbilityChoice abilityChoice : this.theAbilities) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(abilityChoice.getAbility());
            stringBuffer.append(": [");
            List<String> list = abilityChoice.getChoices();
            boolean bl2 = true;
            for (String string : list) {
                if (!bl2) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string);
                bl2 = false;
            }
            stringBuffer.append("]");
            bl = false;
        }
        return stringBuffer.toString();
    }

    private void addLevelAbility(PlayerCharacter playerCharacter, PCClass pCClass, AbilityChoice abilityChoice) {
        LevelAbility levelAbility = this.theClass.addAddList(this.theLevel, abilityChoice.getAbility());
        PCLevelInfo pCLevelInfo = playerCharacter.getLevelInfoFor(this.theClass.getKeyName(), this.theLevel);
        ArrayList<String> arrayList = new ArrayList<String>();
        levelAbility.process(arrayList, playerCharacter, pCLevelInfo);
        arrayList.clear();
        for (String string : abilityChoice.getChoices()) {
            arrayList.add(string.substring(7));
        }
        levelAbility.processChoice(null, arrayList, playerCharacter, pCLevelInfo);
    }

    @Override
    public boolean testApply(Kit kit, PlayerCharacter playerCharacter, List<String> list) {
        this.theClass = Globals.getClassKeyed(this.theClassName);
        if (this.theClass == null) {
            list.add("LEVELABILITY: Could not find class \"" + this.theClassName + "\"");
            return false;
        }
        for (AbilityChoice abilityChoice : this.theAbilities) {
            this.addLevelAbility(playerCharacter, this.theClass, abilityChoice);
        }
        return true;
    }

    @Override
    public void apply(PlayerCharacter playerCharacter) {
        for (AbilityChoice abilityChoice : this.theAbilities) {
            this.addLevelAbility(playerCharacter, this.theClass, abilityChoice);
        }
    }

    @Override
    public KitLevelAbility clone() {
        return (KitLevelAbility)super.clone();
    }

    @Override
    public String getObjectName() {
        return "Class Feature";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AbilityChoice {
        private List<String> theChoices = new ArrayList<String>();
        private String theAbilityName = "";

        AbilityChoice(String string, List<String> list) {
            this.theAbilityName = string.substring(7);
            this.theChoices.addAll(list);
        }

        public final String getAbility() {
            return this.theAbilityName;
        }

        public final List<String> getChoices() {
            return this.theChoices;
        }
    }
}

