/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.WeaponProf;
import pcgen.core.kit.BaseKit;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.ListKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KitProf
extends BaseKit
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final List<String> profList = new ArrayList<String>();
    private boolean racialProf = false;
    private transient PObject thePObject = null;
    private transient List<WeaponProf> weaponProfs = null;

    public KitProf(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            this.profList.add(stringTokenizer.nextToken());
        }
    }

    public List<String> getProfList() {
        return this.profList;
    }

    public boolean isRacial() {
        return this.racialProf;
    }

    public void setRacialProf(boolean bl) {
        this.racialProf = bl;
    }

    public String toString() {
        int n = this.profList.size();
        StringBuffer stringBuffer = new StringBuffer(n * 10);
        if (this.choiceCount != 1 || n != 1) {
            stringBuffer.append(this.choiceCount).append(" of ");
        }
        stringBuffer.append(CoreUtility.joinToStringBuffer(this.profList, ", "));
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean testApply(Kit kit, PlayerCharacter playerCharacter, List<String> list) {
        void var8_15;
        Cloneable cloneable;
        this.thePObject = null;
        this.weaponProfs = null;
        ListKey<String> listKey = ListKey.SELECTED_WEAPON_PROF_BONUS;
        List<String> list2 = null;
        if (this.isRacial()) {
            cloneable = playerCharacter.getRace();
            if (cloneable == null) {
                list.add("PROF: PC has no race");
                return false;
            }
            if (((PObject)cloneable).getSafeSizeOfListFor((ListKey)listKey) != 0) {
                list.add("PROF: Race has already selected bonus weapon proficiency");
                return false;
            }
            this.thePObject = cloneable;
            list2 = ((PObject)cloneable).getWeaponProfBonus();
        } else {
            cloneable = playerCharacter.getClassList();
            if (cloneable == null || cloneable.size() == 0) {
                list.add("PROF: No owning class found.");
                return false;
            }
            Object object3 = null;
            Iterator object22 = cloneable.iterator();
            while (object22.hasNext() && ((list2 = ((PObject)(object3 = (PCClass)object22.next())).getWeaponProfBonus()) == null || list2.size() <= 0)) {
            }
            this.thePObject = object3;
            if (((PObject)object3).getSafeSizeOfListFor((ListKey)listKey) != 0) {
                list.add("PROF: Class has already selected bonus weapon proficiency");
                return false;
            }
        }
        if (list2 == null || list2.size() == 0) {
            list.add("PROF: No optional weapon proficiencies");
            return false;
        }
        cloneable = new ArrayList();
        for (String string : this.getProfList()) {
            if (!list2.contains(string)) {
                list.add("PROF: Weapon proficiency \"" + string + "\" is not in list of choices");
                continue;
            }
            WeaponProf weaponProf = Globals.getWeaponProfKeyed(string);
            if (weaponProf != null) {
                cloneable.add(string);
                continue;
            }
            list.add("PROF: Non-existant proficiency \"" + string + "\"");
        }
        int n = this.getChoiceCount();
        if (n > cloneable.size()) {
            n = cloneable.size();
        }
        if (n == 0) {
            return false;
        }
        if (n == cloneable.size()) {
            Cloneable cloneable2 = cloneable;
        } else {
            List list3;
            while ((list3 = Globals.getChoiceFromList("Choose Proficiencies", cloneable, new ArrayList(), n)).size() == 0) {
            }
        }
        for (String string : var8_15) {
            WeaponProf weaponProf = Globals.getWeaponProfKeyed(string);
            if (weaponProf == null) continue;
            if (this.weaponProfs == null) {
                this.weaponProfs = new ArrayList<WeaponProf>();
            }
            this.weaponProfs.add(weaponProf);
        }
        return false;
    }

    @Override
    public void apply(PlayerCharacter playerCharacter) {
        for (WeaponProf weaponProf : this.weaponProfs) {
            this.thePObject.addSelectedWeaponProfBonus(weaponProf.getKeyName());
        }
    }

    @Override
    public KitProf clone() {
        KitProf kitProf = (KitProf)super.clone();
        kitProf.profList.addAll(this.profList);
        kitProf.racialProf = this.racialProf;
        return kitProf;
    }

    @Override
    public String getObjectName() {
        return "Proficiencies";
    }
}

