/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.kit.BaseKit;
import pcgen.core.kit.KitSkillAdd;
import pcgen.core.kit.KitWrapper;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.gui.CharacterInfo;
import pcgen.gui.PCGen_Frame1;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KitSkill
extends BaseKit
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String skillName = "";
    private String className = null;
    private boolean free = false;
    private double rank = 1.0;
    private transient List<KitWrapper> skillsToAdd = new ArrayList<KitWrapper>();

    public KitSkill(String string) {
        this.skillName = string;
    }

    public void setFree(boolean bl) {
        this.free = bl;
    }

    public boolean isFree() {
        return this.free;
    }

    public void setRank(String string) {
        try {
            this.rank = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint("Invalid rank \"" + string + "\" in KitSkill.setRank");
        }
    }

    public double getRank() {
        return this.rank;
    }

    public String getSkillName() {
        return this.skillName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.skillName.indexOf("|") != -1) {
            stringBuffer.append(this.getChoiceCount() + " of (");
            stringBuffer.append(this.skillName.replaceAll("\\|", ", "));
            stringBuffer.append(")");
        } else {
            stringBuffer.append(this.skillName);
        }
        stringBuffer.append(" (").append(this.rank);
        if (stringBuffer.toString().endsWith(".0")) {
            stringBuffer.setLength(stringBuffer.length() - 2);
        }
        if (this.free) {
            stringBuffer.append("/free");
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    public boolean testApply(Kit kit, PlayerCharacter playerCharacter, List<String> list) {
        this.skillsToAdd = new ArrayList<KitWrapper>();
        String string = this.getSkillName();
        if (string == null) {
            return false;
        }
        List<Skill> list2 = this.getSkillChoices(string);
        if (list2 == null || list2.size() == 0) {
            return false;
        }
        for (Skill skill : list2) {
            if (skill == null) {
                list.add("SKILL: Non-existant skill \"" + string + "\"");
                return false;
            }
            double d = this.getRank();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (this.getClassName() != null) {
                PCClass pCClass = playerCharacter.getClassKeyed(this.getClassName());
                if (pCClass != null) {
                    arrayList.add(pCClass);
                } else {
                    list.add("SKILL: Could not find specified class " + this.getClassName() + " to add ranks from.");
                }
            }
            for (PCClass pCClass : playerCharacter.getClassList()) {
                if (arrayList.contains(pCClass)) continue;
                arrayList.add(pCClass);
            }
            for (PCClass pCClass : arrayList) {
                KitSkillAdd kitSkillAdd = this.addRanks(playerCharacter, pCClass, skill, d, this.isFree(), list);
                if (kitSkillAdd == null) continue;
                KitWrapper kitWrapper = new KitWrapper(kitSkillAdd);
                kitWrapper.setPObject(pCClass);
                this.skillsToAdd.add(kitWrapper);
                if ((d -= kitSkillAdd.getRanks()) != 0.0) continue;
                break;
            }
            if (!(d > 0.0)) continue;
            list.add("SKILL: Could not add " + d + " ranks to " + skill.getKeyName() + ". Not enough points.");
        }
        return true;
    }

    @Override
    public void apply(PlayerCharacter playerCharacter) {
        for (KitWrapper kitWrapper : this.skillsToAdd) {
            KitSkillAdd kitSkillAdd = (KitSkillAdd)kitWrapper.getObject();
            this.updatePCSkills(playerCharacter, kitSkillAdd.getSkill(), (int)kitSkillAdd.getRanks(), kitSkillAdd.getCost(), (PCClass)kitWrapper.getPObject());
        }
    }

    private boolean updatePCSkills(PlayerCharacter playerCharacter, Skill skill, int n, double d, PCClass pCClass) {
        Skill skill2 = playerCharacter.addSkill(skill);
        String string = skill2.modRanks(n, pCClass, true, playerCharacter);
        if (string.length() > 0) {
            Logging.errorPrint("SKILL: " + string);
            return false;
        }
        List<PCLevelInfo> list = playerCharacter.getLevelInfo();
        double d2 = d;
        if (d2 >= 0.0) {
            for (PCLevelInfo pCLevelInfo : list) {
                int n2;
                if (!pCLevelInfo.getClassKeyName().equals(pCClass.getKeyName()) || (n2 = pCLevelInfo.getSkillPointsRemaining()) == 0) continue;
                int n3 = n2 - (int)Math.min((double)n2, d2);
                pCLevelInfo.setSkillPointsRemaining(n3);
                if (!((d2 -= (double)(n2 - n3)) <= 0.0)) continue;
                break;
            }
        }
        CharacterInfo characterInfo = PCGen_Frame1.getCharacterPane();
        characterInfo.setPaneForUpdate(characterInfo.infoSkills());
        characterInfo.refresh();
        return true;
    }

    @Override
    public String getObjectName() {
        return "Skills";
    }

    private List<Skill> getSkillChoices(String string) {
        Object object;
        ArrayList<Skill> arrayList = new ArrayList<Skill>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            Object object2;
            object = stringTokenizer.nextToken();
            if (((String)object).startsWith("TYPE=") || ((String)object).startsWith("TYPE.")) {
                object2 = ((String)object).substring(5);
                for (Skill skill : Globals.getSkillList()) {
                    if (!skill.isType((String)object2)) continue;
                    arrayList.add(skill);
                }
                continue;
            }
            object2 = Globals.getSkillKeyed((String)object);
            arrayList.add((Skill)object2);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() == 1) {
            return arrayList;
        }
        object = new ArrayList();
        Globals.getChoiceFromList("Select skill", arrayList, object, this.getChoiceCount());
        return object;
    }

    private KitSkillAdd addRanks(PlayerCharacter playerCharacter, PCClass pCClass, Skill skill, double d, boolean bl, List<String> list) {
        Skill skill2;
        String string;
        int n;
        if (!bl && pCClass.getSkillPool(playerCharacter) == 0) {
            return null;
        }
        Skill skill3 = playerCharacter.getSkillKeyed(skill.getKeyName());
        double d2 = 0.0;
        if (skill3 != null) {
            d2 = skill3.getRank().doubleValue();
        }
        double d3 = d;
        if (!Globals.checkRule("SKILLMAX") && d3 > 0.0) {
            d3 = Math.min(playerCharacter.getMaxRank(skill.getKeyName(), pCClass).doubleValue(), d2 + d);
            if ((d3 -= d2) != d) {
                list.add("SKILL: Could not add " + (d - d3) + " to " + skill.getDisplayName() + ". Excedes MAXRANK of " + playerCharacter.getMaxRank(skill.getDisplayName(), pCClass) + ".");
            }
        }
        int n2 = 0;
        List<PCLevelInfo> list2 = playerCharacter.getLevelInfo();
        int[] nArray = new int[list2.size()];
        if (!bl) {
            double d4 = 0.0;
            n2 = (int)(d3 * (double)skill.costForPCClass(pCClass, playerCharacter));
            for (n = 0; n < list2.size(); ++n) {
                PCLevelInfo pCLevelInfo = list2.get(n);
                nArray[n] = pCLevelInfo.getClassKeyName().equals(pCClass.getKeyName()) ? pCLevelInfo.getSkillPointsRemaining() : -1;
            }
            for (n = 0; n < nArray.length; ++n) {
                int n3;
                int n4 = nArray[n];
                if (n4 <= 0) continue;
                nArray[n] = n3 = n4 - Math.min(n4, n2);
                int n5 = n4 - n3;
                if ((d4 += (double)n5 / (double)skill.costForPCClass(pCClass, playerCharacter)) == d3 || (n2 -= n5) <= 0) break;
            }
            d3 = d4;
            n2 = (int)(d3 * (double)skill.costForPCClass(pCClass, playerCharacter));
        }
        if ((string = (skill2 = playerCharacter.addSkill(skill)).modRanks(d3, pCClass, playerCharacter)).length() > 0) {
            if (bl && string.indexOf("You do not have enough skill points.") != -1) {
                skill2.modRanks(d3, pCClass, true, playerCharacter);
            } else {
                list.add(string);
                return null;
            }
        }
        if (!bl) {
            for (n = 0; n < list2.size(); ++n) {
                PCLevelInfo pCLevelInfo = list2.get(n);
                if (nArray[n] < 0) continue;
                pCLevelInfo.setSkillPointsRemaining(nArray[n]);
            }
        }
        return new KitSkillAdd(skill, d3, n2);
    }
}

