/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import pcgen.core.Ability;
import pcgen.core.CharacterDomain;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.character.CharacterSpell;
import pcgen.core.kit.BaseKit;
import pcgen.core.kit.KitSpellBook;
import pcgen.core.kit.KitSpellBookEntry;
import pcgen.core.spell.Spell;
import pcgen.gui.CharacterInfo;
import pcgen.gui.PCGen_Frame1;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KitSpells
extends BaseKit
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private HashMap<String, List<KitSpellBook>> spellMap = new HashMap();
    private String countFormula = "";
    private transient List<KitSpellBookEntry> theSpells = null;

    public void setCountFormula(String string) {
        this.countFormula = string;
    }

    public String getCountFormula() {
        return this.countFormula;
    }

    public List<String> getClasses() {
        Set<String> set = this.spellMap.keySet();
        ArrayList<String> arrayList = new ArrayList<String>(set.size());
        arrayList.addAll(set);
        return arrayList;
    }

    public List<KitSpellBook> getSpellBooks(String string) {
        return this.spellMap.get(string);
    }

    public void addSpell(String string, String string2, String string3, List<String> list, String string4) {
        String string5 = string;
        if (string == null) {
            string5 = "Default";
        }
        List<KitSpellBook> list2 = this.spellMap.get(string5);
        KitSpellBook kitSpellBook = null;
        if (list2 == null) {
            kitSpellBook = new KitSpellBook(string5, string2);
            list2 = new ArrayList<KitSpellBook>();
            list2.add(kitSpellBook);
            this.spellMap.put(string5, list2);
        } else {
            for (KitSpellBook kitSpellBook2 : list2) {
                if (!kitSpellBook2.getName().equals(string2)) continue;
                kitSpellBook = kitSpellBook2;
                break;
            }
            if (kitSpellBook == null) {
                kitSpellBook = new KitSpellBook(string5, string2);
                list2.add(kitSpellBook);
            }
        }
        kitSpellBook.addSpell(string3, list, string4);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Set<String> set = this.spellMap.keySet();
        for (String string : set) {
            if (!"Default".equals(string)) {
                stringBuffer.append(string);
            }
            List<KitSpellBook> list = this.spellMap.get(string);
            for (KitSpellBook kitSpellBook : list) {
                stringBuffer.append(" " + kitSpellBook);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean testApply(Kit kit, PlayerCharacter playerCharacter, List<String> list) {
        this.theSpells = null;
        for (String string : this.getClasses()) {
            PCClass pCClass = this.findDefaultSpellClass(string, playerCharacter);
            if (pCClass == null) {
                list.add("SPELLS: Character does not have " + string + " spellcasting class.");
                return false;
            }
            List<KitSpellBook> list2 = this.getSpellBooks(string);
            for (KitSpellBook kitSpellBook : list2) {
                List<Object> list3;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                String string2 = kitSpellBook.getName();
                if (!pCClass.getMemorizeSpells() && !string2.equals(Globals.getDefaultSpellBook())) {
                    list.add("SPELLS: " + pCClass.getDisplayName() + " can only add to " + Globals.getDefaultSpellBook());
                    return false;
                }
                for (List<KitSpellBookEntry> list4 : kitSpellBook.getSpells()) {
                    list3 = list4.iterator();
                    while (list3.hasNext()) {
                        Object object;
                        KitSpellBookEntry kitSpellBookEntry = list3.next();
                        Object object2 = kitSpellBookEntry.getName();
                        if (((String)object2).startsWith("LEVEL=")) {
                            object = Globals.getSpellsIn(Integer.parseInt(((String)object2).substring(6)), pCClass.getKeyName(), "");
                            Iterator iterator = object.iterator();
                            while (iterator.hasNext()) {
                                Spell spell = (Spell)iterator.next();
                                arrayList.add(new KitSpellBookEntry(pCClass.getKeyName(), kitSpellBookEntry.getBookName(), spell.toString(), null));
                            }
                            continue;
                        }
                        object = Globals.getSpellKeyed((String)object2);
                        if (object != null) {
                            arrayList.add(kitSpellBookEntry);
                            continue;
                        }
                        list.add("SPELLS: Non-existant spell \"" + (String)object2 + "\"");
                    }
                }
                String string3 = this.getCountFormula();
                int n = string3.length() == 0 ? arrayList.size() : playerCharacter.getVariableValue(string3, "").intValue();
                if (n > arrayList.size()) {
                    n = arrayList.size();
                }
                if (n == 0) continue;
                if (n == arrayList.size()) {
                    list3 = arrayList;
                } else {
                    while ((list3 = Globals.getChoiceFromList("Choose " + string + " spell(s) for " + string2, arrayList, new ArrayList(), n)).size() == 0) {
                    }
                }
                for (Object object2 : list3) {
                    if (object2 != null) {
                        ((KitSpellBookEntry)object2).setPCClass(pCClass);
                        if (this.theSpells == null) {
                            this.theSpells = new ArrayList<KitSpellBookEntry>();
                        }
                        this.theSpells.add((KitSpellBookEntry)object2);
                        continue;
                    }
                    list.add("SPELLS: Non-existant spell chosen");
                }
            }
        }
        return this.theSpells != null && this.theSpells.size() > 0;
    }

    @Override
    public void apply(PlayerCharacter playerCharacter) {
        for (KitSpellBookEntry kitSpellBookEntry : this.theSpells) {
            this.updatePCSpells(playerCharacter, kitSpellBookEntry, playerCharacter.getClassKeyed(kitSpellBookEntry.getPCClass().getKeyName()));
        }
    }

    @Override
    public KitSpells clone() {
        KitSpells kitSpells = (KitSpells)super.clone();
        kitSpells.spellMap = this.spellMap;
        kitSpells.countFormula = this.countFormula;
        return kitSpells;
    }

    private PCClass findDefaultSpellClass(String string, PlayerCharacter playerCharacter) {
        if ("Default".equals(string)) {
            List<? extends PObject> list = playerCharacter.getSpellClassList();
            for (PObject pObject : list) {
                if (!(pObject instanceof PCClass)) continue;
                return (PCClass)pObject;
            }
            return null;
        }
        return playerCharacter.getClassKeyed(string);
    }

    private void updatePCSpells(PlayerCharacter playerCharacter, KitSpellBookEntry kitSpellBookEntry, PCClass pCClass) {
        Object object;
        Spell spell = Globals.getSpellKeyed(kitSpellBookEntry.getName());
        int n = 99;
        PObject pObject = null;
        if (playerCharacter.hasCharacterDomainList()) {
            for (CharacterDomain object22 : playerCharacter.getCharacterDomainList()) {
                Domain n3 = object22.getDomain();
                object = n3.getSpellKey();
                int iterator = spell.getFirstLevelForKey((String)object, playerCharacter);
                if (iterator <= 0 || iterator >= n) continue;
                n = iterator;
                pObject = n3;
            }
        }
        if (n == 99) {
            n = spell.getFirstLevelForKey(pCClass.getSpellKey(), playerCharacter);
            pObject = pCClass;
        }
        if (n < 0) {
            Logging.errorPrint("SPELLS: " + pCClass.getDisplayName() + " cannot cast spell \"" + kitSpellBookEntry.getName() + "\"");
            return;
        }
        CharacterSpell characterSpell = new CharacterSpell(pObject, spell);
        List<String> list = kitSpellBookEntry.getModifiers();
        int n2 = n;
        object = new ArrayList();
        for (String string : list) {
            Ability ability = playerCharacter.getFeatNamed(string);
            if (ability == null) continue;
            n2 += ability.getAddSpellLevel();
            object.add(ability);
        }
        if (object.size() <= 0) {
            object = null;
        }
        playerCharacter.addSpellBook(kitSpellBookEntry.getBookName());
        for (int characterInfo = 0; characterInfo < kitSpellBookEntry.getCopies(); ++characterInfo) {
            String string;
            string = playerCharacter.addSpell(characterSpell, (List<Ability>)object, pCClass.getKeyName(), kitSpellBookEntry.getBookName(), n2, n);
            if (string.length() == 0) continue;
            Logging.errorPrint("Add spell failed:" + string);
            return;
        }
        CharacterInfo characterInfo = PCGen_Frame1.getCharacterPane();
        characterInfo.setPaneForUpdate(characterInfo.infoSpells());
        characterInfo.refresh();
    }

    @Override
    public String getObjectName() {
        return "Spells";
    }
}

