/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.levelability;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.levelability.LevelAbility;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.prereq.PrereqHandler;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevelAbilityAbility
extends LevelAbility {
    private boolean isVirtual = false;
    private boolean allowDups = false;
    private int dupChoices = 0;
    private int numFeats = 0;
    private List<Ability> previousChoices = new ArrayList<Ability>();
    private String lastCategorySeen = "";
    private Ability.Nature nature = Ability.Nature.NORMAL;
    final HashMap<String, AbilityChoice> nameMap = new HashMap();
    final HashMap<String, AbilityChoice> catMap = new HashMap();
    boolean useNameMap = true;

    LevelAbilityAbility(PObject pObject, int n, String string, boolean bl) {
        super(pObject, n, string);
        this.isVirtual = bl;
    }

    @Override
    public boolean isAbility() {
        return true;
    }

    @Override
    public void process(List<String> list, PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo) {
        block4: {
            ChooserInterface chooserInterface;
            List<String> list2;
            block5: {
                block3: {
                    this.nameMap.clear();
                    this.catMap.clear();
                    this.useNameMap = true;
                    list2 = this.getChoicesList(this.rawTagData, playerCharacter);
                    if (list == null) break block3;
                    list.addAll(list2);
                    break block4;
                }
                chooserInterface = ChooserFactory.getChooserInstance();
                this.setNumberofChoices(chooserInterface, playerCharacter);
                this.numFeats = chooserInterface.getPool();
                if (this.nature != Ability.Nature.NORMAL) {
                    chooserInterface.setTitle(this.nature.name().substring(0, 1).toUpperCase() + this.nature.name().substring(1).toLowerCase() + " Feat Selection");
                } else {
                    chooserInterface.setTitle("Feat Choice");
                }
                chooserInterface.setPoolFlag(true);
                if (chooserInterface.getPool() != Integer.MIN_VALUE) break block5;
                this.processChoice(list2, list2, playerCharacter, pCLevelInfo);
                break block4;
            }
            chooserInterface.setAvailableList(list2);
            chooserInterface.setVisible(false);
            if (list2.size() <= 0) break block4;
            do {
                chooserInterface.setVisible(true);
            } while (!this.processChoice(list2, chooserInterface.getSelectedList(), playerCharacter, pCLevelInfo));
        }
    }

    @Override
    List<String> getChoicesList(String string, PlayerCharacter playerCharacter) {
        List<String> list = Arrays.asList(string.split("\\(", 2));
        super.getChoicesList(list.get(1), playerCharacter);
        ArrayList<String> arrayList = this.useNameMap ? new ArrayList<String>(this.nameMap.keySet()) : new ArrayList<String>(this.catMap.keySet());
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    void processToken(String string, List<String> list, PlayerCharacter playerCharacter) {
        Object object;
        Object object2;
        if ("STACKS".equals(string)) {
            this.allowDups = true;
            return;
        }
        if (string.startsWith("STACKS=")) {
            this.allowDups = true;
            this.dupChoices = Integer.parseInt(string.substring(7));
            return;
        }
        if (string.startsWith("CATEGORY=")) {
            if (!this.lastCategorySeen.equals("")) {
                Logging.errorPrint("Duplicate ability category string " + string.substring(9));
                return;
            }
            this.lastCategorySeen = string.substring(9);
        } else if (string.startsWith("NATURE=")) {
            object2 = string.substring(7);
            object = Ability.Nature.valueOf((String)object2);
            if (object == null) {
                Logging.errorPrint("Invalid ability nature string " + (String)object2);
                return;
            }
            this.isVirtual = object.equals((Object)Ability.Nature.VIRTUAL);
        }
        if (this.lastCategorySeen.equals("")) {
            return;
        }
        object2 = this.getAbilityList(this.lastCategorySeen, string, playerCharacter);
        object = object2.iterator();
        while (object.hasNext()) {
            Ability ability = (Ability)object.next();
            if (this.allowDups && this.dupChoices > 0 && this.dupChoices <= this.timesChoiceHasBeenTaken(ability) || !this.isVirtual && !PrereqHandler.passesAll(ability.getPreReqList(), playerCharacter, ability)) continue;
            if (ability.isMultiples()) {
                this.addMultiplySelectableAbility(list, playerCharacter, ability);
                continue;
            }
            GameMode gameMode = SettingsHandler.getGame();
            AbilityCategory abilityCategory = gameMode.getAbilityCategory(this.lastCategorySeen);
            if (playerCharacter.hasRealAbility(abilityCategory, Globals.getAbilityKeyed(this.lastCategorySeen, ability.getKeyName())) || playerCharacter.hasAutomaticAbility(abilityCategory, ability)) continue;
            this.addToAvailableLists(ability, null);
        }
    }

    private int timesChoiceHasBeenTaken(Ability ability) {
        int n = 0;
        for (Ability ability2 : this.previousChoices) {
            if (!ability.isSameBaseAbility(ability2)) continue;
            ++n;
        }
        return n;
    }

    private void addMultiplySelectableAbility(List<String> list, PlayerCharacter playerCharacter, Ability ability) {
        Iterator iterator;
        int n;
        String string;
        int n2;
        Ability ability2 = playerCharacter.getAbilityMatching(ability);
        if (ability2 != null) {
            ability = ability2;
        }
        if ((n2 = (string = LevelAbilityAbility.getSubKey(ability.getKeyName())).indexOf(37)) > -1) {
            string = string.substring(0, n2).trim();
        } else if (string.length() != 0 && (n = string.lastIndexOf(41)) > -1) {
            string = string.substring(0, n);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string2 = ability.getChoiceString();
        if (string2.indexOf("NUMCHOICES=") < 0 && string2.indexOf("COUNT=") < 0) {
            iterator = new ArrayList();
            ArrayList object2 = new ArrayList();
            ability.modChoices((List)((Object)iterator), object2, false, playerCharacter, true, null);
            Iterator iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                arrayList.add(String.valueOf(iterator2.next()));
            }
            iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                arrayList2.add(String.valueOf(iterator2.next()));
            }
        } else {
            arrayList.add("NOCHOICE");
        }
        if (string.length() != 0) {
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (string3.startsWith(string)) continue;
                iterator.remove();
            }
            if (n2 == -1 && arrayList.size() == 0) {
                arrayList.add(string);
            }
        }
        if (!ability.isStacks()) {
            iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                int n3 = arrayList.indexOf(iterator.next());
                if (n3 <= -1) continue;
                arrayList.remove(n3);
            }
        }
        if (!ability.getChoiceString().startsWith("SPELLLIST|")) {
            for (String string4 : arrayList) {
                this.addToAvailableLists(ability, !string4.equalsIgnoreCase("NOCHOICE") ? string4 : null);
            }
        } else {
            this.addToAvailableLists(ability, null);
        }
    }

    private void addToAvailableLists(Ability ability, String string) {
        String string2 = ability.getKeyName();
        AbilityChoice abilityChoice = new AbilityChoice(ability, string);
        String string3 = string2;
        if (string != null) {
            string3 = string3 + "(" + string + ")";
        }
        AbilityChoice abilityChoice2 = this.nameMap.put(string3, abilityChoice);
        this.catMap.put(ability.getCategory() + " " + string3, abilityChoice);
        if (abilityChoice2 != null) {
            this.useNameMap = false;
        }
    }

    private static String getSubKey(String string) {
        int n = string.indexOf(40);
        int n2 = string.lastIndexOf(41);
        if (n > -1 && n2 > -1) {
            return string.substring(n + 1, n2);
        }
        return "";
    }

    private List<Ability> getAbilityList(String string, String string2, PlayerCharacter playerCharacter) {
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        if (string2.startsWith("TYPE=") || string2.startsWith("TYPE.")) {
            String string3 = string2.substring(5);
            if ("REGION".equals(string3)) {
                this.addAbilitiesForRegion(playerCharacter, arrayList, string, string3);
            } else if ("SUBREGION".equals(string3)) {
                this.addAbilitiesForSubRegion(playerCharacter, arrayList, string, string3);
            } else if ("ALLREGION".equals(string3)) {
                this.addAbilitiesForRegion(playerCharacter, arrayList, string, string3);
                this.addAbilitiesForSubRegion(playerCharacter, arrayList, string, string3);
            } else {
                arrayList.addAll(playerCharacter.getAvailableAbilities(string, string3, this.isVirtual));
            }
            return arrayList;
        }
        Ability ability = AbilityUtilities.retrieveAbilityKeyed(string, string2);
        if (ability != null) {
            arrayList.add(ability);
        }
        return arrayList;
    }

    private void addAbilitiesForSubRegion(PlayerCharacter playerCharacter, ArrayList<Ability> arrayList, String string, String string2) {
        string2 = LevelAbilityAbility.getAbilityTypeFromRegion(playerCharacter, string2, false);
        arrayList.addAll(playerCharacter.getAvailableAbilities(string, string2, this.isVirtual));
    }

    private void addAbilitiesForRegion(PlayerCharacter playerCharacter, ArrayList<Ability> arrayList, String string, String string2) {
        string2 = LevelAbilityAbility.getAbilityTypeFromRegion(playerCharacter, string2, true);
        arrayList.addAll(playerCharacter.getAvailableAbilities(string, string2, this.isVirtual));
    }

    @Override
    public boolean processChoice(List<String> list, List<String> list2, PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo) {
        HashMap<String, AbilityChoice> hashMap = this.useNameMap ? this.nameMap : this.catMap;
        AbilityCategory abilityCategory = SettingsHandler.getGame().getAbilityCategory(this.lastCategorySeen);
        if (this.isVirtual) {
            for (String string : list2) {
                ArrayList<String> arrayList = new ArrayList<String>();
                Ability ability = ((AbilityChoice)hashMap.get(string)).getAbility();
                arrayList.add(((AbilityChoice)hashMap.get(string)).getChoice());
                this.previousChoices.add(ability);
                List<Ability> list3 = playerCharacter.getVirtualAbilityList(abilityCategory);
                Ability ability2 = AbilityUtilities.addVirtualAbility(ability, arrayList, list3, pCLevelInfo);
                playerCharacter.setDirty(true);
                if (ability2 != null) {
                    if (ability2.isMultiples()) {
                        double d = playerCharacter.getRawFeats(false);
                        playerCharacter.setFeats(1.0);
                        ability2.modChoices(playerCharacter, true, abilityCategory);
                        playerCharacter.setFeats(d);
                    }
                    ability2.setNeedsSaving(true);
                    continue;
                }
                Logging.errorPrint("Error:" + string + " not added, aPC.getFeatNamedInList() == NULL");
            }
        } else {
            if (this.numFeats == Integer.MIN_VALUE) {
                this.numFeats = list2.size();
            }
            playerCharacter.adjustAbilities(abilityCategory, new BigDecimal(this.numFeats));
            for (String string : list2) {
                AbilityChoice abilityChoice = (AbilityChoice)hashMap.get(string);
                Ability ability = abilityChoice.getAbility();
                String string2 = abilityChoice.getChoice();
                this.previousChoices.add(ability);
                ArrayList<String> arrayList = new ArrayList<String>();
                boolean bl = false;
                if (ability != null && ability.getChoiceString().startsWith("SPELLLEVEL")) {
                    bl = true;
                    StringTokenizer stringTokenizer = new StringTokenizer(ability.getChoiceString(), "[]", false);
                    stringTokenizer.nextToken();
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList.add(stringTokenizer.nextToken());
                    }
                }
                AbilityUtilities.modAbility(playerCharacter, pCLevelInfo, ability, string2, true, abilityCategory);
                if (!bl || ability == null) continue;
                for (String string3 : arrayList) {
                    ability.applyBonus(string3, string2, playerCharacter, false);
                }
            }
        }
        this.addAllToAssociated(list2);
        return true;
    }

    private static String getAbilityTypeFromRegion(PlayerCharacter playerCharacter, String string, boolean bl) {
        for (PCTemplate pCTemplate : playerCharacter.getTemplateList()) {
            String string2 = bl ? pCTemplate.getRegion() : pCTemplate.getSubRegion();
            if (string2.equals("None")) continue;
            string = string2;
        }
        return string;
    }

    protected static class AbilityChoice {
        Ability ability;
        String choice;

        public AbilityChoice(Ability ability, String string) {
            this.ability = ability;
            this.choice = string;
        }

        public final Ability getAbility() {
            return this.ability;
        }

        public final String getChoice() {
            return this.choice;
        }
    }
}

