/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.levelability;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.levelability.LevelAbility;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LevelAbilityClassSkills
extends LevelAbility {
    private static final int CHOICETYPE_ANY = -1;
    private static final int CHOICETYPE_NONE = 0;
    private static final int CHOICETYPE_UNTRAINED = 1;
    private static final int CHOICETYPE_TRAINED = 2;
    private static final int CHOICETYPE_EXCLUSIVE = 3;
    private static final int CHOICETYPE_NONEXCLUSIVE = 4;
    private static final int CHOICETYPE_CROSSCLASS = 5;
    private static final int CHOICETYPE_BYTYPE = 6;
    private int autoRank = 0;

    LevelAbilityClassSkills(PObject pObject, int n, String string) {
        super(pObject, n, string);
    }

    @Override
    List<String> getChoicesList(String string, PlayerCharacter playerCharacter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.rawTagData.substring(this.rawTagData.indexOf(40) + 1, this.rawTagData.lastIndexOf(41)), ",", false);
        String string2 = "";
        this.autoRank = 0;
        PCClass pCClass = this.owner instanceof PCClass ? (PCClass)this.owner : new PCClass();
        while (stringTokenizer.hasMoreTokens()) {
            int n = 0;
            String string3 = stringTokenizer.nextToken();
            if ("UNTRAINED".equals(string3)) {
                n = 1;
            } else if ("TRAINED".equals(string3)) {
                n = 2;
            } else if ("EXCLUSIVE".equals(string3)) {
                n = 3;
            } else if ("NONEXCLUSIVE".equals(string3)) {
                n = 4;
            } else if ("CROSSCLASSSKILLS".equals(string3)) {
                n = 5;
            } else if ("ANY".equals(string3)) {
                n = -1;
            } else if (string3.startsWith("TYPE=") || string3.startsWith("TYPE.")) {
                string2 = string3.substring(5);
                n = 6;
            } else if (string3.startsWith("AUTORANK=") || string3.startsWith("AUTORANK.")) {
                try {
                    this.autoRank = Integer.parseInt(string3.substring(9));
                }
                catch (NumberFormatException numberFormatException) {
                    Logging.errorPrint("Will use default for autoRank: " + this.autoRank, numberFormatException);
                }
            } else {
                Skill skill = Globals.getSkillKeyed(string3);
                if (skill != null && !skill.isClassSkill(pCClass, playerCharacter)) {
                    arrayList.add(skill.getKeyName());
                }
            }
            if (n == 0) continue;
            block12: for (Skill skill : Globals.getSkillList()) {
                if (skill.isClassSkill(pCClass, playerCharacter)) continue;
                switch (n) {
                    case 1: {
                        if (!skill.isUntrained()) continue block12;
                        break;
                    }
                    case 2: {
                        if (skill.isUntrained()) continue block12;
                        break;
                    }
                    case 3: {
                        if (!skill.isExclusive()) continue block12;
                        break;
                    }
                    case 4: {
                        if (skill.isExclusive()) continue block12;
                        break;
                    }
                    case 5: {
                        if (skill.isExclusive()) continue block12;
                        break;
                    }
                    case -1: {
                        break;
                    }
                    case 6: {
                        if (!skill.isType(string2)) continue block12;
                        break;
                    }
                    default: {
                        Logging.errorPrint("Impossible choice in LevelAbilityClassSkills.getChoicesList() :" + n);
                    }
                }
                arrayList.add(skill.getKeyName());
            }
        }
        return arrayList;
    }

    @Override
    String prepareChooser(ChooserInterface chooserInterface, PlayerCharacter playerCharacter) {
        super.prepareChooser(chooserInterface, playerCharacter);
        StringTokenizer stringTokenizer = new StringTokenizer(this.rawTagData, "|", false);
        try {
            chooserInterface.setTitle(stringTokenizer.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.equalsIgnoreCase("ALL")) {
                chooserInterface.setPool(Integer.MIN_VALUE);
            } else {
                chooserInterface.setPool(Integer.parseInt(string));
            }
        }
        return this.rawTagData;
    }

    @Override
    public boolean processChoice(List<String> list, List<String> list2, PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo) {
        for (String string : list2) {
            Skill skill;
            if (!(this.owner instanceof PCClass) || ((PCClass)this.owner).hasSkill(string)) continue;
            ((PCClass)this.owner).addSkillToList(string);
            if (this.autoRank == 0 || (skill = Globals.getSkillKeyed(string)) == null || playerCharacter == null) continue;
            skill = playerCharacter.addSkill(skill);
            skill.modRanks(1.0, (PCClass)this.owner, true, playerCharacter);
        }
        this.addAllToAssociated(list2);
        return true;
    }
}

