/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.levelability;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.Categorisable;
import pcgen.core.Globals;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.levelability.LevelAbility;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LevelAbilityFeat
extends LevelAbility {
    protected boolean isVirtual = false;
    protected int numFeats = 1;
    protected boolean allowDups = false;
    protected int dupChoices = 0;
    protected ArrayList<String> previousChoices = new ArrayList();
    private boolean hasPrereqs = false;

    LevelAbilityFeat(PObject pObject, int n, String string, boolean bl) {
        super(pObject, n, string);
        this.isVirtual = bl;
    }

    @Override
    public boolean isFeat() {
        return true;
    }

    @Override
    public void subForLevel(PlayerCharacter playerCharacter) {
        if (this.getAssociatedCount(false) == 0) {
            super.subForLevel(playerCharacter);
        } else {
            for (int i = 0; i < this.getAssociatedCount(); ++i) {
                String string = this.getAssociatedList().get(i).toString();
                Ability ability = Globals.getAbilityKeyed("FEAT", string);
                if (ability == null) {
                    playerCharacter.adjustFeats(-1.0);
                    Logging.debugPrint("There is no feat '" + string + "'. Adjusting feat count by -1");
                } else {
                    string = ability.getKeyName();
                    playerCharacter.adjustFeats(-ability.getCost());
                }
                AbilityUtilities.modFeat(playerCharacter, null, string, false, false);
            }
            this.clearAssociated();
        }
    }

    @Override
    List<String> getChoicesList(String string, PlayerCharacter playerCharacter) {
        List<String> list = this.isVirtual ? super.getChoicesList(string.substring(6), playerCharacter) : super.getChoicesList(string.substring(5), playerCharacter);
        Collections.sort(list);
        return list;
    }

    @Override
    String prepareChooser(ChooserInterface chooserInterface, PlayerCharacter playerCharacter) {
        this.setNumberofChoices(chooserInterface, playerCharacter);
        this.numFeats = chooserInterface.getPool();
        if (this.isVirtual) {
            chooserInterface.setTitle("Virtual Feat Selection");
        } else {
            chooserInterface.setTitle("Feat Choice");
        }
        chooserInterface.setPoolFlag(true);
        return this.rawTagData;
    }

    @Override
    public boolean processChoice(List<String> list, List<String> list2, PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo) {
        if (this.isVirtual) {
            int n = list2.size();
            for (int i = 0; i < n; ++i) {
                String string = list2.get(i);
                this.previousChoices.add(string);
                Ability ability = AbilityUtilities.addVirtualAbility("FEAT", string, playerCharacter.getVirtualFeatList(), pCLevelInfo);
                playerCharacter.setDirty(true);
                if (ability != null) {
                    ability.setNeedsSaving(true);
                    continue;
                }
                Logging.errorPrint("Error:" + string + " not added, aPC.getFeatNamedInList() == NULL");
            }
        } else {
            if (this.numFeats == Integer.MIN_VALUE) {
                this.numFeats = list2.size();
            }
            if (list2.size() == 0) {
                double d = Double.NaN;
                double d2 = Double.NaN;
                for (int i = 0; i < list.size(); ++i) {
                    String string = list.get(i);
                    Ability ability = Globals.getAbilityKeyed("ALL", string);
                    double d3 = ability == null ? 1.0 : ability.getCost();
                    if (Double.isNaN(d) || d3 > d) {
                        d = d3;
                    }
                    if (!Double.isNaN(d2) && !(d3 < d2)) continue;
                    d2 = d3;
                }
                if (!Double.isNaN(d) && CoreUtility.doublesEqual(d2, d) && d > -1.0E-4) {
                    playerCharacter.adjustFeats(d);
                    return true;
                }
                ShowMessageDelegate.showMessageDialog("Available selections have varying costs.\nYou must make a selection.", "PCGen", MessageType.INFORMATION);
                return false;
            }
            for (int i = 0; i < list2.size(); ++i) {
                Object object;
                String string = list2.get(i);
                this.previousChoices.add(string);
                String string2 = string;
                ArrayList<String> arrayList = new ArrayList<String>();
                Ability ability = Globals.getAbilityKeyed("FEAT", string2);
                boolean bl = false;
                if (ability != null && ability.getChoiceString().startsWith("SPELLLEVEL")) {
                    bl = true;
                    object = new StringTokenizer(ability.getChoiceString(), "[]", false);
                    ((StringTokenizer)object).nextToken();
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        arrayList.add(((StringTokenizer)object).nextToken());
                    }
                }
                if (ability != null) {
                    playerCharacter.adjustFeats(ability.getCost());
                } else {
                    playerCharacter.adjustFeats(1.0);
                    Logging.debugPrint("There is no feat '" + string2 + "'. Adjusting feat count by 1");
                }
                AbilityUtilities.modFeat(playerCharacter, pCLevelInfo, string2, true, false);
                if (!bl || ability == null) continue;
                if (string.indexOf(40) > 0) {
                    object = new StringTokenizer(string, "()", false);
                    ability = playerCharacter.getFeatNamed(((StringTokenizer)object).nextToken());
                    string = ((StringTokenizer)object).nextToken();
                }
                if (ability == null) continue;
                for (String string3 : arrayList) {
                    ability.applyBonus(string3, string, playerCharacter, false);
                }
            }
        }
        return true;
    }

    @Override
    void processToken(String string, List<String> list, PlayerCharacter playerCharacter) {
        if ("STACKS".equals(string)) {
            this.allowDups = true;
            return;
        }
        if (string.startsWith("STACKS=")) {
            this.allowDups = true;
            try {
                this.dupChoices = Integer.parseInt(string.substring(7));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return;
        }
        List<String> list2 = this.getFeatList(string, playerCharacter);
        Iterator<String> iterator = list2.iterator();
        this.hasPrereqs = false;
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",", false);
            String string3 = stringTokenizer.nextToken().trim();
            String string4 = "";
            Ability ability = AbilityUtilities.retrieveAbilityKeyed("FEAT", string3);
            if (ability == null) {
                Logging.errorPrint("LevelAbilityFeat: Feat not found: " + string3);
                continue;
            }
            if (!string3.equalsIgnoreCase(ability.getKeyName())) {
                string4 = this.adjustNames(string3, ability);
                string3 = ability.getKeyName();
            }
            if (this.allowDups && ability.hasPreReqs()) {
                this.hasPrereqs = true;
            }
            if (this.allowDups && this.dupChoices > 0 && this.dupChoices <= this.timesChoiceHasBeenTaken(string3) || !this.isVirtual && !PrereqHandler.passesAll(ability.getPreReqList(), playerCharacter, ability)) continue;
            if (ability.isMultiples()) {
                this.addMultiplySelectableAbility(list, playerCharacter, string3, string4, ability);
                continue;
            }
            if (playerCharacter.hasRealFeat(Globals.getAbilityKeyed("FEAT", string3)) || playerCharacter.hasFeatAutomatic(string3)) continue;
            list.add(string3);
        }
    }

    private List<String> getFeatList(String string, PlayerCharacter playerCharacter) {
        if (string.equals("ALL") || string.equals("ANY")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Categorisable categorisable : Globals.getUnmodifiableAbilityList("FEAT")) {
                Ability ability = (Ability)categorisable;
                if (!playerCharacter.canSelectAbility(ability, this.isVirtual) || !ability.getVisibility().equals((Object)Visibility.DEFAULT)) continue;
                arrayList.add(ability.getKeyName());
            }
            return arrayList;
        }
        if (string.startsWith("TYPE=") || string.startsWith("TYPE.")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string2 = string.substring(5);
            if ("REGION".equals(string2)) {
                this.addFeatsForRegion(playerCharacter, arrayList, string2);
            } else if ("SUBREGION".equals(string2)) {
                this.addFeatsForSubRegion(playerCharacter, arrayList, string2);
            } else if ("ALLREGION".equals(string2)) {
                this.addFeatsForRegion(playerCharacter, arrayList, string2);
                this.addFeatsForSubRegion(playerCharacter, arrayList, string2);
            } else {
                arrayList.addAll(playerCharacter.getAvailableFeatNames(string2, this.isVirtual));
            }
            return arrayList;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        return arrayList;
    }

    private void addFeatsForRegion(PlayerCharacter playerCharacter, ArrayList<String> arrayList, String string) {
        string = LevelAbilityFeat.findFeatType(playerCharacter, string, true);
        arrayList.addAll(playerCharacter.getAvailableFeatNames(string, this.isVirtual));
    }

    private void addFeatsForSubRegion(PlayerCharacter playerCharacter, ArrayList<String> arrayList, String string) {
        string = LevelAbilityFeat.findFeatType(playerCharacter, string, false);
        arrayList.addAll(playerCharacter.getAvailableFeatNames(string, this.isVirtual));
    }

    private static String findFeatType(PlayerCharacter playerCharacter, String string, boolean bl) {
        for (PCTemplate pCTemplate : playerCharacter.getTemplateList()) {
            String string2 = bl ? pCTemplate.getRegion() : pCTemplate.getSubRegion();
            if (string2.equals("None")) continue;
            string = string2;
        }
        return string;
    }

    private String adjustNames(String string, Ability ability) {
        String string2 = string.substring(ability.getKeyName().length());
        int n = string2.indexOf(40);
        return n > -1 ? string2.substring(n + 1) : string2;
    }

    private void addMultiplySelectableAbility(List<String> list, PlayerCharacter playerCharacter, String string, String string2, Ability ability) {
        Iterator iterator;
        int n;
        int n2;
        Ability ability2 = playerCharacter.getFeatNamed(string);
        if (ability2 != null) {
            ability = ability2;
        }
        if ((n2 = string2.indexOf(37)) > -1) {
            string2 = string2.substring(0, n2);
        } else if (string2.length() != 0 && (n = string2.lastIndexOf(41)) > -1) {
            string2 = string2.substring(0, n);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string3 = ability.getChoiceString();
        if (string3.indexOf("NUMCHOICES=") < 0 && string3.indexOf("COUNT=") < 0) {
            iterator = new ArrayList();
            ArrayList object2 = new ArrayList();
            ability.modChoices((List)((Object)iterator), object2, false, playerCharacter, true, AbilityCategory.FEAT);
            Iterator iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                arrayList.add(String.valueOf(iterator2.next()));
            }
            iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                arrayList2.add(String.valueOf(iterator2.next()));
            }
        } else {
            arrayList.add("NOCHOICE");
        }
        if (string2.length() != 0) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                String string4 = (String)arrayList.get(i);
                if (string4.startsWith(string2)) continue;
                arrayList.remove(i);
            }
            if (n2 == -1 && arrayList.size() == 0) {
                arrayList.add(string2);
            }
        }
        if (!ability.isStacks()) {
            iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                int n3 = arrayList.indexOf(iterator.next());
                if (n3 <= -1) continue;
                arrayList.remove(n3);
            }
        }
        if (!ability.getChoiceString().startsWith("SPELLLIST|")) {
            for (String string5 : arrayList) {
                if (!string5.equalsIgnoreCase("NOCHOICE")) {
                    list.add(string + "(" + string5 + ")");
                    continue;
                }
                list.add(string);
            }
        } else {
            list.add(string);
        }
    }

    private int timesChoiceHasBeenTaken(String string) {
        int n = 0;
        for (String string2 : this.previousChoices) {
            if (!string.equalsIgnoreCase(string2)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public void process(List<String> list, PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo) {
        this.aText = this.rawTagData;
        boolean bl = true;
        int n = 1;
        int n2 = 0;
        do {
            ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
            String string = this.prepareChooser(chooserInterface, playerCharacter);
            List<String> list2 = this.getChoicesList(string, playerCharacter);
            if (this.allowDups) {
                if ((n -= n2) < 1) break;
                if (!bl || this.hasPrereqs) {
                    chooserInterface.setPool(1);
                } else if (bl && this.dupChoices > 0) {
                    n = this.numFeats;
                    chooserInterface.setPool(Math.min(n, this.dupChoices));
                }
                bl = false;
            }
            chooserInterface.setAllowsDups(this.allowDups);
            n2 = 0;
            if (list != null) {
                list.addAll(list2);
                continue;
            }
            if (chooserInterface.getPool() == Integer.MIN_VALUE) {
                this.processChoice(list2, list2, playerCharacter, pCLevelInfo);
                n2 = chooserInterface.getSelectedList().size();
                continue;
            }
            chooserInterface.setAvailableList(list2);
            chooserInterface.setVisible(false);
            if (list2.size() <= 0) continue;
            do {
                chooserInterface.setVisible(true);
            } while (!this.processChoice(list2, chooserInterface.getSelectedList(), playerCharacter, pCLevelInfo));
            n2 = chooserInterface.getSelectedList().size();
        } while (this.allowDups);
    }
}

