/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.levelability;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import pcgen.core.Ability;
import pcgen.core.Categorisable;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SpecialAbility;
import pcgen.core.levelability.LevelAbility;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.util.chooser.ChooserInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LevelAbilitySpecial
extends LevelAbility {
    LevelAbilitySpecial(PObject pObject, int n, String string) {
        super(pObject, n, string);
    }

    @Override
    List<String> getChoicesList(String string, PlayerCharacter playerCharacter) {
        if ((string = string.substring(string.lastIndexOf(40) + 1)).lastIndexOf(")") >= string.length() - 2) {
            string = string.substring(0, string.lastIndexOf(")"));
        }
        List<String> list = super.getChoicesList(string, playerCharacter);
        Collections.sort(list);
        return list;
    }

    @Override
    String prepareChooser(ChooserInterface chooserInterface, PlayerCharacter playerCharacter) {
        super.prepareChooser(chooserInterface, playerCharacter);
        chooserInterface.setTitle("Special Ability Choice");
        return this.rawTagData;
    }

    @Override
    public boolean processChoice(List<String> list, List<String> list2, PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo) {
        for (String string : list2) {
            SpecialAbility specialAbility;
            if ("Free Feat".equals(string)) {
                playerCharacter.adjustFeats(1.0);
                continue;
            }
            if (this.owner instanceof PCClass) {
                String string2 = "PCCLASS|" + this.owner.getKeyName() + "|" + this.level();
                specialAbility = new SpecialAbility(string, string2);
            } else {
                specialAbility = new SpecialAbility(string);
            }
            this.owner.addSpecialAbilityToList(specialAbility);
            this.owner.addSave(string);
        }
        return true;
    }

    @Override
    void processToken(String string, List<String> list, PlayerCharacter playerCharacter) {
        if ("FEATLIST".equals(string)) {
            Iterator<Categorisable> iterator = Globals.getAbilityKeyIterator("FEAT");
            while (iterator.hasNext()) {
                Ability ability = (Ability)iterator.next();
                if (!playerCharacter.canSelectAbility(ability)) continue;
                list.add(ability.getKeyName());
            }
        } else if ("Free Feat".equals(string)) {
            list.add(string);
        } else if (string.startsWith("FEATTYPE=") || string.startsWith("FEATTYPE.")) {
            String string2 = string.substring(9);
            list.addAll(playerCharacter.getAvailableFeatNames(string2));
        } else if (string.startsWith("FEAT=") || string.startsWith("FEAT.")) {
            String string3 = string.substring(5);
            Ability ability = Globals.getAbilityKeyed("FEAT", string3);
            if (playerCharacter.canSelectAbility(ability)) {
                list.add(ability.getKeyName());
            }
        } else {
            List<String> list2 = playerCharacter.getSpecialAbilityListStrings();
            if (!list2.contains(string)) {
                list.add(string);
            }
        }
    }
}

