/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.npcgen;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.QualifiedObject;
import pcgen.core.SettingsHandler;
import pcgen.core.SubClass;
import pcgen.core.npcgen.SkillChoice;
import pcgen.core.spell.Spell;
import pcgen.util.WeightedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassData {
    private String theClassKey = null;
    private WeightedList<String> theStatWeights = null;
    private WeightedList<SkillChoice> theSkillWeights = null;
    private Map<AbilityCategory, WeightedList<Ability>> theAbilityWeights = null;
    private WeightedList<Deity> theDeityWeights = null;
    private Map<String, WeightedList<Domain>> theDomainWeights = null;
    private Map<Integer, WeightedList<Spell>> theKnownSpellWeights = null;
    private Map<Integer, WeightedList<Spell>> thePreparedSpellWeights = null;
    private WeightedList<String> theSubClassWeights = null;

    public ClassData(String string) {
        this.theClassKey = string;
    }

    public String getClassKey() {
        return this.theClassKey;
    }

    public void addStat(String string, int n) {
        if (this.theStatWeights == null) {
            this.theStatWeights = new WeightedList();
        }
        this.theStatWeights.add(n, string);
    }

    public WeightedList<String> getStatWeights() {
        List<PCStat> list = SettingsHandler.getGame().getUnmodifiableStatList();
        for (PCStat pCStat : list) {
            if (this.theStatWeights != null && this.theStatWeights.contains(pCStat.getAbb())) continue;
            this.addStat(pCStat.getAbb(), 1);
        }
        return this.theStatWeights;
    }

    public void addSkill(String string, int n) {
        if (this.theSkillWeights == null) {
            this.theSkillWeights = new WeightedList();
        }
        for (SkillChoice skillChoice : this.theSkillWeights) {
            if (!skillChoice.hasSkill(string)) continue;
            return;
        }
        this.theSkillWeights.add(n, new SkillChoice(string));
    }

    public void removeSkill(String string) {
        if (this.theSkillWeights == null) {
            return;
        }
        this.theSkillWeights.remove(new SkillChoice(string));
    }

    public WeightedList<SkillChoice> getSkillWeights() {
        return this.theSkillWeights;
    }

    public void addAbility(AbilityCategory abilityCategory, Ability ability, int n) {
        WeightedList<Ability> weightedList;
        if (this.theAbilityWeights == null) {
            this.theAbilityWeights = new HashMap<AbilityCategory, WeightedList<Ability>>();
        }
        if ((weightedList = this.theAbilityWeights.get(abilityCategory)) == null) {
            weightedList = new WeightedList();
            this.theAbilityWeights.put(abilityCategory, weightedList);
        }
        if (!weightedList.contains(ability)) {
            weightedList.add(n, ability);
        }
    }

    public void removeAbility(AbilityCategory abilityCategory, Ability ability) {
        if (this.theAbilityWeights == null) {
            return;
        }
        WeightedList<Ability> weightedList = this.theAbilityWeights.get(abilityCategory);
        if (weightedList == null) {
            return;
        }
        weightedList.remove(ability);
    }

    public WeightedList<Ability> getAbilityWeights(AbilityCategory abilityCategory) {
        if (this.theAbilityWeights == null) {
            return null;
        }
        return this.theAbilityWeights.get(abilityCategory);
    }

    public void addDeity(Deity deity, int n) {
        if (this.theDeityWeights == null) {
            this.theDeityWeights = new WeightedList();
        }
        this.theDeityWeights.add(n, deity);
    }

    public WeightedList<Deity> getDeityWeights() {
        if (this.theDeityWeights == null) {
            for (Deity deity : Globals.getDeityList()) {
                this.addDeity(deity, 1);
            }
        }
        return this.theDeityWeights;
    }

    public void addDomain(String string, Domain domain, int n) {
        WeightedList<Domain> weightedList;
        if (this.theDomainWeights == null) {
            this.theDomainWeights = new HashMap<String, WeightedList<Domain>>();
        }
        if ((weightedList = this.theDomainWeights.get(string)) == null) {
            weightedList = new WeightedList();
            this.theDomainWeights.put(string, weightedList);
        }
        weightedList.add(n, domain);
    }

    public WeightedList<Domain> getDomainWeights(String string) {
        WeightedList<Domain> weightedList;
        if (this.theDomainWeights == null) {
            this.theDomainWeights = new HashMap<String, WeightedList<Domain>>();
        }
        if ((weightedList = this.theDomainWeights.get(string)) == null) {
            weightedList = new WeightedList();
            Deity deity = Globals.getDeityKeyed(string);
            List<QualifiedObject<Domain>> list = deity.getDomainList();
            for (QualifiedObject<Domain> qualifiedObject : list) {
                weightedList.add(1, qualifiedObject.getObject(null));
            }
        }
        return weightedList;
    }

    public void addKnownSpell(int n, Spell spell, int n2) {
        WeightedList<Spell> weightedList;
        if (this.theKnownSpellWeights == null) {
            this.theKnownSpellWeights = new HashMap<Integer, WeightedList<Spell>>();
        }
        if ((weightedList = this.theKnownSpellWeights.get(n)) == null) {
            weightedList = new WeightedList();
            this.theKnownSpellWeights.put(n, weightedList);
        }
        if (!weightedList.contains(spell)) {
            weightedList.add(n2, spell);
        }
    }

    public void removeKnownSpell(int n, Spell spell) {
        if (this.theKnownSpellWeights == null) {
            return;
        }
        WeightedList<Spell> weightedList = this.theKnownSpellWeights.get(n);
        if (weightedList != null) {
            weightedList.remove(spell);
        }
    }

    public WeightedList<Spell> getKnownSpellWeights(int n) {
        WeightedList<Spell> weightedList;
        if (this.theKnownSpellWeights == null) {
            this.theKnownSpellWeights = new HashMap<Integer, WeightedList<Spell>>();
        }
        if ((weightedList = this.theKnownSpellWeights.get(n)) == null) {
            weightedList = new WeightedList();
            for (Spell spell : Globals.getSpellsIn(n, this.theClassKey, "")) {
                weightedList.add(1, spell);
            }
        }
        return weightedList;
    }

    public void addPreparedSpell(int n, Spell spell, int n2) {
        WeightedList<Spell> weightedList;
        if (this.thePreparedSpellWeights == null) {
            this.thePreparedSpellWeights = new HashMap<Integer, WeightedList<Spell>>();
        }
        if ((weightedList = this.thePreparedSpellWeights.get(n)) == null) {
            weightedList = new WeightedList();
            this.thePreparedSpellWeights.put(n, weightedList);
        }
        if (!weightedList.contains(spell)) {
            weightedList.add(n2, spell);
        }
    }

    public void removePreparedSpell(int n, Spell spell) {
        if (this.thePreparedSpellWeights == null) {
            return;
        }
        WeightedList<Spell> weightedList = this.thePreparedSpellWeights.get(n);
        if (weightedList != null) {
            weightedList.remove(spell);
        }
    }

    public WeightedList<Spell> getPreparedSpellWeights(int n) {
        WeightedList<Spell> weightedList;
        if (this.thePreparedSpellWeights == null) {
            this.thePreparedSpellWeights = new HashMap<Integer, WeightedList<Spell>>();
        }
        if ((weightedList = this.thePreparedSpellWeights.get(n)) == null) {
            weightedList = new WeightedList();
            for (Spell spell : Globals.getSpellsIn(n, this.theClassKey, "")) {
                weightedList.add(1, spell);
            }
        }
        return weightedList;
    }

    public void addSubClass(String string, int n) {
        if (this.theSubClassWeights == null) {
            this.theSubClassWeights = new WeightedList();
        }
        this.theSubClassWeights.add(n, string);
    }

    public WeightedList<String> getSubClassWeights() {
        PCClass pCClass;
        if (this.theSubClassWeights == null && (pCClass = Globals.getClassKeyed(this.theClassKey)) != null) {
            List<SubClass> list = pCClass.getSubClassList();
            for (SubClass subClass : list) {
                this.addSubClass(subClass.getKeyName(), 1);
            }
        }
        return this.theSubClassWeights;
    }
}

