/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.npcgen;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SystemCollections;
import pcgen.core.npcgen.ClassData;
import pcgen.core.spell.Spell;
import pcgen.util.Logging;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassDataHandler
extends DefaultHandler {
    private List<ClassData> theList;
    private GameMode theGameMode = null;
    private boolean theValidFlag = false;
    private ParserState theState = ParserState.INIT;
    private ClassData theCurrentData = null;
    private AbilityCategory theCurrentCategory = null;
    private SpellType theCurrentSpellType = SpellType.KNOWN;
    private int theCurrentLevel = -1;
    private transient int remainingWeight = -1;
    private transient List<String> removeList = new ArrayList<String>();

    public ClassDataHandler(GameMode gameMode, List<ClassData> list) {
        this.theGameMode = gameMode;
        this.theList = list;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.theState == ParserState.INIT && "class_data".equals(string3)) {
            if (attributes != null) {
                String string4 = attributes.getValue("game_mode");
                if (!SystemCollections.getGameModeNamed(string4).equals(this.theGameMode)) {
                    throw new IllegalArgumentException("Incorrect game mode");
                }
                this.theValidFlag = true;
            }
            return;
        }
        if (!this.theValidFlag) {
            throw new SAXException("NPCGen.Options.InvalidFileFormat");
        }
        if (this.theState == ParserState.INIT) {
            if ("class".equals(string3) && attributes != null) {
                String string5 = attributes.getValue("key");
                PCClass pCClass = Globals.getClassKeyed(string5);
                if (pCClass == null) {
                    Logging.errorPrintLocalised("Exceptions.PCGenParser.ClassNotFound", string5);
                } else {
                    this.theCurrentData = new ClassData(string5);
                    this.theState = ParserState.CLASSDATA;
                }
            }
        } else if (this.theState == ParserState.CLASSDATA) {
            if ("stats".equals(string3)) {
                this.theState = ParserState.STATDATA;
            } else if ("skills".equals(string3)) {
                this.theState = ParserState.SKILLDATA;
            } else if ("abilities".equals(string3)) {
                String string6;
                this.theState = ParserState.ABILITYDATA;
                this.theCurrentCategory = AbilityCategory.FEAT;
                if (attributes != null && (string6 = attributes.getValue("category")) != null) {
                    this.theCurrentCategory = SettingsHandler.getGame().getAbilityCategory(string6);
                }
            } else if ("spells".equals(string3)) {
                String string7;
                this.theState = ParserState.SPELLDATA;
                this.theCurrentSpellType = SpellType.KNOWN;
                if (attributes != null && (string7 = attributes.getValue("type")) != null && "Prepared Spells".equals(string7)) {
                    this.theCurrentSpellType = SpellType.PREPARED;
                }
            } else if ("subclasses".equals(string3)) {
                this.theState = ParserState.SUBCLASSDATA;
            }
        } else if (this.theState == ParserState.STATDATA) {
            if ("stat".equals(string3) && attributes != null) {
                int n = this.getWeight(attributes);
                String string8 = attributes.getValue("value");
                if (string8 != null) {
                    this.theCurrentData.addStat(string8, n);
                }
            }
        } else if (this.theState == ParserState.SKILLDATA) {
            if ("skill".equals(string3) && attributes != null) {
                int n = this.getWeight(attributes);
                String string9 = attributes.getValue("value");
                if (string9 != null) {
                    if ("*".equals(string9)) {
                        this.remainingWeight = n;
                    } else if (string9.startsWith("TYPE")) {
                        List<Skill> list = Globals.getSkillsByType(string9.substring(5));
                        if (list.size() == 0) {
                            Logging.debugPrint("NPCGenerator: No skills of type found (" + string9 + ")");
                        }
                    } else {
                        Skill skill = Globals.getSkillKeyed(string9);
                        if (skill == null) {
                            Logging.debugPrint("NPCGenerator: Skill not found (" + string9 + ")");
                        }
                    }
                    if (n > 0 && !string9.equals("*")) {
                        this.theCurrentData.addSkill(string9, n);
                    } else {
                        this.removeList.add(string9);
                    }
                }
            }
        } else if (this.theState == ParserState.ABILITYDATA) {
            if ("ability".equals(string3) && attributes != null) {
                int n = this.getWeight(attributes);
                String string10 = attributes.getValue("value");
                if (string10 != null) {
                    if ("*".equals(string10)) {
                        this.remainingWeight = n;
                    } else if (string10.startsWith("TYPE")) {
                        List<Ability> list = Globals.getAbilitiesByType(this.theCurrentCategory.getAbilityCategory(), string10.substring(5));
                        for (Ability ability : list) {
                            if (ability.getVisibility() != Visibility.DEFAULT) continue;
                            if (n > 0) {
                                this.theCurrentData.addAbility(this.theCurrentCategory, ability, n);
                                continue;
                            }
                            this.removeList.add(ability.getKeyName());
                        }
                    } else {
                        Ability ability = Globals.getAbilityKeyed(this.theCurrentCategory.getAbilityCategory(), string10);
                        if (ability == null) {
                            Logging.debugPrint("Ability (" + string10 + ") not found");
                        } else if (n > 0) {
                            this.theCurrentData.addAbility(this.theCurrentCategory, ability, n);
                        } else {
                            this.removeList.add(ability.getKeyName());
                        }
                    }
                }
            }
        } else if (this.theState == ParserState.SPELLDATA) {
            String string11;
            if ("level".equals(string3) && attributes != null && (string11 = attributes.getValue("id")) != null) {
                this.theCurrentLevel = Integer.parseInt(string11);
                this.theState = ParserState.SPELLLEVELDATA;
            }
        } else if (this.theState == ParserState.SPELLLEVELDATA) {
            if ("spell".equals(string3) && attributes != null) {
                int n = this.getWeight(attributes);
                String string12 = attributes.getValue("name");
                if (string12 != null) {
                    if ("*".equals(string12)) {
                        this.remainingWeight = n;
                    } else if (!string12.startsWith("SCHOOL")) {
                        Spell spell = Globals.getSpellKeyed(string12);
                        if (spell != null) {
                            if (this.theCurrentSpellType == SpellType.KNOWN) {
                                this.theCurrentData.addKnownSpell(this.theCurrentLevel, spell, n);
                            } else if (this.theCurrentSpellType == SpellType.PREPARED) {
                                this.theCurrentData.addPreparedSpell(this.theCurrentLevel, spell, n);
                            }
                        } else {
                            Logging.errorPrint("Spell \"" + string12 + "\" not found.");
                        }
                    }
                }
            }
        } else if (this.theState == ParserState.SUBCLASSDATA && "subclass".equals(string3) && attributes != null) {
            int n = this.getWeight(attributes);
            String string13 = attributes.getValue("value");
            this.theCurrentData.addSubClass(string13, n);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (this.theState == ParserState.INIT) {
            return;
        }
        if ("skills".equals(string3) && this.theState == ParserState.SKILLDATA) {
            if (this.remainingWeight > 0) {
                List<Skill> list = Globals.getSkillList();
                Iterator<Skill> object = list.iterator();
                while (object.hasNext()) {
                    Skill skill = object.next();
                    if (skill.getVisibility() != Visibility.DEFAULT) continue;
                    this.theCurrentData.addSkill(skill.getKeyName(), this.remainingWeight);
                }
                this.remainingWeight = -1;
            }
            for (String object : this.removeList) {
                this.theCurrentData.removeSkill(object);
            }
            this.removeList = new ArrayList<String>();
            this.theState = ParserState.CLASSDATA;
        } else if ("abilities".equals(string3) && this.theState == ParserState.ABILITYDATA) {
            if (this.remainingWeight > 0) {
                Iterator<Object> iterator = Globals.getAbilityNameIterator(this.theCurrentCategory.getAbilityCategory());
                while (iterator.hasNext()) {
                    Ability ability = (Ability)iterator.next();
                    if (ability.getVisibility() != Visibility.DEFAULT) continue;
                    this.theCurrentData.addAbility(this.theCurrentCategory, ability, this.remainingWeight);
                }
                this.remainingWeight = -1;
            }
            for (String string4 : this.removeList) {
                Ability ability = Globals.getAbilityKeyed(this.theCurrentCategory, string4);
                this.theCurrentData.removeAbility(this.theCurrentCategory, ability);
            }
            this.removeList = new ArrayList<String>();
            this.theCurrentCategory = null;
            this.theState = ParserState.CLASSDATA;
        } else if ("class".equals(string3) && this.theState != ParserState.INIT) {
            this.theList.add(this.theCurrentData);
            this.theState = ParserState.INIT;
        } else if ("stats".equals(string3)) {
            this.theState = ParserState.CLASSDATA;
        } else if ("level".equals(string3)) {
            Spell spell;
            if (this.remainingWeight > 0) {
                List<Spell> list = Globals.getSpellsIn(this.theCurrentLevel, this.theCurrentData.getClassKey(), "");
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    spell = (Spell)iterator.next();
                    if (this.theCurrentSpellType == SpellType.KNOWN) {
                        this.theCurrentData.addKnownSpell(this.theCurrentLevel, spell, this.remainingWeight);
                        continue;
                    }
                    if (this.theCurrentSpellType != SpellType.PREPARED) continue;
                    this.theCurrentData.addPreparedSpell(this.theCurrentLevel, spell, this.remainingWeight);
                }
                this.remainingWeight = -1;
            }
            for (String string5 : this.removeList) {
                spell = Globals.getSpellKeyed(string5);
                if (this.theCurrentSpellType == SpellType.KNOWN) {
                    this.theCurrentData.removeKnownSpell(this.theCurrentLevel, spell);
                    continue;
                }
                if (this.theCurrentSpellType != SpellType.PREPARED) continue;
                this.theCurrentData.removeKnownSpell(this.theCurrentLevel, spell);
            }
            this.removeList = new ArrayList<String>();
            this.theCurrentLevel = -1;
            this.theState = ParserState.SPELLDATA;
        } else if ("spells".equals(string3)) {
            this.theState = ParserState.CLASSDATA;
            this.theCurrentSpellType = SpellType.KNOWN;
        } else if ("subclasses".equals(string3)) {
            this.theState = ParserState.CLASSDATA;
        }
    }

    private int getWeight(Attributes attributes) {
        int n = 1;
        String string = attributes.getValue("weight");
        if (string != null) {
            n = Integer.parseInt(string.trim());
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SpellType {
        KNOWN,
        PREPARED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParserState {
        INIT,
        CLASSDATA,
        STATDATA,
        SKILLDATA,
        ABILITYDATA,
        SPELLDATA,
        SPELLLEVELDATA,
        SUBCLASSDATA;

    }
}

