/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.npcgen;

import pcgen.core.Globals;
import pcgen.core.Race;
import pcgen.core.npcgen.GeneratorOption;
import pcgen.util.Logging;
import pcgen.util.WeightedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RaceGeneratorOption
extends GeneratorOption {
    private WeightedList<Race> theChoices = null;

    @Override
    public void addChoice(int n, String string) {
        if (this.theChoices == null) {
            this.theChoices = new WeightedList();
        }
        if (string.equals("*")) {
            for (Race race : Globals.getAllRaces()) {
                if (this.theChoices.contains(race)) continue;
                this.theChoices.add(n, race);
            }
            return;
        }
        if (string.startsWith("TYPE")) {
            for (Race race : Globals.getAllRaces()) {
                if (!race.isType(string.substring(5)) || race.getDisplayName().equals("<none selected>")) continue;
                this.theChoices.add(n, race);
            }
            return;
        }
        Race race = Globals.getRaceKeyed(string);
        if (race == null) {
            Logging.errorPrintLocalised("NPCGen.Options.RaceNotFound", string);
        } else {
            this.theChoices.add(n, race);
        }
    }

    public WeightedList<Race> getList() {
        return this.theChoices;
    }
}

