/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.util.List;
import pcgen.core.Ability;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.core.prereq.PrerequisiteTestFactory;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrereqHandler {
    public static boolean passesAll(List<Prerequisite> list, PlayerCharacter playerCharacter, PObject pObject) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        if (pObject instanceof PCClass && Globals.checkRule("CLASSPRE")) {
            return true;
        }
        if (pObject instanceof Ability && Globals.checkRule("FEATPRE")) {
            return true;
        }
        if (playerCharacter != null && pObject != null && playerCharacter.checkQualifyList(pObject)) {
            return true;
        }
        for (Prerequisite prerequisite : list) {
            Prerequisite prerequisite2;
            if (prerequisite instanceof String) {
                String string = (String)((Object)prerequisite);
                Logging.debugPrintLocalised("PrereqHandler.Why_not_already_parsed", prerequisite, "PrereqHandler.passesAll()");
                try {
                    PreParserFactory preParserFactory = PreParserFactory.getInstance();
                    prerequisite2 = preParserFactory.parse(string);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    Logging.errorPrint(persistenceLayerException.getMessage(), persistenceLayerException);
                    return false;
                }
            } else {
                prerequisite2 = prerequisite;
            }
            if (PrereqHandler.passes(prerequisite2, playerCharacter, pObject)) continue;
            return false;
        }
        return true;
    }

    public static boolean passesAll(List<?> list, Equipment equipment, PlayerCharacter playerCharacter) {
        if (list == null) {
            return true;
        }
        for (Object obj : list) {
            Prerequisite prerequisite;
            if (obj instanceof String) {
                Logging.debugPrintLocalised("PrereqHandler.Why_not_already_parsed", obj, "PrereqHandler.passesAll()");
                try {
                    PreParserFactory preParserFactory = PreParserFactory.getInstance();
                    prerequisite = preParserFactory.parse((String)obj);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    Logging.errorPrint(persistenceLayerException.getMessage(), persistenceLayerException);
                    return false;
                }
            } else {
                prerequisite = (Prerequisite)obj;
            }
            if (PrereqHandler.passes(prerequisite, equipment, playerCharacter)) continue;
            return false;
        }
        return true;
    }

    public static boolean passesAtLeastOne(List<Prerequisite> list, PlayerCharacter playerCharacter, PObject pObject) {
        if (list == null) {
            return true;
        }
        for (Prerequisite prerequisite : list) {
            if (!PrereqHandler.passes(prerequisite, playerCharacter, pObject)) continue;
            return true;
        }
        return false;
    }

    public static boolean passesAtLeastOne(List<Prerequisite> list, Equipment equipment, PlayerCharacter playerCharacter) {
        if (list == null) {
            return true;
        }
        for (Prerequisite prerequisite : list) {
            if (!PrereqHandler.passes(prerequisite, equipment, playerCharacter)) continue;
            return true;
        }
        return false;
    }

    public static boolean passes(Prerequisite prerequisite, PlayerCharacter playerCharacter, PObject pObject) {
        if (playerCharacter == null) {
            return true;
        }
        PrerequisiteTestFactory prerequisiteTestFactory = PrerequisiteTestFactory.getInstance();
        PrerequisiteTest prerequisiteTest = prerequisiteTestFactory.getTest(prerequisite.getKind());
        if (prerequisite.getLevelQualifier() >= 0 && pObject instanceof PCClass && ((PCClass)pObject).getLevel() != prerequisite.getLevelQualifier()) {
            return true;
        }
        if (prerequisiteTest == null) {
            Logging.errorPrintLocalised("PrereqHandler.Unable_to_find_implementation", prerequisite.toString());
            return false;
        }
        boolean bl = prerequisite.isOverrideQualify();
        boolean bl2 = false;
        int n = 0;
        if (pObject != null && playerCharacter.checkQualifyList(pObject) && !bl) {
            bl2 = true;
        }
        if (bl2) {
            return true;
        }
        try {
            n = prerequisiteTest.passes(prerequisite, playerCharacter);
        }
        catch (PrerequisiteException prerequisiteException) {
            Logging.errorPrintLocalised("PrereqHandler.Exception_in_test", prerequisiteException);
        }
        catch (Exception exception) {
            Logging.errorPrint("Problem encountered when testing PREREQ " + String.valueOf(prerequisite) + (pObject != null ? " for " + String.valueOf(pObject) : "") + ". See following trace for details.", exception);
        }
        return n > 0;
    }

    public static boolean passes(Prerequisite prerequisite, Equipment equipment, PlayerCharacter playerCharacter) {
        if (equipment == null) {
            return true;
        }
        PrerequisiteTestFactory prerequisiteTestFactory = PrerequisiteTestFactory.getInstance();
        PrerequisiteTest prerequisiteTest = prerequisiteTestFactory.getTest(prerequisite.getKind());
        if (prerequisiteTest == null) {
            Logging.errorPrintLocalised("PrereqHandler.Unable_to_find_implementation", prerequisite.toString());
            return false;
        }
        int n = 0;
        try {
            n = prerequisiteTest.passes(prerequisite, equipment, playerCharacter);
        }
        catch (PrerequisiteException prerequisiteException) {
            Logging.errorPrintLocalised("PrereqHandler.Exception_in_test", prerequisiteException);
        }
        return n > 0;
    }

    public static final String toHtmlString(List<Prerequisite> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        PrerequisiteTestFactory prerequisiteTestFactory = PrerequisiteTestFactory.getInstance();
        StringBuffer stringBuffer = new StringBuffer(list.size() * 20);
        String string = "";
        for (Prerequisite prerequisite : list) {
            PrerequisiteTest prerequisiteTest = prerequisiteTestFactory.getTest(prerequisite.getKind());
            if (prerequisiteTest == null) {
                Logging.errorPrintLocalised("PrereqHandler.No_known_formatter", prerequisite.getKind());
                continue;
            }
            stringBuffer.append(string);
            if (prerequisite.getLevelQualifier() > 0) {
                stringBuffer.append("at level " + prerequisite.getLevelQualifier() + ":");
            }
            stringBuffer.append(prerequisiteTest.toHtmlString(prerequisite));
            string = PropertyFactory.getString("PrereqHandler.HTML_prerequisite_delimiter");
        }
        return stringBuffer.toString();
    }
}

