/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.utils.CoreUtility;
import pcgen.util.PropertyFactory;

public class PrerequisiteOperator {
    private static final int ComparatorGTEQ = 0;
    private static final int ComparatorGT = 1;
    private static final int ComparatorEQ = 2;
    private static final int ComparatorNEQ = 3;
    private static final int ComparatorLT = 4;
    private static final int ComparatorLTEQ = 5;
    private static final String[] validTypes = new String[]{"gteq", "gt", "eq", "neq", "lt", "lteq"};
    private static final String[] altValidTypes = new String[]{">=", ">", "=", "!=", "<", "<="};
    public static final PrerequisiteOperator GTEQ = new PrerequisiteOperator(0);
    public static final PrerequisiteOperator GT = new PrerequisiteOperator(1);
    public static final PrerequisiteOperator EQ = new PrerequisiteOperator(2);
    public static final PrerequisiteOperator NEQ = new PrerequisiteOperator(3);
    public static final PrerequisiteOperator LT = new PrerequisiteOperator(4);
    public static final PrerequisiteOperator LTEQ = new PrerequisiteOperator(5);
    private int value = 0;

    private PrerequisiteOperator(int n) {
        this.value = n;
    }

    public PrerequisiteOperator invert() {
        switch (this.value) {
            case 1: {
                return LTEQ;
            }
            case 2: {
                return NEQ;
            }
            case 3: {
                return EQ;
            }
            case 4: {
                return GTEQ;
            }
            case 5: {
                return GT;
            }
        }
        return LT;
    }

    public String toString() {
        return validTypes[this.value];
    }

    public String toDisplayString() {
        return PropertyFactory.getString("PrerequisiteOperator.display." + this.toString());
    }

    public int compare(int n, int n2) {
        return (int)this.compare((float)n, (float)n2);
    }

    public float compare(float f, float f2) {
        boolean bl = false;
        switch (this.value) {
            case 2: {
                bl = CoreUtility.doublesEqual(f, f2);
                break;
            }
            case 4: {
                bl = f < f2;
                break;
            }
            case 5: {
                bl = f <= f2;
                break;
            }
            case 1: {
                bl = f > f2;
                break;
            }
            case 3: {
                bl = !CoreUtility.doublesEqual(f, f2);
                break;
            }
            default: {
                boolean bl2 = bl = f >= f2;
            }
        }
        if (bl) {
            if (CoreUtility.doublesEqual(f, 0.0)) {
                return 1.0f;
            }
            return f;
        }
        return 0.0f;
    }

    public boolean equals(Object object) {
        if (object instanceof PrerequisiteOperator) {
            return this.value == ((PrerequisiteOperator)object).value;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static PrerequisiteOperator getOperatorByName(String string) throws PrerequisiteException {
        for (int i = 0; i < validTypes.length; ++i) {
            if (!validTypes[i].equalsIgnoreCase(string) && !altValidTypes[i].equals(string)) continue;
            switch (i) {
                case 1: {
                    return GT;
                }
                case 2: {
                    return EQ;
                }
                case 3: {
                    return NEQ;
                }
                case 4: {
                    return LT;
                }
                case 5: {
                    return LTEQ;
                }
            }
            return GTEQ;
        }
        throw new PrerequisiteException(PropertyFactory.getFormattedString("PrerequisiteOperator.error.invalid_operator", string));
    }
}

