/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.utils;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CoreUtility {
    private CoreUtility() {
    }

    public static <T> List<T> arrayToList(T[] TArray) {
        if (TArray == null) {
            return new ArrayList();
        }
        ArrayList<T> arrayList = new ArrayList<T>(TArray.length);
        for (int i = 0; i < TArray.length; ++i) {
            arrayList.add(TArray[i]);
        }
        return arrayList;
    }

    public static boolean isIntegerString(String string) {
        boolean bl;
        try {
            Integer.parseInt(string);
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public static boolean isNetURL(String string) {
        return string.startsWith("http:") || string.startsWith("ftp:");
    }

    public static boolean isNetURL(URL uRL) {
        return "http".equalsIgnoreCase(uRL.getProtocol()) || "ftp".equalsIgnoreCase(uRL.getProtocol());
    }

    public static boolean isURL(String string) {
        return string.startsWith("http:") || string.startsWith("ftp:") || string.startsWith("file:");
    }

    public static String capitalizeFirstLetter(String string) {
        boolean bl = true;
        char[] cArray = string.toLowerCase().toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isWhitespace(cArray[i])) {
                bl = true;
                continue;
            }
            if (bl && Character.isLowerCase(cArray[i])) {
                cArray[i] = Character.toUpperCase(cArray[i]);
            }
            bl = false;
        }
        return new String(cArray);
    }

    public static String commaDelimit(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public static String commaDelimit(Collection<String> collection) {
        return CoreUtility.join(collection, ',');
    }

    public static boolean compareDouble(double d, double d2, double d3) {
        return Math.abs(d - d2) < d3;
    }

    public static <T> boolean containsAny(Collection<T> collection, Collection<T> collection2) {
        Iterator<T> iterator = collection2.iterator();
        while (iterator.hasNext()) {
            if (!collection.contains(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean doublesEqual(double d, double d2) {
        return CoreUtility.compareDouble(d, d2, 1.0E-4);
    }

    public static String fixFilenamePath(String string) {
        return string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public static int innerMostStringEnd(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '(') {
                if (++n3 <= n2) continue;
                n2 = n3;
                continue;
            }
            if (string.charAt(i) != ')') continue;
            if (n3 == n2) {
                n = i;
            }
            --n3;
        }
        return n;
    }

    public static int innerMostStringStart(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '(') {
                if (++n3 < n2) continue;
                n2 = n3;
                n = i;
                continue;
            }
            if (string.charAt(i) != ')') continue;
            --n3;
        }
        return n;
    }

    public static String join(Collection<?> collection, char c) {
        return CoreUtility.join(collection, c + " ");
    }

    public static String join(Collection<?> collection, String string) {
        return CoreUtility.joinToStringBuffer(collection, string).toString();
    }

    public static StringBuffer joinToStringBuffer(Collection<?> collection, String string) {
        if (collection == null) {
            return new StringBuffer();
        }
        StringBuffer stringBuffer = new StringBuffer(collection.size() * 10);
        boolean bl = false;
        for (Object obj : collection) {
            if (bl) {
                stringBuffer.append(string);
            }
            bl = true;
            stringBuffer.append(obj.toString());
        }
        return stringBuffer;
    }

    public static String ordinal(int n) {
        String string = "th";
        if (n < 4 || n > 20) {
            switch (n % 10) {
                case 1: {
                    string = "st";
                    break;
                }
                case 2: {
                    string = "nd";
                    break;
                }
                case 3: {
                    string = "rd";
                    break;
                }
            }
        }
        return Integer.toString(n) + string;
    }

    public static String replaceAll(String string, String string2, String string3) {
        int n;
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(string.length() + string3.length());
        int n2 = string.indexOf(string2);
        if (n2 < 0) {
            return string;
        }
        int n3 = 0;
        while (n2 > -1) {
            for (n = n3; n < n2; ++n) {
                stringBuffer.append(cArray[n]);
            }
            n3 = n2;
            stringBuffer.append(string3);
            n2 = string.indexOf(string2, n3 += string2.length());
        }
        for (n = n3; n < cArray.length; ++n) {
            stringBuffer.append(cArray[n]);
        }
        return stringBuffer.toString();
    }

    public static String replaceFirst(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(string.substring(0, n));
        stringBuffer.append(string3);
        stringBuffer.append(string.substring(n + string2.length()));
        return stringBuffer.toString();
    }

    public static List<String> split(String string, char c) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "\\" + String.valueOf(c);
        if (string.trim().length() == 0) {
            return arrayList;
        }
        Iterator<String> iterator = Arrays.asList(string.split(string2)).iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().trim());
        }
        return arrayList;
    }

    public static String unEscapeColons2(String string) {
        return CoreUtility.replaceAll(string, "&#59;", ":");
    }

    public static List<String> toStringRepresentation(List<?> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        Iterator<?> iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().toString());
        }
        return arrayList;
    }
}

