/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SpecialAbility;
import pcgen.gui.tabs.InfoSpecialAbilities;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.TableSorter;
import pcgen.gui.utils.Utility;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public final class AddSpecialAbility
extends JFrame {
    static final long serialVersionUID = 8632071234484774756L;
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private InfoSpecialAbilities owner;
    private JButton okButton;
    private JPanel saPanel;
    private JScrollPane saPane;
    private JTableEx saTable;
    private JTextField saField = new JTextField();
    private PlayerCharacter aPC = null;
    private SAModel saModel = new SAModel();
    private TableSorter saSorter = null;

    public AddSpecialAbility() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logging.errorPrint("Error while initing form", exception);
        }
    }

    public AddSpecialAbility(PlayerCharacter playerCharacter, InfoSpecialAbilities infoSpecialAbilities) {
        try {
            this.aPC = playerCharacter;
            this.setTitle(AddSpecialAbility.myGetTitle());
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = toolkit.getImage(this.getClass().getResource("/pcgen/gui/resource/PcgenIcon.gif"));
            this.setIconImage(image);
            Dimension dimension = Utility.getScreenSize(toolkit);
            int n = dimension.height;
            int n2 = dimension.width;
            this.setSize(n2 >> 1, n >> 1);
            this.setLocation(n2 >> 2, n >> 2);
            this.setDefaultCloseOperation(2);
            Container container = this.getContentPane();
            this.jbInit();
            container.add(this.saPanel);
            this.setVisible(true);
            this.owner = infoSpecialAbilities;
        }
        catch (HeadlessException headlessException) {
            Logging.errorPrint("This gui cannot run headless. D-oh.", headlessException);
        }
        catch (Exception exception) {
            Logging.errorPrint("Error while initing form", exception);
        }
    }

    private static String myGetTitle() {
        String string = PropertyFactory.getString("in_addSA");
        return string;
    }

    private void addSpecialAbility() {
        if (this.aPC == null || this.aPC.getClassList().isEmpty()) {
            return;
        }
        String string = this.saField.getText();
        if (string != null) {
            PCClass pCClass = this.aPC.getClassList().get(0);
            String string2 = string.trim();
            SpecialAbility specialAbility = new SpecialAbility(string2, "PCCLASS|" + pCClass.getKeyName() + "|0");
            pCClass.addSpecialAbilityToList(specialAbility);
            pCClass.addSave(string2);
            if (this.owner != null) {
                this.owner.forceRefresh();
            }
        }
    }

    private void jbInit() throws Exception {
        this.saPanel = new JPanel();
        this.saPane = new JScrollPane();
        JLabel jLabel = new JLabel("Special Ability:");
        JPanel jPanel = new JPanel();
        this.saPanel.setLayout(this.gridBagLayout);
        this.saSorter = new TableSorter(this.saModel);
        this.saTable = new JTableEx(this.saSorter);
        this.saSorter.addMouseListenerToHeaderInTable(this.saTable);
        this.saTable.setSelectionMode(0);
        this.saTable.setDoubleBuffered(false);
        this.saPane.setViewportView(this.saTable);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)this.saField, "Center");
        this.saPanel.add((Component)jPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.saPanel.add((Component)this.saPane, new GridBagConstraints(0, 1, 1, 7, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.saTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ListSelectionModel listSelectionModel = AddSpecialAbility.this.saTable.getSelectionModel();
                int n = AddSpecialAbility.this.saSorter.getRowTranslated(listSelectionModel.getMinSelectionIndex());
                if (n >= 0) {
                    AddSpecialAbility.this.saField.setText((String)AddSpecialAbility.this.saModel.getValueAt(n, 0));
                }
                if (mouseEvent.getClickCount() == 2) {
                    AddSpecialAbility.this.okButton.doClick();
                }
            }
        });
        this.okButton = new JButton();
        this.okButton.setText(PropertyFactory.getString("in_ok"));
        this.okButton.setMnemonic(PropertyFactory.getMnemonic("in_mn_ok"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddSpecialAbility.this.addSpecialAbility();
                AddSpecialAbility.this.setVisible(false);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        JPanel jPanel2 = new JPanel();
        jPanel2.add((Component)this.okButton, gridBagConstraints);
        this.saPanel.add((Component)jPanel2, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SAModel
    extends AbstractTableModel {
        SAModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Ability";
                }
                case 1: {
                    return "Source";
                }
            }
            return "Out Of Bounds";
        }

        @Override
        public int getRowCount() {
            return Globals.getSASet().size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n < 0) {
                return null;
            }
            SpecialAbility specialAbility = (SpecialAbility)Globals.getSASet().toArray()[n];
            if (specialAbility == null) {
                return null;
            }
            switch (n2) {
                case 0: {
                    return specialAbility.getDisplayName();
                }
                case 1: {
                    return specialAbility.getSASource();
                }
            }
            return null;
        }
    }
}

