/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pcgen.core.Ability;
import pcgen.core.Categorisable;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.spell.Spell;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.EqBuilder;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ChooseSpellDialog
extends JDialog {
    static final long serialVersionUID = 3692925177296126937L;
    private static final int TRIGGER_ALL = -1;
    private static final int TRIGGER_CLASS = 0;
    private static final int TRIGGER_BASELEVEL = 1;
    private static final int TRIGGER_CASTERLEVEL = 2;
    private static final int TRIGGER_SPELLNAME = 3;
    private static final int TRIGGER_METAMAGIC = 4;
    private JButton btnCancel;
    private JButton btnOk;
    private JComboBoxEx cmbBaseSpellLevel;
    private JComboBoxEx cmbCasterLevel;
    private JComboBoxEx cmbClass;
    private JComboBoxEx cmbSpellName;
    private JComboBoxEx cmbSpellType;
    private JComboBoxEx cmbSpellVariant;
    private JLabel lblBaseSpellLevel;
    private JLabel lblCasterLevel;
    private JLabel lblClass;
    private JLabel lblMetamagicFeats;
    private JLabel lblSpellName;
    private JLabel lblSpellType;
    private JLabel lblSpellVariant;
    private JList lstMetamagicFeats;
    private JScrollPane jScrollPane1;
    private List<String> classList = null;
    private List<Spell> classSpells = null;
    private List<String> levelList = null;
    private List<String> subTypeList = new ArrayList<String>();
    private PObject castingClass = null;
    private Spell theSpell = null;
    private String choiceString = "";
    private boolean metaAllowed = true;
    private boolean wasCancelled = true;
    private int baseSpellLevel = -1;
    private int eqType = -1;
    private int levelAdjust = 0;
    private int minLevel = 0;
    private int spellBooks = 0;
    private PlayerCharacter pc;

    ChooseSpellDialog(JFrame jFrame, PlayerCharacter playerCharacter, int n, boolean bl, List<String> list, List<String> list2, int n2, String string) {
        super(jFrame);
        IconUtilitities.maybeSetIcon(jFrame, "PcgenIcon.gif");
        this.eqType = n;
        this.pc = playerCharacter;
        this.metaAllowed = bl;
        this.spellBooks = n2;
        this.classList = list;
        this.levelList = list2;
        this.choiceString = string;
        this.initComponents();
        this.setLocationRelativeTo(jFrame);
    }

    ChooseSpellDialog(JFrame jFrame, PlayerCharacter playerCharacter, int n, boolean bl, List<String> list, List<String> list2, int n2) {
        super(jFrame);
        IconUtilitities.maybeSetIcon(jFrame, "PcgenIcon.gif");
        this.eqType = n;
        this.metaAllowed = bl;
        this.spellBooks = n2;
        this.classList = list;
        this.levelList = list2;
        this.initComponents();
        this.setLocationRelativeTo(jFrame);
    }

    public int getBaseSpellLevel() {
        return this.baseSpellLevel + this.levelAdjust;
    }

    public int getCasterLevel() {
        if (this.cmbCasterLevel.getSelectedIndex() >= 0) {
            return (Integer)this.cmbCasterLevel.getItemAt(this.cmbCasterLevel.getSelectedIndex());
        }
        return 9999;
    }

    public Object getCastingClass() {
        return this.castingClass;
    }

    public Object[] getMetamagicFeats() {
        if (this.lstMetamagicFeats != null && this.lstMetamagicFeats.getSelectedIndex() > -1) {
            return this.lstMetamagicFeats.getSelectedValues();
        }
        return null;
    }

    public Spell getSpell() {
        return this.theSpell;
    }

    public String getSpellType() {
        if (this.cmbSpellType.getSelectedIndex() >= 0) {
            return (String)this.cmbSpellType.getItemAt(this.cmbSpellType.getSelectedIndex());
        }
        return null;
    }

    public String getVariant() {
        if (this.cmbSpellVariant.isEnabled()) {
            return (String)this.cmbSpellVariant.getItemAt(this.cmbSpellVariant.getSelectedIndex());
        }
        return "";
    }

    public boolean getWasCancelled() {
        return this.wasCancelled;
    }

    private void setCasterLevel(int n) {
        boolean bl = true;
        if (n == 9999) {
            this.cmbCasterLevel.setSelectedIndex(-1);
            bl = false;
        } else {
            this.cmbCasterLevel.setSelectedItem(n);
        }
        if (this.lblCasterLevel.isEnabled() != bl) {
            this.lblCasterLevel.setEnabled(bl);
            this.cmbCasterLevel.setEnabled(bl);
        }
    }

    private boolean isSpellOfSubType(Spell spell) {
        if (this.subTypeList.size() == 0) {
            return true;
        }
        boolean bl = false;
        for (String string : this.subTypeList) {
            boolean bl2 = true;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";,");
            while (stringTokenizer.hasMoreTokens()) {
                Object object;
                String string2 = stringTokenizer.nextToken();
                if (string2.startsWith("SCHOOL.")) {
                    object = new ArrayList<String>();
                    object.add(string2.substring(7));
                    if (!spell.schoolContains((Collection<String>)object)) {
                        bl2 = false;
                        break;
                    }
                }
                if (string2.startsWith("SUBSCHOOL.")) {
                    object = new ArrayList();
                    object.add((String)string2.substring(10));
                    if (!spell.subschoolContains((Collection<String>)object)) {
                        bl2 = false;
                        break;
                    }
                }
                if (!string2.startsWith("DESCRIPTOR.")) continue;
                object = string2.substring(11);
                if (spell.getDescriptorList().contains(object)) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private List<String> getSpellTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.castingClass instanceof PCClass) {
            arrayList.add(((PCClass)this.castingClass).getSpellType());
        } else if (this.castingClass instanceof Domain) {
            arrayList.add("Divine");
        } else {
            PCClass pCClass = Globals.getClassKeyed(this.castingClass.getAssociated(0));
            if (pCClass != null) {
                arrayList.add(pCClass.getSpellType());
            }
        }
        return arrayList;
    }

    private void addSpellInfoToList(Spell spell, List<String> list, List<PObject> list2, String string) {
        Map<String, Integer> map = spell.getLevelInfo(this.pc);
        if (map == null || map.size() == 0) {
            Logging.errorPrint("Spell: " + spell.getKeyName() + "(" + spell.getDefaultSourceString() + ") has no home");
            return;
        }
        for (String string2 : map.keySet()) {
            PObject pObject;
            String string3;
            if (string2.startsWith("CLASS|")) {
                string3 = string2.substring(6);
                pObject = Globals.getClassKeyed(string3);
                if (pObject != null) {
                    if (!"".equals(string) && string.indexOf(pObject.getSpellType()) < 0 || list2.contains(pObject)) continue;
                    list2.add(pObject);
                    continue;
                }
                string3 = 'C' + string3;
                if (list.contains(string3)) continue;
                list.add(string3);
                continue;
            }
            if (string2.startsWith("DOMAIN|")) {
                if (!"".equals(string) && string.indexOf("Divine") < 0) continue;
                string3 = string2.substring(7);
                pObject = Globals.getDomainKeyed(string3);
                if (pObject != null) {
                    if (list2.contains(pObject)) continue;
                    list2.add(pObject);
                    continue;
                }
                string3 = 'D' + string3;
                if (list.contains(string3)) continue;
                list.add(string3);
                continue;
            }
            Logging.errorPrint("Unknown spell source: " + string2);
        }
    }

    private void btnOKActionPerformed() {
        if (this.btnOk.isEnabled()) {
            this.wasCancelled = false;
            this.setVisible(false);
            this.dispose();
        }
    }

    private boolean canCreateItem(Spell spell) {
        String string;
        boolean bl = true;
        switch (this.eqType) {
            case -1: {
                return true;
            }
            case 0: {
                bl = false;
            }
            case 1: 
            case 2: 
            case 3: {
                string = EqBuilder.validEqTypes[this.eqType];
                break;
            }
            default: {
                return false;
            }
        }
        String string2 = spell.getCreatableItem().toLowerCase();
        if (string2.indexOf("[" + string + "]") >= 0) {
            bl = false;
        } else if (string2.indexOf(string) >= 0) {
            bl = true;
        }
        return bl;
    }

    private void closeDialog() {
        this.wasCancelled = true;
        this.setVisible(false);
        this.dispose();
    }

    private void cmbClassLevelActionPerformed(ItemEvent itemEvent, int n) {
        boolean bl;
        Object object;
        if (itemEvent != null && itemEvent.getStateChange() != 1) {
            return;
        }
        if ((n == -1 || n == 0) && this.cmbClass.getSelectedIndex() >= 0) {
            this.castingClass = (PObject)this.cmbClass.getItemAt(this.cmbClass.getSelectedIndex());
            object = "";
            String string = "";
            if (this.castingClass instanceof PCClass) {
                object = ((PCClass)this.castingClass).getCastAs();
                if (((String)object).length() == 0) {
                    object = this.castingClass.getKeyName();
                }
            } else if (this.castingClass instanceof Domain) {
                string = this.castingClass.getKeyName();
            } else {
                object = this.castingClass.getKeyName();
            }
            this.classSpells = new ArrayList<Spell>();
            for (Spell object2 : Globals.getSpellsIn(-1, (String)object, string)) {
                if (!this.canCreateItem(object2)) continue;
                this.classSpells.add(object2);
            }
            List<String> list = this.getSpellTypes();
            this.cmbSpellType.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
            this.cmbBaseSpellLevel.setSelectedIndex(0);
        }
        if (this.castingClass == null) {
            return;
        }
        if ((n == -1 || n == 1) && this.cmbBaseSpellLevel.getSelectedIndex() >= 0) {
            this.baseSpellLevel = (Integer)this.cmbBaseSpellLevel.getItemAt(this.cmbBaseSpellLevel.getSelectedIndex());
        }
        if (this.baseSpellLevel < 0) {
            return;
        }
        if (n == -1 || n == 4) {
            this.levelAdjust = 0;
            object = this.getMetamagicFeats();
            if (object != null) {
                for (int i = 0; i < ((Object)object).length; ++i) {
                    this.levelAdjust += ((Ability)object[i]).getAddSpellLevel();
                }
            }
        }
        if (n == -1 || n == 0 || n == 1 || n == 2 || n == 4) {
            if (n != 4 && n != 2 && this.lblSpellVariant.isEnabled()) {
                this.lblSpellVariant.setEnabled(false);
                this.cmbSpellVariant.setEnabled(false);
                this.cmbSpellVariant.setModel(new DefaultComboBoxModel<Object>(new ArrayList().toArray()));
            }
            int n2 = 0;
            PCClass pCClass = this.castingClass instanceof PCClass ? (PCClass)this.castingClass : (this.castingClass instanceof Domain ? Globals.getClassKeyed("Cleric") : Globals.getClassKeyed(this.castingClass.getKeyName()));
            if (pCClass != null) {
                this.minLevel = pCClass.getMinLevelForSpellLevel(this.baseSpellLevel + this.levelAdjust, true);
                if (pCClass.hasMaxLevel()) {
                    n2 = pCClass.getMaxLevel();
                }
            } else {
                this.minLevel = 1;
            }
            int n3 = this.getCasterLevel();
            if (n == 1 || n == 4 || n3 < this.minLevel) {
                n3 = this.minLevel;
            }
            if (!Globals.checkRule("LEVELCAP") && n3 != 9999 && n2 > 0 && n3 > n2) {
                n3 = n2;
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_csdEr4"), "PCGen", MessageType.INFORMATION);
            }
            if (this.getCasterLevel() != n3) {
                this.setCasterLevel(n3);
            }
        }
        if (n == -1 || n == 0 || n == 1) {
            this.theSpell = null;
            ArrayList<SpellShell> arrayList = new ArrayList<SpellShell>();
            if (this.classSpells != null) {
                String string;
                String string2;
                if (this.castingClass instanceof PCClass) {
                    string2 = ((PCClass)this.castingClass).getCastAs();
                    if (string2.length() == 0) {
                        string2 = this.castingClass.getKeyName();
                    }
                    string = "CLASS";
                } else if (this.castingClass instanceof Domain) {
                    string2 = this.castingClass.getKeyName();
                    string = "DOMAIN";
                } else {
                    string2 = this.castingClass.getKeyName();
                    string = "CLASS";
                }
                for (Spell spell : this.classSpells) {
                    if (!this.isSpellOfSubType(spell) || spell.levelForKey(string, string2, this.pc) != this.baseSpellLevel) continue;
                    if (SettingsHandler.guiUsesOutputNameSpells()) {
                        arrayList.add(new SpellShell(spell, true));
                        continue;
                    }
                    arrayList.add(new SpellShell(spell, false));
                }
                Collections.sort(arrayList);
            }
            bl = arrayList.size() != 0;
            this.lblSpellName.setEnabled(bl);
            this.cmbSpellName.setEnabled(bl);
            this.cmbSpellName.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        }
        if (n == -1 || n == 0 || n == 1 || n == 3) {
            Object e;
            this.theSpell = this.cmbSpellName.getSelectedIndex() >= 0 ? ((e = this.cmbSpellName.getItemAt(this.cmbSpellName.getSelectedIndex())) instanceof SpellShell ? ((SpellShell)e).getSpell() : (Spell)e) : null;
            List<String> list = this.theSpell != null ? this.theSpell.getVariants() : new ArrayList<String>();
            boolean bl2 = bl = list.size() != 0;
            if (bl || !bl && this.lblSpellVariant.isEnabled()) {
                this.cmbSpellVariant.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
            }
            if (bl != this.lblSpellVariant.isEnabled()) {
                this.lblSpellVariant.setEnabled(bl);
                this.cmbSpellVariant.setEnabled(bl);
            }
        }
        this.btnOk.setEnabled(this.cmbSpellName.isEnabled() && this.cmbCasterLevel.getSelectedIndex() >= 0);
    }

    /*
     * WARNING - void declaration
     */
    private void initComponents() {
        void var8_26;
        Integer[] integerArray;
        Object object;
        Object object4;
        this.lblClass = new JLabel();
        this.lblBaseSpellLevel = new JLabel();
        this.lblSpellName = new JLabel();
        this.lblSpellVariant = new JLabel();
        this.lblCasterLevel = new JLabel();
        this.lblSpellType = new JLabel();
        this.cmbClass = new JComboBoxEx();
        this.cmbBaseSpellLevel = new JComboBoxEx();
        this.cmbSpellName = new JComboBoxEx();
        this.cmbSpellVariant = new JComboBoxEx();
        this.cmbCasterLevel = new JComboBoxEx();
        this.cmbSpellType = new JComboBoxEx();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        if (this.metaAllowed) {
            this.lblMetamagicFeats = new JLabel();
            this.lstMetamagicFeats = new JList();
            this.jScrollPane1 = new JScrollPane();
        }
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle(PropertyFactory.getString("in_csdSelect"));
        this.setModal(true);
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ChooseSpellDialog.this.closeDialog();
            }
        });
        this.lblClass.setText(PropertyFactory.getString("in_class"));
        this.lblClass.setDisplayedMnemonic(PropertyFactory.getMnemonic("in_mn_class"));
        this.lblClass.setLabelFor(this.cmbClass);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 12;
        gridBagConstraints.fill = 1;
        this.lblClass.setPreferredSize(new Dimension(32, 16));
        this.getContentPane().add((Component)this.lblClass, gridBagConstraints);
        this.cmbClass.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ChooseSpellDialog.this.cmbClassLevelActionPerformed(itemEvent, 0);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 12;
        gridBagConstraints.fill = 1;
        this.cmbClass.setPreferredSize(new Dimension(200, 25));
        this.getContentPane().add((Component)this.cmbClass, gridBagConstraints);
        this.lblBaseSpellLevel.setText(PropertyFactory.getString("in_csdSpLvl"));
        this.lblBaseSpellLevel.setDisplayedMnemonic(PropertyFactory.getMnemonic("in_mn_csdSpLvl"));
        this.lblBaseSpellLevel.setLabelFor(this.cmbBaseSpellLevel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 1;
        this.lblBaseSpellLevel.setPreferredSize(new Dimension(61, 16));
        this.getContentPane().add((Component)this.lblBaseSpellLevel, gridBagConstraints);
        this.cmbBaseSpellLevel.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ChooseSpellDialog.this.cmbClassLevelActionPerformed(itemEvent, 1);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 1;
        this.cmbBaseSpellLevel.setPreferredSize(new Dimension(61, 25));
        this.getContentPane().add((Component)this.cmbBaseSpellLevel, gridBagConstraints);
        if (this.metaAllowed) {
            this.lblMetamagicFeats.setText(PropertyFactory.getString("in_metaFeat"));
            this.lblMetamagicFeats.setDisplayedMnemonic(PropertyFactory.getMnemonic("in_mn_metaFeat"));
            this.lblMetamagicFeats.setLabelFor(this.lstMetamagicFeats);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 8;
            gridBagConstraints.gridwidth = 11;
            gridBagConstraints.fill = 1;
            this.lblMetamagicFeats.setPreferredSize(new Dimension(97, 16));
            this.getContentPane().add((Component)this.lblMetamagicFeats, gridBagConstraints);
            this.jScrollPane1.setViewportView(this.lstMetamagicFeats);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 9;
            gridBagConstraints.gridwidth = 11;
            gridBagConstraints.gridheight = 15;
            gridBagConstraints.fill = 1;
            this.jScrollPane1.setPreferredSize(new Dimension(259, 150));
            this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
            this.lstMetamagicFeats.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        ChooseSpellDialog.this.cmbClassLevelActionPerformed(null, 4);
                    }
                    if (ChooseSpellDialog.this.lstMetamagicFeats.getSelectedIndex() >= 0) {
                        ChooseSpellDialog.this.lstMetamagicFeats.ensureIndexIsVisible(ChooseSpellDialog.this.lstMetamagicFeats.getSelectedIndex());
                    }
                }
            });
        }
        this.btnOk.setMnemonic(PropertyFactory.getMnemonic("in_mn_ok"));
        this.btnOk.setText(PropertyFactory.getString("in_ok"));
        this.btnOk.setEnabled(false);
        this.btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChooseSpellDialog.this.btnOKActionPerformed();
            }
        });
        this.btnOk.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ChooseSpellDialog.this.btnOKActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        this.btnOk.setPreferredSize(new Dimension(73, 26));
        this.getContentPane().add((Component)this.btnOk, gridBagConstraints);
        this.btnCancel.setMnemonic(PropertyFactory.getMnemonic("in_mn_cancel"));
        this.btnCancel.setText(PropertyFactory.getString("in_cancel"));
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChooseSpellDialog.this.closeDialog();
            }
        });
        this.btnCancel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ChooseSpellDialog.this.closeDialog();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        this.btnCancel.setPreferredSize(new Dimension(73, 26));
        this.getContentPane().add((Component)this.btnCancel, gridBagConstraints);
        this.lblSpellName.setText(PropertyFactory.getString("in_spellName"));
        this.lblSpellName.setDisplayedMnemonic(PropertyFactory.getMnemonic("in_mn_spellName"));
        this.lblSpellName.setLabelFor(this.cmbSpellName);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 20;
        gridBagConstraints.fill = 1;
        this.lblSpellName.setPreferredSize(new Dimension(64, 16));
        this.getContentPane().add((Component)this.lblSpellName, gridBagConstraints);
        this.cmbSpellName.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ChooseSpellDialog.this.cmbClassLevelActionPerformed(itemEvent, 3);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 20;
        gridBagConstraints.fill = 1;
        this.cmbSpellName.setPreferredSize(new Dimension(280, 25));
        this.getContentPane().add((Component)this.cmbSpellName, gridBagConstraints);
        this.lblSpellVariant.setText(PropertyFactory.getString("in_csdVariant"));
        this.lblSpellVariant.setDisplayedMnemonic(PropertyFactory.getMnemonic("in_mn_csdVariant"));
        this.lblSpellVariant.setLabelFor(this.cmbSpellVariant);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 20;
        gridBagConstraints.fill = 1;
        this.lblSpellVariant.setPreferredSize(new Dimension(41, 16));
        this.getContentPane().add((Component)this.lblSpellVariant, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 20;
        gridBagConstraints.fill = 1;
        this.cmbSpellVariant.setPreferredSize(new Dimension(280, 25));
        this.getContentPane().add((Component)this.cmbSpellVariant, gridBagConstraints);
        this.lblCasterLevel.setText(PropertyFactory.getString("in_casterLvl"));
        this.lblCasterLevel.setDisplayedMnemonic(PropertyFactory.getMnemonic("in_mn_casterLvl"));
        this.lblCasterLevel.setLabelFor(this.cmbCasterLevel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        this.lblCasterLevel.setPreferredSize(new Dimension(71, 16));
        this.getContentPane().add((Component)this.lblCasterLevel, gridBagConstraints);
        this.cmbCasterLevel.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ChooseSpellDialog.this.cmbClassLevelActionPerformed(itemEvent, 2);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        this.cmbCasterLevel.setPreferredSize(new Dimension(71, 25));
        this.getContentPane().add((Component)this.cmbCasterLevel, gridBagConstraints);
        this.lblSpellType.setText(PropertyFactory.getString("in_spellType"));
        this.lblSpellType.setDisplayedMnemonic(PropertyFactory.getMnemonic("in_mn_spellType"));
        this.lblSpellType.setLabelFor(this.cmbSpellType);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 14;
        gridBagConstraints.fill = 1;
        this.lblSpellType.setPreferredSize(new Dimension(58, 16));
        this.getContentPane().add((Component)this.lblSpellType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 14;
        gridBagConstraints.fill = 1;
        this.cmbSpellType.setPreferredSize(new Dimension(60, 25));
        this.getContentPane().add((Component)this.cmbSpellType, gridBagConstraints);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<PObject> arrayList2 = new ArrayList<PObject>();
        String string = "";
        int n2 = 0;
        int n3 = 9;
        if (this.choiceString.startsWith("EQBUILDER.SPELL") && !this.choiceString.endsWith("EQBUILDER.SPELL")) {
            object4 = new StringTokenizer(this.choiceString, "|");
            ((StringTokenizer)object4).nextToken();
            if (((StringTokenizer)object4).hasMoreTokens() && ((string = ((StringTokenizer)object4).nextToken()).equalsIgnoreCase("ANY") || string.equalsIgnoreCase("ALL"))) {
                string = "";
            }
            while (((StringTokenizer)object4).hasMoreTokens()) {
                String object32 = ((StringTokenizer)object4).nextToken();
                try {
                    n2 = Integer.parseInt(object32);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    this.subTypeList.add(object32);
                }
            }
            if (((StringTokenizer)object4).hasMoreTokens()) {
                n3 = Integer.parseInt(((StringTokenizer)object4).nextToken());
            }
        }
        if (this.classList != null) {
            for (String arrayList3 : this.classList) {
                void var9_32;
                PCClass pCClass = Globals.getClassKeyed(arrayList3);
                if (pCClass == null) {
                    Domain domain = Globals.getDomainKeyed(arrayList3);
                }
                if (var9_32 == null || var9_32 instanceof Domain && string.indexOf("Divine") < 0 || "".equals(string) || !(var9_32 instanceof PCClass) || string.indexOf(((PCClass)var9_32).getSpellType()) < 0) continue;
                arrayList2.add((PObject)var9_32);
            }
        } else {
            object4 = Globals.getSpellMap();
            for (String string2 : object4.keySet()) {
                object = object4.get(string2);
                if (object instanceof ArrayList) {
                    for (Object e : (ArrayList)object) {
                        Spell spell = (Spell)e;
                        if (!this.isSpellOfSubType(spell)) continue;
                        this.addSpellInfoToList(spell, arrayList, arrayList2, string);
                    }
                    continue;
                }
                if (!this.isSpellOfSubType((Spell)object)) continue;
                this.addSpellInfoToList((Spell)object, arrayList, arrayList2, string);
            }
            if (arrayList.size() > 0) {
                for (String string3 : arrayList) {
                    object = null;
                    if (string3.length() <= 0) continue;
                    switch (string3.charAt(0)) {
                        case 'C': {
                            object = "Class";
                            break;
                        }
                        case 'D': {
                            object = "Domain";
                            break;
                        }
                    }
                    if (object == null) continue;
                    Logging.errorPrint(object + " not found: " + string3.substring(1));
                }
            }
            for (PCClass pCClass : Globals.getClassList()) {
                if (pCClass.getSpellType().equals("None") || pCClass.zeroCastSpells() || !"".equals(string) && string.indexOf(pCClass.getSpellType()) < 0 || arrayList2.contains(pCClass)) continue;
                arrayList2.add(pCClass);
            }
        }
        if (this.spellBooks != 0) {
            for (int i = arrayList2.size() - 1; i >= 0; --i) {
                Object e = arrayList2.get(i);
                if (this.spellBooks < 0) {
                    if (!(e instanceof PCClass) || !((PCClass)e).getSpellBookUsed()) continue;
                    arrayList2.remove(i);
                    continue;
                }
                if (e instanceof PCClass && ((PCClass)e).getSpellBookUsed()) continue;
                arrayList2.remove(i);
            }
        }
        Globals.sortPObjectListByName(arrayList2);
        this.cmbClass.setModel(new DefaultComboBoxModel<Object>(arrayList2.toArray()));
        switch (this.eqType) {
            case 0: {
                n3 = Math.min(n3, SettingsHandler.getMaxPotionSpellLevel());
                break;
            }
            case 2: {
                n3 = Math.min(n3, SettingsHandler.getMaxWandSpellLevel());
                break;
            }
        }
        if (this.levelList != null && this.levelList.size() > 0) {
            void var8_21;
            integerArray = new Integer[this.levelList.size()];
            int n = n2;
            while (var8_21 < this.levelList.size()) {
                integerArray[var8_21] = Integer.valueOf(this.levelList.get((int)var8_21));
                ++var8_21;
            }
        } else {
            void var8_23;
            integerArray = new Integer[n3 - n2 + 1];
            int n = n2;
            while (var8_23 <= n3) {
                integerArray[var8_23 - n2] = (int)var8_23;
                ++var8_23;
            }
        }
        this.cmbBaseSpellLevel.setModel(new DefaultComboBoxModel<Integer>(integerArray));
        integerArray = new Integer[20];
        boolean bl = true;
        while (var8_26 <= 20) {
            integerArray[var8_26 - true] = (int)var8_26;
            ++var8_26;
        }
        this.cmbCasterLevel.setModel(new DefaultComboBoxModel<Integer>(integerArray));
        if (this.metaAllowed) {
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            Iterator<Categorisable> iterator = Globals.getAbilityKeyIterator("FEAT");
            while (iterator.hasNext()) {
                object = (Ability)iterator.next();
                if (!((PObject)object).isType("Metamagic")) continue;
                arrayList3.add(object);
            }
            Globals.sortPObjectListByName(arrayList3);
            this.lstMetamagicFeats.setListData(arrayList3.toArray());
        }
        this.cmbClassLevelActionPerformed(null, -1);
        this.pack();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SpellShell
    implements Serializable,
    Comparable<Object> {
        private Spell aSpell = null;
        private boolean useOutputName = false;

        SpellShell(Spell spell, boolean bl) {
            this.aSpell = spell;
            this.useOutputName = bl;
        }

        @Override
        public int compareTo(Object object) {
            if (object != null) {
                return this.toString().compareToIgnoreCase(object.toString());
            }
            return 1;
        }

        public String toString() {
            if (this.aSpell != null) {
                if (this.useOutputName) {
                    return this.aSpell.getOutputName();
                }
                return this.aSpell.toString();
            }
            return "";
        }

        Spell getSpell() {
            return this.aSpell;
        }
    }
}

