/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import pcgen.core.SettingsHandler;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CsheetFilter
extends FileFilter
implements FilenameFilter {
    private static final String chaTemplates = PropertyFactory.getString("in_chaTemplates");
    private List<String> acceptedList = null;
    private String dirFilter = null;
    private String ignoreExtension = ".fo";
    private int sheetType = 0;

    public CsheetFilter() {
    }

    public CsheetFilter(int n) {
        this.sheetType = n;
    }

    public List<String> getAccepted() {
        this.acceptedList = new ArrayList<String>();
        this.accept(SettingsHandler.getPcgenOutputSheetDir());
        return this.acceptedList;
    }

    @Override
    public String getDescription() {
        return chaTemplates;
    }

    public void setDirFilter(String string) {
        this.dirFilter = string;
    }

    public void setIgnoreExtension(String string) {
        this.ignoreExtension = string;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.accept(fileArray[i]);
            }
            return true;
        }
        return this.accept(file.getParentFile(), file.getName());
    }

    @Override
    public boolean accept(File file, String string) {
        String string2 = string.toLowerCase();
        File file2 = new File(file + File.separator + string);
        if (file2.isDirectory()) {
            return this.accept(file2);
        }
        if (!file2.getParent().endsWith(File.separator + this.dirFilter)) {
            return false;
        }
        if ((!string2.endsWith(this.ignoreExtension) || string2.endsWith(this.ignoreExtension) && Logging.isDebugMode()) && (this.sheetType == 0 && string2.startsWith("csheet") || this.sheetType == 1 && string2.startsWith("psheet"))) {
            if (this.acceptedList != null) {
                try {
                    String string3 = file.getAbsolutePath().substring(SettingsHandler.getPcgenOutputSheetDir().getAbsolutePath().length() + 1) + File.separator + string;
                    this.acceptedList.add(string3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }
}

