/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui.EqBuilder;
import pcgen.gui.utils.Utility;
import pcgen.util.PropertyFactory;

public final class EQFrame
extends JFrame {
    private EqBuilder mainEq = null;
    private PlayerCharacter aPC;

    public EQFrame(PlayerCharacter playerCharacter) {
        super(PropertyFactory.getString("in_itemCustomizer"));
        this.aPC = playerCharacter;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(this.getClass().getResource("/pcgen/gui/resource/PcgenIcon.gif"));
        this.setIconImage(image);
        this.setDefaultCloseOperation(0);
        this.mainEq = new EqBuilder(playerCharacter);
        this.mainEq.setParentWindow(this);
        Container container = this.getContentPane();
        container.add(this.mainEq);
        this.pack();
        Dimension dimension = SettingsHandler.getCustomizerDimension();
        Point point = SettingsHandler.getCustomizerLeftUpperCorner();
        int n = -11;
        int n2 = -11;
        if (point != null) {
            n = (int)point.getX();
            n2 = (int)point.getY();
        }
        if (n < -10 || n2 < -10 || dimension == null || dimension.height == 0 || dimension.width == 0) {
            Utility.centerFrame(this, true);
        } else {
            this.setLocation(point);
            this.setSize(dimension);
        }
    }

    public boolean setEquipment(Equipment equipment) {
        if (this.mainEq != null) {
            return this.mainEq.setEquipment(equipment);
        }
        return false;
    }

    public void toFront() {
        super.toFront();
        if (this.mainEq != null) {
            this.mainEq.toFront();
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.handleQuit(true);
        }
    }

    void exitItem_actionPerformed(boolean bl) {
        this.handleQuit(bl);
    }

    private void handleQuit(boolean bl) {
        if (!bl) {
            SettingsHandler.setCustomizerLeftUpperCorner(this.getLocationOnScreen());
            SettingsHandler.setCustomizerDimension(this.getSize());
            SettingsHandler.writeOptionsProperties(this.aPC);
        }
        Globals.setCurrentFrame(null);
        this.dispose();
    }
}

