/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.util.Iterator;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.gui.InfoSkillsSorter;
import pcgen.gui.tabs.InfoSkills;
import pcgen.gui.utils.PObjectNode;

public final class InfoSkillsSorters {
    private static boolean costsMatch(PObjectNode pObjectNode, Skill skill, InfoSkills infoSkills) {
        return pObjectNode.toString().equals(skill.getSkillCostType(infoSkills.getSelectedPCClass(), infoSkills.getPc()));
    }

    private static boolean keystatsMatch(PObjectNode pObjectNode, Skill skill) {
        if (Globals.isSkillTypeHidden(skill.getMyType(0))) {
            return false;
        }
        return pObjectNode.toString().equals(skill.getMyType(0));
    }

    public static class SubtypeName_Primary
    extends AbstractSubtypeName_Penultimate {
        public SubtypeName_Primary(InfoSkills infoSkills) {
            super(infoSkills);
        }

        public boolean nodeGoHere(PObjectNode pObjectNode, Skill skill) {
            return true;
        }
    }

    public static class Name_Primary
    extends FinalSorter {
        public Name_Primary(InfoSkills infoSkills) {
            super(infoSkills);
        }

        public boolean nodeGoHere(PObjectNode pObjectNode, Skill skill) {
            return true;
        }
    }

    public static class KeystatSubtypeName_Secondary
    extends AbstractSubtypeName_Penultimate {
        public KeystatSubtypeName_Secondary(InfoSkills infoSkills) {
            super(infoSkills);
        }

        public boolean nodeGoHere(PObjectNode pObjectNode, Skill skill) {
            return InfoSkillsSorters.keystatsMatch(pObjectNode, skill);
        }
    }

    public static class KeystatSubtypeName_Primary
    extends AbstractSorter {
        public KeystatSubtypeName_Primary(InfoSkills infoSkills) {
            super(infoSkills);
        }

        public InfoSkillsSorter nextSorter() {
            return new KeystatSubtypeName_Secondary(this.tab);
        }

        public boolean nodeGoHere(PObjectNode pObjectNode, Skill skill) {
            return true;
        }

        public boolean nodeHaveNext() {
            return true;
        }

        public Object whatPart(boolean bl, Skill skill, PlayerCharacter playerCharacter) {
            if (Globals.isSkillTypeHidden(skill.getMyType(0))) {
                return "";
            }
            return skill.getMyType(0);
        }
    }

    public static class KeystatName_Secondary
    extends FinalSorter {
        public KeystatName_Secondary(InfoSkills infoSkills) {
            super(infoSkills);
        }

        public boolean nodeGoHere(PObjectNode pObjectNode, Skill skill) {
            return InfoSkillsSorters.keystatsMatch(pObjectNode, skill);
        }
    }

    public static class KeystatName_Primary
    extends KeystatSubtypeName_Primary {
        public KeystatName_Primary(InfoSkills infoSkills) {
            super(infoSkills);
        }

        public InfoSkillsSorter nextSorter() {
            return new KeystatName_Secondary(this.tab);
        }
    }

    public static class GenericSubtypeName_Final
    extends FinalSorter {
        public GenericSubtypeName_Final(InfoSkills infoSkills) {
            super(infoSkills);
        }

        public PObjectNode finalPass(PObjectNode pObjectNode) {
            PObjectNode pObjectNode2 = pObjectNode;
            while (pObjectNode2.hasNext()) {
                PObjectNode pObjectNode3;
                PObjectNode pObjectNode4 = pObjectNode3 = (PObjectNode)pObjectNode2.next();
                while (pObjectNode4.hasNext()) {
                    PObjectNode pObjectNode5 = (PObjectNode)pObjectNode4.next();
                    while (pObjectNode5.hasNext()) {
                        pObjectNode5.next();
                        if (pObjectNode.getChildCount() != 1) continue;
                        pObjectNode5.set(pObjectNode.getChild(0));
                    }
                }
            }
            return pObjectNode;
        }

        public boolean nodeGoHere(PObjectNode pObjectNode, Skill skill) {
            Iterator<String> iterator = skill.getSubtypeIterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                if (Globals.isSkillTypeHidden(string) || !pObjectNode.toString().equals(string)) continue;
                return true;
            }
            return false;
        }
    }

    public static class CostSubtypeName_Final
    extends FinalSorter {
        public CostSubtypeName_Final(InfoSkills infoSkills) {
            super(infoSkills);
        }

        public PObjectNode finalPass(PObjectNode pObjectNode) {
            PObjectNode pObjectNode2 = pObjectNode;
            while (pObjectNode2.hasNext()) {
                PObjectNode pObjectNode3;
                PObjectNode pObjectNode4 = pObjectNode3 = (PObjectNode)pObjectNode2.next();
                while (pObjectNode4.hasNext()) {
                    PObjectNode pObjectNode5 = (PObjectNode)pObjectNode4.next();
                    while (pObjectNode5.hasNext()) {
                        pObjectNode5.next();
                        if (pObjectNode.getChildCount() != 1) continue;
                        pObjectNode5.set(pObjectNode.getChild(0));
                    }
                }
            }
            return pObjectNode;
        }

        public boolean nodeGoHere(PObjectNode pObjectNode, Skill skill) {
            Iterator<String> iterator = skill.getSubtypeIterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                if (Globals.isSkillTypeHidden(string) || !InfoSkillsSorters.costsMatch(pObjectNode.getParent(), skill, this.tab) || !pObjectNode.toString().equals(string)) continue;
                return true;
            }
            return false;
        }
    }

    public static class CostSubtypeName_Secondary
    extends AbstractSubtypeName_Penultimate {
        public CostSubtypeName_Secondary(InfoSkills infoSkills) {
            super(infoSkills);
        }

        public boolean nodeGoHere(PObjectNode pObjectNode, Skill skill) {
            return InfoSkillsSorters.costsMatch(pObjectNode, skill, this.tab);
        }

        public InfoSkillsSorter nextSorter() {
            return new CostSubtypeName_Final(this.tab);
        }
    }

    public static class CostSubtypeName_Primary
    extends CostSorter {
        public CostSubtypeName_Primary(InfoSkills infoSkills) {
            super(infoSkills);
        }

        public InfoSkillsSorter nextSorter() {
            return new CostSubtypeName_Secondary(this.tab);
        }
    }

    public static class CostName_Secondary
    extends FinalSorter {
        public CostName_Secondary(InfoSkills infoSkills) {
            super(infoSkills);
        }

        public boolean nodeGoHere(PObjectNode pObjectNode, Skill skill) {
            return InfoSkillsSorters.costsMatch(pObjectNode, skill, this.tab);
        }
    }

    public static class CostName_Primary
    extends CostSorter {
        public CostName_Primary(InfoSkills infoSkills) {
            super(infoSkills);
        }

        public InfoSkillsSorter nextSorter() {
            return new CostName_Secondary(this.tab);
        }
    }

    public static abstract class FinalSorter
    extends AbstractSorter {
        public FinalSorter(InfoSkills infoSkills) {
            super(infoSkills);
        }

        public InfoSkillsSorter nextSorter() {
            throw new UnsupportedOperationException();
        }

        public boolean nodeHaveNext() {
            return false;
        }

        public Object whatPart(boolean bl, Skill skill, PlayerCharacter playerCharacter) {
            return InfoSkills.createSkillWrapper(bl, skill, playerCharacter);
        }
    }

    public static abstract class CostSorter
    extends AbstractSorter {
        private int n = 0;

        public CostSorter(InfoSkills infoSkills) {
            super(infoSkills);
        }

        public boolean nodeGoHere(PObjectNode pObjectNode, Skill skill) {
            return this.n < 3;
        }

        public boolean nodeHaveNext() {
            return true;
        }

        public Object whatPart(boolean bl, Skill skill, PlayerCharacter playerCharacter) {
            String[] stringArray = new String[]{"CLASS", "CROSS-CLASS", "EXCLUSIVE"};
            return stringArray[this.n++];
        }
    }

    public static abstract class AbstractSubtypeName_Penultimate
    extends AbstractSorter {
        public AbstractSubtypeName_Penultimate(InfoSkills infoSkills) {
            super(infoSkills);
        }

        public InfoSkillsSorter nextSorter() {
            return new GenericSubtypeName_Final(this.tab);
        }

        public boolean nodeHaveNext() {
            return true;
        }

        public Object whatPart(boolean bl, Skill skill, PlayerCharacter playerCharacter) {
            if (skill.getSubtypeCount() > 0) {
                return skill.getSubtypeIterator();
            }
            return InfoSkills.createSkillWrapper(bl, skill, playerCharacter);
        }
    }

    public static abstract class AbstractSorter
    implements InfoSkillsSorter {
        InfoSkills tab;

        public AbstractSorter(InfoSkills infoSkills) {
            this.tab = infoSkills;
        }

        public PObjectNode finalPass(PObjectNode pObjectNode) {
            return pObjectNode;
        }
    }
}

