/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreePath;
import pcgen.core.Campaign;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.PCCCreator;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.PersistenceObserver;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.tabs.InfoTabUtils;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.BrowserLauncher;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.LabelTreeCellRenderer;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.TreeTableModel;
import pcgen.gui.utils.Utility;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.PersistenceManager;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.SponsorLoader;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.SwingWorker;
import pcgen.util.enumeration.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainSource
extends FilterAdapterPanel {
    public static final String SOURCE_MATERIALS_TAB = "Select and load source materials";
    static final long serialVersionUID = -2654080650560664447L;
    private static int splitOrientation = 1;
    private static final int COL_NAME = 0;
    private static final int COL_LOADED = 1;
    private static final int VIEW_PRODUCT = 0;
    private static final int VIEW_PUBLISH = 1;
    private static final int VIEW_PUBSET = 2;
    private static final int VIEW_PUBFMTSET = 3;
    private static int viewMode = 3;
    private static int viewSelectMode = 0;
    private static final int MODEL_AVAIL = 0;
    private static final int MODEL_SELECT = 1;
    private static PObjectNode typePubRoot;
    private static PObjectNode typePubSetRoot;
    private static PObjectNode typePubFmtSetRoot;
    private final JLabel avaLabel = new JLabel();
    private final JLabel selLabel = new JLabel();
    private CampaignModel availableModel = null;
    private CampaignModel selectedModel = null;
    private FlippingSplitPane asplit;
    private FlippingSplitPane bsplit;
    private FlippingSplitPane splitPane;
    private JButton leftButton;
    private JButton loadButton = new JButton();
    private JButton refreshButton = new JButton();
    private JButton removeAllButton;
    private JButton rightButton;
    private JButton unloadAllButton = new JButton();
    private JButton websiteButton;
    private JComboBoxEx viewComboBox = new JComboBoxEx();
    private JComboBoxEx viewSelectComboBox = new JComboBoxEx();
    private JLabelPane infoLabel;
    private JPanel bLeftPane;
    private JPanel center = new JPanel();
    private JPanel jPanel1n = new JPanel();
    private JPanel jPanel1s = new JPanel();
    private JTreeTable availableTable;
    private JTreeTable selectedTable;
    private List<Campaign> selectedCampaigns = new ArrayList<Campaign>();
    private PObjectNode lastSelection = null;
    private TreePath selPath;
    private boolean hasBeenSized = false;
    private boolean sourcesLoaded = false;
    private final JLabel lblQFilter = new JLabel("Filter:");
    private JTextField textQFilter = new JTextField();
    private JButton clearQFilterButton = new JButton("Clear");
    private static Integer saveViewMode;
    private int selRow;

    public MainSource() {
        this.setName(Tab.SOURCES.toString());
        try {
            this.initComponents();
        }
        catch (Exception exception) {
            ShowMessageDelegate.showMessageDialog("Error in MainSource whilst initialising:\n " + exception.toString() + "\n" + "PCGen may not operate correctly as a result of this error. ", "PCGen", MessageType.ERROR);
            Logging.errorPrint("Error initialising MainSource: " + exception.toString(), exception);
        }
        this.initActionListeners();
        FilterFactory.restoreFilterSettings(this);
    }

    @Override
    public boolean isMatchAnyEnabled() {
        return true;
    }

    @Override
    public boolean isNegateEnabled() {
        return true;
    }

    @Override
    public int getSelectionMode() {
        return -2;
    }

    public void changedGameMode() {
        this.selectedCampaigns.clear();
        this.resetViewNodes();
        this.unloadAllCampaigns_actionPerformed();
    }

    @Override
    public void initializeFilters() {
    }

    public void refreshCampaigns() {
        PersistenceManager.getInstance().refreshCampaigns();
        this.updateModels();
    }

    @Override
    public void refreshFiltering() {
        this.updateModels();
        this.selectCampaignsByURI(PersistenceManager.getInstance().getChosenCampaignSourcefiles());
    }

    private void clearQFilter() {
        this.availableModel.clearQFilter();
        if (saveViewMode != null) {
            viewMode = saveViewMode;
            saveViewMode = null;
        }
        this.textQFilter.setText("");
        this.availableModel.resetModel(viewMode, true, false);
        this.clearQFilterButton.setEnabled(false);
        this.viewComboBox.setEnabled(true);
        this.updateAvailableModel();
    }

    private void setQFilter() {
        String string = this.textQFilter.getText();
        if (string.length() == 0) {
            this.clearQFilter();
            return;
        }
        this.availableModel.setQFilter(string);
        if (saveViewMode == null) {
            saveViewMode = viewMode;
        }
        viewMode = 0;
        this.availableModel.resetModel(viewMode, true, false);
        this.clearQFilterButton.setEnabled(true);
        this.viewComboBox.setEnabled(false);
        this.updateAvailableModel();
    }

    public void updateLoadedCampaignsUI() {
        this.selectedCampaigns.clear();
        for (Campaign campaign : Globals.getCampaignList()) {
            if (!campaign.isLoaded()) continue;
            this.selectedCampaigns.add(campaign);
        }
        this.updateModels();
        if (this.getParent() != null && Globals.displayListsHappy()) {
            PCGen_Frame1 pCGen_Frame1 = PCGen_Frame1.getRealParentFrame(this);
            pCGen_Frame1.enableLstEditors(true);
        }
    }

    private void setInfoLabelText(PObjectNode pObjectNode) {
        this.lastSelection = pObjectNode;
        if (pObjectNode != null) {
            if (pObjectNode.getItem() instanceof Campaign) {
                Object object;
                Campaign campaign = (Campaign)pObjectNode.getItem();
                String string = campaign.getSourceEntry().getSourceBook().getWebsite();
                this.websiteButton.setEnabled(string != null);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<b>").append(campaign.getDisplayName()).append("</b><br>");
                stringBuffer.append("<html>");
                if (campaign.getCoverFiles().size() > 0) {
                    object = campaign.getCoverFiles().get(0);
                    stringBuffer.append("<img src='").append(((CampaignSourceEntry)object).getURI()).append("'><br>");
                }
                stringBuffer.append("<b>TYPE</b>: ").append(campaign.getType());
                stringBuffer.append("&nbsp; <b>RANK</b>: ").append(campaign.getRank());
                stringBuffer.append("&nbsp; <b>GAME MODE</b>: ").append(campaign.getGameModeString());
                object = campaign.getDefaultSourceString();
                if (((String)object).length() > 0) {
                    stringBuffer.append("&nbsp; <b>SOURCE</b>: ").append((String)object);
                }
                boolean bl = false;
                object = campaign.getInfoText();
                if (((String)object).length() > 0) {
                    stringBuffer.append("<p><b>INFORMATION</b>:<br>").append((String)object).append("</p>");
                    bl = true;
                }
                if (((String)(object = campaign.getSection15String())).length() != 0) {
                    if (!bl) {
                        stringBuffer.append("<br");
                    }
                    stringBuffer.append("<b>COPYRIGHT</b>:<br>").append((String)object);
                }
                stringBuffer.append("</html>");
                this.infoLabel.setText(stringBuffer.toString());
            } else {
                this.websiteButton.setEnabled(false);
                PObjectNode pObjectNode2 = pObjectNode;
                String string = pObjectNode2.getItem().toString();
                while (pObjectNode2.getParent() != this.availableTable.getTree().getModel().getRoot() && pObjectNode2.getParent() != this.selectedTable.getTree().getModel().getRoot()) {
                    pObjectNode2 = pObjectNode2.getParent();
                    string = pObjectNode2.getItem().toString() + "." + string;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<html><b>").append(string).append("</b><br>");
                if (Globals.getSponsor(string) != null) {
                    Map<String, String> map = Globals.getSponsor(string);
                    stringBuffer.append("<img src='").append(SponsorLoader.getConvertedSponsorPath(map.get("IMAGELARGE"))).append("'><br>");
                }
                stringBuffer.append("</html>");
                this.infoLabel.setText(stringBuffer.toString());
            }
        }
    }

    private void setLoadedColMaxWidth() {
        this.selectedTable.getColumnModel().getColumn(1).setMaxWidth(50);
    }

    private int getSelectedIndex(ListSelectionEvent listSelectionEvent) {
        DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
        if (defaultListSelectionModel == null) {
            return -1;
        }
        return defaultListSelectionModel.getMinSelectionIndex();
    }

    private void createAvailableModel() {
        if (this.availableModel == null) {
            this.availableModel = new CampaignModel(viewMode, true);
        } else {
            this.availableModel.resetModel(viewMode, true, false);
        }
    }

    private void createModels() {
        this.createAvailableModel();
        this.createSelectedModel();
    }

    private void createSelectedModel() {
        if (this.selectedModel == null) {
            this.selectedModel = new CampaignModel(viewSelectMode, false);
        } else {
            this.selectedModel.resetModel(viewSelectMode, false, false);
        }
    }

    private void createTreeTables() {
        this.availableTable = new JTreeTable(this.availableModel);
        this.availableTable.setSelectionMode(0);
        this.availableTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = MainSource.this.getSelectedIndex(listSelectionEvent);
                    if (n < 0) {
                        return;
                    }
                    Object object = MainSource.this.availableTable.getTree().getPathForRow(n).getLastPathComponent();
                    if (object == null || !(object instanceof PObjectNode)) {
                        ShowMessageDelegate.showMessageDialog("No campaign selected. Try again.", "PCGen", MessageType.ERROR);
                        return;
                    }
                    MainSource.this.setInfoLabelText((PObjectNode)object);
                    MainSource.this.rightButton.setEnabled(true);
                    MainSource.this.leftButton.setEnabled(false);
                }
            }
        });
        final JTree jTree = this.availableTable.getTree();
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
        jTree.setCellRenderer(new LabelTreeCellRenderer());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = jTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1) {
                    if (mouseEvent.getClickCount() == 1 && treePath != null) {
                        jTree.setSelectionPath(treePath);
                    } else if (mouseEvent.getClickCount() == 2) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                MainSource.this.doCampaign(true);
                            }
                        });
                    }
                }
            }
        };
        jTree.addMouseListener(mouseAdapter);
        this.selectedTable = new JTreeTable(this.selectedModel);
        this.selectedTable.setSelectionMode(0);
        final JTree jTree2 = this.selectedTable.getTree();
        jTree2.setRootVisible(false);
        jTree2.setShowsRootHandles(true);
        jTree2.setCellRenderer(new LabelTreeCellRenderer());
        this.selectedTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = MainSource.this.getSelectedIndex(listSelectionEvent);
                    if (n < 0) {
                        return;
                    }
                    Object object = MainSource.this.selectedTable.getTree().getPathForRow(n).getLastPathComponent();
                    if (object == null || !(object instanceof PObjectNode)) {
                        MainSource.this.lastSelection = null;
                        MainSource.this.infoLabel.setText();
                        return;
                    }
                    MainSource.this.setInfoLabelText((PObjectNode)object);
                    MainSource.this.leftButton.setEnabled(true);
                    MainSource.this.rightButton.setEnabled(false);
                }
            }
        });
        mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = jTree2.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = jTree2.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1) {
                    if (mouseEvent.getClickCount() == 1) {
                        jTree2.setSelectionPath(treePath);
                    } else if (mouseEvent.getClickCount() == 2) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                MainSource.this.doCampaign(false);
                            }
                        });
                    }
                }
            }
        };
        jTree2.addMouseListener(mouseAdapter);
        this.hookupPopupMenu(this.availableTable);
        this.hookupPopupMenu(this.selectedTable);
    }

    private void doCampaign(boolean bl) {
        if (this.lastSelection == null) {
            return;
        }
        if (this.lastSelection.getItem() instanceof Campaign) {
            Campaign campaign = (Campaign)this.lastSelection.getItem();
            if (bl) {
                if (!this.selectedCampaigns.contains(campaign)) {
                    this.selectedCampaigns.add(campaign);
                }
            } else {
                this.selectedCampaigns.remove(campaign);
            }
        } else {
            this.selectAllLeaves(this.lastSelection, bl);
        }
        Collections.sort(this.selectedCampaigns);
        this.updateModels();
        if (bl) {
            this.selectedTable.expandByPObjectName(this.lastSelection.getItem().toString());
        }
        this.rememberSourceChanges();
    }

    private void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.setMessageAreaTextWithoutSaving(SOURCE_MATERIALS_TAB);
        if (!this.hasBeenSized) {
            this.hasBeenSized = true;
            this.splitPane.setDividerSize(10);
            this.splitPane.setDividerLocation(0.5);
            this.bsplit.setDividerSize(10);
            this.bsplit.setDividerLocation(0.75);
            this.asplit.setDividerSize(10);
            this.asplit.setDividerLocation(0.5);
            this.setLoadedColMaxWidth();
        }
    }

    private void hookupPopupMenu(JTreeTable jTreeTable) {
        jTreeTable.addMouseListener(new CampaignPopupListener(jTreeTable, new CampaignPopupMenu(jTreeTable)));
    }

    private void initActionListeners() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                MainSource.this.formComponentShown();
            }
        });
        this.rightButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.doCampaign(true);
            }
        });
        this.leftButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.doCampaign(false);
            }
        });
        this.viewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.viewComboBoxActionPerformed();
            }
        });
        this.viewSelectComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.viewSelectComboBoxActionPerformed();
            }
        });
        this.textQFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                MainSource.this.setQFilter();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                MainSource.this.setQFilter();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                MainSource.this.setQFilter();
            }
        });
        this.clearQFilterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.clearQFilter();
            }
        });
    }

    private void initComponents() {
        this.resetViewNodes();
        this.viewComboBox.addItem("Name Only");
        this.viewComboBox.addItem("Company");
        this.viewComboBox.addItem("Company/Setting");
        this.viewComboBox.addItem("Comp/Fmt/Setting");
        Utility.setDescription(this.viewComboBox, "You can change how the Sources in the Tables are listed.");
        viewMode = SettingsHandler.getPCGenOption("pcgen.options.sourceTab.availableListMode", 3);
        this.viewComboBox.setSelectedIndex(viewMode);
        this.viewSelectComboBox.addItem("Name Only");
        this.viewSelectComboBox.addItem("Company");
        this.viewSelectComboBox.addItem("Company/Setting");
        this.viewSelectComboBox.addItem("Company/Format/Setting");
        viewSelectMode = SettingsHandler.getPCGenOption("pcgen.options.sourceTab.selectedListMode", 0);
        Utility.setDescription(this.viewSelectComboBox, "You can change how the Sources in the Tables are listed.");
        this.viewSelectComboBox.setSelectedIndex(viewSelectMode);
        this.createModels();
        this.createTreeTables();
        this.center.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.splitPane = new FlippingSplitPane(splitOrientation, jPanel, jPanel2);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(10);
        this.center.add((Component)this.splitPane, "Center");
        this.avaLabel.setText(PropertyFactory.getString("in_available"));
        jPanel.add((Component)InfoTabUtils.createFilterPane(this.avaLabel, this.viewComboBox, this.lblQFilter, this.textQFilter, this.clearQFilterButton), "North");
        JScrollPane jScrollPane = new JScrollPane(this.availableTable);
        jPanel.add((Component)jScrollPane, "Center");
        this.rightButton = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
        jPanel.add((Component)this.buildModSpellPanel(this.rightButton, "Click to add the source"), "South");
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 5, 1));
        this.selLabel.setText(PropertyFactory.getString("in_selected"));
        jPanel3.add(this.selLabel);
        jPanel3.add(this.viewSelectComboBox);
        jPanel2.add((Component)jPanel3, "North");
        jScrollPane = new JScrollPane(this.selectedTable);
        jPanel2.add((Component)jScrollPane, "Center");
        this.leftButton = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        jPanel2.add((Component)this.buildModSpellPanel(this.leftButton, "Click to remove the source"), "South");
        this.selectedTable.setColAlign(1, 0);
        this.bLeftPane = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel();
        Border border = null;
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "Source Info");
        titledBorder.setTitleJustification(2);
        this.infoLabel = new JLabelPane();
        JScrollPane jScrollPane2 = new JScrollPane(this.infoLabel);
        jScrollPane2.setBorder(titledBorder);
        this.bLeftPane.add((Component)jScrollPane2, "Center");
        this.infoLabel.setBackground(this.bLeftPane.getBackground());
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(1);
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)this.jPanel1n, "North");
        jPanel4.add((Component)this.jPanel1s, "Center");
        this.jPanel1n.setLayout(flowLayout);
        flowLayout = new FlowLayout();
        flowLayout.setAlignment(1);
        this.jPanel1s.setLayout(flowLayout);
        this.loadButton.setText("Load");
        this.loadButton.setMnemonic(76);
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.loadCampaigns_actionPerformed();
            }
        });
        this.jPanel1n.add(this.loadButton);
        this.loadButton.setToolTipText("This loads all the sources listed in the above table");
        this.unloadAllButton.setText("Unload All");
        this.unloadAllButton.setMnemonic(85);
        this.unloadAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.unloadAllCampaigns_actionPerformed();
            }
        });
        this.jPanel1n.add(this.unloadAllButton);
        this.removeAllButton = new JButton("Remove All");
        this.removeAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.selectAll_actionPerformed(false);
            }
        });
        this.removeAllButton.setToolTipText("Remove all sources from the above table");
        this.jPanel1n.add(this.removeAllButton);
        this.refreshButton.setText("Refresh");
        this.refreshButton.setToolTipText("Refresh the list of sources");
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.refreshCampaigns();
            }
        });
        this.jPanel1s.add(this.refreshButton);
        this.websiteButton = new JButton("Website");
        this.websiteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.launchProductWebsite(false, true);
            }
        });
        this.websiteButton.setToolTipText("Go to the selected product's website");
        this.websiteButton.setEnabled(false);
        this.jPanel1s.add(this.websiteButton);
        JButton jButton = new JButton("Customise");
        JPanel jPanel5 = this;
        jButton.addActionListener(new ActionListener((MainSource)jPanel5){
            final /* synthetic */ MainSource val$t;
            {
                this.val$t = mainSource2;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                new PCCCreator(this.val$t);
            }
        });
        jButton.setToolTipText("Customise your own source to ease your loading process");
        this.jPanel1s.add(jButton);
        this.asplit = new FlippingSplitPane(1, this.bLeftPane, jPanel4);
        this.asplit.setOneTouchExpandable(true);
        this.asplit.setDividerSize(10);
        jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)this.asplit, "Center");
        this.bsplit = new FlippingSplitPane(0, this.center, jPanel5);
        this.bsplit.setOneTouchExpandable(true);
        this.bsplit.setDividerSize(10);
        this.setLayout(new BorderLayout());
        this.add((Component)this.bsplit, "Center");
        if (SettingsHandler.isLoadCampaignsAtStart()) {
            this.selectCampaignsByURI(PersistenceManager.getInstance().getChosenCampaignSourcefiles());
            if (this.selectedCampaigns.size() > 0) {
                this.loadCampaigns();
            }
        }
    }

    private JPanel buildModSpellPanel(JButton jButton, String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 1));
        Utility.setDescription(jButton, string);
        jButton.setEnabled(false);
        jButton.setMargin(new Insets(1, 14, 1, 14));
        jPanel.add(jButton);
        return jPanel;
    }

    private void launchProductWebsite(boolean bl, boolean bl2) {
        JTreeTable jTreeTable = bl ? this.availableTable : this.selectedTable;
        PObjectNode pObjectNode = (PObjectNode)jTreeTable.getTree().getLastSelectedPathComponent();
        if (pObjectNode != null) {
            if (pObjectNode.getItem() instanceof Campaign) {
                String string;
                Campaign campaign = (Campaign)pObjectNode.getItem();
                String string2 = string = bl2 ? campaign.getSourceEntry().getSourceBook().getWebsite() : campaign.getHelp();
                if (string != null && !string.equals("")) {
                    try {
                        BrowserLauncher.openURL(string);
                    }
                    catch (IOException iOException) {
                        Logging.errorPrint("Could not open browser to " + string, iOException);
                        ShowMessageDelegate.showMessageDialog("Could not open browser to " + string, "PCGen", MessageType.ERROR);
                    }
                } else {
                    String string3 = bl2 ? "web" : "help";
                    ShowMessageDelegate.showMessageDialog("No " + string3 + " information found for Source: " + campaign.getDisplayName(), "PCGen", MessageType.WARNING);
                }
            }
        } else {
            ShowMessageDelegate.showMessageDialog("Please select a source.", "PCGen", MessageType.ERROR);
        }
    }

    private void loadCampaigns() {
        if (this.selectedCampaigns.size() < 1) {
            return;
        }
        PersistenceObserver persistenceObserver = new PersistenceObserver();
        PersistenceManager persistenceManager = PersistenceManager.getInstance();
        try {
            persistenceManager.addObserver(persistenceObserver);
            persistenceManager.loadCampaigns(this.selectedCampaigns);
            persistenceManager.deleteObserver(persistenceObserver);
        }
        catch (PersistenceLayerException persistenceLayerException) {
            ShowMessageDelegate.showMessageDialog(persistenceLayerException.getMessage(), "PCGen", MessageType.WARNING);
            this.unloadAllCampaigns_actionPerformed();
        }
        Globals.sortCampaigns();
    }

    private void loadCampaigns_actionPerformed() {
        final String string = this.showLoadingSources();
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                MainSource.this.loadCampaigns();
                return "";
            }

            public void finished() {
                if (MainSource.this.getParent() != null && Globals.displayListsHappy()) {
                    PCGen_Frame1 pCGen_Frame1 = PCGen_Frame1.getRealParentFrame(MainSource.this);
                    pCGen_Frame1.enableLstEditors(true);
                }
                MainSource.this.updateModels();
                MainSource.this.showSourcesLoaded(string);
            }
        };
        swingWorker.start();
    }

    String showLoadingSources() {
        this.sourcesLoaded = true;
        this.loadButton.setEnabled(false);
        this.refreshButton.setEnabled(false);
        this.refreshButton.setToolTipText("Can't refresh while sources are loaded.");
        String string = PCGen_Frame1.getMessageAreaText();
        PCGen_Frame1.setMessageAreaTextWithoutSaving("Loading Sources...");
        return string;
    }

    void showSourcesLoaded(String string) {
        PCGen_Frame1.enableDisableMenuItems();
        PCGen_Frame1.setMessageAreaTextWithoutSaving(string);
        PCGen_Frame1.restoreFilterSettings(null);
    }

    private void rememberSourceChanges() {
        ArrayList<URI> arrayList = new ArrayList<URI>(this.selectedCampaigns.size());
        for (Campaign campaign : this.selectedCampaigns) {
            arrayList.add(campaign.getSourceURI());
        }
        PersistenceManager.getInstance().setChosenCampaignSourcefiles(arrayList);
    }

    public void resetUI() {
        this.infoLabel.setBackground(this.bLeftPane.getBackground());
    }

    /*
     * WARNING - void declaration
     */
    private void resetViewNodes() {
        Object object;
        List<String> list = Globals.getAllowedGameModes();
        typePubRoot = new PObjectNode();
        typePubSetRoot = new PObjectNode();
        typePubFmtSetRoot = new PObjectNode();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Campaign pObjectNodeArray2 : Globals.getCampaignList()) {
            if (!pObjectNodeArray2.isGameMode(list) || pObjectNodeArray2.getMyTypeCount() <= 0) continue;
            treeSet.add(pObjectNodeArray2.getMyType(0));
        }
        treeSet.add("Other");
        int n = treeSet.size();
        PObjectNode[] pObjectNodeArray = new PObjectNode[n];
        PObjectNode[] pObjectNodeArray2 = new PObjectNode[n];
        PObjectNode[] pObjectNodeArray3 = new PObjectNode[n];
        int n2 = 0;
        for (String string : treeSet) {
            PObjectNode pObjectNode = new PObjectNode();
            pObjectNode.setItem(string);
            pObjectNode.setParent(typePubRoot);
            pObjectNodeArray[n2] = pObjectNode;
            pObjectNode = new PObjectNode();
            pObjectNode.setItem(string);
            pObjectNode.setParent(typePubSetRoot);
            pObjectNodeArray2[n2] = pObjectNode;
            pObjectNode = new PObjectNode();
            pObjectNode.setItem(string);
            pObjectNode.setParent(typePubFmtSetRoot);
            pObjectNodeArray3[n2] = pObjectNode;
            ++n2;
        }
        typePubRoot.setChildren(pObjectNodeArray);
        typePubSetRoot.setChildren(pObjectNodeArray2);
        typePubFmtSetRoot.setChildren(pObjectNodeArray3);
        for (PObjectNode pObjectNode : pObjectNodeArray2) {
            treeSet.clear();
            for (Campaign campaign : Globals.getCampaignList()) {
                if (!campaign.isType((String)(object = pObjectNode.toString())) || campaign.getMyTypeCount() <= 2 || !campaign.isGameMode(list)) continue;
                treeSet.add(campaign.getMyType(2));
            }
            for (String string : treeSet) {
                object = new PObjectNode();
                ((PObjectNode)object).setParent(pObjectNode);
                pObjectNode.addChild((PObjectNode)object);
                ((PObjectNode)object).setItem(string);
            }
        }
        for (PObjectNode pObjectNode : pObjectNodeArray3) {
            void var13_23;
            treeSet.clear();
            for (Campaign i : Globals.getCampaignList()) {
                if (!i.isType((String)(object = pObjectNode.toString())) || i.getMyTypeCount() <= 1 || !i.isGameMode(list)) continue;
                treeSet.add(i.getMyType(1));
            }
            for (String string : treeSet) {
                object = new PObjectNode(string);
                pObjectNode.addChild((PObjectNode)object);
            }
            ArrayList<PObjectNode> arrayList = pObjectNode.getChildren();
            boolean bl = false;
            while (arrayList != null && var13_23 < arrayList.size()) {
                Object object2;
                object = (PObjectNode)arrayList.get((int)var13_23);
                treeSet.clear();
                for (Campaign campaign : Globals.getCampaignList()) {
                    object2 = ((PObjectNode)object).getParent().toString();
                    String string = ((PObjectNode)object).toString();
                    if (!campaign.isType((String)object2) || !campaign.isType(string) || campaign.getMyTypeCount() <= 2 || !campaign.isGameMode(list)) continue;
                    treeSet.add(campaign.getMyType(2));
                }
                for (String string : treeSet) {
                    object2 = new PObjectNode(string);
                    ((PObjectNode)object).addChild((PObjectNode)object2);
                }
                ++var13_23;
            }
        }
    }

    private void selectAllLeaves(PObjectNode pObjectNode, boolean bl) {
        for (int i = 0; i < pObjectNode.getChildCount(); ++i) {
            PObjectNode pObjectNode2 = pObjectNode.getChild(i);
            if (pObjectNode2.isLeaf() && pObjectNode2.getItem() instanceof Campaign) {
                Campaign campaign = (Campaign)pObjectNode2.getItem();
                if (campaign == null) continue;
                if (bl) {
                    if (this.selectedCampaigns.contains(campaign)) continue;
                    this.selectedCampaigns.add(campaign);
                    continue;
                }
                this.selectedCampaigns.remove(campaign);
                continue;
            }
            this.selectAllLeaves(pObjectNode2, bl);
        }
    }

    private void selectAll_actionPerformed(boolean bl) {
        if (bl) {
            this.selectAllLeaves((PObjectNode)this.availableTable.getTree().getModel().getRoot(), true);
        } else {
            this.selectedCampaigns.clear();
            this.unloadAllCampaigns_actionPerformed();
        }
        this.updateModels();
        this.rememberSourceChanges();
    }

    private void selectCampaignsByURI(Collection<URI> collection) {
        for (URI uRI : collection) {
            Campaign campaign = Globals.getCampaignByURI(uRI);
            if (campaign == null || this.selectedCampaigns.contains(campaign)) continue;
            this.selectedCampaigns.add(campaign);
            this.updateModels();
        }
    }

    private void unloadAllCampaigns_actionPerformed() {
        PCGen_Frame1 pCGen_Frame1 = PCGen_Frame1.getRealParentFrame(this);
        if (Logging.isDebugMode()) {
            ShowMessageDelegate.showMessageDialog("PC's are not closed in debug mode.  Please be aware that they may not function correctly until campaign data is loaded again.", "PCGen", MessageType.WARNING);
        } else {
            pCGen_Frame1.closeAllPCs();
            if (PCGen_Frame1.getBaseTabbedPane().getTabCount() > PCGen_Frame1.FIRST_CHAR_TAB) {
                ShowMessageDelegate.showMessageDialog("Can't unload campaigns until all PC's are closed.", "PCGen", MessageType.INFORMATION);
                return;
            }
            PCGen_Frame1.setCharacterPane(null);
        }
        Globals.emptyLists();
        PersistenceManager.getInstance().emptyLists();
        PersistenceManager.getInstance().setChosenCampaignSourcefiles(new ArrayList<URI>());
        for (Campaign campaign : Globals.getCampaignList()) {
            campaign.setIsLoaded(false);
        }
        pCGen_Frame1.enableLstEditors(false);
        this.sourcesLoaded = false;
        this.refreshButton.setEnabled(true);
        this.refreshButton.setToolTipText("Refresh the list of sources");
        PCGen_Frame1.enableDisableMenuItems();
        this.updateModels();
    }

    private void updateAvailableModel() {
        List<String> list = this.availableTable.getExpandedPaths();
        this.createAvailableModel();
        this.availableTable.updateUI();
        this.availableTable.expandPathList(list);
    }

    private void updateModels() {
        this.updateAvailableModel();
        this.updateSelectedModel();
        this.setLoadedColMaxWidth();
        if (this.selectedTable.getTree().getRowCount() == 0) {
            this.loadButton.setEnabled(false);
            this.unloadAllButton.setEnabled(false);
            this.removeAllButton.setEnabled(false);
        } else {
            this.loadButton.setEnabled(!this.sourcesLoaded);
            this.unloadAllButton.setEnabled(true);
            this.removeAllButton.setEnabled(true);
        }
    }

    private void updateSelectedModel() {
        List<String> list = this.selectedTable.getExpandedPaths();
        this.createSelectedModel();
        this.selectedTable.updateUI();
        this.selectedTable.expandPathList(list);
    }

    private void viewComboBoxActionPerformed() {
        int n = this.viewComboBox.getSelectedIndex();
        if (n != viewMode) {
            viewMode = n;
            SettingsHandler.setPCGenOption("pcgen.options.sourceTab.availableListMode", viewMode);
            this.updateAvailableModel();
        }
    }

    private void viewSelectComboBoxActionPerformed() {
        int n = this.viewSelectComboBox.getSelectedIndex();
        if (n != viewSelectMode) {
            viewSelectMode = n;
            SettingsHandler.setPCGenOption("pcgen.options.sourceTab.selectedListMode", viewSelectMode);
            this.updateSelectedModel();
        }
    }

    static {
        saveViewMode = null;
    }

    private class CampaignPopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = -2654080650560664447L;

        CampaignPopupMenu(JTreeTable jTreeTable) {
            if (jTreeTable == MainSource.this.availableTable) {
                this.add(this.createAddMenuItem("Select", "shortcut EQUALS"));
                this.add(this.createAddAllMenuItem("Select All", "alt A"));
                this.add(this.createWebMenuItem("Product Website...", "alt W", true));
                this.add(this.createHelpFileMenuItem("Product Help...", "alt H", true));
            } else {
                this.add(this.createRemoveMenuItem("Remove", "shortcut MINUS"));
                this.add(this.createRemoveAllMenuItem("Remove All", "alt A"));
                this.add(this.createWebMenuItem("Product Website...", "alt W", false));
                this.add(this.createHelpFileMenuItem("Product Help...", "alt H", false));
            }
        }

        private JMenuItem createAddAllMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new AddAllCampaignActionListener(), "selectall", '\u0000', string2, "Select All Source material to load", "Add16.gif", true);
        }

        private JMenuItem createAddMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new AddCampaignActionListener(), "select", '\u0000', string2, "Select Source material to load", "Add16.gif", true);
        }

        private JMenuItem createRemoveAllMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new RemoveAllCampaignActionListener(), "deselectall", '\u0000', string2, "Remove All Source material from loading", "Remove16.gif", true);
        }

        private JMenuItem createRemoveMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new RemoveCampaignActionListener(), "deselect", '\u0000', string2, "Remove Source material from loading", "Remove16.gif", true);
        }

        private JMenuItem createHelpFileMenuItem(String string, String string2, boolean bl) {
            return Utility.createMenuItem(string, new HelpfileActionListener(bl), "helpfile", '\u0000', string2, "Launch browser to product's helpfile", "Bookmarks16.gif", true);
        }

        private JMenuItem createWebMenuItem(String string, String string2, boolean bl) {
            return Utility.createMenuItem(string, new WebActionListener(bl), "website", '\u0000', string2, "Launch browser to product's website", "Bookmarks16.gif", true);
        }

        private class WebActionListener
        implements ActionListener {
            boolean available = true;

            WebActionListener(boolean bl) {
                this.available = bl;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.launchProductWebsite(this.available, true);
            }
        }

        private class HelpfileActionListener
        implements ActionListener {
            boolean available = true;

            HelpfileActionListener(boolean bl) {
                this.available = bl;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.launchProductWebsite(this.available, false);
            }
        }

        private class RemoveCampaignActionListener
        implements ActionListener {
            private RemoveCampaignActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.doCampaign(false);
            }
        }

        private class RemoveAllCampaignActionListener
        implements ActionListener {
            private RemoveAllCampaignActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.selectAll_actionPerformed(false);
            }
        }

        private class AddCampaignActionListener
        implements ActionListener {
            private AddCampaignActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.doCampaign(true);
            }
        }

        private class AddAllCampaignActionListener
        implements ActionListener {
            private AddAllCampaignActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.selectAll_actionPerformed(true);
            }
        }
    }

    private class CampaignPopupListener
    extends MouseAdapter {
        private CampaignPopupMenu menu;
        private JTree tree;

        CampaignPopupListener(JTreeTable jTreeTable, CampaignPopupMenu campaignPopupMenu) {
            this.tree = jTreeTable.getTree();
            this.menu = campaignPopupMenu;
            KeyListener keyListener = new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                    MainSource.this.dispatchEvent(keyEvent);
                }

                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                        for (int i = 0; i < CampaignPopupListener.this.menu.getComponentCount(); ++i) {
                            JMenuItem jMenuItem = (JMenuItem)CampaignPopupListener.this.menu.getComponent(i);
                            KeyStroke keyStroke2 = jMenuItem.getAccelerator();
                            if (keyStroke2 == null || !keyStroke.equals(keyStroke2)) continue;
                            MainSource.this.selPath = CampaignPopupListener.this.tree.getSelectionPath();
                            jMenuItem.doClick(2);
                            return;
                        }
                    }
                    MainSource.this.dispatchEvent(keyEvent);
                }

                public void keyReleased(KeyEvent keyEvent) {
                    MainSource.this.dispatchEvent(keyEvent);
                }
            };
            jTreeTable.addKeyListener(keyListener);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                MainSource.this.selRow = this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (MainSource.this.selRow == -1) {
                    return;
                }
                MainSource.this.selPath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (MainSource.this.selPath == null) {
                    return;
                }
                this.tree.setSelectionPath(MainSource.this.selPath);
                this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class CampaignModel
    extends AbstractTreeTableModel {
        final String[] availNameList;
        final String[] selNameList;
        int modelType;

        public CampaignModel(int n, boolean bl) {
            super(null);
            this.availNameList = new String[]{"Source Material"};
            this.selNameList = new String[]{"Source Material", "Loaded"};
            this.modelType = 0;
            if (!bl) {
                this.modelType = 1;
            }
            this.resetModel(n, bl, true);
        }

        @Override
        public boolean isCellEditable(Object object, int n) {
            return n == 0;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 1: {
                    return String.class;
                }
                case 0: {
                    return TreeTableModel.class;
                }
            }
            Logging.errorPrint("In MainSource.CampaignModel.getColumnClass the column " + n + " is not handled.");
            return String.class;
        }

        @Override
        public int getColumnCount() {
            if (this.modelType == 0) {
                return this.availNameList.length;
            }
            return this.selNameList.length;
        }

        @Override
        public String getColumnName(int n) {
            if (this.modelType == 0) {
                return this.availNameList[n];
            }
            return this.selNameList[n];
        }

        public void setRoot(PObjectNode pObjectNode) {
            super.setRoot(pObjectNode);
        }

        @Override
        public final Object getRoot() {
            return super.getRoot();
        }

        @Override
        public Object getValueAt(Object object, int n) {
            try {
                PObjectNode pObjectNode = (PObjectNode)object;
                Campaign campaign = null;
                if (pObjectNode != null && pObjectNode.getItem() instanceof Campaign) {
                    campaign = (Campaign)pObjectNode.getItem();
                }
                switch (n) {
                    case 0: {
                        if (pObjectNode != null) {
                            return pObjectNode.toString();
                        }
                        Logging.errorPrint("Somehow we have no active node when doing getValueAt in MainSource.");
                        return "";
                    }
                    case 1: {
                        if (campaign != null) {
                            if (campaign.isLoaded()) {
                                return "Y";
                            }
                            return "N";
                        }
                        break;
                    }
                    case -1: {
                        if (pObjectNode != null) {
                            return pObjectNode.getItem();
                        }
                        Logging.errorPrint("Somehow we have no active node when doing getValueAt in MainSource.");
                        return null;
                    }
                    default: {
                        Logging.errorPrint("In MainSource.CampaignModel.getValueAt the column " + n + " is not handled.");
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public void resetModel(int n, boolean bl, boolean bl2) {
            Object object;
            List<String> list = Globals.getAllowedGameModes();
            PCGen_Frame1 pCGen_Frame1 = PCGen_Frame1.getInst();
            PlayerCharacter playerCharacter = null;
            if (pCGen_Frame1 != null) {
                playerCharacter = pCGen_Frame1.getCurrentPC();
            }
            List list2 = bl ? Globals.getCampaignList() : MainSource.this.selectedCampaigns;
            switch (n) {
                case 3: {
                    this.setRoot(typePubFmtSetRoot.clone());
                    for (Campaign campaign : list2) {
                        PObjectNode pObjectNode = (PObjectNode)super.getRoot();
                        if (!this.shouldDisplayThis(campaign, playerCharacter) || !campaign.isGameMode(list) || bl && MainSource.this.selectedCampaigns.contains(campaign)) continue;
                        boolean bl3 = false;
                        for (int i = 0; i < pObjectNode.getChildCount(); ++i) {
                            ArrayList<Object> arrayList;
                            if (!campaign.isType(pObjectNode.getChild(i).getItem().toString()) && (bl3 || i != pObjectNode.getChildCount() - 1)) continue;
                            if (campaign.getMyTypeCount() < 2) {
                                arrayList = new ArrayList(1);
                                arrayList.add(pObjectNode.getChild(i));
                            } else {
                                arrayList = pObjectNode.getChild(i).getChildren();
                            }
                            if (arrayList != null && arrayList.size() == 0) {
                                PObjectNode pObjectNode2 = new PObjectNode(campaign);
                                PrereqHandler.passesAll(campaign.getPreReqList(), playerCharacter, campaign);
                                pObjectNode.getChild(i).addChild(pObjectNode2);
                                bl3 = true;
                            }
                            for (int j = 0; arrayList != null && j < arrayList.size(); ++j) {
                                ArrayList<Object> arrayList2;
                                if (!campaign.isType(((PObjectNode)arrayList.get(j)).getItem().toString()) && (bl3 || j != arrayList.size() - 1)) continue;
                                if (campaign.getMyTypeCount() == 2) {
                                    arrayList2 = new ArrayList(1);
                                    arrayList2.add(arrayList.get(j));
                                } else if (campaign.getMyTypeCount() < 2) {
                                    arrayList2 = new ArrayList(1);
                                    arrayList2.add(pObjectNode.getChild(i));
                                } else {
                                    arrayList2 = ((PObjectNode)arrayList.get(j)).getChildren();
                                }
                                for (int k = 0; arrayList2 != null && k < arrayList2.size(); ++k) {
                                    if (!campaign.isType(((PObjectNode)arrayList2.get(k)).getItem().toString()) && (bl3 || k != arrayList2.size() - 1)) continue;
                                    PObjectNode pObjectNode3 = new PObjectNode(campaign);
                                    PrereqHandler.passesAll(campaign.getPreReqList(), playerCharacter, campaign);
                                    ((PObjectNode)arrayList2.get(k)).addChild(pObjectNode3);
                                    bl3 = true;
                                }
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    this.setRoot(typePubSetRoot.clone());
                    for (Campaign campaign : list2) {
                        PObjectNode pObjectNode = (PObjectNode)super.getRoot();
                        if (!this.shouldDisplayThis(campaign, playerCharacter) || !campaign.isGameMode(list) || bl && MainSource.this.selectedCampaigns.contains(campaign)) continue;
                        boolean bl4 = false;
                        for (int i = 0; i < pObjectNode.getChildCount(); ++i) {
                            ArrayList<Object> arrayList;
                            if (!campaign.isType(pObjectNode.getChild(i).getItem().toString()) && (bl4 || i != pObjectNode.getChildCount() - 1)) continue;
                            if (campaign.getMyTypeCount() < 3) {
                                arrayList = new ArrayList(1);
                                arrayList.add(pObjectNode.getChild(i));
                            } else {
                                arrayList = pObjectNode.getChild(i).getChildren();
                            }
                            for (int j = 0; arrayList != null && j < arrayList.size(); ++j) {
                                if (((PObjectNode)arrayList.get(j)).getItem() instanceof PObject || !campaign.isType(((PObjectNode)arrayList.get(j)).getItem().toString()) && (bl4 || i != pObjectNode.getChildCount() - 1)) continue;
                                PObjectNode pObjectNode4 = new PObjectNode(campaign);
                                PrereqHandler.passesAll(campaign.getPreReqList(), playerCharacter, campaign);
                                ((PObjectNode)arrayList.get(j)).addChild(pObjectNode4);
                                bl4 = true;
                            }
                        }
                    }
                    break;
                }
                case 1: {
                    this.setRoot(typePubRoot.clone());
                    for (Campaign campaign : list2) {
                        PObjectNode pObjectNode = (PObjectNode)super.getRoot();
                        if (!this.shouldDisplayThis(campaign, playerCharacter) || !campaign.isGameMode(list) || bl && MainSource.this.selectedCampaigns.contains(campaign)) continue;
                        boolean bl5 = false;
                        for (int i = 0; i < pObjectNode.getChildCount(); ++i) {
                            if (!campaign.isType(pObjectNode.getChild(i).getItem().toString()) && (bl5 || i != pObjectNode.getChildCount() - 1)) continue;
                            PObjectNode pObjectNode5 = new PObjectNode();
                            pObjectNode5.setParent(pObjectNode.getChild(i));
                            pObjectNode5.setItem(campaign);
                            PrereqHandler.passesAll(campaign.getPreReqList(), playerCharacter, campaign);
                            pObjectNode.getChild(i).addChild(pObjectNode5);
                            bl5 = true;
                        }
                    }
                    break;
                }
                case 0: {
                    this.setRoot(new PObjectNode());
                    object = this.getQFilter();
                    for (Campaign campaign : list2) {
                        PObjectNode pObjectNode = (PObjectNode)super.getRoot();
                        if (!this.shouldDisplayThis(campaign, playerCharacter) || !campaign.isGameMode(list) || bl && MainSource.this.selectedCampaigns.contains(campaign) || object != null && campaign.getKeyName().toLowerCase().indexOf((String)object) < 0 && campaign.getType().toLowerCase().indexOf((String)object) < 0) continue;
                        PObjectNode pObjectNode6 = new PObjectNode();
                        pObjectNode6.setParent(pObjectNode);
                        pObjectNode6.setItem(campaign);
                        PrereqHandler.passesAll(campaign.getPreReqList(), playerCharacter, campaign);
                        pObjectNode.addChild(pObjectNode6);
                    }
                    break;
                }
                default: {
                    Logging.errorPrint("In MainSource.CampaignlModel.resetModel the mode " + n + " is not handled.");
                }
            }
            object = (PObjectNode)super.getRoot();
            if (((PObjectNode)object).getChildCount() > 0) {
                this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
            }
        }

        private boolean shouldDisplayThis(Campaign campaign, PlayerCharacter playerCharacter) {
            if (campaign.getDisplayName().length() == 0) {
                return false;
            }
            return this.modelType == 1 || MainSource.this.accept(playerCharacter, campaign);
        }
    }
}

