/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import pcgen.gui.FrameActionListener;
import pcgen.gui.utils.Utility;
import pcgen.util.Logging;

final class PCPopupMenu
extends JPopupMenu {
    public static final int SHIFT_NONE = 0;
    public static final int SHIFT_LEFT = 1;
    public static final int SHIFT_RIGHT = 2;
    public static final int SHIFT_LEFT_RIGHT = 3;
    public static final int SHIFT_LEFT_BEGINNING = 4;
    public static final int SHIFT_END_RIGHT = 5;
    private JMenuItem closeItem;
    private JMenuItem newItem;
    private JMenuItem newNPCItem;
    private JMenuItem revertToSavedItem;
    private JMenuItem saveAsItem;
    private JMenuItem saveItem;
    private JMenuItem shiftBeginningItem;
    private JMenuItem shiftEndItem;
    private JMenuItem shiftLeftItem;
    private JMenuItem shiftRightItem;
    private JSeparator shiftSeparator;

    public PCPopupMenu(FrameActionListener frameActionListener) {
        this.newItem = Utility.createMenuItem("New", frameActionListener.newPopupActionListener, "pcPopupMenu.new", 'N', null, "Create a new character", "New16.gif", true);
        this.add(this.newItem);
        this.newNPCItem = Utility.createMenuItem("New NPC", frameActionListener.newNPCPopupActionListener, "pcPopupMenu.newNPC", '\u0000', null, "Create a new random NPC", "NewNPC16.gif", true);
        this.add(this.newNPCItem);
        this.closeItem = Utility.createMenuItem("Close", frameActionListener.closePopupActionListener, "pcPopupMenu.close", 'C', null, "Close the current character", "Close16.gif", true);
        this.add(this.closeItem);
        this.saveItem = Utility.createMenuItem("Save", frameActionListener.savePopupActionListener, "pcPopupMenu.save", 'S', null, "Save the current character to its .PCG file", "Save16.gif", true);
        this.add(this.saveItem);
        this.saveAsItem = Utility.createMenuItem("Save as...", frameActionListener.saveAsPopupActionListener, "pcPopupMenu.saveas", 'A', null, "Save the current character to a new .PCG file", "SaveAs16.gif", true);
        this.add(this.saveAsItem);
        this.revertToSavedItem = Utility.createMenuItem("Revert to saved", frameActionListener.revertToSavedPopupActionListener, "pcPopupMenu.revert", 'T', null, "Reopen the current character from its .PCG file, discarding any changes", null, true);
        this.add(this.revertToSavedItem);
        this.shiftSeparator = new JSeparator();
        this.shiftLeftItem = Utility.createMenuItem("Shift left", frameActionListener.shiftLeftPopupActionListener, "pcPopupMenu.shift.left", 'L', null, "Shift PC tab left one position", "Back16.gif", true);
        this.shiftRightItem = Utility.createMenuItem("Shift right", frameActionListener.shiftRightPopupActionListener, "pcPopupMenu.shift.right", 'R', null, "Shift PC tab right one position", "Forward16.gif", true);
        this.shiftBeginningItem = Utility.createMenuItem("Shift beginning", frameActionListener.shiftRightPopupActionListener, "pcPopupMenu.shift.beginning", 'B', null, "Shift PC tab left all the way", "BBack16.gif", true);
        this.shiftEndItem = Utility.createMenuItem("Shift end", frameActionListener.shiftLeftPopupActionListener, "pcPopupMenu.shift.end", 'E', null, "Shift PC tab right all the way", "FForward16.gif", true);
    }

    public JMenuItem getCloseItem() {
        return this.closeItem;
    }

    public JMenuItem getNewItem() {
        return this.newItem;
    }

    public JMenuItem getNewNPCItem() {
        return this.newNPCItem;
    }

    public JMenuItem getRevertToSavedItem() {
        return this.revertToSavedItem;
    }

    public JMenuItem getSaveAsItem() {
        return this.saveAsItem;
    }

    public JMenuItem getSaveItem() {
        return this.saveItem;
    }

    public void setShiftType(int n) {
        this.remove(this.shiftSeparator);
        this.remove(this.shiftLeftItem);
        this.remove(this.shiftRightItem);
        this.remove(this.shiftBeginningItem);
        this.remove(this.shiftEndItem);
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.add(this.shiftSeparator);
                this.add(this.shiftLeftItem);
                break;
            }
            case 2: {
                this.add(this.shiftSeparator);
                this.add(this.shiftRightItem);
                break;
            }
            case 3: {
                this.add(this.shiftSeparator);
                this.add(this.shiftLeftItem);
                this.add(this.shiftRightItem);
                break;
            }
            case 4: {
                this.add(this.shiftSeparator);
                this.add(this.shiftLeftItem);
                this.add(this.shiftBeginningItem);
                break;
            }
            case 5: {
                this.add(this.shiftSeparator);
                this.add(this.shiftEndItem);
                this.add(this.shiftRightItem);
                break;
            }
            default: {
                Logging.errorPrint("Invalid shift for PCPopupMenu: " + n);
            }
        }
    }
}

