/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SourceLoadProgressPanel
extends JPanel {
    private JProgressBar progressBar;
    private JLabel filenameArea;
    private JTextArea messageArea;
    private JScrollPane messageAreaContainer;
    private boolean errorState = false;

    public SourceLoadProgressPanel() {
        this.initialize();
    }

    public void setMaxProgress(int n) {
        this.getProgressBar().setMaximum(n);
    }

    public void setCutrrentProgress(int n) {
        this.getProgressBar().setValue(n);
    }

    public void setCurrentFilename(String string) {
        Graphics graphics = this.getFilenameArea().getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        if (n < this.getFilenameArea().getWidth()) {
            this.getFilenameArea().setText(string);
        } else {
            this.getFilenameArea().setText(this.shortenString(fontMetrics, string, this.getFilenameArea().getWidth()));
        }
    }

    public void addMessage(String string) {
        this.getMessageArea().append(string + "\n");
    }

    public void setErrorState(boolean bl) {
        this.errorState = bl;
    }

    public boolean getErrorState() {
        return this.errorState;
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 5, 10);
        this.add((Component)this.getProgressBar(), gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.ipadx = 0;
        gridBagConstraints2.ipady = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(5, 10, 5, 10);
        this.add((Component)this.getFilenameArea(), gridBagConstraints2);
        this.addMessageAreaContainer();
        this.setSize(594, 193);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    private void addMessageAreaContainer() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 340;
        gridBagConstraints.ipady = 40;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.messageAreaContainer(), gridBagConstraints);
    }

    private JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.setValue(17);
            this.progressBar.setStringPainted(true);
        }
        return this.progressBar;
    }

    private JLabel getFilenameArea() {
        if (this.filenameArea == null) {
            this.filenameArea = new JLabel();
            this.filenameArea.setText("Current File Name");
            this.filenameArea.setFont(new Font("Dialog", 0, 12));
            this.filenameArea.setName("labelCurrentFileName");
        }
        return this.filenameArea;
    }

    private JTextArea getMessageArea() {
        if (this.messageArea == null) {
            this.messageArea = new JTextArea();
            this.messageArea.setName("errorMessageBox");
            this.messageArea.setEditable(false);
            this.messageArea.setTabSize(8);
        }
        return this.messageArea;
    }

    private JScrollPane messageAreaContainer() {
        if (this.messageAreaContainer == null) {
            this.messageAreaContainer = new JScrollPane(this.getMessageArea());
        }
        return this.messageAreaContainer;
    }

    private String shortenString(FontMetrics fontMetrics, String string, int n) {
        for (int i = string.length(); i > 0; i -= 5) {
            String string2 = "..." + string.substring(string.length() - i);
            int n2 = fontMetrics.stringWidth(string2);
            if (n2 >= n) continue;
            return string2;
        }
        return "";
    }
}

