/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.Race;
import pcgen.gui.editor.PObjectUpdater;
import pcgen.util.PropertyFactory;

final class AgePanel
extends JPanel
implements PObjectUpdater {
    static final long serialVersionUID = -5835737108073399178L;
    private static String defaultRegionName = "None";
    private static final int COL_MINAGE = 1;
    private AgeTableModel ageModel = null;

    AgePanel() {
        this.initComponents();
    }

    public void updateData(PObject pObject) {
        if (!(pObject instanceof Race)) {
            return;
        }
        Race race = (Race)pObject;
        String string = race.getRegionString();
        if (string == null) {
            string = defaultRegionName;
        }
        String string2 = race.getKeyName();
        this.ageModel.saveValues(string, string2);
    }

    public void updateView(PObject pObject) {
        if (!(pObject instanceof Race)) {
            return;
        }
        Race race = (Race)pObject;
        String string = race.getRegionString();
        if (string == null) {
            string = defaultRegionName;
        }
        String string2 = race.getKeyName();
        this.ageModel.reset(string, string2);
    }

    private void initComponents() {
        this.ageModel = new AgeTableModel("", null);
        JTable jTable = new JTable(this.ageModel);
        jTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.add(jScrollPane);
    }

    static final class AgeTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{PropertyFactory.getString("in_demAgeName"), PropertyFactory.getString("in_demAgeMin"), PropertyFactory.getString("in_demAgeRoll"), PropertyFactory.getString("in_demAgeMax")};
        private List data = null;

        AgeTableModel(String string, String string2) {
            this.reset(string, string2);
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 >= 1;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRowCount() {
            return this.data.size();
        }

        public void setValueAt(Object object, int n, int n2) {
            Object[] objectArray = (Object[])this.data.get(n);
            objectArray[n2] = object;
            this.fireTableCellUpdated(n, n2);
        }

        public Object getValueAt(int n, int n2) {
            Object[] objectArray = (Object[])this.data.get(n);
            if (objectArray == null || n2 < 0 || n2 > objectArray.length) {
                return null;
            }
            return objectArray[n2];
        }

        void reset(String string, String string2) {
            Iterator<String> iterator;
            if (string == null || string.length() == 0) {
                string = defaultRegionName;
            }
            this.data = new ArrayList();
            Map<String, String> map = Globals.getBioSet().getAgeMap();
            TreeSet<String> treeSet = new TreeSet<String>(map.keySet());
            for (String string3 : treeSet) {
                if (!string3.startsWith(string)) continue;
                String string4 = map.get(string3);
                iterator = new StringTokenizer(string4, "\t");
                Object[] objectArray = new Object[]{((StringTokenizer)((Object)iterator)).nextToken(), "", "", "", string3};
                this.data.add(objectArray);
            }
            if (string2 != null) {
                Object[] objectArray;
                String string5;
                Iterator iterator2;
                List<String> list = Globals.getBioSet().getTagForRace(string, string2, "BASEAGE");
                if (list != null) {
                    iterator = list.iterator();
                    iterator2 = this.data.iterator();
                    while (iterator2.hasNext() && iterator.hasNext()) {
                        string5 = iterator.next();
                        objectArray = (Object[])iterator2.next();
                        objectArray[1] = string5;
                    }
                }
                if (list != null) {
                    list = Globals.getBioSet().getTagForRace(string, string2, "AGEDIEROLL");
                    iterator = list.iterator();
                    iterator2 = this.data.iterator();
                    while (iterator2.hasNext() && iterator.hasNext()) {
                        string5 = iterator.next();
                        objectArray = (Object[])iterator2.next();
                        objectArray[2] = string5;
                    }
                }
                if (list != null) {
                    list = Globals.getBioSet().getTagForRace(string, string2, "MAXAGE");
                    iterator = list.iterator();
                    iterator2 = this.data.iterator();
                    while (iterator2.hasNext() && iterator.hasNext()) {
                        string5 = iterator.next();
                        objectArray = (Object[])iterator2.next();
                        objectArray[3] = string5;
                    }
                }
            }
        }

        void saveValues(String string, String string2) {
            if (string == null || string.length() == 0) {
                string = defaultRegionName;
            }
            Globals.getBioSet().removeFromUserMap(string, string2, "BASEAGE");
            Globals.getBioSet().removeFromUserMap(string, string2, "AGEDIEROLL");
            Globals.getBioSet().removeFromUserMap(string, string2, "MAXAGE");
            int n = 0;
            for (Object[] objectArray : this.data) {
                if (String.valueOf(objectArray[1]).length() > 0) {
                    Globals.getBioSet().addToUserMap(string, string2, "BASEAGE:" + String.valueOf(objectArray[1]), n);
                }
                if (String.valueOf(objectArray[2]).length() > 0) {
                    Globals.getBioSet().addToUserMap(string, string2, "AGEDIEROLL:" + String.valueOf(objectArray[2]), n);
                }
                if (String.valueOf(objectArray[3]).length() > 0) {
                    Globals.getBioSet().addToUserMap(string, string2, "MAXAGE:" + String.valueOf(objectArray[3]), n);
                }
                ++n;
            }
        }
    }
}

