/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.ChoiceList;
import pcgen.core.utils.CoreUtility;
import pcgen.gui.editor.PObjectUpdater;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.persistence.lst.PCClassLstToken;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.MapCollection;
import pcgen.util.enumeration.AttackType;

public class ClassAbilityPanel
extends JPanel
implements PObjectUpdater {
    private JCheckBox memorize = new JCheckBox();
    private JCheckBox spellBook = new JCheckBox();
    private JComboBoxEx spellStat = new JComboBoxEx();
    private JComboBoxEx spellType = new JComboBoxEx();
    private JTextField attackCycle = new JTextField();
    private JTextField castAs = new JTextField();
    private JTextField deity = new JTextField();
    private JTextField extraFeats = new JTextField();
    private JTextField hitDice = new JTextField();
    private JTextField itemCreate = new JTextField();
    private JTextField knownSpells = new JTextField();
    private JTextField levelsPerFeat = new JTextField();
    private JTextField maxLevel = new JTextField();
    private JTextField prohibited = new JTextField();
    private JTextField spellList = new JTextField();

    public ClassAbilityPanel() {
        this.initComponents();
        this.initComponentContents();
    }

    public void updateData(PObject pObject) {
        PCClassLstToken pCClassLstToken;
        if (!(pObject instanceof PCClass)) {
            return;
        }
        PCClass pCClass = (PCClass)pObject;
        String string = this.attackCycle.getText().trim();
        if (string.length() > 0) {
            pCClassLstToken = (PCClassLstToken)TokenStore.inst().getTokenMap(PCClassLstToken.class).get("ATTACKCYCLE");
            pCClassLstToken.parse(pCClass, string, -9);
        }
        if ((string = this.hitDice.getText().trim()).length() > 0) {
            pCClass.setHitDie(Integer.parseInt(string));
        }
        if ((string = this.deity.getText().trim()).length() > 0) {
            pCClassLstToken = (PCClassLstToken)TokenStore.inst().getTokenMap(PCClassLstToken.class).get("DEITY");
            pCClassLstToken.parse(pCClass, string, -9);
        }
        string = this.itemCreate.getText().trim();
        pCClass.setItemCreationMultiplier(string);
        string = this.extraFeats.getText().trim();
        if (string.length() > 0) {
            pCClass.setInitialFeats(Integer.parseInt(string));
        }
        if ((string = this.levelsPerFeat.getText().trim()).length() > 0) {
            pCClass.setLevelsPerFeat(Integer.valueOf(string));
        }
        if ((string = this.castAs.getText().trim()).length() > 0) {
            pCClass.setCastAs(string);
        }
        if ((string = this.knownSpells.getText().trim()).length() > 0) {
            pCClass.clearKnownSpellsList();
            pCClassLstToken = (PCClassLstToken)TokenStore.inst().getTokenMap(PCClassLstToken.class).get("KNOWNSPELLS");
            pCClassLstToken.parse(pCClass, string, -9);
        }
        pCClass.setMemorizeSpells(this.memorize.getSelectedObjects() != null);
        string = this.prohibited.getText().trim();
        if (string.length() > 0) {
            pCClassLstToken = (PCClassLstToken)TokenStore.inst().getTokenMap(PCClassLstToken.class).get("PROHIBITED");
            pCClassLstToken.parse(pCClass, string, -9);
        }
        pCClass.setSpellBookUsed(this.spellBook.getSelectedObjects() != null);
        pCClassLstToken = (PCClassLstToken)TokenStore.inst().getTokenMap(PCClassLstToken.class).get("SPELLLIST");
        pCClassLstToken.parse(pCClass, this.spellList.getText().trim(), -9);
        if (!"None".equals(pCClass.getSpellBaseStat())) {
            pCClass.setSpellBaseStat("None");
        }
        if ((string = (String)this.spellStat.getSelectedItem()) != null && string.length() > 0 && !"None".equals(string)) {
            pCClass.setSpellBaseStat(string);
        }
        pCClass.setSpellType("None");
        string = (String)this.spellType.getSelectedItem();
        if (string != null && string.length() > 0) {
            pCClass.setSpellType(string);
        }
        if ((string = this.maxLevel.getText().trim()).length() > 0) {
            pCClass.setMaxLevel(Integer.parseInt(string));
        }
    }

    public void updateView(PObject pObject) {
        Object object;
        if (!(pObject instanceof PCClass)) {
            return;
        }
        PCClass pCClass = (PCClass)pObject;
        Map<AttackType, String> map = pCClass.getAttackCycle();
        if (map != null) {
            object = new MapCollection(map);
            this.attackCycle.setText(CoreUtility.join(object, "|"));
        }
        this.hitDice.setText(String.valueOf(pCClass.getBaseHitDie()));
        this.deity.setText(CoreUtility.join(pCClass.getDeityList(), '|'));
        this.itemCreate.setText(pCClass.getItemCreationMultiplier());
        this.extraFeats.setText(String.valueOf(pCClass.getInitialFeats()));
        if (pCClass.getLevelsPerFeat() != null) {
            this.levelsPerFeat.setText(pCClass.getLevelsPerFeat().toString());
        }
        this.castAs.setText(pCClass.getCastAs());
        this.knownSpells.setText(CoreUtility.join(pCClass.getKnownSpellsList(), "|"));
        this.memorize.setSelected(pCClass.getMemorizeSpells());
        this.prohibited.setText(CoreUtility.join(pCClass.getProhibitedSchools(), ","));
        this.spellBook.setSelected(pCClass.getSpellBookUsed());
        object = pCClass.getClassSpellChoices();
        if (object != null) {
            this.spellList.setText(((ChoiceList)object).toString());
        }
        this.spellStat.setSelectedItem(pCClass.getSpellBaseStat());
        this.spellType.setSelectedItem(pCClass.getSpellType());
        this.maxLevel.setText(String.valueOf(pCClass.getMaxLevel()));
    }

    private static GridBagConstraints buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, boolean bl) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        if (bl) {
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        }
        return gridBagConstraints;
    }

    private void initComponentContents() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<PObject> iterator = SettingsHandler.getGame().getUnmodifiableStatList().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().getAbb());
        }
        arrayList.remove("None");
        Collections.sort(arrayList);
        arrayList.add(0, "None");
        this.spellStat.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        arrayList.clear();
        iterator = Globals.getClassList().iterator();
        while (iterator.hasNext()) {
            String string = ((PCClass)iterator.next()).getSpellType();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        arrayList.remove("None");
        Collections.sort(arrayList);
        arrayList.add(0, "None");
        this.spellType.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
    }

    private void initComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        JLabel jLabel = new JLabel("Hit Die:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 0, 0, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 1, 0, true);
        gridBagConstraints.weightx = 0.2;
        this.add((Component)this.hitDice, gridBagConstraints);
        jLabel = new JLabel("Max Level:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 2, 0, true);
        gridBagConstraints.weightx = 0.1;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 3, 0, true);
        gridBagConstraints.weightx = 0.2;
        this.add((Component)this.maxLevel, gridBagConstraints);
        jLabel = new JLabel("Bonus Feats:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 0, 1, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 1, 1, true);
        this.add((Component)this.extraFeats, gridBagConstraints);
        jLabel = new JLabel("Levels Per Feat:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 2, 1, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 3, 1, true);
        this.add((Component)this.levelsPerFeat, gridBagConstraints);
        jLabel = new JLabel("Attack Cycle:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 0, 2, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 1, 2, true);
        this.add((Component)this.attackCycle, gridBagConstraints);
        jLabel = new JLabel("Item Create Mult:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 2, 2, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 3, 2, true);
        this.add((Component)this.itemCreate, gridBagConstraints);
        jLabel = new JLabel("Spell Type:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 0, 3, true);
        this.add((Component)jLabel, gridBagConstraints);
        this.spellType.setEditable(true);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 1, 3, true);
        this.add((Component)this.spellType, gridBagConstraints);
        jLabel = new JLabel("Spell Stat:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 2, 3, true);
        this.add((Component)jLabel, gridBagConstraints);
        this.spellStat.setEditable(true);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 3, 3, true);
        this.add((Component)this.spellStat, gridBagConstraints);
        jLabel = new JLabel("Cast As:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 0, 4, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 1, 4, true);
        this.add((Component)this.castAs, gridBagConstraints);
        jLabel = new JLabel("Spell List:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 2, 4, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 3, 4, true);
        this.add((Component)this.spellList, gridBagConstraints);
        jLabel = new JLabel("Uses Spell Book:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 0, 5, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 1, 5, true);
        this.add((Component)this.spellBook, gridBagConstraints);
        jLabel = new JLabel("Memorizes Spells:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 2, 5, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 3, 5, true);
        this.add((Component)this.memorize, gridBagConstraints);
        jLabel = new JLabel("Prohibited:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 2, 6, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 3, 6, true);
        this.add((Component)this.prohibited, gridBagConstraints);
        jLabel = new JLabel("Known Spells:");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 0, 7, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 1, 7, true);
        gridBagConstraints.gridwidth = 3;
        this.add((Component)this.knownSpells, gridBagConstraints);
    }
}

