/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import pcgen.core.Campaign;
import pcgen.core.CustomData;
import pcgen.core.DamageReduction;
import pcgen.core.Description;
import pcgen.core.Globals;
import pcgen.core.LevelProperty;
import pcgen.core.PCClass;
import pcgen.core.PCSpell;
import pcgen.core.PObject;
import pcgen.core.SpecialAbility;
import pcgen.core.bonus.BonusObj;
import pcgen.core.levelability.LevelAbility;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.ListKey;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.editor.AvailableSelectedPanel;
import pcgen.gui.editor.PObjectUpdater;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.TableSorter;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.PCClassLoader;
import pcgen.util.InputFactory;
import pcgen.util.InputInterface;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class ClassLevelPanel
extends JPanel
implements PObjectUpdater {
    static final long serialVersionUID = 1485178774957708877L;
    private static List<LevelTag> levelTagList = new ArrayList<LevelTag>();
    private JButton addBtn = new JButton();
    private JButton delBtn = new JButton();
    private JComboBoxEx tagList = new JComboBoxEx();
    private JScrollPane levelPane;
    private JTableEx levelTable = new JTableEx();
    private JTextField level = new JTextField();
    private LevelModel levelModel = new LevelModel();
    private PCClass obj = null;
    private TableSorter sortedLevelModel = new TableSorter();

    public ClassLevelPanel() {
        this.initComponents();
    }

    public void updateData(PObject pObject) {
        if (!(pObject instanceof PCClass)) {
            Logging.errorPrint("Invalid PObject passed to ClassLevelPanel.updateData()!");
            return;
        }
        PCClass pCClass = (PCClass)pObject;
        try {
            Campaign campaign = new Campaign();
            campaign.setName("Custom");
            campaign.addDescription(new Description("Custom data"));
            URI uRI = pCClass.getSourceURI();
            if (uRI == null) {
                uRI = new URI("file", null, CustomData.customClassFilePath(true), null);
                pCClass.setSourceURI(uRI);
                pCClass.setSourceCampaign(campaign);
            }
            CampaignSourceEntry campaignSourceEntry = new CampaignSourceEntry(campaign, uRI);
            pCClass.addAddList(-1, ".CLEAR");
            for (LevelTag levelTag : levelTagList) {
                if (!levelTag.needsSaving()) continue;
                String string = levelTag.getLevel() + "\t" + levelTag.getTag() + ":" + levelTag.getValue();
                PCClassLoader pCClassLoader = new PCClassLoader();
                pCClassLoader.parseLine(pCClass, string, campaignSourceEntry);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            Logging.errorPrint(uRISyntaxException.getLocalizedMessage());
        }
        catch (PersistenceLayerException persistenceLayerException) {
            Logging.errorPrint(persistenceLayerException.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateView(PObject pObject) {
        Object object3;
        void var4_14;
        void var4_10;
        Object object2;
        if (!(pObject instanceof PCClass)) {
            return;
        }
        levelTagList.clear();
        this.obj = (PCClass)pObject;
        List<Object> list = this.obj.getLevelAbilityList();
        if (list != null) {
            for (LevelAbility object4 : list) {
                LevelTag list2 = new LevelTag(object4.level(), 0, object4.getTagData());
                levelTagList.add(list2);
            }
        }
        if ((list = this.obj.getAddDomains()) != null) {
            for (String string : list) {
                int object5 = string.indexOf(124);
                String specialAbility = string.substring(0, object5);
                String string2 = string.substring(object5 + 1);
                object2 = new LevelTag(specialAbility, 1, string2);
                levelTagList.add((LevelTag)object2);
            }
        }
        for (BonusObj i : this.obj.getBonusList()) {
            String levelProperty;
            String string = i.toString();
            if (string.startsWith(levelProperty = String.valueOf(i.getPCLevel()))) {
                string = string.substring(levelProperty.length() + 1);
            }
            LevelTag levelTag = new LevelTag(i.getPCLevel(), 2, string);
            levelTagList.add(levelTag);
        }
        boolean list3 = false;
        while (var4_10 < this.obj.getVariableCount()) {
            String string = this.obj.getVariableDefinition((int)var4_10);
            int levelProperty = string.indexOf(124);
            LevelTag levelTag = new LevelTag(string.substring(0, levelProperty), 4, string.substring(levelProperty + 1));
            levelTagList.add(levelTag);
            ++var4_10;
        }
        if (this.obj.hasCastList()) {
            for (Map.Entry<Integer, List<String>> entry : this.obj.getCastProgression().entrySet()) {
                LevelTag string5 = new LevelTag(entry.getKey(), 3, CoreUtility.join((Collection)entry.getValue(), ","));
                levelTagList.add(string5);
            }
        }
        if (this.obj.hasKnownList()) {
            for (Map.Entry<Integer, List<String>> entry : this.obj.getKnownMap().entrySet()) {
                LevelTag n = new LevelTag(entry.getKey(), 9, CoreUtility.join((Collection)entry.getValue(), ","));
                levelTagList.add(n);
            }
        }
        boolean bl = false;
        while (var4_14 <= this.obj.getSpellSupport().getMaxSpellListLevel()) {
            List<PCSpell> list2 = this.obj.getSpellSupport().getSpellListForLevel((int)var4_14);
            if (list2 != null) {
                Iterator<PCSpell> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    String string = iterator.next().getPCCText();
                    object2 = new LevelTag(String.valueOf((int)var4_14), 12, string);
                    levelTagList.add((LevelTag)object2);
                }
            }
            ++var4_14;
        }
        List<DamageReduction> list4 = this.obj.getDRList();
        for (DamageReduction i : list4) {
            List<Prerequisite> list5 = i.getPreReqList();
            for (Object object3 : list5) {
                if (!DamageReduction.isPrereqForClassLevel((Prerequisite)object3, this.obj.getKeyName())) continue;
                String string = i.getReduction() + "/" + i.getBypass();
                LevelTag levelTag = new LevelTag(((Prerequisite)object3).getOperand(), 5, string);
                levelTagList.add(levelTag);
            }
        }
        list = this.obj.getListFor(ListKey.SPECIAL_ABILITY);
        if (list != null && list.size() != 0) {
            for (SpecialAbility specialAbility : list) {
                String string = specialAbility.getSASource();
                object2 = string.substring(string.lastIndexOf(124) + 1);
                object3 = new LevelTag((String)object2, 11, specialAbility.toString());
                levelTagList.add((LevelTag)object3);
            }
        }
        for (LevelProperty levelProperty : this.obj.getSRlist()) {
            levelTagList.add(new LevelTag(levelProperty.getLevel(), 13, (String)levelProperty.getObject()));
        }
        for (LevelProperty levelProperty : this.obj.getFeatList()) {
            levelTagList.add(new LevelTag(levelProperty.getLevel(), 6, (String)levelProperty.getObject()));
        }
        for (LevelProperty levelProperty : this.obj.getAllFeatAutos()) {
            levelTagList.add(new LevelTag(levelProperty.getLevel(), 7, (String)levelProperty.getObject()));
        }
        for (String string : this.obj.getSafeListFor(ListKey.KITS)) {
            void var6_38;
            int n = string.indexOf(124);
            object2 = "1";
            if (n > 0) {
                object2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
            }
            object3 = new LevelTag((String)object2, 8, (String)var6_38);
            levelTagList.add((LevelTag)object3);
        }
        Object object4 = this.obj.getRegionString();
        if (object4 != null && !((String)object4).equals("")) {
            void var7_59;
            int n = ((String)object4).indexOf(124);
            String string = "1";
            if (n > 0) {
                String string4 = ((String)object4).substring(0, n);
                object4 = ((String)object4).substring(n + 1);
            }
            object2 = new LevelTag((String)var7_59, 10, (String)object4);
            levelTagList.add((LevelTag)object2);
        }
        for (LevelProperty<String> levelProperty : this.obj.getTemplates()) {
            object2 = new LevelTag(levelProperty.getLevel(), 14, levelProperty.getObject());
            levelTagList.add((LevelTag)object2);
        }
        list = this.obj.getListFor(ListKey.UMULT);
        if (list != null && list.size() != 0) {
            for (String string : list) {
                int n = string.indexOf(124);
                object3 = new LevelTag(string.substring(0, n), 16, string.substring(n + 1));
                levelTagList.add((LevelTag)object3);
            }
        }
        if ((list = this.obj.getListFor(ListKey.UDAM)) != null) {
            void var6_44;
            boolean bl2 = false;
            while (var6_44 < list.size()) {
                String string = (String)list.get((int)var6_44);
                if (!string.equals("")) {
                    LevelTag levelTag = new LevelTag((int)(var6_44 + true), 15, string);
                    levelTagList.add(levelTag);
                }
                ++var6_44;
            }
        }
        this.levelModel.updateModel();
    }

    private void initComponents() {
        for (int i = 0; i < LevelTag.validTags.length; ++i) {
            this.tagList.addItem(LevelTag.validTags[i]);
        }
        this.tagList.setSelectedIndex(0);
        this.level.setText("1     ");
        this.setLayout(new BorderLayout());
        this.levelPane = new JScrollPane(this.levelTable);
        this.sortedLevelModel.setModel(this.levelModel);
        this.levelTable.setModel(this.sortedLevelModel);
        this.levelTable.setColAlign(0, 0);
        this.levelPane.setViewportView(this.levelTable);
        this.levelTable.setSelectionMode(0);
        this.sortedLevelModel.addMouseListenerToHeaderInTable(this.levelTable);
        this.levelTable.getColumnModel().getColumn(0).setPreferredWidth(5);
        this.levelTable.getColumnModel().getColumn(1).setPreferredWidth(10);
        this.add((Component)this.levelPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        JLabel jLabel = new JLabel("Level:");
        jPanel.add(jLabel);
        jPanel.add(this.level);
        jLabel = new JLabel("Tag:");
        jPanel.add(jLabel);
        jPanel.add(this.tagList);
        this.addBtn.setText(PropertyFactory.getString("in_add"));
        jPanel.add(this.addBtn);
        this.addBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ClassLevelPanel.this.tagList.getSelectedItem().toString();
                if (string.equals("CAST") || string.equals("KNOWN")) {
                    int n;
                    String[] stringArray = new String[]{"Level 0", "Level 1", "Level 2", "Level 3", "Level 4", "Level 5", "Level 6", "Level 7", "Level 8", "Level 9"};
                    String[] stringArray2 = new String[]{"", "", "", "", "", "", "", "", "", ""};
                    MatrixFrame matrixFrame = new MatrixFrame(stringArray, 10, stringArray2, string);
                    String string2 = "";
                    for (n = 0; n < 10; ++n) {
                        if (n > 0) {
                            string2 = string2 + ",";
                        }
                        string2 = string2 + matrixFrame.fields[n];
                    }
                    n = 0;
                    while (string2.endsWith(",") && n++ < 9) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    if (!string2.equals("")) {
                        LevelTag levelTag = new LevelTag(ClassLevelPanel.this.level.getText().trim(), string, string2.trim(), true);
                        levelTagList.add(levelTag);
                        ClassLevelPanel.this.levelModel.updateModel();
                    }
                } else if (string.equals("FEAT") || string.equals("VFEAT") || string.equals("FEATAUTO")) {
                    ListFrame listFrame = new ListFrame("Choices for " + string, Globals.getUnmodifiableAbilityList("FEAT"));
                    String string3 = listFrame.getSelectedList();
                    if (!string3.equals("")) {
                        LevelTag levelTag = new LevelTag(ClassLevelPanel.this.level.getText().trim(), string, string3.trim(), true);
                        levelTagList.add(levelTag);
                        ClassLevelPanel.this.levelModel.updateModel();
                    }
                } else {
                    InputInterface inputInterface = InputFactory.getInputInstance();
                    Object object = inputInterface.showInputDialog(null, "Enter the value for " + string, "PCGen", MessageType.INFORMATION, null, "");
                    if (object == null) {
                        return;
                    }
                    LevelTag levelTag = new LevelTag(ClassLevelPanel.this.level.getText().trim(), string, object.toString().trim(), true);
                    levelTagList.add(levelTag);
                    ClassLevelPanel.this.levelModel.updateModel();
                }
            }
        });
        this.delBtn.setText(PropertyFactory.getString("in_remove"));
        jPanel.add(this.delBtn);
        this.delBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassLevelPanel.this.removeLevelTag();
            }
        });
        this.add((Component)jPanel, "South");
    }

    private void removeLevelTag() {
        int n = this.levelTable.getSelectedRow();
        if (n >= 0 && n < levelTagList.size()) {
            LevelTag levelTag = levelTagList.get(n = this.sortedLevelModel.getRowTranslated(n));
            if (!levelTag.needsSaving()) {
                if (this.obj == null) {
                    return;
                }
                boolean bl = false;
                switch (levelTag.getTagVal()) {
                    case 0: {
                        this.obj.removeLevelAbility(levelTag.getLevel(), levelTag.getValue());
                        bl = true;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: {
                        this.obj.removeFeatAuto(levelTag.getLevel(), levelTag.getValue());
                        bl = true;
                        break;
                    }
                }
                if (!bl) {
                    Logging.errorPrint("This tag " + levelTag.getTag() + ":" + levelTag.getValue() + " needs to be hand-deleted from customClasses.lst");
                    ShowMessageDelegate.showMessageDialog("This tag " + levelTag.getTag() + ":" + levelTag.getValue() + " needs to be hand-deleted from customClasses.lst", "PCGen", MessageType.ERROR);
                    return;
                }
            }
            levelTagList.remove(n);
            this.levelModel.updateModel();
        }
    }

    private static final class LevelTag {
        static final String[] validTags = new String[]{"ADD", "ADDDOMAINS", "BONUS", "CAST", "DEFINE", "DR", "FEAT", "FEATAUTO", "KIT", "KNOWN", "REGION", "SA", "SPELLS", "SR", "TEMPLATE", "UDAM", "UMULT", "VFEAT"};
        private static final int TAG_ADD = 0;
        private static final int TAG_ADDDOMAINS = 1;
        private static final int TAG_BONUS = 2;
        private static final int TAG_CAST = 3;
        private static final int TAG_DEFINE = 4;
        private static final int TAG_DR = 5;
        private static final int TAG_FEAT = 6;
        private static final int TAG_FEATAUTO = 7;
        private static final int TAG_KIT = 8;
        private static final int TAG_KNOWN = 9;
        private static final int TAG_REGION = 10;
        private static final int TAG_SA = 11;
        private static final int TAG_SPELLS = 12;
        private static final int TAG_SR = 13;
        private static final int TAG_TEMPLATE = 14;
        private static final int TAG_UDAM = 15;
        private static final int TAG_UMULT = 16;
        private static final int TAG_VFEAT = 17;
        private String value;
        private boolean needsSaving;
        private int level;
        private int tagVal;

        public LevelTag(String string, String string2, String string3, boolean bl) {
            int n = 0;
            if (string != null && string.length() > 0) {
                n = Integer.parseInt(string);
            }
            this.setData(n, this.parseTag(string2), string3, bl);
        }

        LevelTag(String string, int n, String string2) {
            int n2 = 0;
            if (string != null && string.length() > 0) {
                n2 = Integer.parseInt(string);
            }
            this.setData(n2, n, string2, true);
        }

        LevelTag(int n, int n2, String string) {
            this.setData(n, n2, string, true);
        }

        LevelTag(int n, String string, String string2, boolean bl) {
            this.setData(n, this.parseTag(string), string2, bl);
        }

        public int getLevel() {
            return this.level;
        }

        public String getTag() {
            if (this.tagVal >= 0) {
                return validTags[this.tagVal];
            }
            return "Unknown";
        }

        public int getTagVal() {
            return this.tagVal;
        }

        public String getValue() {
            return this.value;
        }

        public boolean needsSaving() {
            return this.needsSaving;
        }

        void setData(int n, int n2, String string, boolean bl) {
            if (n2 >= validTags.length) {
                n2 = -1;
            }
            this.level = n;
            this.tagVal = n2;
            this.value = string;
            this.needsSaving = bl;
        }

        private int parseTag(String string) {
            for (int i = 0; i < validTags.length; ++i) {
                if (!validTags[i].equalsIgnoreCase(string)) continue;
                return i;
            }
            return -1;
        }
    }

    private static final class LevelModel
    extends AbstractTableModel {
        static final long serialVersionUID = 1485178774957708877L;
        private final String[] colNames = new String[]{"Level", "Tag", "Value"};

        private LevelModel() {
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return Integer.class;
            }
            return String.class;
        }

        public int getColumnCount() {
            return this.colNames.length;
        }

        public String getColumnName(int n) {
            return n >= 0 && n < this.colNames.length ? this.colNames[n] : "Out Of Bounds";
        }

        public int getRowCount() {
            return levelTagList.size();
        }

        public Object getValueAt(int n, int n2) {
            if (n >= 0 && n < levelTagList.size()) {
                LevelTag levelTag = (LevelTag)levelTagList.get(n);
                switch (n2) {
                    case 0: {
                        return levelTag.getLevel();
                    }
                    case 1: {
                        return levelTag.getTag();
                    }
                    case 2: {
                        return levelTag.getValue();
                    }
                }
                Logging.errorPrint("In ClassLevelPanel.LevelModel.getValueAt the column " + n2 + " is not supported.");
            }
            return null;
        }

        private void updateModel() {
            this.fireTableDataChanged();
        }
    }

    static final class MatrixFrame
    extends JDialog {
        public String[] fields;
        private String[] colNames;
        private JTextField[] textField;
        private String[] values;
        private int columns;

        public MatrixFrame(String[] stringArray, int n, String[] stringArray2, String string) {
            super(Globals.getRootFrame(), string, true);
            this.colNames = stringArray;
            this.columns = n;
            this.values = stringArray2;
            this.initComponents();
            this.setSize(new Dimension(60 * this.columns, 140));
            this.setVisible(true);
            this.pack();
        }

        private GridBagConstraints buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, boolean bl) {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            if (bl) {
                gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            }
            return gridBagConstraints;
        }

        private void initComponents() {
            this.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            this.textField = new JTextField[this.columns];
            for (int i = 0; i < this.columns; ++i) {
                JLabel jLabel = new JLabel(this.colNames[i]);
                gridBagConstraints = this.buildConstraints(gridBagConstraints, i, 0, true);
                this.getContentPane().add((Component)jLabel, gridBagConstraints);
                this.textField[i] = new JTextField(this.values[i]);
                gridBagConstraints = this.buildConstraints(gridBagConstraints, i, 1, true);
                this.getContentPane().add((Component)this.textField[i], gridBagConstraints);
            }
            JButton jButton = new JButton(PropertyFactory.getString("in_ok"));
            gridBagConstraints = this.buildConstraints(gridBagConstraints, this.columns - 2, 2, true);
            this.getContentPane().add((Component)jButton, gridBagConstraints);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MatrixFrame.this.setVisible(false);
                    MatrixFrame.this.fields = new String[MatrixFrame.this.columns];
                    for (int i = 0; i < MatrixFrame.this.columns; ++i) {
                        MatrixFrame.this.fields[i] = MatrixFrame.this.textField[i].getText();
                    }
                }
            });
            jButton = new JButton(PropertyFactory.getString("in_cancel"));
            gridBagConstraints = this.buildConstraints(gridBagConstraints, this.columns - 1, 2, true);
            this.getContentPane().add((Component)jButton, gridBagConstraints);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MatrixFrame.this.setVisible(false);
                    MatrixFrame.this.fields = new String[MatrixFrame.this.columns];
                    for (int i = 0; i < MatrixFrame.this.columns; ++i) {
                        MatrixFrame.this.fields[i] = "";
                    }
                }
            });
        }
    }

    static final class ListFrame
    extends JDialog {
        AvailableSelectedPanel asPanel = new AvailableSelectedPanel();

        public ListFrame(String string, List list) {
            super(Globals.getRootFrame(), string, true);
            this.initComponents();
            this.asPanel.setAvailableList(list, true);
            this.setSize(new Dimension(400, 400));
            this.setVisible(true);
            this.pack();
        }

        public String getSelectedList() {
            Object[] objectArray = this.asPanel.getSelectedList();
            if (objectArray.length == 0) {
                return "";
            }
            String string = objectArray[0].toString();
            for (int i = 1; i < objectArray.length; ++i) {
                string = string + "|" + objectArray[i].toString();
            }
            return string;
        }

        private void initComponents() {
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.asPanel, "Center");
            JButton jButton = new JButton(PropertyFactory.getString("in_ok"));
            this.getContentPane().add((Component)jButton, "South");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ListFrame.this.setVisible(false);
                }
            });
        }
    }
}

